/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.AddressSpaceAllocator$Block$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Set;
import scala.collection.mutable.TreeMap;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0014)\u0001EB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\u0006y\u0001!\t!\u0010\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\"\t\u0011\u0005\r\u0001\u0001)A\u0005\u0003\u000bAq!a\u0003\u0001A\u0003&\u0011\bC\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018!1!\u0010\u0001C\u0001\u00037AaA \u0001\u0005\u0002\u0005\r\u0002BBA\u0014\u0001\u0011\u0005!\u000b\u0003\u0004\u0002*\u0001!\tA\u0015\u0005\u0007\u0003W\u0001A\u0011\u0001*\t\r\u00055\u0002\u0001\"\u0001S\r\u0011y\u0005\u0001\u0002)\t\u0011Es!Q1A\u0005\u0002IC\u0001b\u0015\b\u0003\u0002\u0003\u0006I!\u000f\u0005\t):\u0011\t\u0019!C\u0001%\"AQK\u0004BA\u0002\u0013\u0005a\u000b\u0003\u0005]\u001d\t\u0005\t\u0015)\u0003:\u0011!ifB!a\u0001\n\u0003q\u0006\u0002\u00032\u000f\u0005\u0003\u0007I\u0011A2\t\u0011\u0015t!\u0011!Q!\n}C\u0001B\u001a\b\u0003\u0002\u0004%\tA\u0018\u0005\tO:\u0011\t\u0019!C\u0001Q\"A!N\u0004B\u0001B\u0003&q\f\u0003\u0005l\u001d\t\u0005\r\u0011\"\u0001m\u0011!\u0001hB!a\u0001\n\u0003\t\b\u0002C:\u000f\u0005\u0003\u0005\u000b\u0015B7\t\u000bqrA\u0011\u0001;\t\u000bitA\u0011A>\t\u000bytA\u0011A@\t\r\u0005\u0005a\u0002\"\u0003\u0000\u000f%\ty\u0003AA\u0001\u0012\u0013\t\tD\u0002\u0005P\u0001\u0005\u0005\t\u0012BA\u001a\u0011\u0019a$\u0005\"\u0001\u00026!I\u0011q\u0007\u0012\u0012\u0002\u0013\u0005\u0011\u0011\b\u0005\n\u0003\u001f\u0012\u0013\u0013!C\u0001\u0003sA\u0011\"!\u0015##\u0003%\t!a\u0015\u0003+\u0005#GM]3tgN\u0003\u0018mY3BY2|7-\u0019;pe*\u0011\u0011FK\u0001\u0007e\u0006\u0004\u0018\u000eZ:\u000b\u0005-b\u0013!B:qCJ\\'BA\u0017/\u0003\u0019qg/\u001b3jC*\tq&A\u0002d_6\u001c\u0001a\u0005\u0002\u0001eA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t1\u0011I\\=SK\u001a\f\u0001#\u00193ee\u0016\u001c8o\u00159bG\u0016\u001c\u0016N_3\u0011\u0005MR\u0014BA\u001e5\u0005\u0011auN\\4\u0002\rqJg.\u001b;?)\tq\u0004\t\u0005\u0002@\u00015\t\u0001\u0006C\u00039\u0005\u0001\u0007\u0011(\u0001\u0006ge\u0016,'\t\\8dWN\u0004Ba\u0011%:\u00156\tAI\u0003\u0002F\r\u00069Q.\u001e;bE2,'BA$5\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0013\u0012\u0013q\u0001\u0016:fK6\u000b\u0007\u000fE\u0002D\u00176K!\u0001\u0014#\u0003\u0007M+G\u000f\u0005\u0002O\u001d5\t\u0001AA\u0003CY>\u001c7n\u0005\u0002\u000fe\u00059\u0011\r\u001a3sKN\u001cX#A\u001d\u0002\u0011\u0005$GM]3tg\u0002\n\u0011B\u00197pG.\u001c\u0016N_3\u0002\u001b\tdwnY6TSj,w\fJ3r)\t9&\f\u0005\u000241&\u0011\u0011\f\u000e\u0002\u0005+:LG\u000fC\u0004\\%\u0005\u0005\t\u0019A\u001d\u0002\u0007a$\u0013'\u0001\u0006cY>\u001c7nU5{K\u0002\n!\u0002\\8xKJ\u0014En\\2l+\u0005y\u0006cA\u001aa\u001b&\u0011\u0011\r\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001d1|w/\u001a:CY>\u001c7n\u0018\u0013fcR\u0011q\u000b\u001a\u0005\b7V\t\t\u00111\u0001`\u0003-awn^3s\u00052|7m\u001b\u0011\u0002\u0015U\u0004\b/\u001a:CY>\u001c7.\u0001\bvaB,'O\u00117pG.|F%Z9\u0015\u0005]K\u0007bB.\u0019\u0003\u0003\u0005\raX\u0001\fkB\u0004XM\u001d\"m_\u000e\\\u0007%A\u0005bY2|7-\u0019;fIV\tQ\u000e\u0005\u00024]&\u0011q\u000e\u000e\u0002\b\u0005>|G.Z1o\u00035\tG\u000e\\8dCR,Gm\u0018\u0013fcR\u0011qK\u001d\u0005\b7n\t\t\u00111\u0001n\u0003)\tG\u000e\\8dCR,G\r\t\u000b\u0007\u001bV4x\u000f_=\t\u000bEk\u0002\u0019A\u001d\t\u000bQk\u0002\u0019A\u001d\t\u000fuk\u0002\u0013!a\u0001?\"9a-\bI\u0001\u0002\u0004y\u0006bB6\u001e!\u0003\u0005\r!\\\u0001\tC2dwnY1uKR\u0011\u0011\b \u0005\u0006{z\u0001\r!O\u0001\u0007C6|WO\u001c;\u0002\t\u0019\u0014X-\u001a\u000b\u0002/\u0006i1m\\1mKN\u001cW-\u00169qKJ\fq\"\u00197m_\u000e\fG/\u001a3CY>\u001c7n\u001d\t\u0006\u0007\u0006\u001d\u0011(T\u0005\u0004\u0003\u0013!%a\u0002%bg\"l\u0015\r]\u0001\u000fC2dwnY1uK\u0012\u0014\u0015\u0010^3t\u00031\tG\r\u001a$sK\u0016\u0014En\\2l)\r9\u0016\u0011\u0003\u0005\u0007\u0003'1\u0001\u0019A'\u0002\u000b\tdwnY6\u0002\u001fI,Wn\u001c<f\rJ,WM\u00117pG.$2aVA\r\u0011\u0019\t\u0019b\u0002a\u0001\u001bR!\u0011QDA\u0010!\r\u0019\u0004-\u000f\u0005\u0007\u0003CA\u0001\u0019A\u001d\u0002\tML'0\u001a\u000b\u0004/\u0006\u0015\u0002\"B)\n\u0001\u0004I\u0014!D1mY>\u001c\u0017\r^3e'&TX-A\u0005bm\u0006LG.\u00192mK\u0006\u0011b.^7BY2|7-\u0019;fI\ncwnY6t\u00035qW/\u001c$sK\u0016\u0014En\\2lg\u0006)!\t\\8dWB\u0011aJI\n\u0003EI\"\"!!\r\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tYDK\u0002`\u0003{Y#!a\u0010\u0011\t\u0005\u0005\u00131J\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013\"\u0014AC1o]>$\u0018\r^5p]&!\u0011QJA\"\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t)FK\u0002n\u0003{\u0001")
public class AddressSpaceAllocator {
    private volatile AddressSpaceAllocator$Block$ Block$module;
    private final long addressSpaceSize;
    private final TreeMap<Object, Set<Block>> freeBlocks;
    public final HashMap<Object, Block> com$nvidia$spark$rapids$AddressSpaceAllocator$$allocatedBlocks;
    private long allocatedBytes;

    private AddressSpaceAllocator$Block$ Block() {
        if (this.Block$module == null) {
            this.Block$lzycompute$1();
        }
        return this.Block$module;
    }

    public void com$nvidia$spark$rapids$AddressSpaceAllocator$$addFreeBlock(Block block) {
        Set set = (Set)this.freeBlocks.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)block.blockSize()), (Function0 & Serializable & scala.Serializable)() -> new HashSet());
        boolean added = set.add((Object)block);
        Predef$.MODULE$.assert(added, (Function0 & Serializable & scala.Serializable)() -> "block was already in free map");
    }

    public void com$nvidia$spark$rapids$AddressSpaceAllocator$$removeFreeBlock(Block block) {
        block0: {
            Set set = (Set)this.freeBlocks.getOrElse((Object)BoxesRunTime.boxToLong((long)block.blockSize()), (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException("block not in free map");
            });
            boolean removed = set.remove((Object)block);
            Predef$.MODULE$.assert(removed, (Function0 & Serializable & scala.Serializable)() -> "block not in free map");
            if (!set.isEmpty()) break block0;
            this.freeBlocks.remove((Object)BoxesRunTime.boxToLong((long)block.blockSize()));
        }
    }

    public synchronized Option<Object> allocate(long size) {
        None$ none$;
        if (size <= 0L) {
            return None$.MODULE$;
        }
        Iterator it = this.freeBlocks.valuesIteratorFrom((Object)BoxesRunTime.boxToLong((long)size));
        if (it.hasNext()) {
            Set blockSet = (Set)it.next();
            Block block = (Block)blockSet.head();
            this.com$nvidia$spark$rapids$AddressSpaceAllocator$$removeFreeBlock(block);
            this.allocatedBytes += size;
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)block.allocate(size)));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public synchronized void free(long address) {
        Block block = (Block)this.com$nvidia$spark$rapids$AddressSpaceAllocator$$allocatedBlocks.remove((Object)BoxesRunTime.boxToLong((long)address)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(14).append(address).append(" not allocated").toString());
        });
        this.allocatedBytes -= block.blockSize();
        block.free();
    }

    public synchronized long allocatedSize() {
        return this.allocatedBytes;
    }

    public synchronized long available() {
        return this.addressSpaceSize - this.allocatedBytes;
    }

    public synchronized long numAllocatedBlocks() {
        return this.com$nvidia$spark$rapids$AddressSpaceAllocator$$allocatedBlocks.size();
    }

    public synchronized long numFreeBlocks() {
        return BoxesRunTime.unboxToInt((Object)this.freeBlocks.valuesIterator().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private final void Block$lzycompute$1() {
        AddressSpaceAllocator addressSpaceAllocator = this;
        synchronized (addressSpaceAllocator) {
            if (this.Block$module == null) {
                this.Block$module = new AddressSpaceAllocator$Block$(this);
            }
        }
    }

    public AddressSpaceAllocator(long addressSpaceSize) {
        this.addressSpaceSize = addressSpaceSize;
        this.freeBlocks = new TreeMap((Ordering)Ordering.Long$.MODULE$);
        this.com$nvidia$spark$rapids$AddressSpaceAllocator$$allocatedBlocks = new HashMap();
        this.allocatedBytes = 0L;
        long x$1 = 0L;
        long x$2 = addressSpaceSize;
        boolean x$3 = false;
        Option<Block> x$4 = this.Block().$lessinit$greater$default$3();
        Option<Block> x$5 = this.Block().$lessinit$greater$default$4();
        this.com$nvidia$spark$rapids$AddressSpaceAllocator$$addFreeBlock(new Block(this, x$1, x$2, x$4, x$5, x$3));
    }

    private class Block {
        private final long address;
        private long blockSize;
        private Option<Block> lowerBlock;
        private Option<Block> upperBlock;
        private boolean allocated;
        public final /* synthetic */ AddressSpaceAllocator $outer;

        public long address() {
            return this.address;
        }

        public long blockSize() {
            return this.blockSize;
        }

        public void blockSize_$eq(long x$1) {
            this.blockSize = x$1;
        }

        public Option<Block> lowerBlock() {
            return this.lowerBlock;
        }

        public void lowerBlock_$eq(Option<Block> x$1) {
            this.lowerBlock = x$1;
        }

        public Option<Block> upperBlock() {
            return this.upperBlock;
        }

        public void upperBlock_$eq(Option<Block> x$1) {
            this.upperBlock = x$1;
        }

        public boolean allocated() {
            return this.allocated;
        }

        public void allocated_$eq(boolean x$1) {
            this.allocated = x$1;
        }

        public long allocate(long amount) {
            Predef$.MODULE$.assert(!this.allocated(), (Function0 & Serializable & scala.Serializable)() -> "block being allocated already allocated");
            Predef$.MODULE$.assert(amount <= this.blockSize(), (Function0 & Serializable & scala.Serializable)() -> "allocating beyond block");
            if (amount != this.blockSize()) {
                Block unallocated = new Block(this.com$nvidia$spark$rapids$AddressSpaceAllocator$Block$$$outer(), this.address() + amount, this.blockSize() - amount, (Option<Block>)new Some((Object)this), this.upperBlock(), false);
                this.com$nvidia$spark$rapids$AddressSpaceAllocator$Block$$$outer().com$nvidia$spark$rapids$AddressSpaceAllocator$$addFreeBlock(unallocated);
                this.upperBlock().foreach((Function1 & Serializable & scala.Serializable)b -> {
                    Block.$anonfun$allocate$3(this, unallocated, b);
                    return BoxedUnit.UNIT;
                });
                this.upperBlock_$eq((Option<Block>)new Some((Object)unallocated));
                this.blockSize_$eq(amount);
            }
            this.allocated_$eq(true);
            this.com$nvidia$spark$rapids$AddressSpaceAllocator$Block$$$outer().com$nvidia$spark$rapids$AddressSpaceAllocator$$allocatedBlocks.put((Object)BoxesRunTime.boxToLong((long)this.address()), (Object)this);
            return this.address();
        }

        public void free() {
            Predef$.MODULE$.assert(this.allocated(), (Function0 & Serializable & scala.Serializable)() -> "block being freed not allocated");
            this.allocated_$eq(false);
            this.upperBlock().foreach((Function1 & Serializable & scala.Serializable)b -> {
                Block.$anonfun$free$3(this, b);
                return BoxedUnit.UNIT;
            });
            ObjectRef freeBlock = ObjectRef.create((Object)this);
            this.lowerBlock().foreach((Function1 & Serializable & scala.Serializable)b -> {
                Block.$anonfun$free$4(this, freeBlock, b);
                return BoxedUnit.UNIT;
            });
            this.com$nvidia$spark$rapids$AddressSpaceAllocator$Block$$$outer().com$nvidia$spark$rapids$AddressSpaceAllocator$$addFreeBlock((Block)freeBlock.elem);
        }

        private void coalesceUpper() {
            Block upper = (Block)this.upperBlock().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException("no upper block");
            });
            Object object = upper.lowerBlock().orNull(Predef$.MODULE$.$conforms());
            Block block = this;
            Predef$.MODULE$.assert(!(object != null ? !object.equals(block) : block != null), (Function0 & Serializable & scala.Serializable)() -> "block linkage broken");
            Predef$.MODULE$.assert(this.address() + this.blockSize() == upper.address(), (Function0 & Serializable & scala.Serializable)() -> "block adjacency broken");
            this.blockSize_$eq(this.blockSize() + upper.blockSize());
            this.upperBlock_$eq(upper.upperBlock());
            this.upperBlock().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                ((Block)x$2).lowerBlock_$eq((Option<Block>)new Some((Object)this));
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ AddressSpaceAllocator com$nvidia$spark$rapids$AddressSpaceAllocator$Block$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$allocate$3(Block $this, Block unallocated$1, Block b) {
            Object object = b.lowerBlock().get();
            Block block = $this;
            Predef$.MODULE$.assert(!(object != null ? !object.equals(block) : block != null), (Function0 & Serializable & scala.Serializable)() -> "block linkage broken");
            Predef$.MODULE$.assert($this.address() + $this.blockSize() == b.address(), (Function0 & Serializable & scala.Serializable)() -> "block adjacency broken");
            b.lowerBlock_$eq((Option<Block>)new Some((Object)unallocated$1));
        }

        public static final /* synthetic */ void $anonfun$free$3(Block $this, Block b) {
            block0: {
                if (b.allocated()) break block0;
                $this.com$nvidia$spark$rapids$AddressSpaceAllocator$Block$$$outer().com$nvidia$spark$rapids$AddressSpaceAllocator$$removeFreeBlock(b);
                $this.coalesceUpper();
            }
        }

        public static final /* synthetic */ void $anonfun$free$4(Block $this, ObjectRef freeBlock$1, Block b) {
            block0: {
                if (b.allocated()) break block0;
                $this.com$nvidia$spark$rapids$AddressSpaceAllocator$Block$$$outer().com$nvidia$spark$rapids$AddressSpaceAllocator$$removeFreeBlock(b);
                b.coalesceUpper();
                freeBlock$1.elem = b;
            }
        }

        public Block(AddressSpaceAllocator $outer, long address, long blockSize, Option<Block> lowerBlock, Option<Block> upperBlock, boolean allocated) {
            this.address = address;
            this.blockSize = blockSize;
            this.lowerBlock = lowerBlock;
            this.upperBlock = upperBlock;
            this.allocated = allocated;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

