/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumNameSerializer
extends Serializer<Enum> {
    private final Class<? extends Enum> enumType;
    private final Serializer stringSerializer;

    public EnumNameSerializer(Kryo kryo, Class<? extends Enum> type) {
        this.enumType = type;
        this.stringSerializer = kryo.getSerializer(String.class);
        this.setImmutable(true);
    }

    @Override
    public void write(Kryo kryo, Output output2, Enum object) {
        kryo.writeObject(output2, object.name(), this.stringSerializer);
    }

    @Override
    public Enum read(Kryo kryo, Input input, Class<Enum> type) {
        String name = kryo.readObject(input, String.class, this.stringSerializer);
        try {
            return Enum.valueOf(this.enumType, name);
        }
        catch (IllegalArgumentException e) {
            throw new KryoException("Invalid name for enum \"" + this.enumType.getName() + "\": " + name, e);
        }
    }
}

