/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.execution.python;

import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.CudaMemInfo;
import com.nvidia.spark.rapids.GpuDeviceManager$;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.python.PythonConfEntries$;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.api.python.ChainedPythonFunctions;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.Python$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.sql.internal.SQLConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class GpuPythonHelper$
implements Logging {
    public static GpuPythonHelper$ MODULE$;
    private RapidsConf rapidsConf;
    private String gpuId;
    private String isPythonPooledMemEnabled;
    private String isPythonUvmEnabled;
    private Tuple2<Object, Object> x$1;
    private long initAllocPerWorker;
    private long maxAllocPerWorker;
    private final SparkConf sparkConf;
    private final Map<String, Tuple2<String, String>> mapDefaultPythonModules;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    static {
        new GpuPythonHelper$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private RapidsConf rapidsConf$lzycompute() {
        GpuPythonHelper$ gpuPythonHelper$ = this;
        synchronized (gpuPythonHelper$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.rapidsConf = new RapidsConf(this.sparkConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.rapidsConf;
    }

    private RapidsConf rapidsConf() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.rapidsConf$lzycompute() : this.rapidsConf;
    }

    private String gpuId$lzycompute() {
        GpuPythonHelper$ gpuPythonHelper$ = this;
        synchronized (gpuPythonHelper$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.gpuId = GpuDeviceManager$.MODULE$.getDeviceId().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException("No gpu id!");
                }).toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.gpuId;
    }

    private String gpuId() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.gpuId$lzycompute() : this.gpuId;
    }

    private String isPythonPooledMemEnabled$lzycompute() {
        GpuPythonHelper$ gpuPythonHelper$ = this;
        synchronized (gpuPythonHelper$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.isPythonPooledMemEnabled = ((Option)this.rapidsConf().get(PythonConfEntries$.MODULE$.PYTHON_POOLED_MEM())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> MODULE$.rapidsConf().isPooledMemEnabled()).toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.isPythonPooledMemEnabled;
    }

    private String isPythonPooledMemEnabled() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.isPythonPooledMemEnabled$lzycompute() : this.isPythonPooledMemEnabled;
    }

    private String isPythonUvmEnabled$lzycompute() {
        GpuPythonHelper$ gpuPythonHelper$ = this;
        synchronized (gpuPythonHelper$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.isPythonUvmEnabled = ((Option)this.rapidsConf().get(PythonConfEntries$.MODULE$.PYTHON_UVM_ENABLED())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> MODULE$.rapidsConf().isUvmEnabled()).toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.isPythonUvmEnabled;
    }

    private String isPythonUvmEnabled() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.isPythonUvmEnabled$lzycompute() : this.isPythonUvmEnabled;
    }

    private Tuple2<Object, Object> x$1$lzycompute() {
        GpuPythonHelper$ gpuPythonHelper$ = this;
        synchronized (gpuPythonHelper$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                Tuple2.mcJJ.sp sp2;
                Tuple2.mcJJ.sp sp3;
                CudaMemInfo info = Cuda.memGetInfo();
                double maxFactionTotal = BoxesRunTime.unboxToDouble((Object)this.rapidsConf().get(PythonConfEntries$.MODULE$.PYTHON_RMM_MAX_ALLOC_FRACTION()));
                long maxAllocTotal = (long)(maxFactionTotal * (double)info.total);
                long initAllocTotal = BoxesRunTime.unboxToLong((Object)((Option)this.rapidsConf().get(PythonConfEntries$.MODULE$.PYTHON_RMM_ALLOC_FRACTION())).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)fraction -> {
                    if (0.0 < maxFactionTotal && maxFactionTotal < fraction) {
                        throw new IllegalArgumentException(new StringBuilder(65).append("The value of '").append(PythonConfEntries$.MODULE$.PYTHON_RMM_MAX_ALLOC_FRACTION()).append("' ").append("should not be less than that of '").append(PythonConfEntries$.MODULE$.PYTHON_RMM_ALLOC_FRACTION()).append("', but found ").append(maxFactionTotal).append(" < ").append(fraction).toString());
                    }
                    return (long)(fraction * (double)info$1.total);
                }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> (long)(0.5 * (double)info$1.free)));
                if (initAllocTotal > info.free) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Initial RMM allocation(").append((double)initAllocTotal / 1024.0 / (double)1024).append(" MB) for ").append("all the Python workers is larger than free memory(").append((double)info$1.free / 1024.0 / (double)1024).append(" MB)").toString());
                } else {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Configure ").append((double)initAllocTotal / 1024.0 / (double)1024).append("MB GPU memory for ").append("all the Python workers.").toString());
                }
                Integer concurrentPythonWorkers = this.rapidsConf().get(PythonConfEntries$.MODULE$.CONCURRENT_PYTHON_WORKERS());
                if (0 < Predef$.MODULE$.Integer2int(concurrentPythonWorkers)) {
                    sp3 = new Tuple2.mcJJ.sp(initAllocTotal / (long)Predef$.MODULE$.Integer2int(concurrentPythonWorkers), maxAllocTotal / (long)Predef$.MODULE$.Integer2int(concurrentPythonWorkers));
                } else {
                    int cpuTaskSlots = BoxesRunTime.unboxToInt((Object)this.sparkConf().get(package$.MODULE$.EXECUTOR_CORES())) / Math.max(1, BoxesRunTime.unboxToInt((Object)this.sparkConf().get(package$.MODULE$.CPUS_PER_TASK())));
                    sp3 = sp2 = new Tuple2.mcJJ.sp(initAllocTotal / (long)cpuTaskSlots, maxAllocTotal / (long)cpuTaskSlots);
                }
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                long initAllocPerWorker = sp2._1$mcJ$sp();
                long maxAllocPerWorker = sp2._2$mcJ$sp();
                Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(initAllocPerWorker, maxAllocPerWorker);
                this.x$1 = sp4;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private long initAllocPerWorker$lzycompute() {
        GpuPythonHelper$ gpuPythonHelper$ = this;
        synchronized (gpuPythonHelper$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.initAllocPerWorker = this.x$1()._1$mcJ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.initAllocPerWorker;
    }

    private long initAllocPerWorker() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.initAllocPerWorker$lzycompute() : this.initAllocPerWorker;
    }

    private long maxAllocPerWorker$lzycompute() {
        GpuPythonHelper$ gpuPythonHelper$ = this;
        synchronized (gpuPythonHelper$) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.maxAllocPerWorker = this.x$1()._2$mcJ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.maxAllocPerWorker;
    }

    private long maxAllocPerWorker() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.maxAllocPerWorker$lzycompute() : this.maxAllocPerWorker;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isPythonOnGpuEnabled(SQLConf sqlConf, String name) {
        void var3_3;
        block0: {
            boolean pythonEnabled = BoxesRunTime.unboxToBoolean((Object)new RapidsConf(sqlConf).get(PythonConfEntries$.MODULE$.PYTHON_GPU_ENABLED()));
            if (!pythonEnabled) break block0;
            this.checkPythonConfigs(this.sparkConf(), name);
        }
        return (boolean)var3_3;
    }

    public String isPythonOnGpuEnabled$default$2() {
        return "spark";
    }

    public void injectGpuInfo(Seq<ChainedPythonFunctions> funcs, boolean isPythonOnGpuEnabled) {
        funcs.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            GpuPythonHelper$.$anonfun$injectGpuInfo$1(isPythonOnGpuEnabled, x$2);
            return BoxedUnit.UNIT;
        });
    }

    private Map<String, Tuple2<String, String>> mapDefaultPythonModules() {
        return this.mapDefaultPythonModules;
    }

    public void checkPythonConfigs(SparkConf conf, String name) {
        GpuPythonHelper$ gpuPythonHelper$ = this;
        synchronized (gpuPythonHelper$) {
            SparkConf sparkConf;
            boolean useDaemon;
            Tuple2 tuple2 = (Tuple2)this.mapDefaultPythonModules().apply((Object)name);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String daemonModule = (String)tuple2._1();
            String workerModule = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)daemonModule, (Object)workerModule);
            Tuple2 tuple23 = tuple22;
            String daemonModule2 = (String)tuple23._1();
            String workerModule2 = (String)tuple23._2();
            Iterable allPythonModules = this.mapDefaultPythonModules().values();
            boolean useDaemonEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(Python$.MODULE$.PYTHON_USE_DAEMON()));
            boolean bl = useDaemon = !System.getProperty("os.name").startsWith("Windows") && useDaemonEnabled;
            if (useDaemon) {
                Option oDaemon = (Option)conf.get((ConfigEntry)Python$.MODULE$.PYTHON_DAEMON_MODULE());
                if (oDaemon.nonEmpty()) {
                    String daemon = (String)oDaemon.get();
                    boolean isAllowedDaemon = allPythonModules.exists((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)GpuPythonHelper$.$anonfun$checkPythonConfigs$1(daemon, v)));
                    if (!isAllowedDaemon) {
                        throw new IllegalArgumentException(new StringBuilder(67).append("Python daemon module config conflicts.").append(" Expect one of [").append(((TraversableOnce)allPythonModules.map((Function1 & Serializable & scala.Serializable)v -> (String)v._1(), Iterable$.MODULE$.canBuildFrom())).toSet().mkString(", ")).append("],").append(" but found ").append(daemon).toString());
                    }
                    sparkConf = BoxedUnit.UNIT;
                } else {
                    sparkConf = conf.set(Python$.MODULE$.PYTHON_DAEMON_MODULE(), (Object)daemonModule2);
                }
            } else {
                Option oWorker = (Option)conf.get((ConfigEntry)Python$.MODULE$.PYTHON_WORKER_MODULE());
                if (oWorker.nonEmpty()) {
                    String worker = (String)oWorker.get();
                    boolean isAllowedWorker = allPythonModules.exists((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)GpuPythonHelper$.$anonfun$checkPythonConfigs$3(worker, v)));
                    if (!isAllowedWorker) {
                        throw new IllegalArgumentException(new StringBuilder(67).append("Python worker module config conflicts.").append(" Expect one of (").append(((TraversableOnce)allPythonModules.map((Function1 & Serializable & scala.Serializable)v -> (String)v._2(), Iterable$.MODULE$.canBuildFrom())).toSet().mkString(", ")).append("),").append(" but found ").append(worker).toString());
                    }
                    sparkConf = BoxedUnit.UNIT;
                } else {
                    sparkConf = conf.set(Python$.MODULE$.PYTHON_WORKER_MODULE(), (Object)workerModule2);
                }
            }
        }
    }

    public static final /* synthetic */ void $anonfun$injectGpuInfo$1(boolean isPythonOnGpuEnabled$1, ChainedPythonFunctions x$2) {
        x$2.funcs().foreach((Function1 & Serializable & scala.Serializable)pyF -> {
            pyF.envVars().put("CUDA_VISIBLE_DEVICES", MODULE$.gpuId());
            pyF.envVars().put("RAPIDS_PYTHON_ENABLED", Boolean.toString(isPythonOnGpuEnabled$1));
            pyF.envVars().put("RAPIDS_UVM_ENABLED", MODULE$.isPythonUvmEnabled());
            pyF.envVars().put("RAPIDS_POOLED_MEM_ENABLED", MODULE$.isPythonPooledMemEnabled());
            pyF.envVars().put("RAPIDS_POOLED_MEM_SIZE", Long.toString(MODULE$.initAllocPerWorker()));
            return pyF.envVars().put("RAPIDS_POOLED_MEM_MAX_SIZE", Long.toString(MODULE$.maxAllocPerWorker()));
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkPythonConfigs$1(String daemon$1, Tuple2 v) {
        Object object = v._1();
        String string = daemon$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkPythonConfigs$3(String worker$1, Tuple2 v) {
        Object object = v._2();
        String string = worker$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    private GpuPythonHelper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.sparkConf = SparkEnv$.MODULE$.get().conf();
        this.mapDefaultPythonModules = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"spark", (Object)new Tuple2((Object)"rapids.daemon", (Object)"rapids.worker")), new Tuple2((Object)"databricks", (Object)new Tuple2((Object)"rapids.daemon_databricks", (Object)"rapids.worker"))}));
    }
}

