/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.execution;

import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.shims.SparkShimImpl$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.rapids.execution.SerializeConcatHostBuffersDeserializeBatch;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public final class GpuBroadcastHelper$ {
    public static GpuBroadcastHelper$ MODULE$;

    static {
        new GpuBroadcastHelper$();
    }

    public ColumnarBatch getBroadcastBatch(Broadcast<Object> broadcastRelation, StructType broadcastSchema) {
        ColumnarBatch columnarBatch;
        Object object = broadcastRelation.value();
        if (object instanceof SerializeConcatHostBuffersDeserializeBatch) {
            SerializeConcatHostBuffersDeserializeBatch serializeConcatHostBuffersDeserializeBatch = (SerializeConcatHostBuffersDeserializeBatch)object;
            ColumnarBatch builtBatch = serializeConcatHostBuffersDeserializeBatch.batch();
            GpuColumnVector.incRefCounts(builtBatch);
            columnarBatch = builtBatch;
        } else if (SparkShimImpl$.MODULE$.isEmptyRelation(object)) {
            columnarBatch = GpuColumnVector.emptyBatch(broadcastSchema);
        } else {
            throw new IllegalStateException(new StringBuilder(33).append("Invalid broadcast batch received ").append(object).toString());
        }
        return columnarBatch;
    }

    public int getBroadcastBatchNumRows(Broadcast<Object> broadcastRelation) {
        int n;
        Object object = broadcastRelation.value();
        if (object instanceof SerializeConcatHostBuffersDeserializeBatch) {
            SerializeConcatHostBuffersDeserializeBatch serializeConcatHostBuffersDeserializeBatch = (SerializeConcatHostBuffersDeserializeBatch)object;
            n = serializeConcatHostBuffersDeserializeBatch.batch().numRows();
        } else if (SparkShimImpl$.MODULE$.isEmptyRelation(object)) {
            n = 0;
        } else {
            throw new IllegalStateException(new StringBuilder(33).append("Invalid broadcast batch received ").append(object).toString());
        }
        return n;
    }

    private GpuBroadcastHelper$() {
        MODULE$ = this;
    }
}

