/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuSemaphore$;
import com.nvidia.spark.rapids.NoopMetric$;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.ShuffleBufferCatalog;
import com.nvidia.spark.rapids.ShuffleBufferId;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleIterator;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleIterator$;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleTransport;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleTransport$;
import java.io.Serializable;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.sql.rapids.ShuffleMetricsUpdater;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.util.CompletionIterator;
import org.apache.spark.util.CompletionIterator$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product2;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0006\r\u0001]A\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003o\u0011!\u0011\bA!A!\u0002\u0013\u0019\b\u0002\u0003<\u0001\u0005\u0003\u0005\u000b\u0011B<\t\u0013}\u0004!\u0011!Q\u0001\n\u0005\u0005\u0001BCA\u0004\u0001\t\u0005\t\u0015!\u0003\u0002\n!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001bBA\u001a\u0001\u0011\u0005\u0013Q\u0007\u0002\u0014%\u0006\u0004\u0018\u000eZ:DC\u000eD\u0017N\\4SK\u0006$WM\u001d\u0006\u0003\u001b9\taA]1qS\u0012\u001c(BA\b\u0011\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u0001Qc\u0001\r(cM)\u0001!G\u00104{A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\u0004B\u0001I\u0012&a5\t\u0011E\u0003\u0002#!\u000591\u000f[;gM2,\u0017B\u0001\u0013\"\u00055\u0019\u0006.\u001e4gY\u0016\u0014V-\u00193feB\u0011ae\n\u0007\u0001\t\u0015A\u0003A1\u0001*\u0005\u0005Y\u0015C\u0001\u0016.!\tQ2&\u0003\u0002-7\t9aj\u001c;iS:<\u0007C\u0001\u000e/\u0013\ty3DA\u0002B]f\u0004\"AJ\u0019\u0005\u000bI\u0002!\u0019A\u0015\u0003\u0003\r\u0003\"\u0001N\u001e\u000e\u0003UR!!\u0004\u001c\u000b\u0005E9$B\u0001\u001d:\u0003\u0019qg/\u001b3jC*\t!(A\u0002d_6L!\u0001P\u001b\u0003\u0007\u0005\u0013X\u000e\u0005\u0002?\u00036\tqH\u0003\u0002A!\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002C\u007f\t9Aj\\4hS:<\u0017A\u0003:ba&$7oQ8oMB\u0011A'R\u0005\u0003\rV\u0012!BU1qS\u0012\u001c8i\u001c8g\u0003\u001dawnY1m\u0013\u0012\u0004\"!\u0013'\u000e\u0003)S!a\u0013\t\u0002\u000fM$xN]1hK&\u0011QJ\u0013\u0002\u000f\u00052|7m['b]\u0006<WM]%e\u0003=\u0011Gn\\2lg\nK\u0018\t\u001a3sKN\u001c\bc\u0001)Y7:\u0011\u0011K\u0016\b\u0003%Vk\u0011a\u0015\u0006\u0003)Z\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0005][\u0012a\u00029bG.\fw-Z\u0005\u00033j\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003/n\u0001BA\u0007/I=&\u0011Ql\u0007\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007A{\u0016-\u0003\u0002a5\n\u00191+Z9\u0011\u000bi\u0011Gm\u001a6\n\u0005\r\\\"A\u0002+va2,7\u0007\u0005\u0002JK&\u0011aM\u0013\u0002\b\u00052|7m[%e!\tQ\u0002.\u0003\u0002j7\t!Aj\u001c8h!\tQ2.\u0003\u0002m7\t\u0019\u0011J\u001c;\u0002\u000f\r|g\u000e^3yiB\u0011q\u000e]\u0007\u0002!%\u0011\u0011\u000f\u0005\u0002\f)\u0006\u001c8nQ8oi\u0016DH/A\u0004nKR\u0014\u0018nY:\u0011\u0005\u0001\"\u0018BA;\"\u0005i\u0019\u0006.\u001e4gY\u0016\u0014V-\u00193NKR\u0014\u0018nY:SKB|'\u000f^3s\u0003%!(/\u00198ta>\u0014H\u000fE\u0002\u001bqjL!!_\u000e\u0003\r=\u0003H/[8o!\tYX0D\u0001}\u0015\t\u0011S'\u0003\u0002\u007fy\n1\"+\u00199jIN\u001c\u0006.\u001e4gY\u0016$&/\u00198ta>\u0014H/A\u0004dCR\fGn\\4\u0011\u0007Q\n\u0019!C\u0002\u0002\u0006U\u0012Ac\u00155vM\u001adWMQ;gM\u0016\u00148)\u0019;bY><\u0017AC:qCJ\\G+\u001f9fgB)!$a\u0003\u0002\u0010%\u0019\u0011QB\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006\u000f\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tI\"a\u0005\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fa\u0001P5oSRtDCEA\u0010\u0003G\t)#a\n\u0002*\u0005-\u0012QFA\u0018\u0003c\u0001R!!\t\u0001KAj\u0011\u0001\u0004\u0005\u0006\u0007&\u0001\r\u0001\u0012\u0005\u0006\u000f&\u0001\r\u0001\u0013\u0005\u0006\u001d&\u0001\ra\u0014\u0005\u0006[&\u0001\rA\u001c\u0005\u0006e&\u0001\ra\u001d\u0005\u0006m&\u0001\ra\u001e\u0005\u0007\u007f&\u0001\r!!\u0001\t\u000f\u0005\u001d\u0011\u00021\u0001\u0002\n\u0005!!/Z1e)\t\t9\u0004\u0005\u0003Q1\u0006e\u0002#\u0002\u000e\u0002<\u0015\u0002\u0014bAA\u001f7\tA\u0001K]8ek\u000e$(\u0007")
public class RapidsCachingReader<K, C>
implements ShuffleReader<K, C>,
Arm,
Logging {
    private final RapidsConf rapidsConf;
    private final BlockManagerId localId;
    private final Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> blocksByAddress;
    private final TaskContext context;
    public final ShuffleReadMetricsReporter org$apache$spark$sql$rapids$RapidsCachingReader$$metrics;
    private final Option<RapidsShuffleTransport> transport;
    private final ShuffleBufferCatalog catalog;
    private final DataType[] sparkTypes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Iterator<Product2<K, C>> read() {
        InterruptibleIterator interruptibleIterator;
        try (NvtxRange readRange = new NvtxRange("RapidsCachingReader.read", NvtxColor.DARK_GREEN);){
            ArrayBuffer blocksForRapidsTransport = new ArrayBuffer();
            ArrayBuffer cachedBlocks = new ArrayBuffer();
            ArrayBuffer cachedBufferIds = new ArrayBuffer();
            Map blocksByAddressMap = this.blocksByAddress.toMap(Predef$.MODULE$.$conforms());
            blocksByAddressMap.keys().foreach((Function1 & Serializable & scala.Serializable)blockManagerId -> {
                RapidsCachingReader.$anonfun$read$1(this, blocksByAddressMap, cachedBlocks, cachedBufferIds, blocksForRapidsTransport, blockManagerId);
                return BoxedUnit.UNIT;
            });
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Will read ").append(cachedBlocks.size()).append(" cached blocks, ").append(blocksForRapidsTransport.size()).append(" remote blocks from the RapidsShuffleTransport. ").toString());
            if (this.transport.isEmpty() && blocksForRapidsTransport.nonEmpty()) {
                throw new IllegalStateException("Had blocks marked for use with the RapidsShuffleTransport, but the transport was not initialized");
            }
            ShuffleMetricsUpdater metricsUpdater = new ShuffleMetricsUpdater(this){
                private final /* synthetic */ RapidsCachingReader $outer;

                public void update(long fetchWaitTimeInMs, long remoteBlocksFetched, long remoteBytesRead, long rowsFetched) {
                    this.$outer.org$apache$spark$sql$rapids$RapidsCachingReader$$metrics.incFetchWaitTime(fetchWaitTimeInMs);
                    this.$outer.org$apache$spark$sql$rapids$RapidsCachingReader$$metrics.incRemoteBlocksFetched(remoteBlocksFetched);
                    this.$outer.org$apache$spark$sql$rapids$RapidsCachingReader$$metrics.incRemoteBytesRead(remoteBytesRead);
                    this.$outer.org$apache$spark$sql$rapids$RapidsCachingReader$$metrics.incRecordsRead(rowsFetched);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            try (NvtxRange itRange = new NvtxRange("Shuffle Iterator prep", NvtxColor.BLUE);){
                Iterator iterator;
                Iterator cachedIt = cachedBufferIds.iterator().map((Function1 & Serializable & scala.Serializable)bufferId -> {
                    GpuSemaphore$.MODULE$.acquireIfNecessary($this.context, NoopMetric$.MODULE$);
                    ColumnarBatch cb = (ColumnarBatch)this.withResource($this.catalog.acquireBuffer((ShuffleBufferId)bufferId), (Function1 & Serializable & scala.Serializable)buffer -> buffer.getColumnarBatch($this.sparkTypes));
                    long cachedBytesRead = GpuColumnVector.getTotalDeviceMemoryUsed(cb);
                    $this.org$apache$spark$sql$rapids$RapidsCachingReader$$metrics.incLocalBytesRead(cachedBytesRead);
                    $this.org$apache$spark$sql$rapids$RapidsCachingReader$$metrics.incRecordsRead((long)cb.numRows());
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)cb);
                });
                if (blocksForRapidsTransport.nonEmpty()) {
                    RapidsShuffleIterator rapidsShuffleIterator = new RapidsShuffleIterator(this.localId, this.rapidsConf, (RapidsShuffleTransport)this.transport.get(), (Tuple2[])blocksForRapidsTransport.toArray(ClassTag$.MODULE$.apply(Tuple2.class)), metricsUpdater, this.sparkTypes, RapidsShuffleIterator$.MODULE$.$lessinit$greater$default$7(), RapidsShuffleIterator$.MODULE$.$lessinit$greater$default$8());
                    iterator = rapidsShuffleIterator.map((Function1 & Serializable & scala.Serializable)cb -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), cb));
                } else {
                    iterator = package$.MODULE$.Iterator().empty();
                }
                Iterator cbArrayFromUcx = iterator;
                CompletionIterator completionIter = CompletionIterator$.MODULE$.apply(cachedIt.$plus$plus(() -> RapidsCachingReader.$anonfun$read$11((Iterator)cbArrayFromUcx)), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.context.taskMetrics().mergeShuffleReadMetrics());
                interruptibleIterator = new InterruptibleIterator(this.context, (Iterator)completionIter);
            }
        }
        return interruptibleIterator;
    }

    public static final /* synthetic */ Object[] $anonfun$read$4(RapidsCachingReader $this, ArrayBuffer cachedBlocks$1, BlockId blockId$1, ShuffleBlockBatchId x2$1, int reduceId) {
        cachedBlocks$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BlockId[]{blockId$1}));
        ShuffleBlockId sBlockId = new ShuffleBlockId(x2$1.shuffleId(), x2$1.mapId(), reduceId);
        return Predef$.MODULE$.refArrayOps((Object[])$this.catalog.blockIdToBuffersIds(sBlockId));
    }

    public static final /* synthetic */ void $anonfun$read$3(RapidsCachingReader $this, ArrayBuffer cachedBlocks$1, ArrayBuffer cachedBufferIds$1, Tuple3 blockInfo) {
        block4: {
            IndexedSeq indexedSeq;
            BlockId blockId = (BlockId)blockInfo._1();
            BlockId blockId2 = blockId;
            if (blockId2 instanceof ShuffleBlockBatchId) {
                ShuffleBlockBatchId shuffleBlockBatchId = (ShuffleBlockBatchId)blockId2;
                indexedSeq = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(shuffleBlockBatchId.startReduceId()), shuffleBlockBatchId.endReduceId()).flatMap((Function1 & Serializable & scala.Serializable)reduceId -> new ArrayOps.ofRef(RapidsCachingReader.$anonfun$read$4($this, cachedBlocks$1, blockId, shuffleBlockBatchId, BoxesRunTime.unboxToInt((Object)reduceId))), IndexedSeq$.MODULE$.canBuildFrom());
            } else if (blockId2 instanceof ShuffleBlockId) {
                ShuffleBlockId shuffleBlockId = (ShuffleBlockId)blockId2;
                cachedBlocks$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BlockId[]{blockId}));
                indexedSeq = Predef$.MODULE$.wrapRefArray((Object[])$this.catalog.blockIdToBuffersIds(shuffleBlockId));
            } else {
                throw new IllegalArgumentException(new StringBuilder(28).append(blockId.getClass()).append(" ").append(blockId).append(" is not currently supported").toString());
            }
            IndexedSeq shuffleBufferIds = indexedSeq;
            cachedBufferIds$1.$plus$plus$eq((TraversableOnce)shuffleBufferIds);
            shuffleBufferIds.foreach((Function1 & Serializable & scala.Serializable)id -> {
                $this.catalog.updateSpillPriorityForLocalRead(id);
                return BoxedUnit.UNIT;
            });
            if (!shuffleBufferIds.nonEmpty()) break block4;
            $this.org$apache$spark$sql$rapids$RapidsCachingReader$$metrics.incLocalBlocksFetched(1L);
        }
    }

    public static final /* synthetic */ void $anonfun$read$1(RapidsCachingReader $this, Map blocksByAddressMap$1, ArrayBuffer cachedBlocks$1, ArrayBuffer cachedBufferIds$1, ArrayBuffer blocksForRapidsTransport$1, BlockManagerId blockManagerId) {
        Seq blockInfos = (Seq)blocksByAddressMap$1.apply((Object)blockManagerId);
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Trying to read block from manager: ").append(blockManagerId).toString());
        String string = blockManagerId.executorId();
        String string2 = $this.localId.executorId();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            try (NvtxRange readLocalRange = new NvtxRange("Read Local", NvtxColor.GREEN);){
                blockInfos.foreach((Function1 & Serializable & scala.Serializable)blockInfo -> {
                    RapidsCachingReader.$anonfun$read$3($this, cachedBlocks$1, cachedBufferIds$1, blockInfo);
                    return BoxedUnit.UNIT;
                });
            }
        } else {
            Predef$.MODULE$.require(blockManagerId.topologyInfo().isDefined() && ((String)blockManagerId.topologyInfo().get()).startsWith(new StringBuilder(1).append(RapidsShuffleTransport$.MODULE$.BLOCK_MANAGER_ID_TOPO_PREFIX()).append("=").toString()), (Function0 & Serializable & scala.Serializable)() -> {
                String enabledHint = $this.rapidsConf.isUCXShuffleManagerMode() ? new StringBuilder(84).append("The shuffle transport is disabled. ").append("Please set ").append(RapidsConf$.MODULE$.SHUFFLE_MANAGER_MODE().key()).append("=UCX to enable ").append("fetching remote blocks.").toString() : "This is unexpected behavior!";
                return new StringBuilder(54).append("Attempting to handle non-rapids enabled blocks from ").append(blockManagerId).append(". ").append(enabledHint).toString();
            });
            blocksForRapidsTransport$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)blockManagerId, (Object)blockInfos)}));
        }
    }

    public static final /* synthetic */ Iterator $anonfun$read$11(Iterator cbArrayFromUcx$1) {
        return cbArrayFromUcx$1;
    }

    public RapidsCachingReader(RapidsConf rapidsConf, BlockManagerId localId, Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> blocksByAddress, TaskContext context, ShuffleReadMetricsReporter metrics, Option<RapidsShuffleTransport> transport, ShuffleBufferCatalog catalog, DataType[] sparkTypes) {
        this.rapidsConf = rapidsConf;
        this.localId = localId;
        this.blocksByAddress = blocksByAddress;
        this.context = context;
        this.org$apache$spark$sql$rapids$RapidsCachingReader$$metrics = metrics;
        this.transport = transport;
        this.catalog = catalog;
        this.sparkTypes = sparkTypes;
        Arm.$init$(this);
        Logging.$init$((Logging)this);
    }
}

