/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.ShimLoader$;
import com.nvidia.spark.rapids.ShuffleBufferCatalog;
import com.nvidia.spark.rapids.ShuffleReceivedBufferCatalog;
import com.nvidia.spark.rapids.TableCompressionCodec;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.sql.rapids.GpuShuffleEnv;
import org.apache.spark.sql.rapids.RapidsShuffleManagerLike;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GpuShuffleEnv$
implements Logging {
    public static GpuShuffleEnv$ MODULE$;
    private final String RAPIDS_SHUFFLE_CLASS;
    private final String RAPIDS_SHUFFLE_INTERNAL;
    private volatile GpuShuffleEnv env;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new GpuShuffleEnv$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean isUCXShuffleAndEarlyStart(RapidsConf conf) {
        return conf.isUCXShuffleManagerMode() && conf.shuffleTransportEarlyStart();
    }

    public String RAPIDS_SHUFFLE_CLASS() {
        return this.RAPIDS_SHUFFLE_CLASS;
    }

    public String RAPIDS_SHUFFLE_INTERNAL() {
        return this.RAPIDS_SHUFFLE_INTERNAL;
    }

    private GpuShuffleEnv env() {
        return this.env;
    }

    private void env_$eq(GpuShuffleEnv x$1) {
        this.env = x$1;
    }

    public void shutdown() {
        Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.shuffleManager()).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ShuffleManager, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                Object object = A12 instanceof RapidsShuffleManagerLike ? (A1 = A12) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(ShuffleManager x1) {
                ShuffleManager shuffleManager = x1;
                boolean bl = shuffleManager instanceof RapidsShuffleManagerLike;
                return bl;
            }
        }).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
        this.env_$eq(null);
    }

    public boolean isExternalShuffleEnabled() {
        return SparkEnv$.MODULE$.get().blockManager().externalShuffleServiceEnabled();
    }

    public boolean isSparkAuthenticateEnabled() {
        SparkConf conf = SparkEnv$.MODULE$.get().conf();
        return conf.getBoolean("spark.authenticate", false);
    }

    public void initShuffleManager() {
        ShuffleManager shuffleManager = SparkEnv$.MODULE$.get().shuffleManager();
        if (!(shuffleManager instanceof RapidsShuffleManagerLike)) {
            throw new IllegalStateException("Cannot initialize the RAPIDS Shuffle Manager");
        }
        ShuffleManager shuffleManager2 = shuffleManager;
        ((RapidsShuffleManagerLike)shuffleManager2).initialize();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public boolean isRapidsShuffleAvailable(RapidsConf conf) {
        boolean isConfiguredInEnv;
        SparkEnv sparkEnv = SparkEnv$.MODULE$.get();
        boolean isRapidsManager = sparkEnv.shuffleManager() instanceof RapidsShuffleManagerLike;
        if (isRapidsManager) {
            this.validateRapidsShuffleManager(sparkEnv.shuffleManager().getClass().getName());
        }
        return ((isConfiguredInEnv = Option$.MODULE$.apply((Object)this.env()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.org$apache$spark$sql$rapids$GpuShuffleEnv$$isRapidsShuffleConfigured()))) || isRapidsManager) && (conf.isMultiThreadedShuffleManagerMode() || conf.isGPUShuffle() && !this.isExternalShuffleEnabled() && !this.isSparkAuthenticateEnabled()) && conf.isSqlExecuteOnGPU();
    }

    public boolean useGPUShuffle(RapidsConf conf) {
        return conf.shuffleManagerEnabled() && conf.isGPUShuffle() && this.isRapidsShuffleAvailable(conf);
    }

    public boolean useMultiThreadedShuffle(RapidsConf conf) {
        return conf.shuffleManagerEnabled() && conf.isMultiThreadedShuffleManagerMode() && this.isRapidsShuffleAvailable(conf);
    }

    public ShuffleBufferCatalog getCatalog() {
        return this.env() == null ? null : this.env().getCatalog();
    }

    private void validateRapidsShuffleManager(String shuffManagerClassName) {
        String shuffleManagerStr = ShimLoader$.MODULE$.getRapidsShuffleManagerClass();
        String string = shuffManagerClassName;
        String string2 = shuffleManagerStr;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new IllegalStateException(new StringBuilder(143).append("RapidsShuffleManager class mismatch (").append(shuffManagerClassName).append(" != ").append(shuffleManagerStr).append("). ").append("Check that configuration setting spark.shuffle.manager is correct for the Spark ").append("version being used.").toString());
        }
    }

    public void init(RapidsConf conf) {
        GpuShuffleEnv shuffleEnv = new GpuShuffleEnv(conf);
        shuffleEnv.init();
        this.env_$eq(shuffleEnv);
    }

    public ShuffleReceivedBufferCatalog getReceivedCatalog() {
        return this.env().getReceivedCatalog();
    }

    public Option<TableCompressionCodec> rapidsShuffleCodec() {
        return this.env().rapidsShuffleCodec();
    }

    public long shuffleFetchTimeoutSeconds() {
        return this.env().getShuffleFetchTimeoutSeconds();
    }

    private GpuShuffleEnv$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.RAPIDS_SHUFFLE_CLASS = ShimLoader$.MODULE$.getRapidsShuffleManagerClass();
        this.RAPIDS_SHUFFLE_INTERNAL = ShimLoader$.MODULE$.getRapidsShuffleInternalClass();
    }
}

