/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import ai.rapids.cudf.BinaryOp;
import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.BoolUtils$;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.Serializable;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;

public final class GpuSequenceUtil$
implements Arm {
    public static GpuSequenceUtil$ MODULE$;

    static {
        new GpuSequenceUtil$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    private void checkSequenceInputs(ColumnVector start, ColumnVector stop, ColumnVector step) {
        this.withResource(Scalar.fromByte((byte)((byte)0)), (Function1 & Serializable & scala.Serializable)zero -> {
            GpuSequenceUtil$.MODULE$.withResource(new Table(new ColumnVector[]{start, stop}), (Function1 & Serializable & scala.Serializable)startStopTable -> {
                GpuSequenceUtil$.$anonfun$checkSequenceInputs$2(step$1, zero, startStopTable);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public ColumnVector computeSequenceSizes(ColumnVector start, ColumnVector stop, ColumnVector step) {
        this.checkSequenceInputs(start, stop, step);
        ColumnVector sizeAsLong = (ColumnVector)this.withResource(Scalar.fromLong((long)1L), (Function1 & Serializable & scala.Serializable)one -> {
            ColumnVector diff = (ColumnVector)MODULE$.withResource(stop.castTo(DType.INT64), (Function1 & Serializable & scala.Serializable)stopAsLong -> (ColumnVector)MODULE$.withResource(start.castTo(DType.INT64), (Function1 & Serializable & scala.Serializable)startAsLong -> stopAsLong.sub((BinaryOperable)startAsLong)));
            ColumnVector quotient2 = (ColumnVector)MODULE$.withResource(diff, (Function1 & Serializable & scala.Serializable)x$35 -> (ColumnVector)MODULE$.withResource(step.castTo(DType.INT64), (Function1 & Serializable & scala.Serializable)stepAsLong -> diff.div((BinaryOperable)stepAsLong)));
            ColumnVector actualSize = (ColumnVector)MODULE$.withResource(quotient2, (Function1 & Serializable & scala.Serializable)quotient -> quotient.add((BinaryOperable)one, DType.INT64));
            return (ColumnVector)MODULE$.withResource(actualSize, (Function1 & Serializable & scala.Serializable)x$36 -> {
                ColumnVector mergedEquals = (ColumnVector)MODULE$.withResource(start.equalTo((BinaryOperable)stop), (Function1 & Serializable & scala.Serializable)equals -> step.hasNulls() ? equals.mergeAndSetValidity(BinaryOp.BITWISE_AND, new ColumnView[]{equals, step}) : equals.incRefCount());
                return (ColumnVector)MODULE$.withResource(mergedEquals, (Function1 & Serializable & scala.Serializable)x$37 -> mergedEquals.ifElse(one, (ColumnView)actualSize));
            });
        });
        return (ColumnVector)this.withResource(sizeAsLong, (Function1 & Serializable & scala.Serializable)x$38 -> {
            MODULE$.withResource(Scalar.fromInt((int)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH), (Function1 & Serializable & scala.Serializable)maxLen -> {
                GpuSequenceUtil$.MODULE$.withResource(sizeAsLong.lessOrEqualTo((BinaryOperable)maxLen), (Function1 & Serializable & scala.Serializable)allValid -> {
                    Predef$.MODULE$.require(BoolUtils$.MODULE$.isAllValidTrue(allValid), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Too long sequence found. Should be <= ").append(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH).toString());
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            return sizeAsLong.castTo(DType.INT32);
        });
    }

    public static final /* synthetic */ void $anonfun$checkSequenceInputs$2(ColumnVector step$1, Scalar zero$2, Table startStopTable) {
        Table upTbl = (Table)MODULE$.withResource(step$1.greaterThan((BinaryOperable)zero$2), (Function1 & Serializable & scala.Serializable)positiveStep -> startStopTable.filter((ColumnView)positiveStep));
        ColumnVector allUp = (ColumnVector)MODULE$.withResource(upTbl, (Function1 & Serializable & scala.Serializable)x$29 -> upTbl.getColumn(0).lessOrEqualTo((BinaryOperable)upTbl.getColumn(1)));
        MODULE$.withResource(allUp, (Function1 & Serializable & scala.Serializable)x$30 -> {
            Predef$.MODULE$.require(BoolUtils$.MODULE$.isAllValidTrue(allUp), (Function0 & Serializable & scala.Serializable)() -> "Illegal sequence boundaries: step > 0 but start > stop");
            return BoxedUnit.UNIT;
        });
        Table downTbl = (Table)MODULE$.withResource(step$1.lessThan((BinaryOperable)zero$2), (Function1 & Serializable & scala.Serializable)negativeStep -> startStopTable.filter((ColumnView)negativeStep));
        ColumnVector allDown = (ColumnVector)MODULE$.withResource(downTbl, (Function1 & Serializable & scala.Serializable)x$31 -> downTbl.getColumn(0).greaterOrEqualTo((BinaryOperable)downTbl.getColumn(1)));
        MODULE$.withResource(allDown, (Function1 & Serializable & scala.Serializable)x$32 -> {
            Predef$.MODULE$.require(BoolUtils$.MODULE$.isAllValidTrue(allDown), (Function0 & Serializable & scala.Serializable)() -> "Illegal sequence boundaries: step < 0 but start < stop");
            return BoxedUnit.UNIT;
        });
        Table equalTbl = (Table)MODULE$.withResource(step$1.equalTo((BinaryOperable)zero$2), (Function1 & Serializable & scala.Serializable)zeroStep -> startStopTable.filter((ColumnView)zeroStep));
        ColumnVector allEq = (ColumnVector)MODULE$.withResource(equalTbl, (Function1 & Serializable & scala.Serializable)x$33 -> equalTbl.getColumn(0).equalTo((BinaryOperable)equalTbl.getColumn(1)));
        MODULE$.withResource(allEq, (Function1 & Serializable & scala.Serializable)x$34 -> {
            Predef$.MODULE$.require(BoolUtils$.MODULE$.isAllValidTrue(allEq), (Function0 & Serializable & scala.Serializable)() -> "Illegal sequence boundaries: step == 0 but start != stop");
            return BoxedUnit.UNIT;
        });
    }

    private GpuSequenceUtil$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

