/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import com.nvidia.spark.rapids.ExprMeta;
import com.nvidia.spark.rapids.QuantifierFixedLength;
import com.nvidia.spark.rapids.QuantifierVariableLength;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RegexAST;
import com.nvidia.spark.rapids.RegexGroup;
import com.nvidia.spark.rapids.RegexParser;
import com.nvidia.spark.rapids.RegexQuantifier;
import com.nvidia.spark.rapids.RegexRepetition;
import com.nvidia.spark.rapids.RegexSequence;
import com.nvidia.spark.rapids.SimpleQuantifier;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ListBuffer;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class GpuRegExpUtils$ {
    public static GpuRegExpUtils$ MODULE$;

    static {
        new GpuRegExpUtils$();
    }

    private RegexAST parseAST(String pattern) {
        return new RegexParser(pattern).parse();
    }

    public Tuple2<Object, String> backrefConversion(String rep) {
        scala.collection.mutable.StringBuilder b = new scala.collection.mutable.StringBuilder();
        int i = 0;
        while (i < rep.length()) {
            if (((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'$', '\\'}))).contains((Object)BoxesRunTime.boxToCharacter((char)rep.charAt(i))) && i + 1 < rep.length() && RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(rep.charAt(i + 1)))) {
                b.append("${");
                int j = i + 1;
                do {
                    b.append(rep.charAt(j));
                } while (++j < rep.length() && RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(rep.charAt(j))));
                b.append("}");
                i = j;
                continue;
            }
            if (rep.charAt(i) == '\\' && i + 1 < rep.length()) {
                b.append('\\').append(rep.charAt(i + 1));
                i += 2;
                continue;
            }
            b.append(rep.charAt(i));
            ++i;
        }
        String converted = b.toString();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((!rep.equals(converted) ? 1 : 0) != 0)), (Object)converted);
    }

    public String unescapeReplaceString(String s) {
        scala.collection.mutable.StringBuilder b = new scala.collection.mutable.StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\\' && i + 1 < s.length()) {
                ++i;
            }
            b.append(s.charAt(i));
        }
        return b.toString();
    }

    public void tagForRegExpEnabled(ExprMeta<?> meta) {
        String string;
        if (!meta.conf().isRegExpEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(62).append("regular expression support is disabled. ").append("Set ").append(RapidsConf$.MODULE$.ENABLE_REGEXP()).append("=true to enable it").toString());
        }
        if ("UTF-8".equals(string = Charset.defaultCharset().name())) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            meta.willNotWorkOnGpu(new StringBuilder(117).append("regular expression support is disabled because the GPU only ").append("supports the UTF-8 charset when using regular expressions").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public boolean isEmptyRepetition(String pattern) {
        return this.isASTEmptyRepetition$1(this.parseAST(pattern));
    }

    public int countGroups(String pattern) {
        return GpuRegExpUtils$.countGroups$1(this.parseAST(pattern));
    }

    private final boolean isASTEmptyRepetition$1(RegexAST regex2) {
        boolean bl;
        block4: {
            RegexAST regexAST;
            while (true) {
                RegexAST term;
                if ((regexAST = regex2) instanceof RegexRepetition) {
                    QuantifierVariableLength quantifierVariableLength;
                    int n;
                    QuantifierFixedLength quantifierFixedLength;
                    int n2;
                    SimpleQuantifier simpleQuantifier;
                    char c;
                    SimpleQuantifier simpleQuantifier2;
                    char c2;
                    RegexRepetition regexRepetition = (RegexRepetition)regexAST;
                    RegexQuantifier term2 = regexRepetition.quantifier();
                    RegexQuantifier regexQuantifier = term2;
                    boolean bl2 = regexQuantifier instanceof SimpleQuantifier && '*' == (c2 = (simpleQuantifier2 = (SimpleQuantifier)regexQuantifier).ch()) ? true : regexQuantifier instanceof SimpleQuantifier && '?' == (c = (simpleQuantifier = (SimpleQuantifier)regexQuantifier).ch());
                    boolean bl3 = bl2 ? true : (regexQuantifier instanceof QuantifierFixedLength && 0 == (n2 = (quantifierFixedLength = (QuantifierFixedLength)regexQuantifier).length()) ? true : regexQuantifier instanceof QuantifierVariableLength && 0 == (n = (quantifierVariableLength = (QuantifierVariableLength)regexQuantifier).minLength()));
                    bl = bl3;
                    break block4;
                }
                if (!(regexAST instanceof RegexGroup)) break;
                RegexGroup regexGroup = (RegexGroup)regexAST;
                regex2 = term = regexGroup.term();
            }
            if (regexAST instanceof RegexSequence) {
                RegexSequence regexSequence = (RegexSequence)regexAST;
                ListBuffer<RegexAST> parts = regexSequence.parts();
                bl = parts.forall((Function1 & Serializable & scala.Serializable)regex -> BoxesRunTime.boxToBoolean((boolean)this.isASTEmptyRepetition$1(regex)));
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private static final int countGroups$1(RegexAST regexp2) {
        int n;
        RegexAST regexAST = regexp2;
        if (regexAST instanceof RegexGroup) {
            RegexGroup regexGroup = (RegexGroup)regexAST;
            RegexAST term = regexGroup.term();
            n = 1 + GpuRegExpUtils$.countGroups$1(term);
        } else {
            n = BoxesRunTime.unboxToInt((Object)((TraversableOnce)regexAST.children().map((Function1 & Serializable & scala.Serializable)regexp -> BoxesRunTime.boxToInteger((int)GpuRegExpUtils$.countGroups$1(regexp)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        return n;
    }

    private GpuRegExpUtils$() {
        MODULE$ = this;
    }
}

