/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.Scalar;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.Serializable;
import java.math.BigInteger;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.rapids.GpuDecimalMultiply;
import org.apache.spark.sql.types.DecimalType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class GpuDecimalMultiply$
implements Arm,
scala.Serializable {
    public static GpuDecimalMultiply$ MODULE$;
    private BigInteger max128Int;
    private BigInteger min128Int;
    private volatile byte bitmap$0;

    static {
        new GpuDecimalMultiply$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public boolean $lessinit$greater$default$4() {
        return false;
    }

    public boolean $lessinit$greater$default$5() {
        return SQLConf$.MODULE$.get().ansiEnabled();
    }

    public Tuple2<Object, Object> lhsRhsNeededScales(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        Tuple2.mcII.sp sp2;
        int cudfIntermediateScale = lhs.scale() + rhs.scale();
        int requiredIntermediateScale = outputType.scale() + 1;
        if (requiredIntermediateScale > cudfIntermediateScale) {
            int neededScaleDiff = requiredIntermediateScale - cudfIntermediateScale;
            int addToLhs = 0;
            int addToRhs = 0;
            int precisionDiff = lhs.precision() - rhs.precision();
            if (precisionDiff > 0) {
                addToRhs = package$.MODULE$.min(precisionDiff, neededScaleDiff);
            } else {
                addToLhs = package$.MODULE$.min(package$.MODULE$.abs(precisionDiff), neededScaleDiff);
            }
            int stillNeeded = neededScaleDiff - (addToLhs + addToRhs);
            if (stillNeeded > 0) {
                int l = stillNeeded / 2;
                int r = stillNeeded - l;
                addToLhs += l;
                addToRhs += r;
            }
            sp2 = new Tuple2.mcII.sp(lhs.scale() + addToLhs, rhs.scale() + addToRhs);
        } else {
            sp2 = new Tuple2.mcII.sp(lhs.scale(), rhs.scale());
        }
        return sp2;
    }

    public int nonRoundedIntermediatePrecision(DecimalType l, DecimalType r, DecimalType outputType) {
        Tuple2<Object, Object> tuple2 = this.lhsRhsNeededScales(l, r, outputType);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int lhsScale = tuple2._1$mcI$sp();
        int rhsScale = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(lhsScale, rhsScale);
        Tuple2.mcII.sp sp3 = sp2;
        int lhsScale2 = sp3._1$mcI$sp();
        int rhsScale2 = sp3._2$mcI$sp();
        int lhsPrecision = l.precision() - l.scale() + lhsScale2;
        int rhsPrecision = r.precision() - r.scale() + rhsScale2;
        return package$.MODULE$.max(package$.MODULE$.max(lhsPrecision, rhsPrecision), outputType.precision() + 1);
    }

    public int intermediatePrecision(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        return package$.MODULE$.min(this.nonRoundedIntermediatePrecision(lhs, rhs, outputType), 38);
    }

    public Tuple2<DecimalType, DecimalType> intermediateLhsRhsTypes(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        int precision = this.intermediatePrecision(lhs, rhs, outputType);
        Tuple2<Object, Object> tuple2 = this.lhsRhsNeededScales(lhs, rhs, outputType);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int lhsScale = tuple2._1$mcI$sp();
        int rhsScale = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(lhsScale, rhsScale);
        Tuple2.mcII.sp sp3 = sp2;
        int lhsScale2 = sp3._1$mcI$sp();
        int rhsScale2 = sp3._2$mcI$sp();
        return new Tuple2((Object)new DecimalType(precision, lhsScale2), (Object)new DecimalType(precision, rhsScale2));
    }

    public DecimalType intermediateResultType(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        int precision = this.intermediatePrecision(lhs, rhs, outputType);
        return new DecimalType(precision, package$.MODULE$.min(outputType.scale() + 1, 38));
    }

    private BigInteger max128Int$lzycompute() {
        GpuDecimalMultiply$ gpuDecimalMultiply$ = this;
        synchronized (gpuDecimalMultiply$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.max128Int = new BigInteger(new byte[]{(byte)2}).pow(127).subtract(BigInteger.ONE);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.max128Int;
    }

    private BigInteger max128Int() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.max128Int$lzycompute() : this.max128Int;
    }

    private BigInteger min128Int$lzycompute() {
        GpuDecimalMultiply$ gpuDecimalMultiply$ = this;
        synchronized (gpuDecimalMultiply$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.min128Int = new BigInteger(new byte[]{(byte)2}).pow(127).negate();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.min128Int;
    }

    private BigInteger min128Int() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.min128Int$lzycompute() : this.min128Int;
    }

    public ColumnVector checkForOverflow(ColumnView a, ColumnView b) {
        Predef$.MODULE$.assert(a.getType().isDecimalType());
        Predef$.MODULE$.assert(b.getType().isDecimalType());
        return (ColumnVector)this.withResource(a.bitCastTo(DType.create((DType.DTypeEnum)DType.DTypeEnum.DECIMAL128, (int)0)), (Function1 & Serializable & scala.Serializable)castA -> (ColumnVector)MODULE$.withResource(b.bitCastTo(DType.create((DType.DTypeEnum)DType.DTypeEnum.DECIMAL128, (int)0)), (Function1 & Serializable & scala.Serializable)castB -> {
            ColumnVector isNotZero2 = (ColumnVector)MODULE$.withResource(Scalar.fromDecimal((int)0, (BigInteger)BigInteger.ZERO), (Function1 & Serializable & scala.Serializable)zero -> castB.notEqualTo((BinaryOperable)zero));
            return (ColumnVector)MODULE$.withResource(isNotZero2, (Function1 & Serializable & scala.Serializable)isNotZero -> {
                ColumnVector gt2 = (ColumnVector)MODULE$.withResource(Scalar.fromDecimal((int)0, (BigInteger)MODULE$.max128Int()), (Function1 & Serializable & scala.Serializable)maxDecimal -> (ColumnVector)MODULE$.withResource(maxDecimal.div((BinaryOperable)castB), (Function1 & Serializable & scala.Serializable)divided -> castA.greaterThan((BinaryOperable)divided)));
                return (ColumnVector)MODULE$.withResource(gt2, (Function1 & Serializable & scala.Serializable)gt -> {
                    ColumnVector lt2 = (ColumnVector)MODULE$.withResource(Scalar.fromDecimal((int)0, (BigInteger)MODULE$.min128Int()), (Function1 & Serializable & scala.Serializable)minDecimal -> (ColumnVector)MODULE$.withResource(minDecimal.div((BinaryOperable)castB), (Function1 & Serializable & scala.Serializable)divided -> castA.lessThan((BinaryOperable)divided)));
                    return (ColumnVector)MODULE$.withResource(lt2, (Function1 & Serializable & scala.Serializable)lt -> (ColumnVector)MODULE$.withResource(lt.or((BinaryOperable)gt), (Function1 & Serializable & scala.Serializable)ored -> ored.and((BinaryOperable)isNotZero)));
                });
            });
        }));
    }

    public GpuDecimalMultiply apply(Expression left, Expression right, DecimalType dataType, boolean needsExtraOverflowChecks, boolean failOnError) {
        return new GpuDecimalMultiply(left, right, dataType, needsExtraOverflowChecks, failOnError);
    }

    public boolean apply$default$4() {
        return false;
    }

    public boolean apply$default$5() {
        return SQLConf$.MODULE$.get().ansiEnabled();
    }

    public Option<Tuple5<Expression, Expression, DecimalType, Object, Object>> unapply(GpuDecimalMultiply x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.left(), (Object)x$0.right(), (Object)x$0.dataType(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.needsExtraOverflowChecks()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.failOnError())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GpuDecimalMultiply$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

