/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import ai.rapids.cudf.AvroOptions;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.BlockInfo;
import com.nvidia.spark.rapids.FilePartitionReaderBase;
import com.nvidia.spark.rapids.GpuBatchUtils$;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.GpuMetric$;
import com.nvidia.spark.rapids.GpuSemaphore$;
import com.nvidia.spark.rapids.HostMemoryOutputStream;
import com.nvidia.spark.rapids.NvtxWithMetrics;
import com.nvidia.spark.rapids.ScanWithMetrics;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.QueryExecutionException;
import org.apache.spark.sql.execution.QueryExecutionException$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.rapids.CopyRange;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u00055h!C\b\u0011!\u0003\r\taGAp\u0011\u0015\u0011\u0004\u0001\"\u00014\u0011\u001d9\u0004A1A\u0005\naBQ\u0001\u0012\u0001\u0007\u0002\u0015CQa\u0015\u0001\u0007\u0002QCQa\u0017\u0001\u0007\u0002qCq\u0001\u001a\u0001C\u0002\u0013\u0005Q\rC\u0003j\u0001\u0011U!\u000eC\u0004\u0002\u0018\u0001!)\"!\u0007\t\u000f\u0005=\u0002\u0001\"\u0006\u00022!9\u0011Q\f\u0001\u0005\u0016\u0005}\u0003bBAA\u0001\u0011U\u00111\u0011\u0005\b\u0003\u0013\u0003AQCAF\u0011%\t9\fAI\u0001\n+\tI\fC\u0004\u0002P\u0002!I!!5\u0003#\u001d\u0003X/\u0011<s_J+\u0017\rZ3s\u0005\u0006\u001cXM\u0003\u0002\u0012%\u00051!/\u00199jINT!a\u0005\u000b\u0002\u0007M\fHN\u0003\u0002\u0016-\u0005)1\u000f]1sW*\u0011q\u0003G\u0001\u0007CB\f7\r[3\u000b\u0003e\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u000f#YA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0016\u000e\u0003\u0011R!!E\u0013\u000b\u0005U1#BA\u0014)\u0003\u0019qg/\u001b3jC*\t\u0011&A\u0002d_6L!a\u000b\u0013\u0003\u0007\u0005\u0013X\u000e\u0005\u0002.a5\taF\u0003\u00020)\u0005A\u0011N\u001c;fe:\fG.\u0003\u00022]\t9Aj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005F\u00015!\tiR'\u0003\u00027=\t!QK\\5u\u0003)\tgO]8G_Jl\u0017\r^\u000b\u0002sA\u0019QD\u000f\u001f\n\u0005mr\"\u0001B*p[\u0016\u0004\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\t1\fgn\u001a\u0006\u0002\u0003\u0006!!.\u0019<b\u0013\t\u0019eH\u0001\u0004TiJLgnZ\u0001\u0010I\u0016\u0014Wo\u001a#v[B\u0004&/\u001a4jqV\ta\tE\u0002\u001e\u000f&K!\u0001\u0013\u0010\u0003\r=\u0003H/[8o!\tQ\u0015K\u0004\u0002L\u001fB\u0011AJH\u0007\u0002\u001b*\u0011aJG\u0001\u0007yI|w\u000e\u001e \n\u0005As\u0012A\u0002)sK\u0012,g-\u0003\u0002D%*\u0011\u0001KH\u0001\u000fe\u0016\fG\rR1uCN\u001b\u0007.Z7b+\u0005)\u0006C\u0001,Z\u001b\u00059&B\u0001-\u0013\u0003\u0015!\u0018\u0010]3t\u0013\tQvK\u0001\u0006TiJ,8\r\u001e+za\u0016\fAaY8oMV\tQ\f\u0005\u0002_E6\tqL\u0003\u0002\\A*\u0011\u0011MF\u0001\u0007Q\u0006$wn\u001c9\n\u0005\r|&!D\"p]\u001aLw-\u001e:bi&|g.A\bdC\u000eDWMQ;gM\u0016\u00148+\u001b>f+\u00051\u0007CA\u000fh\u0013\tAgDA\u0002J]R\f!c]3oIR{w\t];V]\u000eDWmY6fIR!1\u000e^=\u007f!\ta'/D\u0001n\u0015\tqw.\u0001\u0003dk\u00124'BA\tq\u0015\u0005\t\u0018AA1j\u0013\t\u0019XNA\u0003UC\ndW\rC\u0003v\u000f\u0001\u0007a/A\u0004i_N$()\u001e4\u0011\u00051<\u0018B\u0001=n\u0005AAun\u001d;NK6|'/\u001f\"vM\u001a,'\u000fC\u0003{\u000f\u0001\u000710A\u0004ck\u001a\u001c\u0016N_3\u0011\u0005ua\u0018BA?\u001f\u0005\u0011auN\\4\t\r}<\u0001\u0019AA\u0001\u0003\u0019\u0019\b\u000f\\5ugB)Q$a\u0001\u0002\b%\u0019\u0011Q\u0001\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005%\u00111C\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005YA-\u0019;bg>,(oY3t\u0015\r\t\tBE\u0001\nKb,7-\u001e;j_:LA!!\u0006\u0002\f\ty\u0001+\u0019:uSRLwN\\3e\r&dW-A\u0005tK:$Gk\\$qkRA\u00111DA\u0015\u0003W\ti\u0003\u0005\u0003\u001e\u000f\u0006u\u0001\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\r\"#\u0001\u0006wK\u000e$xN]5{K\u0012LA!a\n\u0002\"\ti1i\u001c7v[:\f'OQ1uG\"DQ!\u001e\u0005A\u0002YDQA\u001f\u0005A\u0002mDaa \u0005A\u0002\u0005\u0005\u0011!\u00079paVd\u0017\r^3DkJ\u0014XM\u001c;CY>\u001c7n\u00115v].$\u0002\"a\r\u0002L\u0005U\u0013\u0011\f\t\u0007\u0003k\ty$!\u0012\u000f\t\u0005]\u00121\b\b\u0004\u0019\u0006e\u0012\"A\u0010\n\u0007\u0005ub$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00131\t\u0002\u0004'\u0016\f(bAA\u001f=A\u00191%a\u0012\n\u0007\u0005%CEA\u0005CY>\u001c7.\u00138g_\"9\u0011QJ\u0005A\u0002\u0005=\u0013!\u00032m_\u000e\\\u0017\n^3s!\u0019\t)$!\u0015\u0002F%!\u00111KA\"\u0005A\u0011UO\u001a4fe\u0016$\u0017\n^3sCR|'\u000f\u0003\u0004\u0002X%\u0001\rAZ\u0001\u0015[\u0006D(+Z1e\u0005\u0006$8\r[*ju\u0016\u0014vn^:\t\r\u0005m\u0013\u00021\u0001|\u0003Ui\u0017\r\u001f*fC\u0012\u0014\u0015\r^2i'&TXMQ=uKN\fAB]3bIB\u000b'\u000f\u001e$jY\u0016$\"\"!\u0019\u0002h\u0005]\u00141PA@!\u0015i\u00121\r<|\u0013\r\t)G\b\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005%$\u00021\u0001\u0002l\u0005a\u0001/\u0019:u\r&dW\rU1uQB!\u0011QNA:\u001b\t\tyGC\u0002\u0002r\u0001\f!AZ:\n\t\u0005U\u0014q\u000e\u0002\u0005!\u0006$\b\u000eC\u0004\u0002z)\u0001\r!a\r\u0002\r\tdwnY6t\u0011\u0019\tiH\u0003a\u0001w\u0006Q\u0001.Z1eKJ\u001c\u0016N_3\t\u000bmS\u0001\u0019A/\u0002%\u0015\u001cH/[7bi\u0016|U\u000f\u001e9viNK'0\u001a\u000b\u0006w\u0006\u0015\u0015q\u0011\u0005\b\u0003sZ\u0001\u0019AA\u001a\u0011\u0019\tih\u0003a\u0001w\u0006q1m\u001c9z\u00052|7m[:ECR\fGCCA\u001a\u0003\u001b\u000by)!'\u0002*\"9\u0011\u0011\u0010\u0007A\u0002\u0005M\u0002bBAI\u0019\u0001\u0007\u00111S\u0001\u0003S:\u0004B!!\u001c\u0002\u0016&!\u0011qSA8\u0005E15\u000bR1uC&s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\b\u00037c\u0001\u0019AAO\u0003\ryW\u000f\u001e\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*\u0019\u00111\u0015!\u0002\u0005%|\u0017\u0002BAT\u0003C\u0013AbT;uaV$8\u000b\u001e:fC6D\u0011\"a+\r!\u0003\u0005\r!!,\u0002\tMLhn\u0019\t\u0005;\u001d\u000by\u000bE\u0003\u001e\u0003\u0007\t\t\fE\u0002\u001e\u0003gK1!!.\u001f\u0005\u0011\u0011\u0015\u0010^3\u00021\r|\u0007/\u001f\"m_\u000e\\7\u000fR1uC\u0012\"WMZ1vYR$C'\u0006\u0002\u0002<*\"\u0011QVA_W\t\ty\f\u0005\u0003\u0002B\u0006-WBAAb\u0015\u0011\t)-a2\u0002\u0013Ut7\r[3dW\u0016$'bAAe=\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00171\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!E2p[B,H/Z\"paf\u0014\u0016M\\4fgR!\u00111[Ao!\u0019\t)$a\u0010\u0002VB!\u0011q[Am\u001b\u0005\u0001\u0012bAAn!\tI1i\u001c9z%\u0006tw-\u001a\u0005\b\u0003sr\u0001\u0019AA\u001a%\u0019\t\t/!:\u0002h\u001a1\u00111\u001d\u0001\u0001\u0003?\u0014A\u0002\u0010:fM&tW-\\3oiz\u00022!a6\u0001!\r\u0019\u0013\u0011^\u0005\u0004\u0003W$#a\u0006$jY\u0016\u0004\u0016M\u001d;ji&|gNU3bI\u0016\u0014()Y:f\u0001")
public interface GpuAvroReaderBase
extends Arm,
Logging {
    public void org$apache$spark$sql$rapids$GpuAvroReaderBase$_setter_$org$apache$spark$sql$rapids$GpuAvroReaderBase$$avroFormat_$eq(Some<String> var1);

    public void org$apache$spark$sql$rapids$GpuAvroReaderBase$_setter_$cacheBufferSize_$eq(int var1);

    public Some<String> org$apache$spark$sql$rapids$GpuAvroReaderBase$$avroFormat();

    public Option<String> debugDumpPrefix();

    public StructType readDataSchema();

    public Configuration conf();

    public int cacheBufferSize();

    public static /* synthetic */ Table sendToGpuUnchecked$(GpuAvroReaderBase $this, HostMemoryBuffer hostBuf, long bufSize, PartitionedFile[] splits) {
        return $this.sendToGpuUnchecked(hostBuf, bufSize, splits);
    }

    default public Table sendToGpuUnchecked(HostMemoryBuffer hostBuf, long bufSize, PartitionedFile[] splits) {
        ((FilePartitionReaderBase)((Object)this)).dumpDataToFile(hostBuf, bufSize, splits, this.debugDumpPrefix(), (Option<String>)this.org$apache$spark$sql$rapids$GpuAvroReaderBase$$avroFormat());
        AvroOptions readOpts = ((AvroOptions.Builder)AvroOptions.builder().includeColumn((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.readDataSchema().fieldNames())).toSeq().toArray(ClassTag$.MODULE$.apply(String.class)))).build();
        GpuSemaphore$.MODULE$.acquireIfNecessary(TaskContext$.MODULE$.get(), (GpuMetric)((ScanWithMetrics)((Object)this)).metrics().apply((Object)GpuMetric$.MODULE$.SEMAPHORE_WAIT_TIME()));
        return (Table)this.withResource(new NvtxWithMetrics("Avro decode", NvtxColor.DARK_GREEN, (Seq<GpuMetric>)Predef$.MODULE$.wrapRefArray((Object[])new GpuMetric[]{(GpuMetric)((ScanWithMetrics)((Object)this)).metrics().apply((Object)GpuMetric$.MODULE$.GPU_DECODE_TIME())})), (Function1 & Serializable & scala.Serializable)x$2 -> Table.readAvro((AvroOptions)readOpts, (HostMemoryBuffer)hostBuf, (long)0L, (long)bufSize));
    }

    public static /* synthetic */ Option sendToGpu$(GpuAvroReaderBase $this, HostMemoryBuffer hostBuf, long bufSize, PartitionedFile[] splits) {
        return $this.sendToGpu(hostBuf, bufSize, splits);
    }

    default public Option<ColumnarBatch> sendToGpu(HostMemoryBuffer hostBuf, long bufSize, PartitionedFile[] splits) {
        return (Option)this.withResource(hostBuf, (Function1 & Serializable & scala.Serializable)x$3 -> bufSize == 0L ? None$.MODULE$ : (Option)this.withResource(this.sendToGpuUnchecked(hostBuf, bufSize, splits), (Function1 & Serializable & scala.Serializable)t -> {
            long batchSizeBytes = GpuColumnVector.getTotalDeviceMemoryUsed(t);
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("GPU batch size: ").append(batchSizeBytes).append(" bytes").toString());
            ((FilePartitionReaderBase)((Object)this)).maxDeviceMemory_$eq(package$.MODULE$.max(batchSizeBytes, ((FilePartitionReaderBase)((Object)this)).maxDeviceMemory()));
            ((GpuMetric)((ScanWithMetrics)((Object)this)).metrics().apply((Object)GpuMetric$.MODULE$.NUM_OUTPUT_BATCHES())).$plus$eq(1L);
            return new Some((Object)GpuColumnVector.from(t, GpuColumnVector.extractTypes(this.readDataSchema())));
        }));
    }

    public static /* synthetic */ Seq populateCurrentBlockChunk$(GpuAvroReaderBase $this, BufferedIterator blockIter, int maxReadBatchSizeRows, long maxReadBatchSizeBytes) {
        return $this.populateCurrentBlockChunk((BufferedIterator<BlockInfo>)blockIter, maxReadBatchSizeRows, maxReadBatchSizeBytes);
    }

    default public Seq<BlockInfo> populateCurrentBlockChunk(BufferedIterator<BlockInfo> blockIter, int maxReadBatchSizeRows, long maxReadBatchSizeBytes) {
        ArrayBuffer currentChunk = new ArrayBuffer();
        LongRef numRows = LongRef.create((long)0L);
        LongRef numBytes = LongRef.create((long)0L);
        LongRef numAvroBytes = LongRef.create((long)0L);
        this.readNextBatch$1(blockIter, numRows, maxReadBatchSizeRows, numBytes, maxReadBatchSizeBytes, currentChunk, numAvroBytes);
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Loaded ").append(numRows$1.elem).append(" rows from Avro. bytes read: ").append(numAvroBytes$1.elem).append(". ").append("Estimated GPU bytes: ").append(numBytes$1.elem).toString());
        return currentChunk;
    }

    public static /* synthetic */ Tuple2 readPartFile$(GpuAvroReaderBase $this, Path partFilePath, Seq blocks, long headerSize, Configuration conf) {
        return $this.readPartFile(partFilePath, (Seq<BlockInfo>)blocks, headerSize, conf);
    }

    default public Tuple2<HostMemoryBuffer, Object> readPartFile(Path partFilePath, Seq<BlockInfo> blocks, long headerSize, Configuration conf) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            tuple2 = (Tuple2)this.withResource(new NvtxWithMetrics("Avro buffer file split", NvtxColor.YELLOW, (Seq<GpuMetric>)Predef$.MODULE$.wrapRefArray((Object[])new GpuMetric[]{(GpuMetric)((ScanWithMetrics)((Object)this)).metrics().apply((Object)"bufferTime")})), (Function1 & Serializable & scala.Serializable)x$4 -> {
                if (blocks.isEmpty()) {
                    throw new NonLocalReturnControl(object, (Object)new Tuple2(null, (Object)BoxesRunTime.boxToLong((long)0L)));
                }
                long estOutSize = this.estimateOutputSize(blocks, headerSize);
                return (Tuple2)this.withResource(partFilePath.getFileSystem(conf).open(partFilePath), (Function1 & Serializable & scala.Serializable)in -> (Tuple2)this.closeOnExcept(HostMemoryBuffer.allocate((long)estOutSize), (Function1 & Serializable & scala.Serializable)hmb -> (Tuple2)this.withResource(new HostMemoryOutputStream((HostMemoryBuffer)hmb), (Function1 & Serializable & scala.Serializable)out -> {
                    BlockInfo blockInfo = new BlockInfo(0L, headerSize, 0L, 0L);
                    Seq headerAndBlocks = (Seq)blocks.$plus$colon((Object)blockInfo, Seq$.MODULE$.canBuildFrom());
                    this.copyBlocksData((Seq<BlockInfo>)headerAndBlocks, (FSDataInputStream)in, (OutputStream)out, this.copyBlocksData$default$4());
                    if (out.getPos() > estOutSize) {
                        throw new QueryExecutionException(new StringBuilder(54).append("Calculated buffer size ").append(estOutSize).append(" is").append(" too small, actual written: ").append(out.getPos()).toString(), QueryExecutionException$.MODULE$.$lessinit$greater$default$2());
                    }
                    return new Tuple2(hmb, (Object)BoxesRunTime.boxToLong((long)out.getPos()));
                })));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    public static /* synthetic */ long estimateOutputSize$(GpuAvroReaderBase $this, Seq blocks, long headerSize) {
        return $this.estimateOutputSize((Seq<BlockInfo>)blocks, headerSize);
    }

    default public long estimateOutputSize(Seq<BlockInfo> blocks, long headerSize) {
        long totalSize = headerSize;
        return totalSize += BoxesRunTime.unboxToLong((Object)((TraversableOnce)blocks.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.blockSize()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static /* synthetic */ Seq copyBlocksData$(GpuAvroReaderBase $this, Seq blocks, FSDataInputStream in, OutputStream out, Option sync) {
        return $this.copyBlocksData((Seq<BlockInfo>)blocks, in, out, (Option<byte[]>)sync);
    }

    default public Seq<BlockInfo> copyBlocksData(Seq<BlockInfo> blocks, FSDataInputStream in, OutputStream out2, Option<byte[]> sync) {
        Seq copyRanges = (Seq)sync.map((Function1 & Serializable & scala.Serializable)s -> {
            Predef$.MODULE$.assert(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(s)).size() >= 16);
            return (Seq)blocks.map((Function1 & Serializable & scala.Serializable)b -> new CopyRange(b.blockStart(), b.blockSize() - 16L), Seq$.MODULE$.canBuildFrom());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.computeCopyRanges(blocks));
        Function1 & Serializable & scala.Serializable copySyncFunc = sync.isEmpty() ? (Function1 & Serializable & scala.Serializable)out -> {
            GpuAvroReaderBase.$anonfun$copyBlocksData$4(out);
            return BoxedUnit.UNIT;
        } : (Function1 & Serializable & scala.Serializable)out -> {
            out.write((byte[])sync.get(), 0, 16);
            return BoxedUnit.UNIT;
        };
        byte[] copyCache = new byte[this.cacheBufferSize()];
        LongRef readTime = LongRef.create((long)0L);
        LongRef writeTime = LongRef.create((long)0L);
        copyRanges.foreach((Function1 & Serializable & scala.Serializable)range -> {
            GpuAvroReaderBase.$anonfun$copyBlocksData$6(in, copyCache, out2, readTime, writeTime, copySyncFunc, range);
            return BoxedUnit.UNIT;
        });
        ((ScanWithMetrics)((Object)this)).metrics().get((Object)GpuMetric$.MODULE$.READ_FS_TIME()).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.add(readTime.elem);
            return BoxedUnit.UNIT;
        });
        ((ScanWithMetrics)((Object)this)).metrics().get((Object)GpuMetric$.MODULE$.WRITE_BUFFER_TIME()).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.add(writeTime.elem);
            return BoxedUnit.UNIT;
        });
        return blocks;
    }

    public static /* synthetic */ Option copyBlocksData$default$4$(GpuAvroReaderBase $this) {
        return $this.copyBlocksData$default$4();
    }

    default public Option<byte[]> copyBlocksData$default$4() {
        return None$.MODULE$;
    }

    private Seq<CopyRange> computeCopyRanges(Seq<BlockInfo> blocks) {
        ArrayBuffer copyRanges;
        block0: {
            LongRef currentCopyStart = LongRef.create((long)0L);
            LongRef currentCopyEnd = LongRef.create((long)0L);
            copyRanges = new ArrayBuffer();
            blocks.foreach((Function1 & Serializable & scala.Serializable)block -> {
                GpuAvroReaderBase.$anonfun$computeCopyRanges$1(currentCopyEnd, copyRanges, currentCopyStart, block);
                return BoxedUnit.UNIT;
            });
            if (currentCopyEnd.elem == currentCopyStart.elem) break block0;
            copyRanges.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CopyRange[]{new CopyRange(currentCopyStart.elem, currentCopyEnd.elem - currentCopyStart.elem)}));
        }
        return copyRanges.toSeq();
    }

    private void readNextBatch$1(BufferedIterator blockIter$1, LongRef numRows$1, int maxReadBatchSizeRows$1, LongRef numBytes$1, long maxReadBatchSizeBytes$1, ArrayBuffer currentChunk$1, LongRef numAvroBytes$1) {
        block5: {
            BoxedUnit boxedUnit;
            while (blockIter$1.hasNext()) {
                BlockInfo peekedRowGroup = (BlockInfo)blockIter$1.head();
                if (peekedRowGroup.count() > Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Too many rows in split");
                }
                if (numRows$1.elem == 0L || numRows$1.elem + peekedRowGroup.count() <= (long)maxReadBatchSizeRows$1) {
                    long estBytes = GpuBatchUtils$.MODULE$.estimateGpuMemory(this_.readDataSchema(), peekedRowGroup.count());
                    if (numBytes$1.elem == 0L || numBytes$1.elem + estBytes <= maxReadBatchSizeBytes$1) {
                        currentChunk$1.$plus$eq(blockIter$1.next());
                        numRows$1.elem += ((BlockInfo)currentChunk$1.last()).count();
                        numAvroBytes$1.elem += ((BlockInfo)currentChunk$1.last()).dataSize();
                        numBytes$1.elem += estBytes;
                        Logging this_ = (FilePartitionReaderBase)this_;
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                break block5;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static /* synthetic */ void $anonfun$copyBlocksData$4(OutputStream out) {
    }

    public static /* synthetic */ void $anonfun$copyBlocksData$6(FSDataInputStream in$2, byte[] copyCache$1, OutputStream out$1, LongRef readTime$1, LongRef writeTime$1, Function1 copySyncFunc$1, CopyRange range) {
        int readLength;
        if (in$2.getPos() != range.offset()) {
            in$2.seek(range.offset());
        }
        for (long bytesLeft = range.length(); bytesLeft > 0L; bytesLeft -= (long)readLength) {
            readLength = (int)Math.min(bytesLeft, (long)copyCache$1.length);
            long start = System.nanoTime();
            in$2.readFully(copyCache$1, 0, readLength);
            long mid = System.nanoTime();
            out$1.write(copyCache$1, 0, readLength);
            long end = System.nanoTime();
            readTime$1.elem += mid - start;
            writeTime$1.elem += end - mid;
        }
        copySyncFunc$1.apply((Object)out$1);
    }

    public static /* synthetic */ void $anonfun$computeCopyRanges$1(LongRef currentCopyEnd$1, ArrayBuffer copyRanges$1, LongRef currentCopyStart$1, BlockInfo block) {
        if (currentCopyEnd$1.elem != block.blockStart()) {
            if (currentCopyEnd$1.elem != 0L) {
                copyRanges$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CopyRange[]{new CopyRange(currentCopyStart$1.elem, currentCopyEnd$1.elem - currentCopyStart$1.elem)}));
            }
            currentCopyEnd$1.elem = currentCopyStart$1.elem = block.blockStart();
        }
        currentCopyEnd$1.elem += block.blockSize();
    }

    public static void $init$(GpuAvroReaderBase $this) {
        $this.org$apache$spark$sql$rapids$GpuAvroReaderBase$_setter_$org$apache$spark$sql$rapids$GpuAvroReaderBase$$avroFormat_$eq((Some<String>)new Some((Object)"avro"));
        $this.org$apache$spark$sql$rapids$GpuAvroReaderBase$_setter_$cacheBufferSize_$eq($this.conf().getInt("avro.read.allocation.size", 0x800000));
    }
}

