/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.Scalar;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.BoolUtils$;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.Serializable;
import org.apache.spark.sql.rapids.shims.RapidsErrorUtils$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;

public final class GpuAnsi$
implements Arm {
    public static GpuAnsi$ MODULE$;

    static {
        new GpuAnsi$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public boolean needBasicOpOverflowCheck(DataType dt) {
        return dt instanceof IntegralType;
    }

    public Scalar minValueScalar(DataType dt) {
        Scalar scalar;
        DataType dataType = dt;
        if (ByteType$.MODULE$.equals(dataType)) {
            scalar = Scalar.fromByte((byte)-128);
        } else if (ShortType$.MODULE$.equals(dataType)) {
            scalar = Scalar.fromShort((short)Short.MIN_VALUE);
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            scalar = Scalar.fromInt((int)Integer.MIN_VALUE);
        } else if (LongType$.MODULE$.equals(dataType)) {
            scalar = Scalar.fromLong((long)Long.MIN_VALUE);
        } else {
            throw new IllegalArgumentException(new StringBuilder(46).append(dataType).append(" does not need an ANSI check for this operator").toString());
        }
        return scalar;
    }

    public void assertMinValueOverflow(GpuColumnVector cv, String op) {
        this.withResource(this.minValueScalar(cv.dataType()), (Function1 & Serializable & scala.Serializable)minVal -> {
            GpuAnsi$.MODULE$.assertMinValueOverflow(minVal, cv, op);
            return BoxedUnit.UNIT;
        });
    }

    public void assertMinValueOverflow(Scalar minVal, GpuColumnVector cv, String op) {
        this.withResource(cv.getBase().equalToNullAware((BinaryOperable)minVal), (Function1 & Serializable & scala.Serializable)isMinVal -> {
            GpuAnsi$.$anonfun$assertMinValueOverflow$2(op, isMinVal);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$assertMinValueOverflow$2(String op$2, ColumnVector isMinVal) {
        if (BoolUtils$.MODULE$.isAnyValidTrue(isMinVal)) {
            throw RapidsErrorUtils$.MODULE$.arithmeticOverflowError(new StringBuilder(40).append("One or more rows overflow for ").append(op$2).append(" operation").toString(), RapidsErrorUtils$.MODULE$.arithmeticOverflowError$default$2(), RapidsErrorUtils$.MODULE$.arithmeticOverflowError$default$3());
        }
    }

    private GpuAnsi$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

