/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.rapids;

import java.util.Locale;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.rapids.DateFormatter;
import org.apache.spark.sql.catalyst.util.rapids.DefaultDateFormatter;
import org.apache.spark.sql.catalyst.util.rapids.Iso8601DateFormatter;
import org.apache.spark.sql.catalyst.util.rapids.LegacyDateFormatter;
import org.apache.spark.sql.catalyst.util.rapids.LegacyFastDateFormatter;
import org.apache.spark.sql.catalyst.util.rapids.LegacySimpleDateFormatter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;

public final class DateFormatter$
implements Serializable {
    public static DateFormatter$ MODULE$;
    private final Locale defaultLocale;
    private final String defaultPattern;

    static {
        new DateFormatter$();
    }

    public Locale defaultLocale() {
        return this.defaultLocale;
    }

    public String defaultPattern() {
        return this.defaultPattern;
    }

    private DateFormatter getFormatter(Option<String> format, Locale locale, Enumeration.Value legacyFormat, boolean isParsing) {
        DateFormatter dateFormatter;
        Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            dateFormatter = this.getLegacyFormatter((String)format.getOrElse((Function0 & java.io.Serializable & Serializable)() -> MODULE$.defaultPattern()), locale, legacyFormat);
        } else {
            Iso8601DateFormatter df = (Iso8601DateFormatter)format.map((Function1 & java.io.Serializable & Serializable)x$4 -> new Iso8601DateFormatter((String)x$4, locale, legacyFormat, isParsing)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> new DefaultDateFormatter(locale, legacyFormat, isParsing));
            df.validatePatternString();
            dateFormatter = df;
        }
        return dateFormatter;
    }

    private Locale getFormatter$default$2() {
        return this.defaultLocale();
    }

    private Enumeration.Value getFormatter$default$3() {
        return LegacyDateFormats$.MODULE$.LENIENT_SIMPLE_DATE_FORMAT();
    }

    public DateFormatter getLegacyFormatter(String pattern, Locale locale, Enumeration.Value legacyFormat) {
        LegacyDateFormatter legacyDateFormatter;
        Enumeration.Value value = legacyFormat;
        Enumeration.Value value2 = LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            legacyDateFormatter = new LegacyFastDateFormatter(pattern, locale);
        } else {
            boolean bl;
            Enumeration.Value value4 = LegacyDateFormats$.MODULE$.SIMPLE_DATE_FORMAT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = LegacyDateFormats$.MODULE$.LENIENT_SIMPLE_DATE_FORMAT();
                Enumeration.Value value7 = value;
                bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
            }
            if (bl) {
                legacyDateFormatter = new LegacySimpleDateFormatter(pattern, locale);
            } else {
                throw new MatchError((Object)value);
            }
        }
        return legacyDateFormatter;
    }

    public DateFormatter apply(Option<String> format, Locale locale, Enumeration.Value legacyFormat, boolean isParsing) {
        return this.getFormatter(format, locale, legacyFormat, isParsing);
    }

    public DateFormatter apply(String format, Locale locale, Enumeration.Value legacyFormat, boolean isParsing) {
        return this.getFormatter((Option<String>)new Some((Object)format), locale, legacyFormat, isParsing);
    }

    public DateFormatter apply(String format, boolean isParsing) {
        Some x$1 = new Some((Object)format);
        boolean x$2 = isParsing;
        Locale x$3 = this.getFormatter$default$2();
        Enumeration.Value x$4 = this.getFormatter$default$3();
        return this.getFormatter((Option<String>)x$1, x$3, x$4, x$2);
    }

    public DateFormatter apply() {
        None$ x$1 = None$.MODULE$;
        boolean x$2 = false;
        Locale x$3 = this.getFormatter$default$2();
        Enumeration.Value x$4 = this.getFormatter$default$3();
        return this.getFormatter((Option<String>)x$1, x$3, x$4, x$2);
    }

    public boolean apply$default$2() {
        return false;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DateFormatter$() {
        MODULE$ = this;
        this.defaultLocale = Locale.US;
        this.defaultPattern = "yyyy-MM-dd";
    }
}

