/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.TimeZone;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.orc.CompressionCodec;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.writer.StreamOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SerializationUtils.class);
    private static final int BUFFER_SIZE = 64;
    private final byte[] readBuffer = new byte[64];
    private final byte[] writeBuffer = new byte[64];

    public void writeVulong(OutputStream output2, long value) throws IOException {
        int posn = 0;
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.writeBuffer[posn++] = (byte)(0x80L | value & 0x7FL);
            value >>>= 7;
        }
        this.writeBuffer[posn++] = (byte)value;
        output2.write(this.writeBuffer, 0, posn);
    }

    public void writeVslong(OutputStream output2, long value) throws IOException {
        this.writeVulong(output2, value << 1 ^ value >> 63);
    }

    public static long readVulong(InputStream in) throws IOException {
        long b;
        long result = 0L;
        int offset = 0;
        do {
            if ((b = (long)in.read()) == -1L) {
                throw new EOFException("Reading Vulong past EOF");
            }
            result |= (0x7FL & b) << offset;
            offset += 7;
        } while (b >= 128L);
        return result;
    }

    public static long readVslong(InputStream in) throws IOException {
        long result = SerializationUtils.readVulong(in);
        return result >>> 1 ^ -(result & 1L);
    }

    public float readFloat(InputStream in) throws IOException {
        this.readFully(in, this.readBuffer, 0, 4);
        int val = ((this.readBuffer[0] & 0xFF) << 0) + ((this.readBuffer[1] & 0xFF) << 8) + ((this.readBuffer[2] & 0xFF) << 16) + ((this.readBuffer[3] & 0xFF) << 24);
        return Float.intBitsToFloat(val);
    }

    public void writeFloat(OutputStream output2, float value) throws IOException {
        int ser = Float.floatToIntBits(value);
        this.writeBuffer[0] = (byte)(ser >> 0 & 0xFF);
        this.writeBuffer[1] = (byte)(ser >> 8 & 0xFF);
        this.writeBuffer[2] = (byte)(ser >> 16 & 0xFF);
        this.writeBuffer[3] = (byte)(ser >> 24 & 0xFF);
        output2.write(this.writeBuffer, 0, 4);
    }

    public double readDouble(InputStream in) throws IOException {
        return Double.longBitsToDouble(this.readLongLE(in));
    }

    public long readLongLE(InputStream in) throws IOException {
        this.readFully(in, this.readBuffer, 0, 8);
        return (long)(((this.readBuffer[0] & 0xFF) << 0) + ((this.readBuffer[1] & 0xFF) << 8) + ((this.readBuffer[2] & 0xFF) << 16)) + ((long)(this.readBuffer[3] & 0xFF) << 24) + ((long)(this.readBuffer[4] & 0xFF) << 32) + ((long)(this.readBuffer[5] & 0xFF) << 40) + ((long)(this.readBuffer[6] & 0xFF) << 48) + ((long)(this.readBuffer[7] & 0xFF) << 56);
    }

    private void readFully(InputStream in, byte[] buffer, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = in.read(buffer, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException("Read past EOF for " + in);
        }
    }

    public void writeDouble(OutputStream output2, double value) throws IOException {
        this.writeLongLE(output2, Double.doubleToLongBits(value));
    }

    private void writeLongLE(OutputStream output2, long value) throws IOException {
        this.writeBuffer[0] = (byte)(value >> 0 & 0xFFL);
        this.writeBuffer[1] = (byte)(value >> 8 & 0xFFL);
        this.writeBuffer[2] = (byte)(value >> 16 & 0xFFL);
        this.writeBuffer[3] = (byte)(value >> 24 & 0xFFL);
        this.writeBuffer[4] = (byte)(value >> 32 & 0xFFL);
        this.writeBuffer[5] = (byte)(value >> 40 & 0xFFL);
        this.writeBuffer[6] = (byte)(value >> 48 & 0xFFL);
        this.writeBuffer[7] = (byte)(value >> 56 & 0xFFL);
        output2.write(this.writeBuffer, 0, 8);
    }

    public static void writeBigInteger(OutputStream output2, BigInteger value) throws IOException {
        int sign = (value = value.shiftLeft(1)).signum();
        if (sign < 0) {
            value = value.negate();
            value = value.subtract(BigInteger.ONE);
        }
        int length = value.bitLength();
        while (true) {
            long lowBits = value.longValue() & Long.MAX_VALUE;
            length -= 63;
            for (int i = 0; i < 9; ++i) {
                if (length <= 0 && (lowBits & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    output2.write((byte)lowBits);
                    return;
                }
                output2.write((byte)(0x80L | lowBits & 0x7FL));
                lowBits >>>= 7;
            }
            value = value.shiftRight(63);
        }
    }

    public static BigInteger readBigInteger(InputStream input) throws IOException {
        boolean isNegative;
        long b;
        BigInteger result = BigInteger.ZERO;
        long work = 0L;
        int offset = 0;
        do {
            if ((b = (long)input.read()) == -1L) {
                throw new EOFException("Reading BigInteger past EOF from " + input);
            }
            work |= (0x7FL & b) << offset % 63;
            if ((offset += 7) == 63) {
                result = BigInteger.valueOf(work);
                work = 0L;
                continue;
            }
            if (offset % 63 != 0) continue;
            result = result.or(BigInteger.valueOf(work).shiftLeft(offset - 63));
            work = 0L;
        } while (b >= 128L);
        if (work != 0L) {
            result = result.or(BigInteger.valueOf(work).shiftLeft(offset / 63 * 63));
        }
        if (isNegative = result.testBit(0)) {
            result = result.add(BigInteger.ONE);
            result = result.negate();
        }
        result = result.shiftRight(1);
        return result;
    }

    public int findClosestNumBits(long value) {
        int count = 0;
        while (value != 0L) {
            ++count;
            value >>>= 1;
        }
        return this.getClosestFixedBits(count);
    }

    public long zigzagEncode(long val) {
        return val << 1 ^ val >> 63;
    }

    public long zigzagDecode(long val) {
        return val >>> 1 ^ -(val & 1L);
    }

    public int percentileBits(long[] data, int offset, int length, double p) {
        if (p > 1.0 || p <= 0.0) {
            return -1;
        }
        int[] hist = new int[32];
        for (int i = offset; i < offset + length; ++i) {
            int idx;
            int n = idx = this.encodeBitWidth(this.findClosestNumBits(data[i]));
            hist[n] = hist[n] + 1;
        }
        int perLen = (int)((double)length * (1.0 - p));
        for (int i = hist.length - 1; i >= 0; --i) {
            if ((perLen -= hist[i]) >= 0) continue;
            return this.decodeBitWidth(i);
        }
        return 0;
    }

    public long bytesToLongBE(InStream input, int n) throws IOException {
        long out = 0L;
        long val = 0L;
        while (n > 0) {
            val = input.read();
            out |= val << --n * 8;
        }
        return out;
    }

    int getTotalBytesRequired(int n, int numBits) {
        return (n * numBits + 7) / 8;
    }

    public int getClosestFixedBits(int n) {
        if (n == 0) {
            return 1;
        }
        if (n >= 1 && n <= 24) {
            return n;
        }
        if (n > 24 && n <= 26) {
            return 26;
        }
        if (n > 26 && n <= 28) {
            return 28;
        }
        if (n > 28 && n <= 30) {
            return 30;
        }
        if (n > 30 && n <= 32) {
            return 32;
        }
        if (n > 32 && n <= 40) {
            return 40;
        }
        if (n > 40 && n <= 48) {
            return 48;
        }
        if (n > 48 && n <= 56) {
            return 56;
        }
        return 64;
    }

    public int getClosestAlignedFixedBits(int n) {
        if (n == 0 || n == 1) {
            return 1;
        }
        if (n > 1 && n <= 2) {
            return 2;
        }
        if (n > 2 && n <= 4) {
            return 4;
        }
        if (n > 4 && n <= 8) {
            return 8;
        }
        if (n > 8 && n <= 16) {
            return 16;
        }
        if (n > 16 && n <= 24) {
            return 24;
        }
        if (n > 24 && n <= 32) {
            return 32;
        }
        if (n > 32 && n <= 40) {
            return 40;
        }
        if (n > 40 && n <= 48) {
            return 48;
        }
        if (n > 48 && n <= 56) {
            return 56;
        }
        return 64;
    }

    public int encodeBitWidth(int n) {
        if ((n = this.getClosestFixedBits(n)) >= 1 && n <= 24) {
            return n - 1;
        }
        if (n > 24 && n <= 26) {
            return FixedBitSizes.TWENTYSIX.ordinal();
        }
        if (n > 26 && n <= 28) {
            return FixedBitSizes.TWENTYEIGHT.ordinal();
        }
        if (n > 28 && n <= 30) {
            return FixedBitSizes.THIRTY.ordinal();
        }
        if (n > 30 && n <= 32) {
            return FixedBitSizes.THIRTYTWO.ordinal();
        }
        if (n > 32 && n <= 40) {
            return FixedBitSizes.FORTY.ordinal();
        }
        if (n > 40 && n <= 48) {
            return FixedBitSizes.FORTYEIGHT.ordinal();
        }
        if (n > 48 && n <= 56) {
            return FixedBitSizes.FIFTYSIX.ordinal();
        }
        return FixedBitSizes.SIXTYFOUR.ordinal();
    }

    public int decodeBitWidth(int n) {
        if (n >= FixedBitSizes.ONE.ordinal() && n <= FixedBitSizes.TWENTYFOUR.ordinal()) {
            return n + 1;
        }
        if (n == FixedBitSizes.TWENTYSIX.ordinal()) {
            return 26;
        }
        if (n == FixedBitSizes.TWENTYEIGHT.ordinal()) {
            return 28;
        }
        if (n == FixedBitSizes.THIRTY.ordinal()) {
            return 30;
        }
        if (n == FixedBitSizes.THIRTYTWO.ordinal()) {
            return 32;
        }
        if (n == FixedBitSizes.FORTY.ordinal()) {
            return 40;
        }
        if (n == FixedBitSizes.FORTYEIGHT.ordinal()) {
            return 48;
        }
        if (n == FixedBitSizes.FIFTYSIX.ordinal()) {
            return 56;
        }
        return 64;
    }

    public void writeInts(long[] input, int offset, int len, int bitSize, OutputStream output2) throws IOException {
        if (input == null || input.length < 1 || offset < 0 || len < 1 || bitSize < 1) {
            return;
        }
        switch (bitSize) {
            case 1: {
                this.unrolledBitPack1(input, offset, len, output2);
                return;
            }
            case 2: {
                this.unrolledBitPack2(input, offset, len, output2);
                return;
            }
            case 4: {
                this.unrolledBitPack4(input, offset, len, output2);
                return;
            }
            case 8: {
                this.unrolledBitPack8(input, offset, len, output2);
                return;
            }
            case 16: {
                this.unrolledBitPack16(input, offset, len, output2);
                return;
            }
            case 24: {
                this.unrolledBitPack24(input, offset, len, output2);
                return;
            }
            case 32: {
                this.unrolledBitPack32(input, offset, len, output2);
                return;
            }
            case 40: {
                this.unrolledBitPack40(input, offset, len, output2);
                return;
            }
            case 48: {
                this.unrolledBitPack48(input, offset, len, output2);
                return;
            }
            case 56: {
                this.unrolledBitPack56(input, offset, len, output2);
                return;
            }
            case 64: {
                this.unrolledBitPack64(input, offset, len, output2);
                return;
            }
        }
        int bitsLeft = 8;
        int current = 0;
        for (int i = offset; i < offset + len; ++i) {
            long value = input[i];
            int bitsToWrite = bitSize;
            while (bitsToWrite > bitsLeft) {
                current = (byte)((long)current | value >>> bitsToWrite - bitsLeft);
                value &= (1L << (bitsToWrite -= bitsLeft)) - 1L;
                output2.write(current);
                current = 0;
                bitsLeft = 8;
            }
            current = (byte)((long)current | value << (bitsLeft -= bitsToWrite));
            if (bitsLeft != 0) continue;
            output2.write(current);
            current = 0;
            bitsLeft = 8;
        }
        if (bitsLeft != 8) {
            output2.write(current);
            current = 0;
            bitsLeft = 8;
        }
    }

    private void unrolledBitPack1(long[] input, int offset, int len, OutputStream output2) throws IOException {
        int numHops = 8;
        int remainder = len % 8;
        int endOffset = offset + len;
        int endUnroll = endOffset - remainder;
        int val = 0;
        for (int i = offset; i < endUnroll; i += 8) {
            val = (int)((long)val | (input[i] & 1L) << 7 | (input[i + 1] & 1L) << 6 | (input[i + 2] & 1L) << 5 | (input[i + 3] & 1L) << 4 | (input[i + 4] & 1L) << 3 | (input[i + 5] & 1L) << 2 | (input[i + 6] & 1L) << 1 | input[i + 7] & 1L);
            output2.write(val);
            val = 0;
        }
        if (remainder > 0) {
            int startShift = 7;
            for (int i = endUnroll; i < endOffset; ++i) {
                val = (int)((long)val | (input[i] & 1L) << startShift);
                --startShift;
            }
            output2.write(val);
        }
    }

    private void unrolledBitPack2(long[] input, int offset, int len, OutputStream output2) throws IOException {
        int numHops = 4;
        int remainder = len % 4;
        int endOffset = offset + len;
        int endUnroll = endOffset - remainder;
        int val = 0;
        for (int i = offset; i < endUnroll; i += 4) {
            val = (int)((long)val | (input[i] & 3L) << 6 | (input[i + 1] & 3L) << 4 | (input[i + 2] & 3L) << 2 | input[i + 3] & 3L);
            output2.write(val);
            val = 0;
        }
        if (remainder > 0) {
            int startShift = 6;
            for (int i = endUnroll; i < endOffset; ++i) {
                val = (int)((long)val | (input[i] & 3L) << startShift);
                startShift -= 2;
            }
            output2.write(val);
        }
    }

    private void unrolledBitPack4(long[] input, int offset, int len, OutputStream output2) throws IOException {
        int numHops = 2;
        int remainder = len % 2;
        int endOffset = offset + len;
        int endUnroll = endOffset - remainder;
        int val = 0;
        for (int i = offset; i < endUnroll; i += 2) {
            val = (int)((long)val | (input[i] & 0xFL) << 4 | input[i + 1] & 0xFL);
            output2.write(val);
            val = 0;
        }
        if (remainder > 0) {
            int startShift = 4;
            for (int i = endUnroll; i < endOffset; ++i) {
                val = (int)((long)val | (input[i] & 0xFL) << startShift);
                startShift -= 4;
            }
            output2.write(val);
        }
    }

    private void unrolledBitPack8(long[] input, int offset, int len, OutputStream output2) throws IOException {
        this.unrolledBitPackBytes(input, offset, len, output2, 1);
    }

    private void unrolledBitPack16(long[] input, int offset, int len, OutputStream output2) throws IOException {
        this.unrolledBitPackBytes(input, offset, len, output2, 2);
    }

    private void unrolledBitPack24(long[] input, int offset, int len, OutputStream output2) throws IOException {
        this.unrolledBitPackBytes(input, offset, len, output2, 3);
    }

    private void unrolledBitPack32(long[] input, int offset, int len, OutputStream output2) throws IOException {
        this.unrolledBitPackBytes(input, offset, len, output2, 4);
    }

    private void unrolledBitPack40(long[] input, int offset, int len, OutputStream output2) throws IOException {
        this.unrolledBitPackBytes(input, offset, len, output2, 5);
    }

    private void unrolledBitPack48(long[] input, int offset, int len, OutputStream output2) throws IOException {
        this.unrolledBitPackBytes(input, offset, len, output2, 6);
    }

    private void unrolledBitPack56(long[] input, int offset, int len, OutputStream output2) throws IOException {
        this.unrolledBitPackBytes(input, offset, len, output2, 7);
    }

    private void unrolledBitPack64(long[] input, int offset, int len, OutputStream output2) throws IOException {
        this.unrolledBitPackBytes(input, offset, len, output2, 8);
    }

    private void unrolledBitPackBytes(long[] input, int offset, int len, OutputStream output2, int numBytes) throws IOException {
        int i;
        int numHops = 8;
        int remainder = len % 8;
        int endOffset = offset + len;
        int endUnroll = endOffset - remainder;
        for (i = offset; i < endUnroll; i += 8) {
            this.writeLongBE(output2, input, i, 8, numBytes);
        }
        if (remainder > 0) {
            this.writeRemainingLongs(output2, i, input, remainder, numBytes);
        }
    }

    private void writeRemainingLongs(OutputStream output2, int offset, long[] input, int remainder, int numBytes) throws IOException {
        int numHops = remainder;
        int idx = 0;
        switch (numBytes) {
            case 1: {
                while (remainder > 0) {
                    this.writeBuffer[idx] = (byte)(input[offset + idx] & 0xFFL);
                    --remainder;
                    ++idx;
                }
                break;
            }
            case 2: {
                while (remainder > 0) {
                    this.writeLongBE2(output2, input[offset + idx], idx * 2);
                    --remainder;
                    ++idx;
                }
                break;
            }
            case 3: {
                while (remainder > 0) {
                    this.writeLongBE3(output2, input[offset + idx], idx * 3);
                    --remainder;
                    ++idx;
                }
                break;
            }
            case 4: {
                while (remainder > 0) {
                    this.writeLongBE4(output2, input[offset + idx], idx * 4);
                    --remainder;
                    ++idx;
                }
                break;
            }
            case 5: {
                while (remainder > 0) {
                    this.writeLongBE5(output2, input[offset + idx], idx * 5);
                    --remainder;
                    ++idx;
                }
                break;
            }
            case 6: {
                while (remainder > 0) {
                    this.writeLongBE6(output2, input[offset + idx], idx * 6);
                    --remainder;
                    ++idx;
                }
                break;
            }
            case 7: {
                while (remainder > 0) {
                    this.writeLongBE7(output2, input[offset + idx], idx * 7);
                    --remainder;
                    ++idx;
                }
                break;
            }
            case 8: {
                while (remainder > 0) {
                    this.writeLongBE8(output2, input[offset + idx], idx * 8);
                    --remainder;
                    ++idx;
                }
                break;
            }
        }
        int toWrite = numHops * numBytes;
        output2.write(this.writeBuffer, 0, toWrite);
    }

    private void writeLongBE(OutputStream output2, long[] input, int offset, int numHops, int numBytes) throws IOException {
        switch (numBytes) {
            case 1: {
                this.writeBuffer[0] = (byte)(input[offset + 0] & 0xFFL);
                this.writeBuffer[1] = (byte)(input[offset + 1] & 0xFFL);
                this.writeBuffer[2] = (byte)(input[offset + 2] & 0xFFL);
                this.writeBuffer[3] = (byte)(input[offset + 3] & 0xFFL);
                this.writeBuffer[4] = (byte)(input[offset + 4] & 0xFFL);
                this.writeBuffer[5] = (byte)(input[offset + 5] & 0xFFL);
                this.writeBuffer[6] = (byte)(input[offset + 6] & 0xFFL);
                this.writeBuffer[7] = (byte)(input[offset + 7] & 0xFFL);
                break;
            }
            case 2: {
                this.writeLongBE2(output2, input[offset + 0], 0);
                this.writeLongBE2(output2, input[offset + 1], 2);
                this.writeLongBE2(output2, input[offset + 2], 4);
                this.writeLongBE2(output2, input[offset + 3], 6);
                this.writeLongBE2(output2, input[offset + 4], 8);
                this.writeLongBE2(output2, input[offset + 5], 10);
                this.writeLongBE2(output2, input[offset + 6], 12);
                this.writeLongBE2(output2, input[offset + 7], 14);
                break;
            }
            case 3: {
                this.writeLongBE3(output2, input[offset + 0], 0);
                this.writeLongBE3(output2, input[offset + 1], 3);
                this.writeLongBE3(output2, input[offset + 2], 6);
                this.writeLongBE3(output2, input[offset + 3], 9);
                this.writeLongBE3(output2, input[offset + 4], 12);
                this.writeLongBE3(output2, input[offset + 5], 15);
                this.writeLongBE3(output2, input[offset + 6], 18);
                this.writeLongBE3(output2, input[offset + 7], 21);
                break;
            }
            case 4: {
                this.writeLongBE4(output2, input[offset + 0], 0);
                this.writeLongBE4(output2, input[offset + 1], 4);
                this.writeLongBE4(output2, input[offset + 2], 8);
                this.writeLongBE4(output2, input[offset + 3], 12);
                this.writeLongBE4(output2, input[offset + 4], 16);
                this.writeLongBE4(output2, input[offset + 5], 20);
                this.writeLongBE4(output2, input[offset + 6], 24);
                this.writeLongBE4(output2, input[offset + 7], 28);
                break;
            }
            case 5: {
                this.writeLongBE5(output2, input[offset + 0], 0);
                this.writeLongBE5(output2, input[offset + 1], 5);
                this.writeLongBE5(output2, input[offset + 2], 10);
                this.writeLongBE5(output2, input[offset + 3], 15);
                this.writeLongBE5(output2, input[offset + 4], 20);
                this.writeLongBE5(output2, input[offset + 5], 25);
                this.writeLongBE5(output2, input[offset + 6], 30);
                this.writeLongBE5(output2, input[offset + 7], 35);
                break;
            }
            case 6: {
                this.writeLongBE6(output2, input[offset + 0], 0);
                this.writeLongBE6(output2, input[offset + 1], 6);
                this.writeLongBE6(output2, input[offset + 2], 12);
                this.writeLongBE6(output2, input[offset + 3], 18);
                this.writeLongBE6(output2, input[offset + 4], 24);
                this.writeLongBE6(output2, input[offset + 5], 30);
                this.writeLongBE6(output2, input[offset + 6], 36);
                this.writeLongBE6(output2, input[offset + 7], 42);
                break;
            }
            case 7: {
                this.writeLongBE7(output2, input[offset + 0], 0);
                this.writeLongBE7(output2, input[offset + 1], 7);
                this.writeLongBE7(output2, input[offset + 2], 14);
                this.writeLongBE7(output2, input[offset + 3], 21);
                this.writeLongBE7(output2, input[offset + 4], 28);
                this.writeLongBE7(output2, input[offset + 5], 35);
                this.writeLongBE7(output2, input[offset + 6], 42);
                this.writeLongBE7(output2, input[offset + 7], 49);
                break;
            }
            case 8: {
                this.writeLongBE8(output2, input[offset + 0], 0);
                this.writeLongBE8(output2, input[offset + 1], 8);
                this.writeLongBE8(output2, input[offset + 2], 16);
                this.writeLongBE8(output2, input[offset + 3], 24);
                this.writeLongBE8(output2, input[offset + 4], 32);
                this.writeLongBE8(output2, input[offset + 5], 40);
                this.writeLongBE8(output2, input[offset + 6], 48);
                this.writeLongBE8(output2, input[offset + 7], 56);
                break;
            }
        }
        int toWrite = numHops * numBytes;
        output2.write(this.writeBuffer, 0, toWrite);
    }

    private void writeLongBE2(OutputStream output2, long val, int wbOffset) {
        this.writeBuffer[wbOffset + 0] = (byte)(val >>> 8);
        this.writeBuffer[wbOffset + 1] = (byte)(val >>> 0);
    }

    private void writeLongBE3(OutputStream output2, long val, int wbOffset) {
        this.writeBuffer[wbOffset + 0] = (byte)(val >>> 16);
        this.writeBuffer[wbOffset + 1] = (byte)(val >>> 8);
        this.writeBuffer[wbOffset + 2] = (byte)(val >>> 0);
    }

    private void writeLongBE4(OutputStream output2, long val, int wbOffset) {
        this.writeBuffer[wbOffset + 0] = (byte)(val >>> 24);
        this.writeBuffer[wbOffset + 1] = (byte)(val >>> 16);
        this.writeBuffer[wbOffset + 2] = (byte)(val >>> 8);
        this.writeBuffer[wbOffset + 3] = (byte)(val >>> 0);
    }

    private void writeLongBE5(OutputStream output2, long val, int wbOffset) {
        this.writeBuffer[wbOffset + 0] = (byte)(val >>> 32);
        this.writeBuffer[wbOffset + 1] = (byte)(val >>> 24);
        this.writeBuffer[wbOffset + 2] = (byte)(val >>> 16);
        this.writeBuffer[wbOffset + 3] = (byte)(val >>> 8);
        this.writeBuffer[wbOffset + 4] = (byte)(val >>> 0);
    }

    private void writeLongBE6(OutputStream output2, long val, int wbOffset) {
        this.writeBuffer[wbOffset + 0] = (byte)(val >>> 40);
        this.writeBuffer[wbOffset + 1] = (byte)(val >>> 32);
        this.writeBuffer[wbOffset + 2] = (byte)(val >>> 24);
        this.writeBuffer[wbOffset + 3] = (byte)(val >>> 16);
        this.writeBuffer[wbOffset + 4] = (byte)(val >>> 8);
        this.writeBuffer[wbOffset + 5] = (byte)(val >>> 0);
    }

    private void writeLongBE7(OutputStream output2, long val, int wbOffset) {
        this.writeBuffer[wbOffset + 0] = (byte)(val >>> 48);
        this.writeBuffer[wbOffset + 1] = (byte)(val >>> 40);
        this.writeBuffer[wbOffset + 2] = (byte)(val >>> 32);
        this.writeBuffer[wbOffset + 3] = (byte)(val >>> 24);
        this.writeBuffer[wbOffset + 4] = (byte)(val >>> 16);
        this.writeBuffer[wbOffset + 5] = (byte)(val >>> 8);
        this.writeBuffer[wbOffset + 6] = (byte)(val >>> 0);
    }

    private void writeLongBE8(OutputStream output2, long val, int wbOffset) {
        this.writeBuffer[wbOffset + 0] = (byte)(val >>> 56);
        this.writeBuffer[wbOffset + 1] = (byte)(val >>> 48);
        this.writeBuffer[wbOffset + 2] = (byte)(val >>> 40);
        this.writeBuffer[wbOffset + 3] = (byte)(val >>> 32);
        this.writeBuffer[wbOffset + 4] = (byte)(val >>> 24);
        this.writeBuffer[wbOffset + 5] = (byte)(val >>> 16);
        this.writeBuffer[wbOffset + 6] = (byte)(val >>> 8);
        this.writeBuffer[wbOffset + 7] = (byte)(val >>> 0);
    }

    public void readInts(long[] buffer, int offset, int len, int bitSize, InStream input) throws IOException {
        int bitsLeft = 0;
        int current = 0;
        switch (bitSize) {
            case 1: {
                this.unrolledUnPack1(buffer, offset, len, input);
                return;
            }
            case 2: {
                this.unrolledUnPack2(buffer, offset, len, input);
                return;
            }
            case 4: {
                this.unrolledUnPack4(buffer, offset, len, input);
                return;
            }
            case 8: {
                this.unrolledUnPack8(buffer, offset, len, input);
                return;
            }
            case 16: {
                this.unrolledUnPack16(buffer, offset, len, input);
                return;
            }
            case 24: {
                this.unrolledUnPack24(buffer, offset, len, input);
                return;
            }
            case 32: {
                this.unrolledUnPack32(buffer, offset, len, input);
                return;
            }
            case 40: {
                this.unrolledUnPack40(buffer, offset, len, input);
                return;
            }
            case 48: {
                this.unrolledUnPack48(buffer, offset, len, input);
                return;
            }
            case 56: {
                this.unrolledUnPack56(buffer, offset, len, input);
                return;
            }
            case 64: {
                this.unrolledUnPack64(buffer, offset, len, input);
                return;
            }
        }
        for (int i = offset; i < offset + len; ++i) {
            int bitsLeftToRead;
            long result = 0L;
            for (bitsLeftToRead = bitSize; bitsLeftToRead > bitsLeft; bitsLeftToRead -= bitsLeft) {
                result <<= bitsLeft;
                result |= (long)(current & (1 << bitsLeft) - 1);
                current = input.read();
                bitsLeft = 8;
            }
            if (bitsLeftToRead > 0) {
                result <<= bitsLeftToRead;
                result |= (long)(current >> (bitsLeft -= bitsLeftToRead) & (1 << bitsLeftToRead) - 1);
            }
            buffer[i] = result;
        }
    }

    private void unrolledUnPack1(long[] buffer, int offset, int len, InStream input) throws IOException {
        int numHops = 8;
        int remainder = len % 8;
        int endOffset = offset + len;
        int endUnroll = endOffset - remainder;
        int val = 0;
        for (int i = offset; i < endUnroll; i += 8) {
            val = input.read();
            buffer[i] = val >>> 7 & 1;
            buffer[i + 1] = val >>> 6 & 1;
            buffer[i + 2] = val >>> 5 & 1;
            buffer[i + 3] = val >>> 4 & 1;
            buffer[i + 4] = val >>> 3 & 1;
            buffer[i + 5] = val >>> 2 & 1;
            buffer[i + 6] = val >>> 1 & 1;
            buffer[i + 7] = val & 1;
        }
        if (remainder > 0) {
            int startShift = 7;
            val = input.read();
            for (int i = endUnroll; i < endOffset; ++i) {
                buffer[i] = val >>> startShift & 1;
                --startShift;
            }
        }
    }

    private void unrolledUnPack2(long[] buffer, int offset, int len, InStream input) throws IOException {
        int numHops = 4;
        int remainder = len % 4;
        int endOffset = offset + len;
        int endUnroll = endOffset - remainder;
        int val = 0;
        for (int i = offset; i < endUnroll; i += 4) {
            val = input.read();
            buffer[i] = val >>> 6 & 3;
            buffer[i + 1] = val >>> 4 & 3;
            buffer[i + 2] = val >>> 2 & 3;
            buffer[i + 3] = val & 3;
        }
        if (remainder > 0) {
            int startShift = 6;
            val = input.read();
            for (int i = endUnroll; i < endOffset; ++i) {
                buffer[i] = val >>> startShift & 3;
                startShift -= 2;
            }
        }
    }

    private void unrolledUnPack4(long[] buffer, int offset, int len, InStream input) throws IOException {
        int numHops = 2;
        int remainder = len % 2;
        int endOffset = offset + len;
        int endUnroll = endOffset - remainder;
        int val = 0;
        for (int i = offset; i < endUnroll; i += 2) {
            val = input.read();
            buffer[i] = val >>> 4 & 0xF;
            buffer[i + 1] = val & 0xF;
        }
        if (remainder > 0) {
            int startShift = 4;
            val = input.read();
            for (int i = endUnroll; i < endOffset; ++i) {
                buffer[i] = val >>> startShift & 0xF;
                startShift -= 4;
            }
        }
    }

    private void unrolledUnPack8(long[] buffer, int offset, int len, InStream input) throws IOException {
        this.unrolledUnPackBytes(buffer, offset, len, input, 1);
    }

    private void unrolledUnPack16(long[] buffer, int offset, int len, InStream input) throws IOException {
        this.unrolledUnPackBytes(buffer, offset, len, input, 2);
    }

    private void unrolledUnPack24(long[] buffer, int offset, int len, InStream input) throws IOException {
        this.unrolledUnPackBytes(buffer, offset, len, input, 3);
    }

    private void unrolledUnPack32(long[] buffer, int offset, int len, InStream input) throws IOException {
        this.unrolledUnPackBytes(buffer, offset, len, input, 4);
    }

    private void unrolledUnPack40(long[] buffer, int offset, int len, InStream input) throws IOException {
        this.unrolledUnPackBytes(buffer, offset, len, input, 5);
    }

    private void unrolledUnPack48(long[] buffer, int offset, int len, InStream input) throws IOException {
        this.unrolledUnPackBytes(buffer, offset, len, input, 6);
    }

    private void unrolledUnPack56(long[] buffer, int offset, int len, InStream input) throws IOException {
        this.unrolledUnPackBytes(buffer, offset, len, input, 7);
    }

    private void unrolledUnPack64(long[] buffer, int offset, int len, InStream input) throws IOException {
        this.unrolledUnPackBytes(buffer, offset, len, input, 8);
    }

    private void unrolledUnPackBytes(long[] buffer, int offset, int len, InStream input, int numBytes) throws IOException {
        int i;
        int numHops = 8;
        int remainder = len % 8;
        int endOffset = offset + len;
        int endUnroll = endOffset - remainder;
        for (i = offset; i < endUnroll; i += 8) {
            this.readLongBE(input, buffer, i, 8, numBytes);
        }
        if (remainder > 0) {
            this.readRemainingLongs(buffer, i, input, remainder, numBytes);
        }
    }

    private void readRemainingLongs(long[] buffer, int offset, InStream input, int remainder, int numBytes) throws IOException {
        int toRead = remainder * numBytes;
        for (int bytesRead = input.read(this.readBuffer, 0, toRead); bytesRead != toRead; bytesRead += input.read(this.readBuffer, bytesRead, toRead - bytesRead)) {
        }
        int idx = 0;
        switch (numBytes) {
            case 1: {
                while (remainder > 0) {
                    buffer[offset++] = this.readBuffer[idx] & 0xFF;
                    --remainder;
                    ++idx;
                }
                break;
            }
            case 2: {
                while (remainder > 0) {
                    buffer[offset++] = this.readLongBE2(input, idx * 2);
                    --remainder;
                    ++idx;
                }
                break;
            }
            case 3: {
                while (remainder > 0) {
                    buffer[offset++] = this.readLongBE3(input, idx * 3);
                    --remainder;
                    ++idx;
                }
                break;
            }
            case 4: {
                while (remainder > 0) {
                    buffer[offset++] = this.readLongBE4(input, idx * 4);
                    --remainder;
                    ++idx;
                }
                break;
            }
            case 5: {
                while (remainder > 0) {
                    buffer[offset++] = this.readLongBE5(input, idx * 5);
                    --remainder;
                    ++idx;
                }
                break;
            }
            case 6: {
                while (remainder > 0) {
                    buffer[offset++] = this.readLongBE6(input, idx * 6);
                    --remainder;
                    ++idx;
                }
                break;
            }
            case 7: {
                while (remainder > 0) {
                    buffer[offset++] = this.readLongBE7(input, idx * 7);
                    --remainder;
                    ++idx;
                }
                break;
            }
            case 8: {
                while (remainder > 0) {
                    buffer[offset++] = this.readLongBE8(input, idx * 8);
                    --remainder;
                    ++idx;
                }
                break;
            }
        }
    }

    private void readLongBE(InStream in, long[] buffer, int start, int numHops, int numBytes) throws IOException {
        int toRead = numHops * numBytes;
        for (int bytesRead = in.read(this.readBuffer, 0, toRead); bytesRead != toRead; bytesRead += in.read(this.readBuffer, bytesRead, toRead - bytesRead)) {
        }
        switch (numBytes) {
            case 1: {
                buffer[start + 0] = this.readBuffer[0] & 0xFF;
                buffer[start + 1] = this.readBuffer[1] & 0xFF;
                buffer[start + 2] = this.readBuffer[2] & 0xFF;
                buffer[start + 3] = this.readBuffer[3] & 0xFF;
                buffer[start + 4] = this.readBuffer[4] & 0xFF;
                buffer[start + 5] = this.readBuffer[5] & 0xFF;
                buffer[start + 6] = this.readBuffer[6] & 0xFF;
                buffer[start + 7] = this.readBuffer[7] & 0xFF;
                break;
            }
            case 2: {
                buffer[start + 0] = this.readLongBE2(in, 0);
                buffer[start + 1] = this.readLongBE2(in, 2);
                buffer[start + 2] = this.readLongBE2(in, 4);
                buffer[start + 3] = this.readLongBE2(in, 6);
                buffer[start + 4] = this.readLongBE2(in, 8);
                buffer[start + 5] = this.readLongBE2(in, 10);
                buffer[start + 6] = this.readLongBE2(in, 12);
                buffer[start + 7] = this.readLongBE2(in, 14);
                break;
            }
            case 3: {
                buffer[start + 0] = this.readLongBE3(in, 0);
                buffer[start + 1] = this.readLongBE3(in, 3);
                buffer[start + 2] = this.readLongBE3(in, 6);
                buffer[start + 3] = this.readLongBE3(in, 9);
                buffer[start + 4] = this.readLongBE3(in, 12);
                buffer[start + 5] = this.readLongBE3(in, 15);
                buffer[start + 6] = this.readLongBE3(in, 18);
                buffer[start + 7] = this.readLongBE3(in, 21);
                break;
            }
            case 4: {
                buffer[start + 0] = this.readLongBE4(in, 0);
                buffer[start + 1] = this.readLongBE4(in, 4);
                buffer[start + 2] = this.readLongBE4(in, 8);
                buffer[start + 3] = this.readLongBE4(in, 12);
                buffer[start + 4] = this.readLongBE4(in, 16);
                buffer[start + 5] = this.readLongBE4(in, 20);
                buffer[start + 6] = this.readLongBE4(in, 24);
                buffer[start + 7] = this.readLongBE4(in, 28);
                break;
            }
            case 5: {
                buffer[start + 0] = this.readLongBE5(in, 0);
                buffer[start + 1] = this.readLongBE5(in, 5);
                buffer[start + 2] = this.readLongBE5(in, 10);
                buffer[start + 3] = this.readLongBE5(in, 15);
                buffer[start + 4] = this.readLongBE5(in, 20);
                buffer[start + 5] = this.readLongBE5(in, 25);
                buffer[start + 6] = this.readLongBE5(in, 30);
                buffer[start + 7] = this.readLongBE5(in, 35);
                break;
            }
            case 6: {
                buffer[start + 0] = this.readLongBE6(in, 0);
                buffer[start + 1] = this.readLongBE6(in, 6);
                buffer[start + 2] = this.readLongBE6(in, 12);
                buffer[start + 3] = this.readLongBE6(in, 18);
                buffer[start + 4] = this.readLongBE6(in, 24);
                buffer[start + 5] = this.readLongBE6(in, 30);
                buffer[start + 6] = this.readLongBE6(in, 36);
                buffer[start + 7] = this.readLongBE6(in, 42);
                break;
            }
            case 7: {
                buffer[start + 0] = this.readLongBE7(in, 0);
                buffer[start + 1] = this.readLongBE7(in, 7);
                buffer[start + 2] = this.readLongBE7(in, 14);
                buffer[start + 3] = this.readLongBE7(in, 21);
                buffer[start + 4] = this.readLongBE7(in, 28);
                buffer[start + 5] = this.readLongBE7(in, 35);
                buffer[start + 6] = this.readLongBE7(in, 42);
                buffer[start + 7] = this.readLongBE7(in, 49);
                break;
            }
            case 8: {
                buffer[start + 0] = this.readLongBE8(in, 0);
                buffer[start + 1] = this.readLongBE8(in, 8);
                buffer[start + 2] = this.readLongBE8(in, 16);
                buffer[start + 3] = this.readLongBE8(in, 24);
                buffer[start + 4] = this.readLongBE8(in, 32);
                buffer[start + 5] = this.readLongBE8(in, 40);
                buffer[start + 6] = this.readLongBE8(in, 48);
                buffer[start + 7] = this.readLongBE8(in, 56);
                break;
            }
        }
    }

    private long readLongBE2(InStream in, int rbOffset) {
        return ((this.readBuffer[rbOffset] & 0xFF) << 8) + ((this.readBuffer[rbOffset + 1] & 0xFF) << 0);
    }

    private long readLongBE3(InStream in, int rbOffset) {
        return ((this.readBuffer[rbOffset] & 0xFF) << 16) + ((this.readBuffer[rbOffset + 1] & 0xFF) << 8) + ((this.readBuffer[rbOffset + 2] & 0xFF) << 0);
    }

    private long readLongBE4(InStream in, int rbOffset) {
        return ((long)(this.readBuffer[rbOffset] & 0xFF) << 24) + (long)((this.readBuffer[rbOffset + 1] & 0xFF) << 16) + (long)((this.readBuffer[rbOffset + 2] & 0xFF) << 8) + (long)((this.readBuffer[rbOffset + 3] & 0xFF) << 0);
    }

    private long readLongBE5(InStream in, int rbOffset) {
        return ((long)(this.readBuffer[rbOffset] & 0xFF) << 32) + ((long)(this.readBuffer[rbOffset + 1] & 0xFF) << 24) + (long)((this.readBuffer[rbOffset + 2] & 0xFF) << 16) + (long)((this.readBuffer[rbOffset + 3] & 0xFF) << 8) + (long)((this.readBuffer[rbOffset + 4] & 0xFF) << 0);
    }

    private long readLongBE6(InStream in, int rbOffset) {
        return ((long)(this.readBuffer[rbOffset] & 0xFF) << 40) + ((long)(this.readBuffer[rbOffset + 1] & 0xFF) << 32) + ((long)(this.readBuffer[rbOffset + 2] & 0xFF) << 24) + (long)((this.readBuffer[rbOffset + 3] & 0xFF) << 16) + (long)((this.readBuffer[rbOffset + 4] & 0xFF) << 8) + (long)((this.readBuffer[rbOffset + 5] & 0xFF) << 0);
    }

    private long readLongBE7(InStream in, int rbOffset) {
        return ((long)(this.readBuffer[rbOffset] & 0xFF) << 48) + ((long)(this.readBuffer[rbOffset + 1] & 0xFF) << 40) + ((long)(this.readBuffer[rbOffset + 2] & 0xFF) << 32) + ((long)(this.readBuffer[rbOffset + 3] & 0xFF) << 24) + (long)((this.readBuffer[rbOffset + 4] & 0xFF) << 16) + (long)((this.readBuffer[rbOffset + 5] & 0xFF) << 8) + (long)((this.readBuffer[rbOffset + 6] & 0xFF) << 0);
    }

    private long readLongBE8(InStream in, int rbOffset) {
        return ((long)(this.readBuffer[rbOffset] & 0xFF) << 56) + ((long)(this.readBuffer[rbOffset + 1] & 0xFF) << 48) + ((long)(this.readBuffer[rbOffset + 2] & 0xFF) << 40) + ((long)(this.readBuffer[rbOffset + 3] & 0xFF) << 32) + ((long)(this.readBuffer[rbOffset + 4] & 0xFF) << 24) + (long)((this.readBuffer[rbOffset + 5] & 0xFF) << 16) + (long)((this.readBuffer[rbOffset + 6] & 0xFF) << 8) + (long)((this.readBuffer[rbOffset + 7] & 0xFF) << 0);
    }

    public boolean isSafeSubtract(long left, long right) {
        return (left ^ right) >= 0L || (left ^ left - right) >= 0L;
    }

    public static double convertFromUtc(TimeZone local, double time) {
        int offset = local.getOffset((long)(time * 1000.0) - (long)local.getRawOffset());
        return time - (double)offset / 1000.0;
    }

    public static long convertFromUtc(TimeZone local, long time) {
        int offset = local.getOffset(time - (long)local.getRawOffset());
        return time - (long)offset;
    }

    public static long convertToUtc(TimeZone local, long time) {
        int offset = local.getOffset(time);
        return time + (long)offset;
    }

    public static StreamOptions getCustomizedCodec(StreamOptions base, OrcFile.CompressionStrategy strategy, OrcProto.Stream.Kind kind) {
        if (base.getCodec() != null) {
            CompressionCodec.Options options = base.getCodecOptions();
            switch (kind) {
                case BLOOM_FILTER: 
                case DATA: 
                case DICTIONARY_DATA: 
                case BLOOM_FILTER_UTF8: {
                    options = options.copy().setData(CompressionCodec.DataKind.TEXT);
                    if (strategy == OrcFile.CompressionStrategy.SPEED) {
                        options.setSpeed(CompressionCodec.SpeedModifier.FAST);
                        break;
                    }
                    options.setSpeed(CompressionCodec.SpeedModifier.DEFAULT);
                    break;
                }
                case LENGTH: 
                case DICTIONARY_COUNT: 
                case PRESENT: 
                case ROW_INDEX: 
                case SECONDARY: {
                    options = options.copy().setSpeed(CompressionCodec.SpeedModifier.FASTEST).setData(CompressionCodec.DataKind.BINARY);
                    break;
                }
                default: {
                    LOG.info("Missing ORC compression modifiers for " + kind);
                }
            }
            if (!base.getCodecOptions().equals(options)) {
                StreamOptions result = new StreamOptions(base).withCodec(base.getCodec(), options);
                return result;
            }
        }
        return base;
    }

    public static long convertBetweenTimezones(TimeZone writer, TimeZone reader, long millis) {
        long writerOffset = writer.getOffset(millis);
        long readerOffset = reader.getOffset(millis);
        long adjustedMillis = millis + writerOffset - readerOffset;
        long adjustedReader = reader.getOffset(adjustedMillis);
        return writerOffset - adjustedReader;
    }

    public static String bytesVectorToString(BytesColumnVector vector, int elementNum) {
        if (vector.isRepeating) {
            elementNum = 0;
        }
        return vector.noNulls || !vector.isNull[elementNum] ? new String(vector.vector[elementNum], vector.start[elementNum], vector.length[elementNum], StandardCharsets.UTF_8) : null;
    }

    public static Date parseDateFromString(String string) {
        try {
            Date value = Date.valueOf(string);
            return value;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static enum FixedBitSizes {
        ONE,
        TWO,
        THREE,
        FOUR,
        FIVE,
        SIX,
        SEVEN,
        EIGHT,
        NINE,
        TEN,
        ELEVEN,
        TWELVE,
        THIRTEEN,
        FOURTEEN,
        FIFTEEN,
        SIXTEEN,
        SEVENTEEN,
        EIGHTEEN,
        NINETEEN,
        TWENTY,
        TWENTYONE,
        TWENTYTWO,
        TWENTYTHREE,
        TWENTYFOUR,
        TWENTYSIX,
        TWENTYEIGHT,
        THIRTY,
        THIRTYTWO,
        FORTY,
        FORTYEIGHT,
        FIFTYSIX,
        SIXTYFOUR;

    }
}

