/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc;

import java.io.PrintStream;
import java.util.List;
import org.apache.orc.TypeDescription;

public class TypeDescriptionPrettyPrint {
    static void pad(PrintStream output2, int offset) {
        for (int i = 0; i < offset; ++i) {
            output2.print(' ');
        }
    }

    static void printFieldName(PrintStream output2, String fieldName) {
        if (TypeDescription.UNQUOTED_NAMES.matcher(fieldName).matches()) {
            output2.print(fieldName);
        } else {
            output2.print('`');
            output2.print(fieldName.replaceAll("`", "``"));
            output2.print('`');
        }
    }

    static void printStruct(PrintStream output2, int offset, TypeDescription type) {
        output2.print("<");
        List<TypeDescription> children = type.getChildren();
        List<String> fields = type.getFieldNames();
        for (int c = 0; c < children.size(); ++c) {
            if (c == 0) {
                output2.println();
            } else {
                output2.println(",");
            }
            TypeDescriptionPrettyPrint.pad(output2, offset + 2);
            TypeDescriptionPrettyPrint.printFieldName(output2, fields.get(c));
            output2.print(':');
            TypeDescriptionPrettyPrint.printType(output2, offset + 2, children.get(c));
        }
        output2.print('>');
    }

    static void printComplex(PrintStream output2, int offset, TypeDescription type) {
        output2.print("<");
        List<TypeDescription> children = type.getChildren();
        for (int c = 0; c < children.size(); ++c) {
            if (c != 0) {
                output2.print(",");
            }
            TypeDescriptionPrettyPrint.printType(output2, offset + 2, children.get(c));
        }
        output2.print('>');
    }

    static void printType(PrintStream output2, int offset, TypeDescription type) {
        output2.print(type.getCategory().getName());
        switch (type.getCategory()) {
            case BOOLEAN: 
            case BINARY: 
            case BYTE: 
            case DATE: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: 
            case STRING: 
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                break;
            }
            case DECIMAL: {
                output2.print('(');
                output2.print(type.getPrecision());
                output2.print(',');
                output2.print(type.getScale());
                output2.print(')');
                break;
            }
            case CHAR: 
            case VARCHAR: {
                output2.print('(');
                output2.print(type.getMaxLength());
                output2.print(')');
                break;
            }
            case STRUCT: {
                TypeDescriptionPrettyPrint.printStruct(output2, offset, type);
                break;
            }
            case LIST: 
            case MAP: 
            case UNION: {
                TypeDescriptionPrettyPrint.printComplex(output2, offset, type);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled type " + type);
            }
        }
    }

    public static void print(PrintStream output2, TypeDescription schema) {
        TypeDescriptionPrettyPrint.printType(output2, 0, schema);
    }
}

