/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.lzo;

import io.airlift.compress.Compressor;
import io.airlift.compress.lzo.LzoRawCompressor;
import io.airlift.compress.lzo.UnsafeUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public class LzoCompressor
implements Compressor {
    private final int[] table = new int[4096];

    @Override
    public int maxCompressedLength(int uncompressedSize) {
        return LzoRawCompressor.maxCompressedLength(uncompressedSize);
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output2, int outputOffset, int maxOutputLength) {
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        return LzoRawCompressor.compress(input, inputAddress, inputLength, output2, outputAddress, maxOutputLength, this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compress(ByteBuffer inputBuffer, ByteBuffer outputBuffer) {
        long outputLimit;
        long outputAddress;
        Object outputBase;
        long inputLimit;
        long inputAddress;
        Object inputBase;
        ByteBuffer input = inputBuffer;
        ByteBuffer output2 = outputBuffer;
        if (((Buffer)input).isDirect()) {
            inputBase = null;
            long address = UnsafeUtil.getAddress(input);
            inputAddress = address + (long)input.position();
            inputLimit = address + (long)input.limit();
        } else if (((Buffer)input).hasArray()) {
            inputBase = ((Buffer)input).array();
            inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)input).arrayOffset() + input.position();
            inputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)input).arrayOffset() + input.limit();
        } else {
            throw new IllegalArgumentException("Unsupported input ByteBuffer implementation " + input.getClass().getName());
        }
        if (((Buffer)output2).isDirect()) {
            outputBase = null;
            long address = UnsafeUtil.getAddress(output2);
            outputAddress = address + (long)output2.position();
            outputLimit = address + (long)output2.limit();
        } else if (((Buffer)output2).hasArray()) {
            outputBase = ((Buffer)output2).array();
            outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)output2).arrayOffset() + output2.position();
            outputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)output2).arrayOffset() + output2.limit();
        } else {
            throw new IllegalArgumentException("Unsupported output ByteBuffer implementation " + output2.getClass().getName());
        }
        ByteBuffer byteBuffer = input;
        synchronized (byteBuffer) {
            ByteBuffer byteBuffer2 = output2;
            synchronized (byteBuffer2) {
                int written = LzoRawCompressor.compress(inputBase, inputAddress, (int)(inputLimit - inputAddress), outputBase, outputAddress, outputLimit - outputAddress, this.table);
                ((Buffer)output2).position(output2.position() + written);
            }
        }
    }
}

