/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;

class HadoopJdkGzipOutputStream
extends CompressionOutputStream {
    private final byte[] oneByte = new byte[1];
    private final GZIPOutputStreamWrapper output;

    public HadoopJdkGzipOutputStream(OutputStream output2, int bufferSize) throws IOException {
        super(output2);
        this.output = new GZIPOutputStreamWrapper(output2, bufferSize);
    }

    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)b;
        this.write(this.oneByte, 0, 1);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.output.write(buffer, offset, length);
    }

    public void finish() throws IOException {
        try {
            this.output.finish();
        }
        finally {
            this.output.end();
        }
    }

    public void resetState() throws IOException {
        this.output.finish();
    }

    private class GZIPOutputStreamWrapper
    extends GZIPOutputStream {
        GZIPOutputStreamWrapper(OutputStream output2, int bufferSize) throws IOException {
            super(output2, bufferSize);
        }

        public void end() throws IOException {
            this.def.end();
        }
    }
}

