/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.shuffle;

import ai.rapids.cudf.MemoryBuffer;
import com.nvidia.spark.rapids.shuffle.BounceBuffer;
import java.io.Serializable;
import java.util.BitSet;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\r\u0002\u0011)\u0019!C\u0001\u000f\"AA\n\u0001B\u0001B\u0003%\u0001\n\u0003\u0005N\u0001\t\u0015\r\u0011\"\u0001O\u0011!\u0011\u0006A!A!\u0002\u0013y\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u000b!\u0004A\u0011A5\u0007\tA\u0004\u0001!\u001d\u0005\nk\"\u0011\t\u0011)A\u0005?ZDQ\u0001\u001b\u0005\u0005\u0002aDQ\u0001 \u0005\u0005BuD\u0001\"a\u0002\u0001A\u0003%\u0011\u0011\u0002\u0005\b\u0003+\u0001\u0001\u0015!\u0003X\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aq!a\u0007\u0001\t\u0003\ti\u0002C\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA#\u0001\u0011\u0005\u0013q\t\u0002\u0014\u0005>,hnY3Ck\u001a4WM]'b]\u0006<WM\u001d\u0006\u0003-]\tqa\u001d5vM\u001adWM\u0003\u0002\u00193\u00051!/\u00199jINT!AG\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qi\u0012A\u00028wS\u0012L\u0017MC\u0001\u001f\u0003\r\u0019w.\\\u0002\u0001+\t\t\u0013l\u0005\u0003\u0001E)j\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0011a\u0017M\\4\u000b\u0003\u001d\nAA[1wC&\u0011\u0011\u0006\n\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\rZ\u0013B\u0001\u0017%\u00055\tU\u000f^8DY>\u001cX-\u00192mKB\u0011aFN\u0007\u0002_)\u0011\u0001'M\u0001\tS:$XM\u001d8bY*\u0011!D\r\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014x-\u0003\u00028_\t9Aj\\4hS:<\u0017\u0001\u00039p_2t\u0015-\\3\u0011\u0005i\u001aeBA\u001eB!\tat(D\u0001>\u0015\tqt$\u0001\u0004=e>|GO\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!iP\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002C\u007f\u0005Q!-\u001e4gKJ\u001c\u0016N_3\u0016\u0003!\u0003\"!\u0013&\u000e\u0003}J!aS \u0003\t1{gnZ\u0001\fEV4g-\u001a:TSj,\u0007%\u0001\u0006ok6\u0014UO\u001a4feN,\u0012a\u0014\t\u0003\u0013BK!!U \u0003\u0007%sG/A\u0006ok6\u0014UO\u001a4feN\u0004\u0013!C1mY>\u001c\u0017\r^8s!\u0011IU\u000bS,\n\u0005Y{$!\u0003$v]\u000e$\u0018n\u001c82!\tA\u0016\f\u0004\u0001\u0005\u000bi\u0003!\u0019A.\u0003\u0003Q\u000b\"\u0001X0\u0011\u0005%k\u0016B\u00010@\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u00194\u000e\u0003\u0005T!AY2\u0002\t\r,HM\u001a\u0006\u00031\u0011T\u0011!Z\u0001\u0003C&L!aZ1\u0003\u00195+Wn\u001c:z\u0005V4g-\u001a:\u0002\rqJg.\u001b;?)\u0015QG.\u001c8p!\rY\u0007aV\u0007\u0002+!)\u0001h\u0002a\u0001s!)ai\u0002a\u0001\u0011\")Qj\u0002a\u0001\u001f\")1k\u0002a\u0001)\n\u0001\"i\\;oG\u0016\u0014UO\u001a4fe&k\u0007\u000f\\\n\u0003\u0011I\u0004\"a[:\n\u0005Q,\"\u0001\u0004\"pk:\u001cWMQ;gM\u0016\u0014\u0018\u0001\u00022vM\u001aL!a^:\u0002\r\t,hMZ3s)\tI8\u0010\u0005\u0002{\u00115\t\u0001\u0001C\u0003v\u0015\u0001\u0007q,\u0001\u0003ge\u0016,Gc\u0001@\u0002\u0004A\u0011\u0011j`\u0005\u0004\u0003\u0003y$\u0001B+oSRDa!!\u0002\f\u0001\u0004\u0011\u0018A\u00012c\u000351'/Z3Ck\u001a4WM]'baB!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010\u0019\nA!\u001e;jY&!\u00111CA\u0007\u0005\u0019\u0011\u0015\u000e^*fi\u0006Q!o\\8u\u0005V4g-\u001a:\u0002\u001b\u0005\u001c\u0017/^5sK\n+hMZ3s)\u0005\u0011\u0018a\u00028v[\u001a\u0013X-\u001a\u000b\u0002\u001f\u0006I\u0012mY9vSJ,')\u001e4gKJ\u001chj\u001c8CY>\u001c7.\u001b8h)\u0011\t\u0019#!\u000e\u0011\u000b\u0005\u0015\u0012q\u0006:\u000f\t\u0005\u001d\u00121\u0006\b\u0004y\u0005%\u0012\"\u0001!\n\u0007\u00055r(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00121\u0007\u0002\u0004'\u0016\f(bAA\u0017\u007f!1\u0011q\u0007\tA\u0002=\u000b!\u0003]8tg&\u0014G.\u001a(v[\n+hMZ3sg\u0006QaM]3f\u0005V4g-\u001a:\u0015\u0007y\fi\u0004\u0003\u0004\u0002@E\u0001\rA]\u0001\rE>,hnY3Ck\u001a4WM]\u0001\u000eO\u0016$(k\\8u\u0005V4g-\u001a:\u0015\u0003}\u000bQa\u00197pg\u0016$\u0012A ")
public class BounceBufferManager<T extends MemoryBuffer>
implements AutoCloseable,
Logging {
    private final String poolName;
    private final long bufferSize;
    private final int numBuffers;
    private final BitSet freeBufferMap;
    private final T rootBuffer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long bufferSize() {
        return this.bufferSize;
    }

    public int numBuffers() {
        return this.numBuffers;
    }

    private BounceBuffer acquireBuffer() {
        int bufferIndex = this.freeBufferMap.nextSetBit(0);
        if (bufferIndex < 0) {
            throw new IllegalStateException(new StringBuilder(27).append("Buffer pool ").append(this.poolName).append(" has exhausted!").toString());
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append($this.poolName).append(": Buffer index: ").append(bufferIndex).toString());
        this.freeBufferMap.clear(bufferIndex);
        MemoryBuffer res = this.rootBuffer.slice((long)bufferIndex * this.bufferSize(), this.bufferSize());
        return new BounceBufferImpl(res);
    }

    public synchronized int numFree() {
        return this.freeBufferMap.cardinality();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Seq<BounceBuffer> acquireBuffersNonBlocking(int possibleNumBuffers) {
        void var2_2;
        if (this.numFree() < possibleNumBuffers) {
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append($this.poolName).append(" at capacity. numFree: ").append(this.numFree()).append(", ").append("buffers required ").append(possibleNumBuffers).toString());
            return (Seq)Nil$.MODULE$;
        }
        IndexedSeq res = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), possibleNumBuffers).map((Function1 & Serializable & scala.Serializable)x$2 -> this.acquireBuffer(), IndexedSeq$.MODULE$.canBuildFrom());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append($this.poolName).append(" at acquire. Has numFree ").append(this.numFree()).toString());
        return var2_2;
    }

    public synchronized void freeBuffer(BounceBuffer bounceBuffer) {
        MemoryBuffer buffer = bounceBuffer.buffer();
        Predef$.MODULE$.require(buffer.getAddress() >= this.rootBuffer.getAddress() && (buffer.getAddress() - this.rootBuffer.getAddress()) % this.bufferSize() == 0L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append($this.poolName).append(": foreign buffer being freed").toString());
        long bufferIndex = (buffer.getAddress() - this.rootBuffer.getAddress()) / this.bufferSize();
        Predef$.MODULE$.require(bufferIndex < (long)this.numBuffers(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append($this.poolName).append(": buffer index invalid ").append(bufferIndex).append(" should be less than ").append(this.numBuffers()).toString());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append($this.poolName).append(": Free buffer index ").append(bufferIndex).toString());
        buffer.close();
        this.freeBufferMap.set((int)bufferIndex);
        this.notifyAll();
    }

    public MemoryBuffer getRootBuffer() {
        return this.rootBuffer;
    }

    @Override
    public void close() {
        this.rootBuffer.close();
    }

    public BounceBufferManager(String poolName, long bufferSize, int numBuffers, Function1<Object, T> allocator) {
        this.poolName = poolName;
        this.bufferSize = bufferSize;
        this.numBuffers = numBuffers;
        Logging.$init$((Logging)this);
        this.freeBufferMap = new BitSet(numBuffers);
        this.rootBuffer = (MemoryBuffer)allocator.apply((Object)BoxesRunTime.boxToLong((long)(bufferSize * (long)numBuffers)));
        this.freeBufferMap.set(0, numBuffers);
    }

    public class BounceBufferImpl
    extends BounceBuffer {
        @Override
        public void free(BounceBuffer bb) {
            this.com$nvidia$spark$rapids$shuffle$BounceBufferManager$BounceBufferImpl$$$outer().freeBuffer(bb);
        }

        public /* synthetic */ BounceBufferManager com$nvidia$spark$rapids$shuffle$BounceBufferManager$BounceBufferImpl$$$outer() {
            return BounceBufferManager.this;
        }

        public BounceBufferImpl(MemoryBuffer buff) {
            if (BounceBufferManager.this == null) {
                throw null;
            }
            super(buff);
        }
    }
}

