/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.spark;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.io.BaseEncoding;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.NamedReference;

public class Spark3Util {
    private Spark3Util() {
    }

    public static NamedReference toNamedReference(String name) {
        return Expressions.column((String)name);
    }

    public static String describe(Expression expr) {
        return (String)ExpressionVisitors.visit((Expression)expr, (ExpressionVisitors.ExpressionVisitor)DescribeExpressionVisitor.INSTANCE);
    }

    private static class DescribeExpressionVisitor
    extends ExpressionVisitors.ExpressionVisitor<String> {
        private static final DescribeExpressionVisitor INSTANCE = new DescribeExpressionVisitor();

        private DescribeExpressionVisitor() {
        }

        public String alwaysTrue() {
            return "true";
        }

        public String alwaysFalse() {
            return "false";
        }

        public String not(String result) {
            return "NOT (" + result + ")";
        }

        public String and(String leftResult, String rightResult) {
            return "(" + leftResult + " AND " + rightResult + ")";
        }

        public String or(String leftResult, String rightResult) {
            return "(" + leftResult + " OR " + rightResult + ")";
        }

        public <T> String predicate(BoundPredicate<T> pred) {
            throw new UnsupportedOperationException("Cannot convert bound predicates to SQL");
        }

        public <T> String predicate(UnboundPredicate<T> pred) {
            switch (pred.op()) {
                case IS_NULL: {
                    return pred.ref().name() + " IS NULL";
                }
                case NOT_NULL: {
                    return pred.ref().name() + " IS NOT NULL";
                }
                case IS_NAN: {
                    return "is_nan(" + pred.ref().name() + ")";
                }
                case NOT_NAN: {
                    return "not_nan(" + pred.ref().name() + ")";
                }
                case LT: {
                    return pred.ref().name() + " < " + DescribeExpressionVisitor.sqlString(pred.literal());
                }
                case LT_EQ: {
                    return pred.ref().name() + " <= " + DescribeExpressionVisitor.sqlString(pred.literal());
                }
                case GT: {
                    return pred.ref().name() + " > " + DescribeExpressionVisitor.sqlString(pred.literal());
                }
                case GT_EQ: {
                    return pred.ref().name() + " >= " + DescribeExpressionVisitor.sqlString(pred.literal());
                }
                case EQ: {
                    return pred.ref().name() + " = " + DescribeExpressionVisitor.sqlString(pred.literal());
                }
                case NOT_EQ: {
                    return pred.ref().name() + " != " + DescribeExpressionVisitor.sqlString(pred.literal());
                }
                case STARTS_WITH: {
                    return pred.ref().name() + " LIKE '" + pred.literal() + "%'";
                }
                case NOT_STARTS_WITH: {
                    return pred.ref().name() + " NOT LIKE '" + pred.literal() + "%'";
                }
                case IN: {
                    return pred.ref().name() + " IN (" + DescribeExpressionVisitor.sqlString(pred.literals()) + ")";
                }
                case NOT_IN: {
                    return pred.ref().name() + " NOT IN (" + DescribeExpressionVisitor.sqlString(pred.literals()) + ")";
                }
            }
            throw new UnsupportedOperationException("Cannot convert predicate to SQL: " + pred);
        }

        private static <T> String sqlString(List<Literal<T>> literals) {
            return literals.stream().map(DescribeExpressionVisitor::sqlString).collect(Collectors.joining(", "));
        }

        private static String sqlString(Literal<?> lit) {
            if (lit.value() instanceof String) {
                return "'" + lit.value() + "'";
            }
            if (lit.value() instanceof ByteBuffer) {
                byte[] bytes = ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)lit.value()));
                return "X'" + BaseEncoding.base16().encode(bytes) + "'";
            }
            return lit.value().toString();
        }
    }
}

