/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.parquet;

import java.util.HashSet;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;

public class ParquetUtil {
    private ParquetUtil() {
    }

    public static boolean hasNonDictionaryPages(ColumnChunkMetaData meta) {
        EncodingStats stats = meta.getEncodingStats();
        if (stats != null) {
            return stats.hasNonDictionaryEncodedPages();
        }
        HashSet encodings = Sets.newHashSet((Iterable)meta.getEncodings());
        if (encodings.remove(Encoding.PLAIN_DICTIONARY)) {
            encodings.remove(Encoding.RLE);
            encodings.remove(Encoding.BIT_PACKED);
            return !encodings.isEmpty();
        }
        return true;
    }
}

