/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class GpuDeleteFilter {
    private static final Schema POS_DELETE_SCHEMA = new Schema(new Types.NestedField[]{MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS});
    private final String filePath;
    private final List<DeleteFile> posDeletes;
    private final List<DeleteFile> eqDeletes;
    private final Schema requiredSchema;

    public GpuDeleteFilter(String filePath, List<DeleteFile> deletes, Schema tableSchema, Schema requestedSchema) {
        this.filePath = filePath;
        ImmutableList.Builder posDeleteBuilder = ImmutableList.builder();
        ImmutableList.Builder eqDeleteBuilder = ImmutableList.builder();
        block4: for (DeleteFile delete : deletes) {
            switch (delete.content()) {
                case POSITION_DELETES: {
                    posDeleteBuilder.add((Object)delete);
                    continue block4;
                }
                case EQUALITY_DELETES: {
                    eqDeleteBuilder.add((Object)delete);
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown delete file content: " + delete.content());
        }
        this.posDeletes = posDeleteBuilder.build();
        this.eqDeletes = eqDeleteBuilder.build();
        this.requiredSchema = GpuDeleteFilter.fileProjection(tableSchema, requestedSchema, this.posDeletes, this.eqDeletes);
    }

    public Schema requiredSchema() {
        return this.requiredSchema;
    }

    public boolean hasPosDeletes() {
        return !this.posDeletes.isEmpty();
    }

    public boolean hasEqDeletes() {
        return !this.eqDeletes.isEmpty();
    }

    private static Schema fileProjection(Schema tableSchema, Schema requestedSchema, List<DeleteFile> posDeletes, List<DeleteFile> eqDeletes) {
        if (posDeletes.isEmpty() && eqDeletes.isEmpty()) {
            return requestedSchema;
        }
        LinkedHashSet requiredIds = Sets.newLinkedHashSet();
        if (!posDeletes.isEmpty()) {
            requiredIds.add(MetadataColumns.ROW_POSITION.fieldId());
        }
        for (DeleteFile eqDelete : eqDeletes) {
            requiredIds.addAll(eqDelete.equalityFieldIds());
        }
        requiredIds.add(MetadataColumns.IS_DELETED.fieldId());
        LinkedHashSet missingIds = Sets.newLinkedHashSet((Iterable)Sets.difference((Set)requiredIds, (Set)TypeUtil.getProjectedIds((Schema)requestedSchema)));
        if (missingIds.isEmpty()) {
            return requestedSchema;
        }
        ArrayList columns = Lists.newArrayList((Iterable)requestedSchema.columns());
        Iterator iterator = missingIds.iterator();
        while (iterator.hasNext()) {
            int fieldId = (Integer)iterator.next();
            if (fieldId == MetadataColumns.ROW_POSITION.fieldId() || fieldId == MetadataColumns.IS_DELETED.fieldId()) continue;
            Types.NestedField field = tableSchema.asStruct().field(fieldId);
            Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot find required field for ID %s", (int)fieldId);
            columns.add(field);
        }
        if (missingIds.contains(MetadataColumns.ROW_POSITION.fieldId())) {
            columns.add(MetadataColumns.ROW_POSITION);
        }
        if (missingIds.contains(MetadataColumns.IS_DELETED.fieldId())) {
            columns.add(MetadataColumns.IS_DELETED);
        }
        return new Schema((List)columns);
    }
}

