/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.format;

import com.nvidia.shaded.spark.com.google.flatbuffers.FlatBufferBuilder;
import com.nvidia.shaded.spark.com.google.flatbuffers.Table;
import com.nvidia.spark.rapids.format.CodecBufferDescriptor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class BufferMeta
extends Table {
    public static BufferMeta getRootAsBufferMeta(ByteBuffer _bb) {
        return BufferMeta.getRootAsBufferMeta(_bb, new BufferMeta());
    }

    public static BufferMeta getRootAsBufferMeta(ByteBuffer _bb, BufferMeta obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
        this.vtable_start = this.bb_pos - this.bb.getInt(this.bb_pos);
        this.vtable_size = this.bb.getShort(this.vtable_start);
    }

    public BufferMeta __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int id() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutateId(int id) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, id);
            return true;
        }
        return false;
    }

    public long size() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateSize(long size) {
        int o = this.__offset(6);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, size);
            return true;
        }
        return false;
    }

    public long uncompressedSize() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateUncompressedSize(long uncompressed_size) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, uncompressed_size);
            return true;
        }
        return false;
    }

    public CodecBufferDescriptor codecBufferDescrs(int j) {
        return this.codecBufferDescrs(new CodecBufferDescriptor(), j);
    }

    public CodecBufferDescriptor codecBufferDescrs(CodecBufferDescriptor obj, int j) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int codecBufferDescrsLength() {
        int o = this.__offset(10);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public static int createBufferMeta(FlatBufferBuilder builder, int id, long size, long uncompressed_size, int codec_buffer_descrsOffset) {
        builder.startObject(4);
        BufferMeta.addUncompressedSize(builder, uncompressed_size);
        BufferMeta.addSize(builder, size);
        BufferMeta.addCodecBufferDescrs(builder, codec_buffer_descrsOffset);
        BufferMeta.addId(builder, id);
        return BufferMeta.endBufferMeta(builder);
    }

    public static void startBufferMeta(FlatBufferBuilder builder) {
        builder.startObject(4);
    }

    public static void addId(FlatBufferBuilder builder, int id) {
        builder.addInt(0, id, 0);
    }

    public static void addSize(FlatBufferBuilder builder, long size) {
        builder.addLong(1, size, 0L);
    }

    public static void addUncompressedSize(FlatBufferBuilder builder, long uncompressedSize) {
        builder.addLong(2, uncompressedSize, 0L);
    }

    public static void addCodecBufferDescrs(FlatBufferBuilder builder, int codecBufferDescrsOffset) {
        builder.addOffset(3, codecBufferDescrsOffset, 0);
    }

    public static int createCodecBufferDescrsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startCodecBufferDescrsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endBufferMeta(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

