/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.ConfHelper$;
import com.nvidia.spark.rapids.ExecChecks;
import com.nvidia.spark.rapids.ExecRule;
import com.nvidia.spark.rapids.ExprChecks;
import com.nvidia.spark.rapids.ExprRule;
import com.nvidia.spark.rapids.ExpressionContext;
import com.nvidia.spark.rapids.FileFormatChecks;
import com.nvidia.spark.rapids.FileFormatType;
import com.nvidia.spark.rapids.GpuOverrides$;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.ReadFileOp$;
import com.nvidia.spark.rapids.SupportLevel;
import com.nvidia.spark.rapids.TypeChecks;
import com.nvidia.spark.rapids.TypeSig;
import com.nvidia.spark.rapids.TypeSig$;
import com.nvidia.spark.rapids.WriteFileOp$;
import com.nvidia.spark.rapids.shims.TypeSigUtil$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import scala.Array$;
import scala.Console$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class SupportedOpsForTools$ {
    public static SupportedOpsForTools$ MODULE$;
    private Enumeration.ValueSet allSupportedTypes;
    private volatile boolean bitmap$0;

    static {
        new SupportedOpsForTools$();
    }

    private Enumeration.ValueSet allSupportedTypes$lzycompute() {
        SupportedOpsForTools$ supportedOpsForTools$ = this;
        synchronized (supportedOpsForTools$) {
            if (!this.bitmap$0) {
                this.allSupportedTypes = TypeSigUtil$.MODULE$.getAllSupportedTypes();
                this.bitmap$0 = true;
            }
        }
        return this.allSupportedTypes;
    }

    private Enumeration.ValueSet allSupportedTypes() {
        return !this.bitmap$0 ? this.allSupportedTypes$lzycompute() : this.allSupportedTypes;
    }

    private String replaceDelimiter(String str, String delimiter) {
        String string;
        if (str != null && str.contains(delimiter)) {
            String replaceWith = delimiter.equals(",") ? ";" : (delimiter.equals(";") ? ":" : ";");
            string = str.replace(delimiter, replaceWith);
        } else {
            string = str;
        }
        return string;
    }

    private void outputSupportIO() {
        RapidsConf conf = new RapidsConf((Map<String, String>)Predef$.MODULE$.Map().empty());
        Seq types = this.allSupportedTypes().toSeq();
        Seq header = (Seq)((TraversableLike)new .colon.colon((Object)"Format", (List)new .colon.colon((Object)"Direction", (List)Nil$.MODULE$))).$plus$plus((GenTraversableOnce)types, Seq$.MODULE$.canBuildFrom());
        String[] writeOps = (String[])Array$.MODULE$.fill(types.size(), (Function0 & Serializable & scala.Serializable)() -> "NA", ClassTag$.MODULE$.apply(String.class));
        Predef$.MODULE$.println((Object)header.mkString(","));
        ((IterableLike)GpuOverrides$.MODULE$.fileFormats().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$20 -> x$20._1().toString(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SupportedOpsForTools$.$anonfun$outputSupportIO$3(conf, types, writeOps, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void operatorMappingWithScore() {
        Seq header = (Seq)new .colon.colon((Object)"CPUOperator", (List)new .colon.colon((Object)"Score", (List)Nil$.MODULE$));
        Predef$.MODULE$.println((Object)header.mkString(","));
        Map operatorCustomSpeedUp = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"BroadcastHashJoinExec", (Object)"3.0"), new Tuple2((Object)"ShuffleExchangeExec", (Object)"3.1"), new Tuple2((Object)"FilterExec", (Object)"2.4"), new Tuple2((Object)"HashAggregateExec", (Object)"3.4"), new Tuple2((Object)"SortExec", (Object)"5.2"), new Tuple2((Object)"SortMergeJoinExec", (Object)"14.1"), new Tuple2((Object)"ArrowEvalPythonExec", (Object)"1.2"), new Tuple2((Object)"AggregateInPandasExec", (Object)"1.2"), new Tuple2((Object)"FlatMapGroupsInPandasExec", (Object)"1.2"), new Tuple2((Object)"MapInPandasExec", (Object)"1.2"), new Tuple2((Object)"WindowInPandasExec", (Object)"1.2")}));
        ((IterableLike)GpuOverrides$.MODULE$.execs().values().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$21 -> x$21.tag().toString(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)rule -> {
            SupportedOpsForTools$.$anonfun$operatorMappingWithScore$2(operatorCustomSpeedUp, rule);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)GpuOverrides$.MODULE$.expressions().values().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$23 -> x$23.tag().runtimeClass().getSimpleName(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)rule -> {
            SupportedOpsForTools$.$anonfun$operatorMappingWithScore$5(rule);
            return BoxedUnit.UNIT;
        });
    }

    private void outputSupportedExecs() {
        RapidsConf conf = new RapidsConf((Map<String, String>)Predef$.MODULE$.Map().empty());
        Seq types = this.allSupportedTypes().toSeq();
        Seq header = (Seq)((TraversableLike)new .colon.colon((Object)"Exec", (List)new .colon.colon((Object)"Supported", (List)new .colon.colon((Object)"Notes", (List)new .colon.colon((Object)"Params", (List)Nil$.MODULE$))))).$plus$plus((GenTraversableOnce)types, Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)header.mkString(","));
        ((IterableLike)GpuOverrides$.MODULE$.execs().values().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$25 -> x$25.tag().toString(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)rule -> {
            SupportedOpsForTools$.$anonfun$outputSupportedExecs$2(rule);
            return BoxedUnit.UNIT;
        });
    }

    private void outputSupportedExpressions() {
        RapidsConf conf = new RapidsConf((Map<String, String>)Predef$.MODULE$.Map().empty());
        Seq types = this.allSupportedTypes().toSeq();
        Seq header = (Seq)((TraversableLike)new .colon.colon((Object)"Expression", (List)new .colon.colon((Object)"Supported", (List)new .colon.colon((Object)"SQL Func", (List)new .colon.colon((Object)"Notes", (List)new .colon.colon((Object)"Context", (List)new .colon.colon((Object)"Params", (List)Nil$.MODULE$))))))).$plus$plus((GenTraversableOnce)types, Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)header.mkString(","));
        ((IterableLike)GpuOverrides$.MODULE$.expressions().values().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$29 -> x$29.tag().toString(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)rule -> {
            SupportedOpsForTools$.$anonfun$outputSupportedExpressions$2(rule);
            return BoxedUnit.UNIT;
        });
    }

    public void help(String printType) {
        String string = printType;
        if (string.equals("execs")) {
            this.outputSupportedExecs();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (string.equals("exprs")) {
            this.outputSupportedExpressions();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (string.equals("operatorScore")) {
            this.operatorMappingWithScore();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (string.equals("ioOnly")) {
            this.outputSupportIO();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException("SupportedOpsForTools: Invalid option. Validoptions are `execs`, `exprs`, `operatorScore` and `ioOnly`");
        }
    }

    public void main(String[] args) {
        FileOutputStream out = new FileOutputStream(new File(args[0]));
        String printType = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() > 1 ? args[1] : "ioOnly";
        Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Console$.MODULE$.withErr((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.help(printType)));
    }

    public static final /* synthetic */ void $anonfun$outputSupportIO$3(RapidsConf conf$1, Seq types$1, String[] writeOps$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TypeSig writeFileFormat;
            boolean bl;
            FileFormatType format = (FileFormatType)tuple2._1();
            Map ioMap = (Map)tuple2._2();
            String formatLowerCase = format.toString().toLowerCase();
            String string = formatLowerCase;
            if ("csv".equals(string)) {
                bl = conf$1.isCsvEnabled() && conf$1.isCsvReadEnabled();
            } else if ("parquet".equals(string)) {
                bl = conf$1.isParquetEnabled() && conf$1.isParquetReadEnabled();
            } else if ("orc".equals(string)) {
                bl = conf$1.isOrcEnabled() && conf$1.isOrcReadEnabled();
            } else if ("json".equals(string)) {
                bl = conf$1.isJsonEnabled() && conf$1.isJsonReadEnabled();
            } else if ("avro".equals(string)) {
                bl = conf$1.isAvroEnabled() && conf$1.isAvroReadEnabled();
            } else if ("iceberg".equals(string)) {
                bl = conf$1.isIcebergEnabled() && conf$1.isIcebergReadEnabled();
            } else {
                throw new IllegalArgumentException("Format is unknown we need to add it here!");
            }
            boolean formatEnabled = bl;
            FileFormatChecks read = (FileFormatChecks)ioMap.apply((Object)ReadFileOp$.MODULE$);
            Seq readOps = (Seq)types$1.map((Function1 & Serializable & scala.Serializable)t -> !formatEnabled ? "CO" : read.support((Enumeration.Value)t).text(), Seq$.MODULE$.canBuildFrom());
            Predef$.MODULE$.println((Object)String.valueOf(((TraversableOnce)((TraversableLike)new .colon.colon((Object)format, (List)new .colon.colon((Object)"read", (List)Nil$.MODULE$))).$plus$plus((GenTraversableOnce)readOps, Seq$.MODULE$.canBuildFrom())).mkString(",")));
            TypeSig typeSig = writeFileFormat = ((FileFormatChecks)ioMap.apply((Object)WriteFileOp$.MODULE$)).getFileFormat();
            TypeSig typeSig2 = TypeSig$.MODULE$.none();
            if (typeSig == null ? typeSig2 != null : !typeSig.equals(typeSig2)) {
                Predef$.MODULE$.println((Object)String.valueOf(((TraversableOnce)((TraversableLike)new .colon.colon((Object)format, (List)new .colon.colon((Object)"write", (List)Nil$.MODULE$))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])writeOps$1)), Seq$.MODULE$.canBuildFrom())).mkString(",")));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$operatorMappingWithScore$2(Map operatorCustomSpeedUp$1, ExecRule rule) {
        block0: {
            Option<TypeChecks<?>> checks = rule.getChecks();
            if (!rule.isVisible() || !checks.forall((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)x$22.shown()))) break block0;
            String cpuName = rule.tag().runtimeClass().getSimpleName();
            Seq allCols = operatorCustomSpeedUp$1.contains((Object)cpuName) ? (Seq)new .colon.colon((Object)cpuName, (List)new .colon.colon((Object)((String)operatorCustomSpeedUp$1.apply((Object)cpuName)), (List)Nil$.MODULE$)) : (Seq)new .colon.colon((Object)cpuName, (List)new .colon.colon((Object)"3.0", (List)Nil$.MODULE$));
            Predef$.MODULE$.println((Object)String.valueOf(allCols.mkString(",")));
        }
    }

    public static final /* synthetic */ void $anonfun$operatorMappingWithScore$5(ExprRule rule) {
        block0: {
            Option<TypeChecks<?>> checks = rule.getChecks();
            if (!rule.isVisible() || !checks.forall((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)x$24.shown()))) break block0;
            String cpuName = rule.tag().runtimeClass().getSimpleName();
            Seq allCols = (Seq)new .colon.colon((Object)cpuName, (List)new .colon.colon((Object)"4", (List)Nil$.MODULE$));
            Predef$.MODULE$.println((Object)String.valueOf(allCols.mkString(",")));
        }
    }

    public static final /* synthetic */ void $anonfun$outputSupportedExecs$6(Map notes$2, Map allData$4, boolean isConfigDisabled$1, Seq firstCol$1, Seq thirdCol$1, String input) {
        String named = (String)notes$2.get((Object)input).map((Function1 & Serializable & scala.Serializable)l -> new StringBuilder(2).append(input).append("(").append(l.mkString(";")).append(")").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> input);
        Seq supportLevelOps = (Seq)MODULE$.allSupportedTypes().toSeq().map((Function1 & Serializable & scala.Serializable)t -> ((SupportLevel)((MapLike)allData$4.apply(t)).apply((Object)input)).text(), Seq$.MODULE$.canBuildFrom());
        Seq isSupportedExec = (Seq)new .colon.colon((Object)(supportLevelOps.forall((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)x$27.equals("NS"))) || isConfigDisabled$1 ? "NS" : "S"), (List)Nil$.MODULE$);
        Seq allCols = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)firstCol$1.$plus$plus((GenTraversableOnce)isSupportedExec, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)thirdCol$1, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)named, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)supportLevelOps, Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)String.valueOf(((TraversableOnce)allCols.map((Function1 & Serializable & scala.Serializable)x$28 -> MODULE$.replaceDelimiter((String)x$28, ","), Seq$.MODULE$.canBuildFrom())).mkString(",")));
    }

    public static final /* synthetic */ void $anonfun$outputSupportedExecs$2(ExecRule rule) {
        block0: {
            Option<TypeChecks<?>> checks = rule.getChecks();
            boolean isConfigDisabled = rule.disabledMsg().isDefined();
            if (!rule.isVisible() || !checks.forall((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)x$26.shown()))) break block0;
            ExecChecks execChecks = (ExecChecks)checks.get();
            Map allData = ((TraversableOnce)MODULE$.allSupportedTypes().map((Function1 & Serializable & scala.Serializable)t -> new Tuple2(t, execChecks.support((Enumeration.Value)t)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Map<String, List<String>> notes = execChecks.supportNotes();
            Iterable inputs = ((MapLike)allData.values().head()).keys();
            Seq firstCol = (Seq)new .colon.colon((Object)rule.tag().runtimeClass().getSimpleName(), (List)Nil$.MODULE$);
            Seq thirdCol = (Seq)new .colon.colon((Object)((String)rule.notes().getOrElse((Function0 & Serializable & scala.Serializable)() -> "None")), (List)Nil$.MODULE$);
            inputs.foreach((Function1 & Serializable & scala.Serializable)input -> {
                SupportedOpsForTools$.$anonfun$outputSupportedExecs$6(notes, allData, isConfigDisabled, firstCol, thirdCol, input);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$outputSupportedExpressions$9(Map allData$5, ExpressionContext context$2, boolean isConfigDisabled$2, Seq firstCol$2, Seq staticCols$1, String param) {
        Seq supportLevelOps = (Seq)MODULE$.allSupportedTypes().toSeq().map((Function1 & Serializable & scala.Serializable)t -> ((SupportLevel)((MapLike)((MapLike)allData$5.apply(t)).apply((Object)context$2)).apply((Object)param)).text(), Seq$.MODULE$.canBuildFrom());
        Seq isSupportedExpr = (Seq)new .colon.colon((Object)(supportLevelOps.forall((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)x$32.equals("NS"))) || isConfigDisabled$2 ? "NS" : "S"), (List)Nil$.MODULE$);
        Seq allCols = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)firstCol$2.$plus$plus((GenTraversableOnce)isSupportedExpr, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)staticCols$1, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)context$2.toString(), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)param, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)supportLevelOps, Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)String.valueOf(((TraversableOnce)allCols.map((Function1 & Serializable & scala.Serializable)x$33 -> MODULE$.replaceDelimiter((String)x$33, ","), Seq$.MODULE$.canBuildFrom())).mkString(",")));
    }

    public static final /* synthetic */ void $anonfun$outputSupportedExpressions$8(Map allData$5, boolean isConfigDisabled$2, Seq firstCol$2, Seq staticCols$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ExpressionContext context = (ExpressionContext)tuple2._1();
        Map data = (Map)tuple2._2();
        data.keys().foreach((Function1 & Serializable & scala.Serializable)param -> {
            SupportedOpsForTools$.$anonfun$outputSupportedExpressions$9(allData$5, context, isConfigDisabled$2, firstCol$2, staticCols$1, param);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$outputSupportedExpressions$2(ExprRule rule) {
        block0: {
            Option<TypeChecks<?>> checks = rule.getChecks();
            boolean isConfigDisabled = rule.disabledMsg().isDefined();
            if (!rule.isVisible() || !checks.isDefined() || !checks.forall((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)x$30.shown()))) break block0;
            Option sqlFunctions = ConfHelper$.MODULE$.getSqlFunctionsForClass(rule.tag().runtimeClass()).map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.mkString(", "));
            ExprChecks exprChecks = (ExprChecks)checks.get();
            Map allData = ((TraversableOnce)MODULE$.allSupportedTypes().map((Function1 & Serializable & scala.Serializable)t -> new Tuple2(t, exprChecks.support((Enumeration.Value)t)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Map representative = (Map)allData.values().head();
            Seq firstCol = (Seq)new .colon.colon((Object)rule.tag().runtimeClass().getSimpleName(), (List)Nil$.MODULE$);
            Seq staticCols = (Seq)new .colon.colon((Object)((String)sqlFunctions.getOrElse((Function0 & Serializable & scala.Serializable)() -> " ")), (List)new .colon.colon((Object)((String)rule.notes().getOrElse((Function0 & Serializable & scala.Serializable)() -> "None")), (List)Nil$.MODULE$));
            representative.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SupportedOpsForTools$.$anonfun$outputSupportedExpressions$8(allData, isConfigDisabled, firstCol, staticCols, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private SupportedOpsForTools$() {
        MODULE$ = this;
    }
}

