/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.GpuSemaphore$;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsBufferCatalog$;
import com.nvidia.spark.rapids.SpillableColumnarBatch;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.rapids.TempSpillBufferId;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y4Aa\u0004\t\u00013!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!i\u0004A!A!\u0002\u0013q\u0004\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000b-\u0003A\u0011\u0001'\t\u000fI\u0003\u0001\u0019!C\u0005'\"9q\u000b\u0001a\u0001\n\u0013A\u0006B\u00020\u0001A\u0003&A\u000bC\u0003`\u0001\u0011\u0005\u0003\rC\u0003b\u0001\u0011\u0005!\r\u0003\u0005d\u0001!\u0015\r\u0011\"\u0011e\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015!\b\u0001\"\u0011v\u0005i\u0019\u0006/\u001b7mC\ndWmQ8mk6t\u0017M\u001d\"bi\u000eD\u0017*\u001c9m\u0015\t\t\"#\u0001\u0004sCBLGm\u001d\u0006\u0003'Q\tQa\u001d9be.T!!\u0006\f\u0002\r94\u0018\u000eZ5b\u0015\u00059\u0012aA2p[\u000e\u00011\u0003\u0002\u0001\u001bE\u0019\u0002\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\t1\fgn\u001a\u0006\u0002?\u0005!!.\u0019<b\u0013\t\tCD\u0001\u0004PE*,7\r\u001e\t\u0003G\u0011j\u0011\u0001E\u0005\u0003KA\u0011ac\u00159jY2\f'\r\\3D_2,XN\\1s\u0005\u0006$8\r\u001b\t\u0003G\u001dJ!\u0001\u000b\t\u0003\u0007\u0005\u0013X.\u0001\u0002jIB\u00111\u0006N\u0007\u0002Y)\u0011\u0011#\f\u0006\u0003]=\n1a]9m\u0015\t\u0019\u0002G\u0003\u00022e\u00051\u0011\r]1dQ\u0016T\u0011aM\u0001\u0004_J<\u0017BA\u001b-\u0005E!V-\u001c9Ta&dGNQ;gM\u0016\u0014\u0018\nZ\u0001\te><8i\\;oiB\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t\u0019\u0011J\u001c;\u0002\u0015M\u0004\u0018M]6UsB,7\u000fE\u00029\u007f\u0005K!\u0001Q\u001d\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\t+U\"A\"\u000b\u0005\u0011k\u0013!\u0002;za\u0016\u001c\u0018B\u0001$D\u0005!!\u0015\r^1UsB,\u0017aB:f[^\u000b\u0017\u000e\u001e\t\u0003G%K!A\u0013\t\u0003\u0013\u001d\u0003X/T3ue&\u001c\u0017A\u0002\u001fj]&$h\bF\u0003N\u001d>\u0003\u0016\u000b\u0005\u0002$\u0001!)\u0011&\u0002a\u0001U!)a'\u0002a\u0001o!)Q(\u0002a\u0001}!)q)\u0002a\u0001\u0011\u000611\r\\8tK\u0012,\u0012\u0001\u0016\t\u0003qUK!AV\u001d\u0003\u000f\t{w\u000e\\3b]\u0006Q1\r\\8tK\u0012|F%Z9\u0015\u0005ec\u0006C\u0001\u001d[\u0013\tY\u0016H\u0001\u0003V]&$\bbB/\b\u0003\u0003\u0005\r\u0001V\u0001\u0004q\u0012\n\u0014aB2m_N,G\rI\u0001\b]Vl'k\\<t)\u00059\u0014aB:qS2d\u0017\nZ\u000b\u0002U\u0005Y1/\u001b>f\u0013:\u0014\u0015\u0010^3t+\u0005)\u0007C\u0001\u001dg\u0013\t9\u0017H\u0001\u0003M_:<\u0017\u0001E:fiN\u0003\u0018\u000e\u001c7Qe&|'/\u001b;z)\tI&\u000eC\u0003l\u0019\u0001\u0007Q-\u0001\u0005qe&|'/\u001b;z\u0003A9W\r^\"pYVlg.\u0019:CCR\u001c\u0007\u000eF\u0001o!\ty'/D\u0001q\u0015\t\tX&\u0001\u0006wK\u000e$xN]5{K\u0012L!a\u001d9\u0003\u001b\r{G.^7oCJ\u0014\u0015\r^2i\u0003\u0015\u0019Gn\\:f)\u0005I\u0006")
public class SpillableColumnarBatchImpl
implements SpillableColumnarBatch,
Arm {
    private long sizeInBytes;
    private final TempSpillBufferId id;
    private final int rowCount;
    private final DataType[] sparkTypes;
    private final GpuMetric semWait;
    private boolean closed;
    private volatile boolean bitmap$0;

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    @Override
    public int numRows() {
        return this.rowCount;
    }

    public TempSpillBufferId spillId() {
        return this.id;
    }

    private long sizeInBytes$lzycompute() {
        SpillableColumnarBatchImpl spillableColumnarBatchImpl = this;
        synchronized (spillableColumnarBatchImpl) {
            if (!this.bitmap$0) {
                this.sizeInBytes = BoxesRunTime.unboxToLong(this.withResource(RapidsBufferCatalog$.MODULE$.acquireBuffer(this.id), (Function1 & java.io.Serializable & Serializable)buff -> BoxesRunTime.boxToLong((long)buff.size())));
                this.bitmap$0 = true;
            }
        }
        return this.sizeInBytes;
    }

    @Override
    public long sizeInBytes() {
        return !this.bitmap$0 ? this.sizeInBytes$lzycompute() : this.sizeInBytes;
    }

    @Override
    public void setSpillPriority(long priority) {
        this.withResource(RapidsBufferCatalog$.MODULE$.acquireBuffer(this.id), (Function1 & java.io.Serializable & Serializable)rapidsBuffer -> {
            rapidsBuffer.setSpillPriority(priority);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public ColumnarBatch getColumnarBatch() {
        return (ColumnarBatch)this.withResource(RapidsBufferCatalog$.MODULE$.acquireBuffer(this.id), (Function1 & java.io.Serializable & Serializable)rapidsBuffer -> {
            GpuSemaphore$.MODULE$.acquireIfNecessary(TaskContext$.MODULE$.get(), $this.semWait);
            return rapidsBuffer.getColumnarBatch($this.sparkTypes);
        });
    }

    @Override
    public void close() {
        block0: {
            if (this.closed()) break block0;
            RapidsBufferCatalog$.MODULE$.removeBuffer(this.id);
            this.closed_$eq(true);
        }
    }

    public SpillableColumnarBatchImpl(TempSpillBufferId id, int rowCount, DataType[] sparkTypes, GpuMetric semWait) {
        this.id = id;
        this.rowCount = rowCount;
        this.sparkTypes = sparkTypes;
        this.semWait = semWait;
        Arm.$init$(this);
        this.closed = false;
    }
}

