/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.GpuCachedBatchSerializer;
import com.nvidia.spark.rapids.AvroProvider;
import com.nvidia.spark.rapids.ExplainPlanBase;
import com.nvidia.spark.rapids.HiveProvider;
import com.nvidia.spark.rapids.Optimizer;
import com.nvidia.spark.rapids.ShimVersion;
import com.nvidia.spark.rapids.SparkShimServiceProvider;
import com.nvidia.spark.rapids.SparkShims;
import com.nvidia.spark.rapids.iceberg.IcebergProvider;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.api.plugin.DriverPlugin;
import org.apache.spark.api.plugin.ExecutorPlugin;
import org.apache.spark.api.resource.ResourceDiscoveryPlugin;
import org.apache.spark.internal.Logging;
import org.apache.spark.package$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.ColumnarRule;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.util.MutableURLClassLoader;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Unit$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try$;

public final class ShimLoader$
implements Logging {
    public static ShimLoader$ MODULE$;
    private final URL shimRootURL;
    private final URL shimCommonURL;
    private volatile String shimProviderClass;
    private volatile SparkShimServiceProvider shimProvider;
    private volatile SparkShims sparkShims;
    private volatile URL shimURL;
    private volatile ClassLoader pluginClassLoader;
    private volatile boolean conventionalSingleShimJarDetected;
    private volatile MutableURLClassLoader tmpClassLoader;
    private final String SERVICE_LOADER_PREFIX;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ShimLoader$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private URL shimRootURL() {
        return this.shimRootURL;
    }

    private URL shimCommonURL() {
        return this.shimCommonURL;
    }

    private String shimProviderClass() {
        return this.shimProviderClass;
    }

    private void shimProviderClass_$eq(String x$1) {
        this.shimProviderClass = x$1;
    }

    private SparkShimServiceProvider shimProvider() {
        return this.shimProvider;
    }

    private void shimProvider_$eq(SparkShimServiceProvider x$1) {
        this.shimProvider = x$1;
    }

    private SparkShims sparkShims() {
        return this.sparkShims;
    }

    private void sparkShims_$eq(SparkShims x$1) {
        this.sparkShims = x$1;
    }

    private URL shimURL() {
        return this.shimURL;
    }

    private void shimURL_$eq(URL x$1) {
        this.shimURL = x$1;
    }

    private ClassLoader pluginClassLoader() {
        return this.pluginClassLoader;
    }

    private void pluginClassLoader_$eq(ClassLoader x$1) {
        this.pluginClassLoader = x$1;
    }

    private boolean conventionalSingleShimJarDetected() {
        return this.conventionalSingleShimJarDetected;
    }

    private void conventionalSingleShimJarDetected_$eq(boolean x$1) {
        this.conventionalSingleShimJarDetected = x$1;
    }

    private MutableURLClassLoader tmpClassLoader() {
        return this.tmpClassLoader;
    }

    private void tmpClassLoader_$eq(MutableURLClassLoader x$1) {
        this.tmpClassLoader = x$1;
    }

    private String shimId() {
        return this.shimIdFromPackageName(this.shimProviderClass());
    }

    private Seq<URL> urlsForSparkClassLoader() {
        return (Seq)new .colon.colon((Object)this.shimCommonURL(), (List)new .colon.colon((Object)this.shimURL(), (List)Nil$.MODULE$));
    }

    private void initShimProviderIfNeeded() {
        block0: {
            if (this.shimURL() != null) break block0;
            this.findShimProvider();
        }
    }

    public String getRapidsShuffleManagerClass() {
        this.initShimProviderIfNeeded();
        return new StringBuilder(45).append("com.nvidia.spark.rapids.").append(this.shimId()).append(".RapidsShuffleManager").toString();
    }

    public String getRapidsShuffleInternalClass() {
        this.initShimProviderIfNeeded();
        return new StringBuilder(63).append("org.apache.spark.sql.rapids.shims.").append(this.shimId()).append(".RapidsShuffleInternalManager").toString();
    }

    private Option<ClassLoader> serializerClassloader() {
        return Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Option option;
            SparkEnv sparkEnv = x0$1;
            if (!new StringOps(Predef$.MODULE$.augmentString(sparkEnv.conf().get("spark.rapids.force.caller.classloader", Boolean.toString(true)))).toBoolean()) {
                option = Option$.MODULE$.apply((Object)sparkEnv.serializer());
            } else if (MODULE$.conventionalSingleShimJarDetected()) {
                option = None$.MODULE$;
            } else {
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Forcing shim caller classloader update (default behavior). If it causes issues with userClassPathFirst, set spark.rapids.force.caller.classloader to false!");
                option = None$.MODULE$;
            }
            return option;
        }).flatMap((Function1 & Serializable & scala.Serializable)serializer -> {
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Looking for a mutable classloader (defaultClassLoader) in SparkEnv.serializer ").append(serializer).toString());
            ClassLoader serdeClassLoader = (ClassLoader)((Option)MethodUtils.invokeMethod(serializer, true, "defaultClassLoader")).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                void var1_1;
                ClassLoader threadContextClassLoader = Thread.currentThread().getContextClassLoader();
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("No defaultClassLoader found in ").append(serializer).append(", falling back ").append("on Thread context classloader: ").append(threadContextClassLoader).toString());
                return var1_1;
            });
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Extracted Spark classloader from SparkEnv.serializer ").append(serdeClassLoader).toString());
            return MODULE$.findURLClassLoader(serdeClassLoader);
        }).orElse((Function0 & Serializable & scala.Serializable)() -> {
            ClassLoader shimLoaderCallerCl;
            block0: {
                shimLoaderCallerCl = MODULE$.getClass().getClassLoader();
                if (MODULE$.conventionalSingleShimJarDetected()) break block0;
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Falling back on ShimLoader caller's classloader ").append(shimLoaderCallerCl).toString());
            }
            return Option$.MODULE$.apply((Object)shimLoaderCallerCl);
        });
    }

    private Option<ClassLoader> findURLClassLoader(ClassLoader classLoader) {
        None$ none$;
        while (true) {
            ClassLoader classLoader2;
            block9: {
                block8: {
                    ClassLoader classLoader3;
                    if ((classLoader2 = classLoader) == null) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "findURLClassLoader failed to locate a mutable classloader");
                        none$ = None$.MODULE$;
                        break;
                    }
                    if (classLoader2 instanceof URLClassLoader) {
                        URLClassLoader uRLClassLoader = (URLClassLoader)classLoader2;
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("findURLClassLoader found a URLClassLoader ").append(uRLClassLoader).toString());
                        none$ = Option$.MODULE$.apply((Object)uRLClassLoader);
                        break;
                    }
                    String string = classLoader2.getClass().getName();
                    String string2 = "org.apache.spark.repl.ExecutorClassLoader";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        ClassLoader parentLoader = (ClassLoader)MethodUtils.invokeMethod((Object)classLoader2, true, "parentLoader");
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("findURLClassLoader found ").append(classLoader2).append(", trying parentLoader=").append(parentLoader).toString());
                        classLoader = parentLoader;
                        continue;
                    }
                    if (classLoader2 != null && MethodUtils.getMatchingMethod((classLoader3 = classLoader2).getClass(), "addURL", URL.class) != null) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("findURLClassLoader found a urLAddable classloader ").append(classLoader3).toString());
                        none$ = Option$.MODULE$.apply((Object)classLoader3);
                        break;
                    }
                    if (classLoader2.getParent() == null) break block8;
                    ClassLoader classLoader4 = classLoader2.getParent();
                    ClassLoader classLoader5 = classLoader2;
                    if (classLoader4 != null ? !classLoader4.equals(classLoader5) : classLoader5 != null) break block9;
                }
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("findURLClassLoader hit the Boostrap classloader ").append(classLoader2).append(", ").append("failed to find a mutable classloader!").toString());
                none$ = None$.MODULE$;
                break;
            }
            ClassLoader parentClassLoader = classLoader2.getParent();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("findURLClassLoader found an immutable ").append(classLoader2).append(", trying parent=").append(parentClassLoader).toString());
            classLoader = parentClassLoader;
        }
        return none$;
    }

    private void updateSparkClassLoader() {
        this.serializerClassloader().foreach((Function1 & Serializable & scala.Serializable)urlAddable -> {
            ShimLoader$.$anonfun$updateSparkClassLoader$1(urlAddable);
            return BoxedUnit.UNIT;
        });
    }

    private ClassLoader getShimClassLoader() {
        ClassLoader classLoader;
        this.initShimProviderIfNeeded();
        if (this.pluginClassLoader() == null) {
            this.updateSparkClassLoader();
        }
        if (this.pluginClassLoader() == null) {
            if (this.tmpClassLoader() == null) {
                this.tmpClassLoader_$eq(new MutableURLClassLoader((URL[])((Object[])new URL[]{this.shimURL(), this.shimCommonURL()}), this.getClass().getClassLoader()));
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Found an unexpected context classloader ").append(Thread.currentThread().getContextClassLoader()).append(". We will try to recover from this, ").append("but it may cause class loading problems.").toString());
            }
            classLoader = this.tmpClassLoader();
        } else {
            classLoader = this.pluginClassLoader();
        }
        return classLoader;
    }

    private String SERVICE_LOADER_PREFIX() {
        return this.SERVICE_LOADER_PREFIX;
    }

    private String detectShimProvider() {
        String sparkVersion = this.getSparkVersion();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Loading shim for Spark version: ").append(sparkVersion).toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Complete Spark build info: ").append(MODULE$.sparkBuildInfo().mkString(", ")).toString());
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        Option shimServiceProviderOverrideClassName = Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.conf().getOption("spark.rapids.shims-provider-override"));
        shimServiceProviderOverrideClassName.foreach((Function1 & Serializable & scala.Serializable)shimProviderClass -> {
            ShimLoader$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Overriding Spark shims provider to ").append(shimProviderClass).append(". ").append("This may be an untested configuration!").toString());
            return BoxedUnit.UNIT;
        });
        String serviceProviderListPath = new StringBuilder(0).append(this.SERVICE_LOADER_PREFIX()).append(SparkShimServiceProvider.class.getName()).toString();
        Seq serviceProviderList = (Seq)shimServiceProviderOverrideClassName.map((Function1 & Serializable & scala.Serializable)clsName -> (Seq)new .colon.colon(clsName, (List)Nil$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(thisClassLoader.getResources(serviceProviderListPath)).asScala()).map((Function1 & Serializable & scala.Serializable)url -> Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec())).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getLines()).toSeq());
        Predef$.MODULE$.assert(serviceProviderList.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Classpath should contain the resource for ").append(serviceProviderListPath).toString());
        int numShimServiceProviders = serviceProviderList.size();
        Option shimServiceProviderOpt = ((IterableLike)serviceProviderList.flatMap((Function1 & Serializable & scala.Serializable)shimServiceProviderStr -> {
            Iterable iterable;
            String mask = MODULE$.shimIdFromPackageName((String)shimServiceProviderStr);
            try {
                URL shimURL = new URL(new StringBuilder(1).append(MODULE$.shimRootURL().toString()).append(mask).append("/").toString());
                MutableURLClassLoader shimClassLoader = new MutableURLClassLoader((URL[])((Object[])new URL[]{shimURL, MODULE$.shimCommonURL()}), thisClassLoader);
                Class shimClass = (Class)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    void var3_3;
                    block0: {
                        Class<?> ret = thisClassLoader.loadClass((String)shimServiceProviderStr);
                        if (numShimServiceProviders != 1) break block0;
                        MODULE$.conventionalSingleShimJarDetected_$eq(true);
                        MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Conventional shim jar layout for a single Spark verision detected");
                    }
                    return var3_3;
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> shimClassLoader.loadClass(shimServiceProviderStr));
                iterable = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)new Tuple2((Object)((SparkShimServiceProvider)MODULE$.instantiateClass(shimClass)), (Object)shimURL)));
            }
            catch (ClassNotFoundException cnf) {
                MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)cnf), ": Could not load the provider, likely a dev build"), cnf);
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ShimLoader$.$anonfun$detectShimProvider$16(shimServiceProviderOverrideClassName, sparkVersion, x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SparkShimServiceProvider inst = (SparkShimServiceProvider)tuple2._1();
            URL url = (URL)tuple2._2();
            MODULE$.shimURL_$eq(url);
            MODULE$.shimProvider_$eq(inst);
            String string = inst.getClass().getName();
            return string;
        });
        return (String)shimServiceProviderOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(37).append("Could not find Spark Shim Loader for ").append(sparkVersion).toString());
        });
    }

    private String shimIdFromPackageName(String shimServiceProviderStr) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(shimServiceProviderStr)).split('.'))).takeRight(2))).head();
    }

    private String findShimProvider() {
        block0: {
            if (this.shimProviderClass() != null) break block0;
            this.shimProviderClass_$eq(this.detectShimProvider());
        }
        return this.shimProviderClass();
    }

    public ShimVersion getShimVersion() {
        this.initShimProviderIfNeeded();
        return this.shimProvider().getShimVersion();
    }

    public String getSparkVersion() {
        return package$.MODULE$.SPARK_BUILD_USER().equals("Databricks") ? new StringBuilder(11).append(package$.MODULE$.SPARK_VERSION()).append("-databricks").toString() : package$.MODULE$.SPARK_VERSION();
    }

    private Seq<String> sparkBuildInfo() {
        return (Seq)new .colon.colon((Object)this.getSparkVersion(), (List)new .colon.colon((Object)package$.MODULE$.SPARK_REPO_URL(), (List)new .colon.colon((Object)package$.MODULE$.SPARK_BRANCH(), (List)new .colon.colon((Object)package$.MODULE$.SPARK_REVISION(), (List)new .colon.colon((Object)package$.MODULE$.SPARK_BUILD_DATE(), (List)Nil$.MODULE$)))));
    }

    public Class<?> loadClass(String className) {
        ClassLoader loader = this.getShimClassLoader();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Loading ").append(className).append(" using ").append(loader).append(" with the parent loader ").append(loader.getParent()).toString());
        return loader.loadClass(className);
    }

    private <T> T newInstanceOf(String className) {
        return (T)this.instantiateClass(this.loadClass(className));
    }

    public Optimizer newOptimizerClass(String className) {
        return (Optimizer)this.newInstanceOf(className);
    }

    private <T> T instantiateClass(Class<T> cls) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Instantiate ").append(cls.getName()).append(" using classloader ").append(cls.getClassLoader()).toString());
        ClassLoader classLoader = cls.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(5).append("urls ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uRLClassLoader.getURLs())).mkString("\n")).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Constructor<T> constructor = cls.getConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }

    public Object newInternalShuffleManager(SparkConf conf, boolean isDriver) {
        ClassLoader shuffleClassLoader = this.getShimClassLoader();
        String shuffleClassName = this.getRapidsShuffleInternalClass();
        Class<?> shuffleClass = shuffleClassLoader.loadClass(shuffleClassName);
        return shuffleClass.getConstructor(SparkConf.class, Boolean.TYPE).newInstance(conf, isDriver);
    }

    public DriverPlugin newDriverPlugin() {
        return (DriverPlugin)this.newInstanceOf("com.nvidia.spark.rapids.RapidsDriverPlugin");
    }

    public ExecutorPlugin newExecutorPlugin() {
        return (ExecutorPlugin)this.newInstanceOf("com.nvidia.spark.rapids.RapidsExecutorPlugin");
    }

    public ColumnarRule newColumnarOverrideRules() {
        return (ColumnarRule)this.newInstanceOf("com.nvidia.spark.rapids.ColumnarOverrideRules");
    }

    public Rule<SparkPlan> newGpuQueryStagePrepOverrides() {
        return (Rule)this.newInstanceOf("com.nvidia.spark.rapids.GpuQueryStagePrepOverrides");
    }

    public Rule<LogicalPlan> newUdfLogicalPlanRules() {
        return (Rule)this.newInstanceOf("com.nvidia.spark.udf.LogicalPlanRules");
    }

    public ResourceDiscoveryPlugin newInternalExclusiveModeGpuDiscoveryPlugin() {
        return (ResourceDiscoveryPlugin)this.newInstanceOf("com.nvidia.spark.rapids.InternalExclusiveModeGpuDiscoveryPlugin");
    }

    public GpuCachedBatchSerializer newParquetCachedBatchSerializer() {
        return (GpuCachedBatchSerializer)this.newInstanceOf("com.nvidia.spark.rapids.ParquetCachedBatchSerializer");
    }

    public Class<?> loadColumnarRDD() {
        return this.loadClass("org.apache.spark.sql.rapids.execution.InternalColumnarRddConverter");
    }

    public ExplainPlanBase newExplainPlan() {
        return (ExplainPlanBase)this.newInstanceOf("com.nvidia.spark.rapids.ExplainPlanImpl");
    }

    public HiveProvider newHiveProvider() {
        return (HiveProvider)this.newInstanceOf("org.apache.spark.sql.hive.rapids.HiveProviderImpl");
    }

    public AvroProvider newAvroProvider() {
        return (AvroProvider)this.newInstanceOf("org.apache.spark.sql.rapids.AvroProviderImpl");
    }

    public IcebergProvider newIcebergProvider() {
        return (IcebergProvider)this.newInstanceOf("com.nvidia.spark.rapids.iceberg.IcebergProviderImpl");
    }

    public static final /* synthetic */ void $anonfun$updateSparkClassLoader$2(ClassLoader urlAddable$1, URL url) {
        block4: {
            if (MODULE$.conventionalSingleShimJarDetected()) break block4;
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Updating spark classloader ").append(urlAddable$1).append(" with the URLs: ").append(MODULE$.urlsForSparkClassLoader().mkString(", ")).toString());
            Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MethodUtils.invokeMethod((Object)urlAddable$1, true, "addURL", url)).recoverWith((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Failure failure;
                    A1 A1 = x1;
                    if (A1 instanceof NoSuchMethodException) {
                        NoSuchMethodException noSuchMethodException = (NoSuchMethodException)A1;
                        ShimLoader$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "JDK8+ detected, consider setting spark.rapids.force.caller.classloader to false as a workaround");
                        ShimLoader$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("JDK8+ detected by catching ").append(noSuchMethodException).toString(), noSuchMethodException);
                        failure = new Success((Object)Unit$.MODULE$);
                    } else {
                        failure = new Failure(A1);
                    }
                    return (B1)failure;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable instanceof NoSuchMethodException ? true : true;
                    return bl;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(java.lang.NoSuchMethodException )}, serializedLambda);
                }
            }).get();
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Spark classLoader ").append(urlAddable$1).append(" updated successfully").toString());
            ClassLoader classLoader = urlAddable$1;
            if (classLoader instanceof URLClassLoader) {
                BoxedUnit boxedUnit;
                URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uRLClassLoader.getURLs())).contains((Object)MODULE$.shimCommonURL())) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(121).append("Didn't find expected URL ").append(MODULE$.shimCommonURL()).append(" in the spark ").append("classloader ").append(uRLClassLoader).append(" although addURL succeeded, maybe pushed up to the ").append("parent classloader ").append(uRLClassLoader.getParent()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$updateSparkClassLoader$1(ClassLoader urlAddable) {
        MODULE$.urlsForSparkClassLoader().foreach((Function1 & Serializable & scala.Serializable)url -> {
            ShimLoader$.$anonfun$updateSparkClassLoader$2(urlAddable, url);
            return BoxedUnit.UNIT;
        });
        MODULE$.pluginClassLoader_$eq(urlAddable);
    }

    public static final /* synthetic */ boolean $anonfun$detectShimProvider$16(Option shimServiceProviderOverrideClassName$1, String sparkVersion$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SparkShimServiceProvider shimServiceProvider = (SparkShimServiceProvider)tuple2._1();
        boolean bl = shimServiceProviderOverrideClassName$1.nonEmpty() || shimServiceProvider.matchesVersion(sparkVersion$1);
        return bl;
    }

    private ShimLoader$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("ShimLoader object instance: ").append(MODULE$).append(" loaded by ").append(MODULE$.getClass().getClassLoader()).toString());
        String thisClassFile = new StringBuilder(6).append(this.getClass().getName().replace(".", "/")).append(".class").toString();
        URL url = this.getClass().getClassLoader().getResource(thisClassFile);
        String urlStr = url.toString();
        String rootUrlStr = urlStr.substring(0, urlStr.length() - thisClassFile.length());
        this.shimRootURL = new URL(rootUrlStr);
        this.shimCommonURL = new URL(new StringBuilder(16).append(this.shimRootURL().toString()).append("spark3xx-common/").toString());
        this.SERVICE_LOADER_PREFIX = "META-INF/services/";
    }
}

