/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.NvtxColor;
import com.google.protobuf.CodedOutputStream;
import com.nvidia.spark.rapids.FilePartitionReaderBase;
import com.nvidia.spark.rapids.GpuBatchUtils$;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.GpuMetric$;
import com.nvidia.spark.rapids.HostMemoryOutputStream;
import com.nvidia.spark.rapids.NvtxWithMetrics;
import com.nvidia.spark.rapids.OrcCommonFunctions;
import com.nvidia.spark.rapids.OrcOutputStripe;
import com.nvidia.spark.rapids.OrcPartitionReaderContext;
import com.nvidia.spark.rapids.ScanWithMetrics;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.channels.WritableByteChannel;
import org.apache.orc.OrcProto;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.OutStream;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc!C\u0004\t!\u0003\r\t!EA$\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u0015\u0011\u0004\u0001\"\u00064\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u001d\t)\u0002\u0001C\t\u0003/Aq!!\f\u0001\t\u0013\ty\u0003C\u0004\u00026\u0001!I!a\u000e\u0003-=\u00138\rU1si&$\u0018n\u001c8SK\u0006$WM\u001d\"bg\u0016T!!\u0003\u0006\u0002\rI\f\u0007/\u001b3t\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051aN^5eS\u0006T\u0011aD\u0001\u0004G>l7\u0001A\n\u0007\u0001IABd\n\u0016\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\tI\"$D\u0001\t\u0013\tY\u0002B\u0001\nPe\u000e\u001cu.\\7p]\u001a+hn\u0019;j_:\u001c\bCA\u000f&\u001b\u0005q\"BA\u0010!\u0003!Ig\u000e^3s]\u0006d'BA\u0006\"\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\n\u0005\u0019r\"a\u0002'pO\u001eLgn\u001a\t\u00033!J!!\u000b\u0005\u0003\u0007\u0005\u0013X\u000e\u0005\u0002\u001aW%\u0011A\u0006\u0003\u0002\u0010'\u000e\fgnV5uQ6+GO]5dg\u00061A%\u001b8ji\u0012\"\u0012a\f\t\u0003'AJ!!\r\u000b\u0003\tUs\u0017\u000e^\u0001\u000eI\u0016\u001cw\u000eZ3U_\n\u000bGo\u00195\u0015\u000fQz$jT,aKB\u00191#N\u001c\n\u0005Y\"\"AB(qi&|g\u000e\u0005\u00029{5\t\u0011H\u0003\u0002;w\u0005Qa/Z2u_JL'0\u001a3\u000b\u0005q\u0002\u0013aA:rY&\u0011a(\u000f\u0002\u000e\u0007>dW/\u001c8be\n\u000bGo\u00195\t\u000b\u0001\u0013\u0001\u0019A!\u0002\u000f!|7\u000f\u001e\"vMB\u0011!\tS\u0007\u0002\u0007*\u0011A)R\u0001\u0005GV$gM\u0003\u0002\n\r*\tq)\u0001\u0002bS&\u0011\u0011j\u0011\u0002\u0011\u0011>\u001cH/T3n_JL()\u001e4gKJDQa\u0013\u0002A\u00021\u000bqAY;g'&TX\r\u0005\u0002\u0014\u001b&\u0011a\n\u0006\u0002\u0005\u0019>tw\rC\u0003Q\u0005\u0001\u0007\u0011+A\u0007nK64\u0015\u000e\\3TG\",W.\u0019\t\u0003%Vk\u0011a\u0015\u0006\u0003)\u0006\n1a\u001c:d\u0013\t16KA\bUsB,G)Z:de&\u0004H/[8o\u0011\u0015A&\u00011\u0001Z\u0003A\u0011X-];fgR,G-T1qa&tw\rE\u0002\u0014ki\u00032aE.^\u0013\taFCA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0014=&\u0011q\f\u0006\u0002\u0004\u0013:$\b\"B1\u0003\u0001\u0004\u0011\u0017aD5t\u0007\u0006\u001cXmU3og&$\u0018N^3\u0011\u0005M\u0019\u0017B\u00013\u0015\u0005\u001d\u0011un\u001c7fC:DQA\u001a\u0002A\u0002\u001d\faa\u001d9mSR\u001c\bcA\n\\QB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002nw\u0005IQ\r_3dkRLwN\\\u0005\u0003_*\u0014q\u0002U1si&$\u0018n\u001c8fI\u001aKG.Z\u0001\u001aa>\u0004X\u000f\\1uK\u000e+(O]3oi\ncwnY6DQVt7\u000eF\u0004s\u0003\u0007\ti!!\u0005\u0011\u0007M\\hP\u0004\u0002us:\u0011Q\u000f_\u0007\u0002m*\u0011q\u000fE\u0001\u0007yI|w\u000e\u001e \n\u0003UI!A\u001f\u000b\u0002\u000fA\f7m[1hK&\u0011A0 \u0002\u0004'\u0016\f(B\u0001>\u0015!\tIr0C\u0002\u0002\u0002!\u0011qb\u0014:d\u001fV$\b/\u001e;TiJL\u0007/\u001a\u0005\b\u0003\u000b\u0019\u0001\u0019AA\u0004\u00035\u0011Gn\\2l\u0013R,'/\u0019;peB!1/!\u0003\u007f\u0013\r\tY! \u0002\u0011\u0005V4g-\u001a:fI&#XM]1u_JDa!a\u0004\u0004\u0001\u0004i\u0016\u0001F7bqJ+\u0017\r\u001a\"bi\u000eD7+\u001b>f%><8\u000f\u0003\u0004\u0002\u0014\r\u0001\r\u0001T\u0001\u0016[\u0006D(+Z1e\u0005\u0006$8\r[*ju\u0016\u0014\u0015\u0010^3t\u00031\u0011X-\u00193QCJ$h)\u001b7f)\u0019\tI\"a\b\u0002*A)1#a\u0007B\u0019&\u0019\u0011Q\u0004\u000b\u0003\rQ+\b\u000f\\33\u0011\u001d\t\t\u0003\u0002a\u0001\u0003G\t1a\u0019;y!\rI\u0012QE\u0005\u0004\u0003OA!!G(sGB\u000b'\u000f^5uS>t'+Z1eKJ\u001cuN\u001c;fqRDa!a\u000b\u0005\u0001\u0004\u0011\u0018aB:ue&\u0004Xm]\u0001\u0013KN$\u0018.\\1uK>+H\u000f];u'&TX\rF\u0003M\u0003c\t\u0019\u0004C\u0004\u0002\"\u0015\u0001\r!a\t\t\r\u0005-R\u00011\u0001s\u0003I9(/\u001b;f\u001fJ\u001cw*\u001e;qkR4\u0015\u000e\\3\u0015\u000f=\nI$a\u000f\u0002F!9\u0011\u0011\u0005\u0004A\u0002\u0005\r\u0002bBA\u001f\r\u0001\u0007\u0011qH\u0001\u0007e\u0006<x*\u001e;\u0011\u0007e\t\t%C\u0002\u0002D!\u0011a\u0003S8ti6+Wn\u001c:z\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\u0007\u0003W1\u0001\u0019\u0001:\u0013\r\u0005%\u0013QJA(\r\u0019\tY\u0005\u0001\u0001\u0002H\taAH]3gS:,W.\u001a8u}A\u0011\u0011\u0004\u0001\t\u00043\u0005E\u0013bAA*\u0011\t9b)\u001b7f!\u0006\u0014H/\u001b;j_:\u0014V-\u00193fe\n\u000b7/\u001a")
public interface OrcPartitionReaderBase
extends OrcCommonFunctions,
Logging,
ScanWithMetrics {
    public static /* synthetic */ Option decodeToBatch$(OrcPartitionReaderBase $this, HostMemoryBuffer hostBuf, long bufSize, TypeDescription memFileSchema, Option requestedMapping, boolean isCaseSensitive, PartitionedFile[] splits) {
        return $this.decodeToBatch(hostBuf, bufSize, memFileSchema, (Option<int[]>)requestedMapping, isCaseSensitive, splits);
    }

    default public Option<ColumnarBatch> decodeToBatch(HostMemoryBuffer hostBuf, long bufSize, TypeDescription memFileSchema, Option<int[]> requestedMapping, boolean isCaseSensitive, PartitionedFile[] splits) {
        return (Option)this.withResource(hostBuf, (Function1 & Serializable & scala.Serializable)x$7 -> bufSize == 0L ? None$.MODULE$ : (Option)this.withResource(this.decodeToTable(hostBuf, bufSize, memFileSchema, requestedMapping, isCaseSensitive, splits), (Function1 & Serializable & scala.Serializable)t -> {
            long batchSizeBytes = GpuColumnVector.getTotalDeviceMemoryUsed(t);
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("GPU batch size: ").append(batchSizeBytes).append(" bytes").toString());
            ((FilePartitionReaderBase)((Object)this)).maxDeviceMemory_$eq(package$.MODULE$.max(batchSizeBytes, ((FilePartitionReaderBase)((Object)this)).maxDeviceMemory()));
            ((GpuMetric)this.metrics().apply((Object)GpuMetric$.MODULE$.NUM_OUTPUT_BATCHES())).$plus$eq(1L);
            return new Some((Object)GpuColumnVector.from(t, GpuColumnVector.extractTypes(this.readDataSchema())));
        }));
    }

    public static /* synthetic */ Seq populateCurrentBlockChunk$(OrcPartitionReaderBase $this, BufferedIterator blockIterator, int maxReadBatchSizeRows, long maxReadBatchSizeBytes) {
        return $this.populateCurrentBlockChunk((BufferedIterator<OrcOutputStripe>)blockIterator, maxReadBatchSizeRows, maxReadBatchSizeBytes);
    }

    default public Seq<OrcOutputStripe> populateCurrentBlockChunk(BufferedIterator<OrcOutputStripe> blockIterator, int maxReadBatchSizeRows, long maxReadBatchSizeBytes) {
        ArrayBuffer currentChunk = new ArrayBuffer();
        LongRef numRows = LongRef.create((long)0L);
        LongRef numBytes = LongRef.create((long)0L);
        LongRef numOrcBytes = LongRef.create((long)0L);
        this.readNextBatch$1(blockIterator, numRows, maxReadBatchSizeRows, numBytes, maxReadBatchSizeBytes, currentChunk, numOrcBytes);
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Loaded ").append(numRows$1.elem).append(" rows from Orc. Orc bytes read: ").append(numOrcBytes$1.elem).append(". ").append("Estimated GPU bytes: ").append(numBytes$1.elem).toString());
        return currentChunk;
    }

    public static /* synthetic */ Tuple2 readPartFile$(OrcPartitionReaderBase $this, OrcPartitionReaderContext ctx, Seq stripes) {
        return $this.readPartFile(ctx, (Seq<OrcOutputStripe>)stripes);
    }

    default public Tuple2<HostMemoryBuffer, Object> readPartFile(OrcPartitionReaderContext ctx, Seq<OrcOutputStripe> stripes) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            tuple2 = (Tuple2)this.withResource(new NvtxWithMetrics("Buffer file split", NvtxColor.YELLOW, (Seq<GpuMetric>)Predef$.MODULE$.wrapRefArray((Object[])new GpuMetric[]{(GpuMetric)this.metrics().apply((Object)"bufferTime")})), (Function1 & Serializable & scala.Serializable)x$8 -> {
                if (stripes.isEmpty()) {
                    throw new NonLocalReturnControl(object, (Object)new Tuple2(null, (Object)BoxesRunTime.boxToLong((long)0L)));
                }
                long hostBufferSize = this.estimateOutputSize(ctx, stripes);
                return (Tuple2)this.closeOnExcept(HostMemoryBuffer.allocate((long)hostBufferSize), (Function1 & Serializable & scala.Serializable)hmb -> (Tuple2)this.withResource(new HostMemoryOutputStream((HostMemoryBuffer)hmb), (Function1 & Serializable & scala.Serializable)out -> {
                    this.writeOrcOutputFile(ctx, (HostMemoryOutputStream)out, stripes);
                    return new Tuple2(hmb, (Object)BoxesRunTime.boxToLong((long)out.getPos()));
                }));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    private long estimateOutputSize(OrcPartitionReaderContext ctx, Seq<OrcOutputStripe> stripes) {
        LongRef size = LongRef.create((long)"ORC".length());
        stripes.foreach((Function1 & Serializable & scala.Serializable)stripe -> {
            OrcPartitionReaderBase.$anonfun$estimateOutputSize$1(size, stripe);
            return BoxedUnit.UNIT;
        });
        size.elem += ctx.fileTail().getPostscript().getFooterLength();
        size.elem += ctx.fileTail().getPostscriptLength();
        ++size.elem;
        return size.elem + 131072L;
    }

    private void writeOrcOutputFile(OrcPartitionReaderContext ctx, HostMemoryOutputStream rawOut, Seq<OrcOutputStripe> stripes) {
        DataOutputStream dataOut = new DataOutputStream(rawOut);
        dataOut.writeBytes("ORC");
        dataOut.flush();
        this.withCodecOutputStream(ctx, rawOut, (Function3 & Serializable & scala.Serializable)(outChannel, protoWriter, codecStream) -> {
            OrcPartitionReaderBase.$anonfun$writeOrcOutputFile$1(this, stripes, rawOut, ctx, outChannel, protoWriter, codecStream);
            return BoxedUnit.UNIT;
        });
    }

    private void readNextBatch$1(BufferedIterator blockIterator$1, LongRef numRows$1, int maxReadBatchSizeRows$1, LongRef numBytes$1, long maxReadBatchSizeBytes$1, ArrayBuffer currentChunk$1, LongRef numOrcBytes$1) {
        block5: {
            BoxedUnit boxedUnit;
            while (blockIterator$1.hasNext()) {
                OrcOutputStripe peekedStripe = (OrcOutputStripe)blockIterator$1.head();
                if (peekedStripe.infoBuilder().getNumberOfRows() > Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Too many rows in split");
                }
                if (numRows$1.elem == 0L || numRows$1.elem + peekedStripe.infoBuilder().getNumberOfRows() <= (long)maxReadBatchSizeRows$1) {
                    long estimatedBytes = GpuBatchUtils$.MODULE$.estimateGpuMemory(this_.readDataSchema(), peekedStripe.infoBuilder().getNumberOfRows());
                    if (numBytes$1.elem == 0L || numBytes$1.elem + estimatedBytes <= maxReadBatchSizeBytes$1) {
                        currentChunk$1.$plus$eq(blockIterator$1.next());
                        numRows$1.elem += ((OrcOutputStripe)currentChunk$1.last()).infoBuilder().getNumberOfRows();
                        numOrcBytes$1.elem += ((OrcOutputStripe)currentChunk$1.last()).infoBuilder().getDataLength();
                        numBytes$1.elem += estimatedBytes;
                        Logging this_ = (FilePartitionReaderBase)this_;
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                break block5;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static /* synthetic */ void $anonfun$estimateOutputSize$1(LongRef size$1, OrcOutputStripe stripe) {
        size$1.elem += stripe.infoBuilder().getIndexLength() + stripe.infoBuilder().getDataLength();
        size$1.elem += (long)stripe.footer().getSerializedSize();
    }

    public static /* synthetic */ void $anonfun$writeOrcOutputFile$2(OrcPartitionReaderBase $this, HostMemoryOutputStream rawOut$1, OrcPartitionReaderContext ctx$2, WritableByteChannel outChannel$1, CodedOutputStream protoWriter$1, OutStream codecStream$1, OrcProto.Footer.Builder fileFooterBuilder$1, LongRef numRows$2, OrcOutputStripe stripe) {
        stripe.infoBuilder().setOffset(rawOut$1.getPos());
        $this.copyStripeData(ctx$2, outChannel$1, stripe.inputDataRanges());
        long stripeFooterStartOffset = rawOut$1.getPos();
        stripe.footer().writeTo(protoWriter$1);
        protoWriter$1.flush();
        codecStream$1.flush();
        stripe.infoBuilder().setFooterLength(rawOut$1.getPos() - stripeFooterStartOffset);
        fileFooterBuilder$1.addStripes(stripe.infoBuilder().build());
        numRows$2.elem += stripe.infoBuilder().getNumberOfRows();
    }

    public static /* synthetic */ void $anonfun$writeOrcOutputFile$1(OrcPartitionReaderBase $this, Seq stripes$2, HostMemoryOutputStream rawOut$1, OrcPartitionReaderContext ctx$2, WritableByteChannel outChannel, CodedOutputStream protoWriter, OutStream codecStream) {
        LongRef numRows = LongRef.create((long)0L);
        OrcProto.Footer.Builder fileFooterBuilder = OrcProto.Footer.newBuilder();
        stripes$2.foreach((Function1 & Serializable & scala.Serializable)stripe -> {
            OrcPartitionReaderBase.$anonfun$writeOrcOutputFile$2($this, rawOut$1, ctx$2, outChannel, protoWriter, codecStream, fileFooterBuilder, numRows, stripe);
            return BoxedUnit.UNIT;
        });
        $this.writeOrcFileFooter(ctx$2, fileFooterBuilder, rawOut$1, rawOut$1.getPos(), numRows.elem, protoWriter, codecStream);
    }

    public static void $init$(OrcPartitionReaderBase $this) {
    }
}

