/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.DType;
import ai.rapids.cudf.HostMemoryBuffer;
import com.nvidia.spark.rapids.CoalesceSizeGoal;
import com.nvidia.spark.rapids.CudfUnsafeRow;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuMetric;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.collection.Iterator;

public abstract class InternalRowToColumnarBatchIterator
implements Iterator<ColumnarBatch> {
    protected final Iterator<InternalRow> input;
    protected UnsafeRow pending = null;
    protected final int numRowsEstimate;
    protected final long dataLength;
    protected final DType[] rapidsTypes;
    protected final DataType[] outputTypes;
    protected final GpuMetric semaphoreWaitTime;
    protected final GpuMetric streamTime;
    protected final GpuMetric opTime;
    protected final GpuMetric numInputRows;
    protected final GpuMetric numOutputRows;
    protected final GpuMetric numOutputBatches;

    protected InternalRowToColumnarBatchIterator(Iterator<InternalRow> input, Attribute[] schema, CoalesceSizeGoal goal, GpuMetric semaphoreWaitTime, GpuMetric streamTime, GpuMetric opTime, GpuMetric numInputRows, GpuMetric numOutputRows, GpuMetric numOutputBatches) {
        this.input = input;
        int sizePerRowEstimate = CudfUnsafeRow.getRowSizeEstimate(schema);
        this.numRowsEstimate = (int)Math.max(1L, Math.min(0x7FFFFFFEL, goal.targetSizeBytes() / (long)sizePerRowEstimate));
        this.dataLength = (long)sizePerRowEstimate * (long)this.numRowsEstimate;
        this.rapidsTypes = new DType[schema.length];
        this.outputTypes = new DataType[schema.length];
        for (int i = 0; i < schema.length; ++i) {
            this.rapidsTypes[i] = GpuColumnVector.getNonNestedRapidsType(schema[i].dataType());
            this.outputTypes[i] = schema[i].dataType();
        }
        this.semaphoreWaitTime = semaphoreWaitTime;
        this.streamTime = streamTime;
        this.opTime = opTime;
        this.numInputRows = numInputRows;
        this.numOutputRows = numOutputRows;
        this.numOutputBatches = numOutputBatches;
    }

    public boolean hasNext() {
        boolean ret = true;
        if (this.pending == null) {
            long start = System.nanoTime();
            ret = this.input.hasNext();
            long ct = System.nanoTime() - start;
            this.streamTime.add(ct);
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    public ColumnarBatch next() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public abstract int[] fillBatch(HostMemoryBuffer var1, HostMemoryBuffer var2);
}

