/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.CompressionMetadataWriterOptions;
import ai.rapids.cudf.CompressionType;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.HostBufferConsumer;
import ai.rapids.cudf.ParquetWriterOptions;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.Table;
import ai.rapids.cudf.TableWriter;
import com.nvidia.spark.RebaseHelper$;
import com.nvidia.spark.rapids.ColumnarOutputWriter;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.SchemaUtils$;
import java.io.Serializable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.rapids.ColumnarWriteTaskStatsTracker;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001\u0002\t\u0012\u0001iA\u0001b\b\u0001\u0003\u0006\u0004%\t\u0005\t\u0005\t]\u0001\u0011\t\u0011)A\u0005C!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u00115\u0003!\u0011!Q\u0001\n9C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\u0006/\u0002!\t\u0001\u0017\u0005\bC\u0002\u0011\r\u0011\"\u0001c\u0011\u0019Q\u0007\u0001)A\u0005G\")1\u000e\u0001C!Y\")Q\u000f\u0001C!m\"I\u0011q\u0004\u0001C\u0002\u0013\u0005\u0013\u0011\u0005\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002$\t\u0001r\t];QCJ\fX/\u001a;Xe&$XM\u001d\u0006\u0003%M\taA]1qS\u0012\u001c(B\u0001\u000b\u0016\u0003\u0015\u0019\b/\u0019:l\u0015\t1r#\u0001\u0004om&$\u0017.\u0019\u0006\u00021\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\u0007\t\u00039ui\u0011!E\u0005\u0003=E\u0011AcQ8mk6t\u0017M](viB,Ho\u0016:ji\u0016\u0014\u0018\u0001\u00029bi\",\u0012!\t\t\u0003E-r!aI\u0015\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019J\u0012A\u0002\u001fs_>$hHC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQs%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y5\u0012aa\u0015;sS:<'B\u0001\u0016(\u0003\u0015\u0001\u0018\r\u001e5!\u0003)!\u0017\r^1TG\",W.\u0019\t\u0003cmj\u0011A\r\u0006\u0003gQ\nQ\u0001^=qKNT!!\u000e\u001c\u0002\u0007M\fHN\u0003\u0002\u0015o)\u0011\u0001(O\u0001\u0007CB\f7\r[3\u000b\u0003i\n1a\u001c:h\u0013\ta$G\u0001\u0006TiJ,8\r\u001e+za\u0016\fqbY8naJ,7o]5p]RK\b/\u001a\t\u0003\u007f\u0015k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bAaY;eM*\u0011!c\u0011\u0006\u0002\t\u0006\u0011\u0011-[\u0005\u0003\r\u0002\u0013qbQ8naJ,7o]5p]RK\b/Z\u0001\u0014I\u0006$XMU3cCN,W\t_2faRLwN\u001c\t\u0003\u0013*k\u0011aJ\u0005\u0003\u0017\u001e\u0012qAQ8pY\u0016\fg.\u0001\ruS6,7\u000f^1naJ+'-Y:f\u000bb\u001cW\r\u001d;j_:\fqaY8oi\u0016DH\u000f\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u0006IQ.\u00199sK\u0012,8-\u001a\u0006\u0003'^\na\u0001[1e_>\u0004\u0018BA+Q\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\u0002+A\f'/];fi\u001aKW\r\u001c3JI\u0016s\u0017M\u00197fI\u00061A(\u001b8jiz\"\u0002\"\u0017.\\9vsv\f\u0019\t\u00039\u0001AQaH\u0005A\u0002\u0005BQaL\u0005A\u0002ABQ!P\u0005A\u0002yBQaR\u0005A\u0002!CQ\u0001T\u0005A\u0002!CQ!T\u0005A\u00029CQAV\u0005A\u0002!\u000b1c\\;uaV$H+[7fgR\fW\u000e\u001d+za\u0016,\u0012a\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\fA\u0001\\1oO*\t\u0001.\u0001\u0003kCZ\f\u0017B\u0001\u0017f\u0003QyW\u000f\u001e9viRKW.Z:uC6\u0004H+\u001f9fA\u0005!2oY1o)\u0006\u0014G.\u001a\"fM>\u0014Xm\u0016:ji\u0016$\"!\u001c9\u0011\u0005%s\u0017BA8(\u0005\u0011)f.\u001b;\t\u000bEd\u0001\u0019\u0001:\u0002\u000bQ\f'\r\\3\u0011\u0005}\u001a\u0018B\u0001;A\u0005\u0015!\u0016M\u00197f\u0003\u00159(/\u001b;f)\riwo \u0005\u0006q6\u0001\r!_\u0001\u0006E\u0006$8\r\u001b\t\u0003uvl\u0011a\u001f\u0006\u0003yR\n!B^3di>\u0014\u0018N_3e\u0013\tq8PA\u0007D_2,XN\\1s\u0005\u0006$8\r\u001b\u0005\b\u0003\u0003i\u0001\u0019AA\u0002\u00035\u0019H/\u0019;t)J\f7m[3sgB1\u0011QAA\b\u0003+qA!a\u0002\u0002\f9\u0019A%!\u0003\n\u0003!J1!!\u0004(\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0005\u0002\u0014\t\u00191+Z9\u000b\u0007\u00055q\u0005\u0005\u0003\u0002\u0018\u0005mQBAA\r\u0015\t\u0011B'\u0003\u0003\u0002\u001e\u0005e!!H\"pYVlg.\u0019:Xe&$X\rV1tWN#\u0018\r^:Ue\u0006\u001c7.\u001a:\u0002\u0017Q\f'\r\\3Xe&$XM]\u000b\u0003\u0003G\u00012aPA\u0013\u0013\r\t9\u0003\u0011\u0002\f)\u0006\u0014G.Z,sSR,'/\u0001\u0007uC\ndWm\u0016:ji\u0016\u0014\b\u0005")
public class GpuParquetWriter
extends ColumnarOutputWriter {
    private final String path;
    private final boolean dateRebaseException;
    private final boolean timestampRebaseException;
    private final String outputTimestampType;
    private final TableWriter tableWriter;

    @Override
    public String path() {
        return this.path;
    }

    public String outputTimestampType() {
        return this.outputTimestampType;
    }

    @Override
    public void scanTableBeforeWrite(Table table) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), table.getNumberOfColumns()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ai.rapids.cudf.ColumnVector col = table.getColumn(i);
            if ($this.dateRebaseException && RebaseHelper$.MODULE$.isDateRebaseNeededInWrite(col)) {
                throw DataSourceUtils$.MODULE$.newRebaseExceptionInWrite("Parquet");
            }
            if ($this.timestampRebaseException && RebaseHelper$.MODULE$.isTimeRebaseNeededInWrite(col)) {
                throw DataSourceUtils$.MODULE$.newRebaseExceptionInWrite("Parquet");
            }
        });
    }

    @Override
    public void write(ColumnarBatch batch, Seq<ColumnarWriteTaskStatsTracker> statsTrackers) {
        String string = this.outputTimestampType();
        String string2 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS().toString();
        boolean outputMillis = !(string != null ? !string.equals(string2) : string2 != null);
        ColumnarBatch newBatch = new ColumnarBatch((ColumnVector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])GpuColumnVector.extractColumns(batch))).map((Function1 & Serializable & scala.Serializable)cv -> {
            boolean bl = false;
            DataType dataType = null;
            DataType dataType2 = cv.dataType();
            DataType dataType3 = DataTypes.TimestampType;
            DataType dataType4 = dataType2;
            if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
                bl = true;
                dataType = dataType2;
                if (outputMillis) {
                    return new GpuColumnVector(DataTypes.TimestampType, (ai.rapids.cudf.ColumnVector)this.withResource(cv.getBase(), (Function1 & Serializable & scala.Serializable)v -> v.castTo(DType.TIMESTAMP_MILLISECONDS)));
                }
            }
            if (bl) {
                String string = this.outputTimestampType();
                String string2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96().toString();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.withResource(Scalar.fromLong((long)9223372036854775L), (Function1 & Serializable & scala.Serializable)upper -> {
                        this.withResource(Scalar.fromLong((long)-9223372036854775L), (Function1 & Serializable & scala.Serializable)lower -> {
                            $this.withResource(cv$1.getBase().bitCastTo(DType.INT64), (Function1 & Serializable & scala.Serializable)int64 -> {
                                $this.withResource(int64.greaterOrEqualTo((BinaryOperable)upper$1), (Function1 & Serializable & scala.Serializable)a -> {
                                    $this.withResource(int64.lessOrEqualTo((BinaryOperable)lower$1), (Function1 & Serializable & scala.Serializable)b -> {
                                        $this.withResource(a.or((BinaryOperable)b), (Function1 & Serializable & scala.Serializable)aOrB -> {
                                            $this.withResource(aOrB.any(), (Function1 & Serializable & scala.Serializable)any -> {
                                                GpuParquetWriter.$anonfun$write$9(batch$1, any);
                                                return BoxedUnit.UNIT;
                                            });
                                            return BoxedUnit.UNIT;
                                        });
                                        return BoxedUnit.UNIT;
                                    });
                                    return BoxedUnit.UNIT;
                                });
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                        return BoxedUnit.UNIT;
                    });
                    return cv;
                }
            }
            if (!(dataType2 instanceof DecimalType)) return cv;
            DecimalType decimalType = (DecimalType)dataType2;
            if (decimalType.precision() > Decimal$.MODULE$.MAX_INT_DIGITS()) return cv;
            return new GpuColumnVector((DataType)decimalType, (ai.rapids.cudf.ColumnVector)this.withResource(cv.getBase(), (Function1 & Serializable & scala.Serializable)v -> v.castTo(DType.create((DType.DTypeEnum)DType.DTypeEnum.DECIMAL32, (int)(-decimalType.scale())))));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnVector.class))));
        super.write(newBatch, statsTrackers);
    }

    @Override
    public TableWriter tableWriter() {
        return this.tableWriter;
    }

    public static final /* synthetic */ void $anonfun$write$9(ColumnarBatch batch$1, Scalar any) {
        if (any.isValid() && any.getBoolean()) {
            batch$1.close();
            throw new IllegalArgumentException("INT96 column contains one or more values that can overflow and will result in data corruption. Please set `spark.rapids.sql.format.parquet.writer.int96.enabled` to false so we can fallback on CPU for writing parquet but still take advantage of parquet read on the GPU.");
        }
    }

    public GpuParquetWriter(String path, StructType dataSchema, CompressionType compressionType, boolean dateRebaseException, boolean timestampRebaseException, TaskAttemptContext context, boolean parquetFieldIdEnabled) {
        this.path = path;
        this.dateRebaseException = dateRebaseException;
        this.timestampRebaseException = timestampRebaseException;
        super(context, dataSchema, "Parquet");
        this.outputTimestampType = this.conf().get(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key());
        WriteSupport.WriteContext writeContext = new ParquetWriteSupport().init(this.conf());
        Enumeration.Value value = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
        Enumeration.Value value2 = SQLConf$.MODULE$.get().parquetOutputTimestampType();
        ParquetWriterOptions.Builder builder = (ParquetWriterOptions.Builder)((CompressionMetadataWriterOptions.Builder)SchemaUtils$.MODULE$.writerOptionsFromSchema(ParquetWriterOptions.builder(), dataSchema, !(value != null ? !value.equals(value2) : value2 != null), parquetFieldIdEnabled)).withMetadata(writeContext.getExtraMetaData()).withCompressionType(compressionType);
        this.tableWriter = Table.writeParquetChunked((ParquetWriterOptions)builder.build(), (HostBufferConsumer)this);
    }
}

