/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.CompressionType;
import com.nvidia.spark.rapids.ColumnarFileFormat;
import com.nvidia.spark.rapids.ColumnarOutputWriter;
import com.nvidia.spark.rapids.ColumnarOutputWriterFactory;
import com.nvidia.spark.rapids.GpuParquetFileFormat$;
import com.nvidia.spark.rapids.GpuParquetWriter;
import com.nvidia.spark.rapids.RapidsMeta;
import com.nvidia.spark.rapids.shims.ParquetFieldIdShims$;
import com.nvidia.spark.rapids.shims.ParquetTimestampNTZShims$;
import com.nvidia.spark.rapids.shims.SparkShimImpl$;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.rapids.execution.TrampolineUtil$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]s!B\u0005\u000b\u0011\u0003\u0019b!B\u000b\u000b\u0011\u00031\u0002\"B\u000f\u0002\t\u0003q\u0002\"B\u0010\u0002\t\u0003\u0001\u0003BB@\u0002\t\u0003\t\t\u0001C\u0004\u0002\u001c\u0005!\t!!\b\u0007\tUQ\u0001!\n\u0005\u0006;\u0019!\t\u0001\u000e\u0005\u0006k\u0019!\tEN\u0001\u0015\u000fB,\b+\u0019:rk\u0016$h)\u001b7f\r>\u0014X.\u0019;\u000b\u0005-a\u0011A\u0002:ba&$7O\u0003\u0002\u000e\u001d\u0005)1\u000f]1sW*\u0011q\u0002E\u0001\u0007]ZLG-[1\u000b\u0003E\t1aY8n\u0007\u0001\u0001\"\u0001F\u0001\u000e\u0003)\u0011Ac\u00129v!\u0006\u0014\u0018/^3u\r&dWMR8s[\u0006$8CA\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aE\u0001\u000ei\u0006<w\t];TkB\u0004xN\u001d;\u0015\u000b\u0005\"7\u0010`?\u0011\u0007a\u0011C%\u0003\u0002$3\t1q\n\u001d;j_:\u0004\"\u0001\u0006\u0004\u0014\t\u00199b%\u000b\t\u0003)\u001dJ!\u0001\u000b\u0006\u0003%\r{G.^7oCJ4\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003UIj\u0011a\u000b\u0006\u0003Y5\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001b9R!a\f\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0014aA8sO&\u00111g\u000b\u0002\b\u0019><w-\u001b8h)\u0005!\u0013\u0001\u00049sKB\f'/Z,sSR,G#B\u001c;\u00052c\u0006C\u0001\u000b9\u0013\tI$BA\u000eD_2,XN\\1s\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\u0006w!\u0001\r\u0001P\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f5\n1a]9m\u0013\t\teH\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003D\u0011\u0001\u0007A)A\u0002k_\n\u0004\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\u00135\f\u0007O]3ek\u000e,'BA%/\u0003\u0019A\u0017\rZ8pa&\u00111J\u0012\u0002\u0004\u0015>\u0014\u0007\"B'\t\u0001\u0004q\u0015aB8qi&|gn\u001d\t\u0005\u001fZK\u0016L\u0004\u0002Q)B\u0011\u0011+G\u0007\u0002%*\u00111KE\u0001\u0007yI|w\u000e\u001e \n\u0005UK\u0012A\u0002)sK\u0012,g-\u0003\u0002X1\n\u0019Q*\u00199\u000b\u0005UK\u0002CA([\u0013\tY\u0006L\u0001\u0004TiJLgn\u001a\u0005\u0006;\"\u0001\rAX\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007CA0c\u001b\u0005\u0001'BA1?\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0007M\u0001\u0006TiJ,8\r\u001e+za\u0016DQ!Z\u0002A\u0002\u0019\fA!\\3uCB\"q\r\u001c<z!\u0015!\u0002N[;y\u0013\tI'B\u0001\u0006SCBLGm]'fi\u0006\u0004\"a\u001b7\r\u0001\u0011IQ\u000eZA\u0001\u0002\u0003\u0015\tA\u001c\u0002\u0004?\u0012\n\u0014CA8s!\tA\u0002/\u0003\u0002r3\t9aj\u001c;iS:<\u0007C\u0001\rt\u0013\t!\u0018DA\u0002B]f\u0004\"a\u001b<\u0005\u0013]$\u0017\u0011!A\u0001\u0006\u0003q'aA0%eA\u00111.\u001f\u0003\nu\u0012\f\t\u0011!A\u0003\u00029\u00141a\u0018\u00134\u0011\u0015i1\u00011\u0001=\u0011\u0015i5\u00011\u0001O\u0011\u0015q8\u00011\u0001_\u0003\u0019\u00198\r[3nC\u0006!\u0002/\u0019:tK\u000e{W\u000e\u001d:fgNLwN\u001c+za\u0016$B!a\u0001\u0002\u0018A!\u0001DIA\u0003!\u0011\t9!a\u0005\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\tAaY;eM*\u00191\"a\u0004\u000b\u0005\u0005E\u0011AA1j\u0013\u0011\t)\"!\u0003\u0003\u001f\r{W\u000e\u001d:fgNLwN\u001c+za\u0016Da!!\u0007\u0005\u0001\u0004I\u0016aD2p[B\u0014Xm]:j_:$\u0016\u0010]3\u0002=%\u001cx*\u001e;qkR$\u0016.\\3ti\u0006l\u0007\u000fV=qKN+\b\u000f]8si\u0016$G\u0003BA\u0010\u0003K\u00012\u0001GA\u0011\u0013\r\t\u0019#\u0007\u0002\b\u0005>|G.Z1o\u0011\u001d\t9#\u0002a\u0001\u0003S\t1c\\;uaV$H+[7fgR\fW\u000e\u001d+za\u0016\u0004B!a\u000b\u0002P9!\u0011QFA%\u001d\u0011\ty#a\u0011\u000f\t\u0005E\u0012\u0011\t\b\u0005\u0003g\tyD\u0004\u0003\u00026\u0005ub\u0002BA\u001c\u0003wq1!UA\u001d\u0013\u0005\t\u0014BA\u00181\u0013\tia&\u0003\u0002@[%\u0011AFP\u0005\u0005\u0003\u000b\n9%A\u0004T#2\u001buN\u001c4\u000b\u00051r\u0014\u0002BA&\u0003\u001b\n!\u0004U1scV,GoT;uaV$H+[7fgR\fW\u000e\u001d+za\u0016TA!!\u0012\u0002H%!\u0011\u0011KA*\u0005\u00151\u0016\r\\;f\u0013\r\t)&\u0007\u0002\f\u000b:,X.\u001a:bi&|g\u000e")
public class GpuParquetFileFormat
implements ColumnarFileFormat,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean isOutputTimestampTypeSupported(Enumeration.Value value) {
        return GpuParquetFileFormat$.MODULE$.isOutputTimestampTypeSupported(value);
    }

    public static Option<CompressionType> parseCompressionType(String string) {
        return GpuParquetFileFormat$.MODULE$.parseCompressionType(string);
    }

    public static Option<GpuParquetFileFormat> tagGpuSupport(RapidsMeta<?, ?, ?> rapidsMeta, SparkSession sparkSession, Map<String, String> map, StructType structType) {
        return GpuParquetFileFormat$.MODULE$.tagGpuSupport(rapidsMeta, sparkSession, map, structType);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        return ColumnarFileFormat.supportDataType$(this, dataType);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public ColumnarOutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        boolean hasTimestamps;
        SQLConf sqlConf = sparkSession.sessionState().conf();
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Enumeration.Value outputTimestampType = sqlConf.parquetOutputTimestampType();
        boolean dateTimeRebaseException = "EXCEPTION".equals(sparkSession.sqlContext().getConf(SparkShimImpl$.MODULE$.parquetRebaseWriteKey()));
        boolean timestampRebaseException = outputTimestampType.equals((Object)SQLConf.ParquetOutputTimestampType$.MODULE$.INT96()) && "EXCEPTION".equals(sparkSession.sqlContext().getConf(SparkShimImpl$.MODULE$.int96ParquetRebaseWriteKey())) || !outputTimestampType.equals((Object)SQLConf.ParquetOutputTimestampType$.MODULE$.INT96()) && dateTimeRebaseException;
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        if (sqlConf.writeLegacyParquetFormat()) {
            throw new UnsupportedOperationException("Spark legacy output format not supported");
        }
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), Boolean.toString(sqlConf.writeLegacyParquetFormat()));
        if (!GpuParquetFileFormat$.MODULE$.isOutputTimestampTypeSupported(outputTimestampType) && (hasTimestamps = dataSchema.exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)TrampolineUtil$.MODULE$.dataTypeExistsRecursively(field.dataType(), (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GpuParquetFileFormat.$anonfun$prepareWrite$4(x$3))))))) {
            throw new UnsupportedOperationException(new StringBuilder(35).append("Unsupported output timestamp type: ").append(outputTimestampType).toString());
        }
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), outputTimestampType.toString());
        ParquetFieldIdShims$.MODULE$.setupParquetFieldIdWriteConfig(conf, sqlConf);
        boolean parquetFieldIdWriteEnabled = ParquetFieldIdShims$.MODULE$.getParquetIdWriteEnabled(sqlConf);
        ParquetTimestampNTZShims$.MODULE$.setupTimestampNTZConfig(conf, sqlConf);
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        CompressionType compressionType = (CompressionType)GpuParquetFileFormat$.MODULE$.parseCompressionType(parquetOptions.compressionCodecClassName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new UnsupportedOperationException(new StringBuilder(35).append("compression codec ").append(parquetOptions.compressionCodecClassName()).append(" is not supported").toString());
        });
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(134).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString());
        }
        return new ColumnarOutputWriterFactory(null, compressionType, dateTimeRebaseException, timestampRebaseException, parquetFieldIdWriteEnabled){
            private final CompressionType compressionType$1;
            private final boolean dateTimeRebaseException$1;
            private final boolean timestampRebaseException$1;
            private final boolean parquetFieldIdWriteEnabled$1;

            public ColumnarOutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new GpuParquetWriter(path, dataSchema, this.compressionType$1, this.dateTimeRebaseException$1, this.timestampRebaseException$1, context, this.parquetFieldIdWriteEnabled$1);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
            {
                this.compressionType$1 = compressionType$1;
                this.dateTimeRebaseException$1 = dateTimeRebaseException$1;
                this.timestampRebaseException$1 = timestampRebaseException$1;
                this.parquetFieldIdWriteEnabled$1 = parquetFieldIdWriteEnabled$1;
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$prepareWrite$4(DataType x$3) {
        return x$3 instanceof TimestampType;
    }

    public GpuParquetFileFormat() {
        ColumnarFileFormat.$init$(this);
        Logging.$init$((Logging)this);
    }
}

