/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.ContiguousTable;
import ai.rapids.cudf.HostColumnVector;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuKeyBatchingIterator$;
import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.GpuSorter;
import com.nvidia.spark.rapids.MetricRange;
import com.nvidia.spark.rapids.NvtxWithMetrics;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.SpillCallback;
import com.nvidia.spark.rapids.SpillPriorities$;
import com.nvidia.spark.rapids.SpillableColumnarBatch;
import com.nvidia.spark.rapids.SpillableColumnarBatch$;
import java.io.Serializable;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001B\u000f\u001f\u0001\u001dB\u0001b\u0013\u0001\u0003\u0002\u0003\u0006IA\f\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\t\u0004!\u0011!Q\u0001\nyC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tI\u0002\u0011\t\u0011)A\u0005=\"AQ\r\u0001B\u0001B\u0003%a\f\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003_\u0011!9\u0007A!A!\u0002\u0013A\u0007\"B6\u0001\t\u0003a\u0007b\u0002>\u0001\u0005\u0004%Ia\u001f\u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003}\u0011%\t\t\u0002\u0001a\u0001\n\u0013\t\u0019\u0002C\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0003\u0002\u0018!9\u00111\u0005\u0001!B\u0013Q\u0006bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kAq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0005\u0002b\u0001\t\n\u0011\"\u0003\u0002d!9\u0011\u0011\u0010\u0001\u0005B\u0005mtaBA?=!\u0005\u0011q\u0010\u0004\u0007;yA\t!!!\t\r-TB\u0011AAB\u0011\u001d\t)I\u0007C\u0001\u0003\u000f\u0013ac\u00129v\u0017\u0016L()\u0019;dQ&tw-\u0013;fe\u0006$xN\u001d\u0006\u0003?\u0001\naA]1qS\u0012\u001c(BA\u0011#\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019C%\u0001\u0004om&$\u0017.\u0019\u0006\u0002K\u0005\u00191m\\7\u0004\u0001M!\u0001\u0001\u000b\u0018H!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fMB\u0019qf\u000e\u001e\u000f\u0005A*dBA\u00195\u001b\u0005\u0011$BA\u001a'\u0003\u0019a$o\\8u}%\t1&\u0003\u00027U\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001d:\u0005!IE/\u001a:bi>\u0014(B\u0001\u001c+!\tYT)D\u0001=\u0015\tid(\u0001\u0006wK\u000e$xN]5{K\u0012T!a\u0010!\u0002\u0007M\fHN\u0003\u0002\"\u0003*\u0011!iQ\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\u000b1a\u001c:h\u0013\t1EHA\u0007D_2,XN\\1s\u0005\u0006$8\r\u001b\t\u0003\u0011&k\u0011AH\u0005\u0003\u0015z\u00111!\u0011:n\u0003\u0011IG/\u001a:\u0002\rM|'\u000f^3s!\tAe*\u0003\u0002P=\tIq\t];T_J$XM]\u0001\u0006if\u0004Xm\u001d\t\u0004SI#\u0016BA*+\u0005\u0015\t%O]1z!\t)v+D\u0001W\u0015\t\u0001f(\u0003\u0002Y-\nAA)\u0019;b)f\u0004X-A\buCJ<W\r^*ju\u0016\u0014\u0015\u0010^3t!\tI3,\u0003\u0002]U\t!Aj\u001c8h\u00031qW/\\%oaV$(k\\<t!\tAu,\u0003\u0002a=\tIq\t];NKR\u0014\u0018nY\u0001\u0010]Vl\u0017J\u001c9vi\n\u000bGo\u00195fg\u0006ia.^7PkR\u0004X\u000f\u001e*poN\f\u0001C\\;n\u001fV$\b/\u001e;CCR\u001c\u0007.Z:\u0002\u0015\r|gnY1u)&lW-\u0001\u0004paRKW.Z\u0001\u000ea\u0016\f7\u000eR3w\u001b\u0016lwN]=\u0002\u001bM\u0004\u0018\u000e\u001c7DC2d'-Y2l!\tA\u0015.\u0003\u0002k=\ti1\u000b]5mY\u000e\u000bG\u000e\u001c2bG.\fa\u0001P5oSRtD#D7o_B\f(o\u001d;vm^D\u0018\u0010\u0005\u0002I\u0001!)1*\u0004a\u0001]!)A*\u0004a\u0001\u001b\")\u0001+\u0004a\u0001#\")\u0011,\u0004a\u00015\")Q,\u0004a\u0001=\")\u0011-\u0004a\u0001=\")!-\u0004a\u0001=\")1-\u0004a\u0001=\")A-\u0004a\u0001=\")Q-\u0004a\u0001=\")a-\u0004a\u0001=\")q-\u0004a\u0001Q\u00069\u0001/\u001a8eS:<W#\u0001?\u0011\u000bu\f)!!\u0003\u000e\u0003yT1a`A\u0001\u0003\u001diW\u000f^1cY\u0016T1!a\u0001+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u000fq(!B)vKV,\u0007c\u0001%\u0002\f%\u0019\u0011Q\u0002\u0010\u0003-M\u0003\u0018\u000e\u001c7bE2,7i\u001c7v[:\f'OQ1uG\"\f\u0001\u0002]3oI&tw\rI\u0001\fa\u0016tG-\u001b8h'&TX-F\u0001[\u0003=\u0001XM\u001c3j]\u001e\u001c\u0016N_3`I\u0015\fH\u0003BA\r\u0003?\u00012!KA\u000e\u0013\r\tiB\u000b\u0002\u0005+:LG\u000f\u0003\u0005\u0002\"E\t\t\u00111\u0001[\u0003\rAH%M\u0001\ra\u0016tG-\u001b8h'&TX\rI\u0001\u0006G2|7/\u001a\u000b\u0003\u00033\tq\u0001[1t\u001d\u0016DH/\u0006\u0002\u0002.A\u0019\u0011&a\f\n\u0007\u0005E\"FA\u0004C_>dW-\u00198\u0002\u0019\u001d,GoS3z\u0007V$xN\u001a4\u0015\t\u0005]\u0012Q\b\t\u0004S\u0005e\u0012bAA\u001eU\t\u0019\u0011J\u001c;\t\r\u0005}R\u00031\u0001;\u0003\t\u0019'-A\u0007d_:\u001c\u0017\r\u001e)f]\u0012Lgn\u001a\u000b\u0004u\u0005\u0015\u0003\"CA$-A\u0005\t\u0019AA%\u0003\u0011a\u0017m\u001d;\u0011\u000b%\nY%a\u0014\n\u0007\u00055#F\u0001\u0004PaRLwN\u001c\t\u0005\u0003#\ni&\u0004\u0002\u0002T)!\u0011QKA,\u0003\u0011\u0019W\u000f\u001a4\u000b\u0007}\tIF\u0003\u0002\u0002\\\u0005\u0011\u0011-[\u0005\u0005\u0003?\n\u0019FA\u0003UC\ndW-A\fd_:\u001c\u0017\r\u001e)f]\u0012Lgn\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\r\u0016\u0005\u0003\u0013\n9g\u000b\u0002\u0002jA!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014!C;oG\",7m[3e\u0015\r\t\u0019HK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA<\u0003[\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0011qW\r\u001f;\u0015\u0003i\nac\u00129v\u0017\u0016L()\u0019;dQ&tw-\u0013;fe\u0006$xN\u001d\t\u0003\u0011j\u0019\"A\u0007\u0015\u0015\u0005\u0005}\u0014\u0001C7bW\u00164UO\\2\u00151\u0005%\u0015qRAU\u0003k\u000b9,!/\u0002<\u0006u\u0016qXAa\u0003\u0007\f)\rE\u0003*\u0003\u0017sS.C\u0002\u0002\u000e*\u0012\u0011BR;oGRLwN\\\u0019\t\u000f\u0005EE\u00041\u0001\u0002\u0014\u0006\u0001RO\u001c2pk:$wJ\u001d3feN\u0003Xm\u0019\t\u0006_\u0005U\u0015\u0011T\u0005\u0004\u0003/K$aA*fcB!\u00111TAS\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016aC3yaJ,7o]5p]NT1!a)?\u0003!\u0019\u0017\r^1msN$\u0018\u0002BAT\u0003;\u0013\u0011bU8si>\u0013H-\u001a:\t\u000f\u0005-F\u00041\u0001\u0002.\u000611o\u00195f[\u0006\u0004B!\u000b*\u00020B!\u00111TAY\u0013\u0011\t\u0019,!(\u0003\u0013\u0005#HO]5ckR,\u0007\"B-\u001d\u0001\u0004Q\u0006\"B/\u001d\u0001\u0004q\u0006\"B1\u001d\u0001\u0004q\u0006\"\u00022\u001d\u0001\u0004q\u0006\"B2\u001d\u0001\u0004q\u0006\"\u00023\u001d\u0001\u0004q\u0006\"B3\u001d\u0001\u0004q\u0006\"\u00024\u001d\u0001\u0004q\u0006\"B4\u001d\u0001\u0004A\u0007")
public class GpuKeyBatchingIterator
implements Iterator<ColumnarBatch>,
Arm {
    private final Iterator<ColumnarBatch> iter;
    private final GpuSorter sorter;
    private final DataType[] types;
    private final long targetSizeBytes;
    private final GpuMetric numInputRows;
    private final GpuMetric numInputBatches;
    private final GpuMetric numOutputRows;
    private final GpuMetric numOutputBatches;
    private final GpuMetric concatTime;
    private final GpuMetric opTime;
    private final GpuMetric peakDevMemory;
    private final SpillCallback spillCallback;
    private final Queue<SpillableColumnarBatch> pending;
    private long pendingSize;

    public static Function1<Iterator<ColumnarBatch>, GpuKeyBatchingIterator> makeFunc(Seq<SortOrder> seq, Attribute[] attributeArray, long l, GpuMetric gpuMetric, GpuMetric gpuMetric2, GpuMetric gpuMetric3, GpuMetric gpuMetric4, GpuMetric gpuMetric5, GpuMetric gpuMetric6, GpuMetric gpuMetric7, SpillCallback spillCallback) {
        return GpuKeyBatchingIterator$.MODULE$.makeFunc(seq, attributeArray, l, gpuMetric, gpuMetric2, gpuMetric3, gpuMetric4, gpuMetric5, gpuMetric6, gpuMetric7, spillCallback);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public Iterator<ColumnarBatch> seq() {
        return Iterator.seq$((Iterator)this);
    }

    public boolean isEmpty() {
        return Iterator.isEmpty$((Iterator)this);
    }

    public boolean isTraversableAgain() {
        return Iterator.isTraversableAgain$((Iterator)this);
    }

    public boolean hasDefiniteSize() {
        return Iterator.hasDefiniteSize$((Iterator)this);
    }

    public Iterator<ColumnarBatch> take(int n) {
        return Iterator.take$((Iterator)this, (int)n);
    }

    public Iterator<ColumnarBatch> drop(int n) {
        return Iterator.drop$((Iterator)this, (int)n);
    }

    public Iterator<ColumnarBatch> slice(int from, int until) {
        return Iterator.slice$((Iterator)this, (int)from, (int)until);
    }

    public Iterator<ColumnarBatch> sliceIterator(int from, int until) {
        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
    }

    public <B> Iterator<B> map(Function1<ColumnarBatch, B> f) {
        return Iterator.map$((Iterator)this, f);
    }

    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
        return Iterator.$plus$plus$((Iterator)this, that);
    }

    public <B> Iterator<B> flatMap(Function1<ColumnarBatch, GenTraversableOnce<B>> f) {
        return Iterator.flatMap$((Iterator)this, f);
    }

    public Iterator<ColumnarBatch> filter(Function1<ColumnarBatch, Object> p) {
        return Iterator.filter$((Iterator)this, p);
    }

    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<ColumnarBatch, B, Object> p) {
        return Iterator.corresponds$((Iterator)this, that, p);
    }

    public Iterator<ColumnarBatch> withFilter(Function1<ColumnarBatch, Object> p) {
        return Iterator.withFilter$((Iterator)this, p);
    }

    public Iterator<ColumnarBatch> filterNot(Function1<ColumnarBatch, Object> p) {
        return Iterator.filterNot$((Iterator)this, p);
    }

    public <B> Iterator<B> collect(PartialFunction<ColumnarBatch, B> pf) {
        return Iterator.collect$((Iterator)this, pf);
    }

    public <B> Iterator<B> scanLeft(B z, Function2<B, ColumnarBatch, B> op) {
        return Iterator.scanLeft$((Iterator)this, z, op);
    }

    public <B> Iterator<B> scanRight(B z, Function2<ColumnarBatch, B, B> op) {
        return Iterator.scanRight$((Iterator)this, z, op);
    }

    public Iterator<ColumnarBatch> takeWhile(Function1<ColumnarBatch, Object> p) {
        return Iterator.takeWhile$((Iterator)this, p);
    }

    public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> partition(Function1<ColumnarBatch, Object> p) {
        return Iterator.partition$((Iterator)this, p);
    }

    public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> span(Function1<ColumnarBatch, Object> p) {
        return Iterator.span$((Iterator)this, p);
    }

    public Iterator<ColumnarBatch> dropWhile(Function1<ColumnarBatch, Object> p) {
        return Iterator.dropWhile$((Iterator)this, p);
    }

    public <B> Iterator<Tuple2<ColumnarBatch, B>> zip(Iterator<B> that) {
        return Iterator.zip$((Iterator)this, that);
    }

    public <A1> Iterator<A1> padTo(int len, A1 elem) {
        return Iterator.padTo$((Iterator)this, (int)len, elem);
    }

    public Iterator<Tuple2<ColumnarBatch, Object>> zipWithIndex() {
        return Iterator.zipWithIndex$((Iterator)this);
    }

    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
    }

    public <U> void foreach(Function1<ColumnarBatch, U> f) {
        Iterator.foreach$((Iterator)this, f);
    }

    public boolean forall(Function1<ColumnarBatch, Object> p) {
        return Iterator.forall$((Iterator)this, p);
    }

    public boolean exists(Function1<ColumnarBatch, Object> p) {
        return Iterator.exists$((Iterator)this, p);
    }

    public boolean contains(Object elem) {
        return Iterator.contains$((Iterator)this, (Object)elem);
    }

    public Option<ColumnarBatch> find(Function1<ColumnarBatch, Object> p) {
        return Iterator.find$((Iterator)this, p);
    }

    public int indexWhere(Function1<ColumnarBatch, Object> p) {
        return Iterator.indexWhere$((Iterator)this, p);
    }

    public int indexWhere(Function1<ColumnarBatch, Object> p, int from) {
        return Iterator.indexWhere$((Iterator)this, p, (int)from);
    }

    public <B> int indexOf(B elem) {
        return Iterator.indexOf$((Iterator)this, elem);
    }

    public <B> int indexOf(B elem, int from) {
        return Iterator.indexOf$((Iterator)this, elem, (int)from);
    }

    public BufferedIterator<ColumnarBatch> buffered() {
        return Iterator.buffered$((Iterator)this);
    }

    public <B> Iterator.GroupedIterator<B> grouped(int size) {
        return Iterator.grouped$((Iterator)this, (int)size);
    }

    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
    }

    public <B> int sliding$default$2() {
        return Iterator.sliding$default$2$((Iterator)this);
    }

    public int length() {
        return Iterator.length$((Iterator)this);
    }

    public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> duplicate() {
        return Iterator.duplicate$((Iterator)this);
    }

    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
    }

    public <B> void copyToArray(Object xs, int start, int len) {
        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
    }

    public boolean sameElements(Iterator<?> that) {
        return Iterator.sameElements$((Iterator)this, that);
    }

    public Traversable<ColumnarBatch> toTraversable() {
        return Iterator.toTraversable$((Iterator)this);
    }

    public Iterator<ColumnarBatch> toIterator() {
        return Iterator.toIterator$((Iterator)this);
    }

    public Stream<ColumnarBatch> toStream() {
        return Iterator.toStream$((Iterator)this);
    }

    public String toString() {
        return Iterator.toString$((Iterator)this);
    }

    public List<ColumnarBatch> reversed() {
        return TraversableOnce.reversed$((TraversableOnce)this);
    }

    public int size() {
        return TraversableOnce.size$((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.nonEmpty$((TraversableOnce)this);
    }

    public int count(Function1<ColumnarBatch, Object> p) {
        return TraversableOnce.count$((TraversableOnce)this, p);
    }

    public <B> Option<B> collectFirst(PartialFunction<ColumnarBatch, B> pf) {
        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
    }

    public <B> B $div$colon(B z, Function2<B, ColumnarBatch, B> op) {
        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
    }

    public <B> B $colon$bslash(B z, Function2<ColumnarBatch, B, B> op) {
        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
    }

    public <B> B foldLeft(B z, Function2<B, ColumnarBatch, B> op) {
        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
    }

    public <B> B foldRight(B z, Function2<ColumnarBatch, B, B> op) {
        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
    }

    public <B> B reduceLeft(Function2<B, ColumnarBatch, B> op) {
        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
    }

    public <B> B reduceRight(Function2<ColumnarBatch, B, B> op) {
        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, ColumnarBatch, B> op) {
        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<ColumnarBatch, B, B> op) {
        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
    }

    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
    }

    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, ColumnarBatch, B> seqop, Function2<B, B, B> combop) {
        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.product$((TraversableOnce)this, num);
    }

    public Object min(Ordering cmp) {
        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object max(Ordering cmp) {
        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
    }

    public <B> void copyToArray(Object xs, int start) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
    }

    public <B> void copyToArray(Object xs) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
    }

    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
    }

    public List<ColumnarBatch> toList() {
        return TraversableOnce.toList$((TraversableOnce)this);
    }

    public Iterable<ColumnarBatch> toIterable() {
        return TraversableOnce.toIterable$((TraversableOnce)this);
    }

    public Seq<ColumnarBatch> toSeq() {
        return TraversableOnce.toSeq$((TraversableOnce)this);
    }

    public IndexedSeq<ColumnarBatch> toIndexedSeq() {
        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
    }

    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.toBuffer$((TraversableOnce)this);
    }

    public <B> Set<B> toSet() {
        return TraversableOnce.toSet$((TraversableOnce)this);
    }

    public Vector<ColumnarBatch> toVector() {
        return TraversableOnce.toVector$((TraversableOnce)this);
    }

    public <Col> Col to(CanBuildFrom<Nothing$, ColumnarBatch, Col> cbf) {
        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
    }

    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<ColumnarBatch, Tuple2<T, U>> ev) {
        return TraversableOnce.toMap$((TraversableOnce)this, ev);
    }

    public String mkString(String start, String sep, String end) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.mkString$((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
    }

    public int sizeHintIfCheap() {
        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
    }

    private Queue<SpillableColumnarBatch> pending() {
        return this.pending;
    }

    private long pendingSize() {
        return this.pendingSize;
    }

    private void pendingSize_$eq(long x$1) {
        this.pendingSize = x$1;
    }

    public void close() {
        this.pending().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.pending().clear();
        this.pendingSize_$eq(0L);
    }

    public boolean hasNext() {
        return this.pending().nonEmpty() || this.iter.hasNext();
    }

    private int getKeyCutoff(ColumnarBatch cb) {
        int n;
        int[] candidates = (int[])this.withResource(this.sorter.appendProjectedColumns(cb), (Function1 & Serializable & scala.Serializable)appended -> (int[])this.withResource(GpuColumnVector.from(appended), (Function1 & Serializable & scala.Serializable)table -> {
            int maxRow = cb.numRows() - 1;
            Predef$.MODULE$.require(maxRow >= 0);
            int rowsPerBatch = Math.max(1, (int)Math.ceil((double)cb.numRows() / 16.0));
            IndexedSeq probePoints = (IndexedSeq)((SeqLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 16).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)idx -> Math.min(maxRow, idx * rowsPerBatch), IndexedSeq$.MODULE$.canBuildFrom())).distinct();
            Table searchTab2 = (Table)this.withResource(ColumnVector.fromInts((int[])((int[])probePoints.toArray(ClassTag$.MODULE$.Int()))), (Function1 & Serializable & scala.Serializable)gatherMap -> table.gather((ColumnView)gatherMap));
            ColumnVector cutoffVec2 = (ColumnVector)this.withResource(searchTab2, (Function1 & Serializable & scala.Serializable)searchTab -> $this.sorter.lowerBound((Table)table, (Table)searchTab));
            int[] cutoffCandidates = new int[(int)cutoffVec2.getRowCount()];
            this.withResource(cutoffVec2, (Function1 & Serializable & scala.Serializable)cutoffVec -> {
                this.withResource(cutoffVec.copyToHost(), (Function1 & Serializable & scala.Serializable)vecHost -> {
                    GpuKeyBatchingIterator.$anonfun$getKeyCutoff$7(cutoffCandidates$1, vecHost);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            return (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(cutoffCandidates)).distinct();
        }));
        if (candidates.length == 1) {
            n = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(candidates)).head());
        } else {
            int[] overButValid;
            double averageRowSize = Math.max(1.0, (double)GpuColumnVector.getTotalDeviceMemoryUsed(cb) / (double)cb.numRows());
            long leftForTarget = this.targetSizeBytes - this.pendingSize();
            double approximateRows = (double)leftForTarget / averageRowSize;
            int[] willFit = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(candidates)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)f -> f > 0 && (double)f <= approximateRows);
            n = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(willFit)).nonEmpty() ? BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(willFit)).max((Ordering)Ordering.Int$.MODULE$)) : (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(overButValid = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(candidates)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)f -> f > 0))).nonEmpty() ? BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(overButValid)).min((Ordering)Ordering.Int$.MODULE$)) : 0);
        }
        return n;
    }

    private ColumnarBatch concatPending(Option<Table> last) {
        ColumnarBatch columnarBatch;
        LongRef peak = LongRef.create((long)0L);
        try {
            columnarBatch = (ColumnarBatch)this.withResource(new NvtxWithMetrics("concat pending", NvtxColor.CYAN, (Seq<GpuMetric>)Predef$.MODULE$.wrapRefArray((Object[])new GpuMetric[]{this.concatTime})), (Function1 & Serializable & scala.Serializable)x$3 -> (ColumnarBatch)this.withResource((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function1 & Serializable & scala.Serializable)toConcat -> {
                while (this.pending().nonEmpty()) {
                    this.withResource((AutoCloseable)this.pending().dequeue(), (Function1 & Serializable & scala.Serializable)spillable -> {
                        this.withResource(spillable.getColumnarBatch(), (Function1 & Serializable & scala.Serializable)cb -> {
                            GpuKeyBatchingIterator.$anonfun$concatPending$4(peak$1, toConcat$1, cb);
                            return BoxedUnit.UNIT;
                        });
                        return BoxedUnit.UNIT;
                    });
                }
                this.pendingSize_$eq(0L);
                last.foreach((Function1 & Serializable & scala.Serializable)lastTab -> {
                    GpuKeyBatchingIterator.$anonfun$concatPending$5(peak, toConcat, lastTab);
                    return BoxedUnit.UNIT;
                });
                return toConcat.length() > 1 ? (ColumnarBatch)this.withResource(Table.concatenate((Table[])((Table[])toConcat.toArray(ClassTag$.MODULE$.apply(Table.class)))), (Function1 & Serializable & scala.Serializable)concated -> {
                    peak$1.elem += GpuColumnVector.getTotalDeviceMemoryUsed(concated);
                    return GpuColumnVector.from(concated, $this.types);
                }) : (toConcat.nonEmpty() ? GpuColumnVector.from((Table)toConcat.head(), $this.types) : GpuColumnVector.emptyBatchFromTypes($this.types));
            }));
        }
        finally {
            this.peakDevMemory.set(Math.max(this.peakDevMemory.value(), peak.elem));
        }
        return columnarBatch;
    }

    private Option<Table> concatPending$default$1() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public ColumnarBatch next() {
        ColumnarBatch columnarBatch;
        Object object = new Object();
        try {
            void var2_2;
            while (this.iter.hasNext()) {
                this.withResource((AutoCloseable)this.iter.next(), (Function1 & Serializable & scala.Serializable)cb -> {
                    GpuKeyBatchingIterator.$anonfun$next$1(this, object, cb);
                    return BoxedUnit.UNIT;
                });
            }
            ColumnarBatch ret = (ColumnarBatch)this.withResource(new MetricRange((Seq<GpuMetric>)Predef$.MODULE$.wrapRefArray((Object[])new GpuMetric[]{this.opTime})), (Function1 & Serializable & scala.Serializable)x$5 -> this.concatPending(this.concatPending$default$1()));
            this.numOutputRows.$plus$eq(ret.numRows());
            this.numOutputBatches.$plus$eq(1L);
            columnarBatch = var2_2;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                columnarBatch = (ColumnarBatch)ex.value();
            }
            throw ex;
        }
        return columnarBatch;
    }

    public static final /* synthetic */ void $anonfun$getKeyCutoff$7(int[] cutoffCandidates$1, HostColumnVector vecHost) {
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(cutoffCandidates$1)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
            cutoffCandidates$1[idx] = vecHost.getInt((long)idx);
        });
    }

    public static final /* synthetic */ void $anonfun$concatPending$4(LongRef peak$1, ArrayBuffer toConcat$1, ColumnarBatch cb) {
        peak$1.elem += GpuColumnVector.getTotalDeviceMemoryUsed(cb);
        toConcat$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Table[]{GpuColumnVector.from(cb)}));
    }

    public static final /* synthetic */ void $anonfun$concatPending$5(LongRef peak$1, ArrayBuffer toConcat$1, Table lastTab) {
        peak$1.elem += GpuColumnVector.getTotalDeviceMemoryUsed(lastTab);
        toConcat$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Table[]{lastTab}));
    }

    public static final /* synthetic */ void $anonfun$next$2(GpuKeyBatchingIterator $this, ColumnarBatch cb$2, Object nonLocalReturnKey1$1, MetricRange x$4) {
        Object object = GpuColumnVector.isTaggedAsFinalBatch(cb$2) ? $this.withResource(GpuColumnVector.from(cb$2), (Function1 & Serializable & scala.Serializable)table -> {
            ColumnarBatch ret = $this.concatPending((Option<Table>)new Some(table));
            $this.numOutputRows.$plus$eq(ret.numRows());
            $this.numOutputBatches.$plus$eq(1L);
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)ret);
        }) : BoxedUnit.UNIT;
        int cutoff = $this.getKeyCutoff(cb$2);
        if (cutoff <= 0) {
            long cbSize = GpuColumnVector.getTotalDeviceMemoryUsed(cb$2);
            $this.peakDevMemory.set(Math.max($this.peakDevMemory.value(), cbSize));
            $this.pending().$plus$eq((Object)SpillableColumnarBatch$.MODULE$.apply(GpuColumnVector.incRefCounts(cb$2), SpillPriorities$.MODULE$.ACTIVE_ON_DECK_PRIORITY(), $this.spillCallback));
            $this.pendingSize_$eq($this.pendingSize() + cbSize);
        } else {
            LongRef peak = LongRef.create((long)GpuColumnVector.getTotalDeviceMemoryUsed(cb$2));
            $this.withResource(GpuColumnVector.from(cb$2), (Function1 & Serializable & scala.Serializable)table -> (Nothing$)$this.withResource((AutoCloseable)((AutoCloseable[])table.contiguousSplit(new int[]{cutoff})), (Function1)(Function1 & Serializable & scala.Serializable)tables -> {
                Predef$.MODULE$.assert(((ContiguousTable[])tables).length == 2);
                ColumnarBatch ret = $this.concatPending((Option<Table>)new Some((Object)tables[0].getTable()));
                peak$2.elem += GpuColumnVector.getTotalDeviceMemoryUsed(ret);
                long savedSize = tables[1].getBuffer().getLength();
                peak$2.elem += savedSize;
                $this.pending().$plus$eq((Object)SpillableColumnarBatch$.MODULE$.apply(tables[1], $this.types, SpillPriorities$.MODULE$.ACTIVE_ON_DECK_PRIORITY(), $this.spillCallback));
                $this.pendingSize_$eq($this.pendingSize() + savedSize);
                $this.numOutputRows.$plus$eq(ret.numRows());
                $this.numOutputBatches.$plus$eq(1L);
                $this.peakDevMemory.set(Math.max($this.peakDevMemory.value(), peak$2.elem));
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)ret);
            }));
        }
    }

    public static final /* synthetic */ void $anonfun$next$1(GpuKeyBatchingIterator $this, Object nonLocalReturnKey1$1, ColumnarBatch cb) {
        block0: {
            $this.numInputBatches.$plus$eq(1L);
            int numRows = cb.numRows();
            if (numRows <= 0) break block0;
            $this.numInputRows.$plus$eq(numRows);
            $this.withResource(new MetricRange((Seq<GpuMetric>)Predef$.MODULE$.wrapRefArray((Object[])new GpuMetric[]{$this.opTime})), (Function1 & Serializable & scala.Serializable)x$4 -> {
                GpuKeyBatchingIterator.$anonfun$next$2($this, cb, nonLocalReturnKey1$1, x$4);
                return BoxedUnit.UNIT;
            });
        }
    }

    public GpuKeyBatchingIterator(Iterator<ColumnarBatch> iter, GpuSorter sorter, DataType[] types, long targetSizeBytes, GpuMetric numInputRows, GpuMetric numInputBatches, GpuMetric numOutputRows, GpuMetric numOutputBatches, GpuMetric concatTime, GpuMetric opTime, GpuMetric peakDevMemory, SpillCallback spillCallback) {
        this.iter = iter;
        this.sorter = sorter;
        this.types = types;
        this.targetSizeBytes = targetSizeBytes;
        this.numInputRows = numInputRows;
        this.numInputBatches = numInputBatches;
        this.numOutputRows = numOutputRows;
        this.numOutputBatches = numOutputBatches;
        this.concatTime = concatTime;
        this.opTime = opTime;
        this.peakDevMemory = peakDevMemory;
        this.spillCallback = spillCallback;
        GenTraversableOnce.$init$((GenTraversableOnce)this);
        TraversableOnce.$init$((TraversableOnce)this);
        Iterator.$init$((Iterator)this);
        Arm.$init$(this);
        this.pending = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.pendingSize = 0L;
        TaskContext$.MODULE$.get().addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.close();
            return BoxedUnit.UNIT;
        });
    }
}

