/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuAlias;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuLiteral;
import com.nvidia.spark.rapids.GpuScalar;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsPluginImplicits$;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;

public final class GpuExpressionsUtils$
implements Arm {
    public static GpuExpressionsUtils$ MODULE$;

    static {
        new GpuExpressionsUtils$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTrimString(Option<Expression> trimStr) {
        GpuAlias gpuAlias;
        Expression expression;
        Expression expression2;
        boolean bl = false;
        Some some = null;
        Option<Expression> option = trimStr;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Expression expression3 = (Expression)some.value();
            if (expression3 instanceof GpuLiteral) {
                GpuLiteral gpuLiteral = (GpuLiteral)expression3;
                Object data = gpuLiteral.value();
                DataType dataType = gpuLiteral.dataType();
                if (StringType$.MODULE$.equals(dataType)) {
                    if (data == null) {
                        return null;
                    }
                    String string = ((UTF8String)data).toString();
                    return string;
                }
            }
        }
        if (bl && (expression2 = (Expression)some.value()) instanceof GpuAlias && (expression = (gpuAlias = (GpuAlias)expression2).child()) instanceof GpuLiteral) {
            GpuLiteral gpuLiteral = (GpuLiteral)expression;
            Object data = gpuLiteral.value();
            DataType dataType = gpuLiteral.dataType();
            if (StringType$.MODULE$.equals(dataType)) {
                if (data == null) {
                    return null;
                }
                String string = ((UTF8String)data).toString();
                return string;
            }
        }
        if (!None$.MODULE$.equals(option)) throw new IllegalStateException("Internal Error GPU support for this data type is not implemented and should have been disabled");
        return " ";
    }

    public GpuColumnVector resolveColumnVector(Object any, int numRows) {
        return (GpuColumnVector)((Object)this.withResourceIfAllowed(any, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            GpuColumnVector gpuColumnVector;
            Object object = x0$1;
            if (object instanceof GpuColumnVector) {
                GpuColumnVector gpuColumnVector2 = (GpuColumnVector)((Object)((Object)object));
                gpuColumnVector = gpuColumnVector2.incRefCount();
            } else if (object instanceof GpuScalar) {
                GpuScalar gpuScalar = (GpuScalar)object;
                gpuColumnVector = GpuColumnVector.from(gpuScalar, numRows, gpuScalar.dataType());
            } else {
                throw new IllegalArgumentException(new StringBuilder(119).append("Cannot resolve a ColumnVector from the value:").append(" ").append(object).append(". Please convert it to a GpuScalar or a GpuColumnVector before returning.").toString());
            }
            return gpuColumnVector;
        }));
    }

    public GpuColumnVector columnarEvalToColumn(Expression expr, ColumnarBatch batch) {
        return this.resolveColumnVector(RapidsPluginImplicits$.MODULE$.ReallyAGpuExpression(expr).columnarEval(batch), batch.numRows());
    }

    public Option<GpuLiteral> extractGpuLit(Expression exp) {
        None$ none$;
        block2: {
            while (true) {
                Expression expression;
                if ((expression = exp) instanceof GpuLiteral) {
                    GpuLiteral gpuLiteral = (GpuLiteral)expression;
                    none$ = new Some((Object)gpuLiteral);
                    break block2;
                }
                if (!(expression instanceof GpuAlias)) break;
                GpuAlias gpuAlias = (GpuAlias)expression;
                exp = gpuAlias.child();
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private GpuExpressionsUtils$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

