/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ArrowColumnBuilder;
import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.HostColumnVector;
import ai.rapids.cudf.HostColumnVectorCore;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.Schema;
import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.DecimalUtil;
import com.nvidia.spark.rapids.GpuColumnVectorBase;
import com.nvidia.spark.rapids.GpuScalar;
import com.nvidia.spark.rapids.GpuUnsignedIntegerType;
import com.nvidia.spark.rapids.GpuUnsignedLongType;
import com.nvidia.spark.rapids.HostColumnarToGpu;
import com.nvidia.spark.rapids.RapidsHostColumnVector;
import com.nvidia.spark.rapids.RapidsNullSafeHostColumnVector;
import com.nvidia.spark.rapids.WithTableBuffer;
import com.nvidia.spark.rapids.shims.GpuTypeShims;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class GpuColumnVector
extends GpuColumnVectorBase {
    private final ai.rapids.cudf.ColumnVector cudfCv;

    public static synchronized void debug(String name, Table table) {
        System.err.println("DEBUG " + name + " " + table);
        for (int col = 0; col < table.getNumberOfColumns(); ++col) {
            GpuColumnVector.debug(String.valueOf(col), (ColumnView)table.getColumn(col));
        }
    }

    public static synchronized void debug(String name, ColumnarBatch cb) {
        try (Table table = GpuColumnVector.from(cb);){
            GpuColumnVector.debug(name, table);
        }
    }

    private static synchronized void debugGPUAddrs(String name, ColumnView col) {
        try (BaseDeviceMemoryBuffer data = col.getData();
             BaseDeviceMemoryBuffer validity = col.getValid();){
            System.err.println("GPU COLUMN " + name + " - NC: " + col.getNullCount() + " DATA: " + data + " VAL: " + validity);
        }
        if (col.getType() == DType.STRUCT) {
            for (int i = 0; i < col.getNumChildren(); ++i) {
                try (ColumnView child = col.getChildColumnView(i);){
                    GpuColumnVector.debugGPUAddrs(name + ":CHILD_" + i, child);
                    continue;
                }
            }
        } else if (col.getType() == DType.LIST) {
            try (ColumnView child = col.getChildColumnView(0);){
                GpuColumnVector.debugGPUAddrs(name + ":DATA", child);
            }
        }
    }

    public static synchronized void debug(String name, ColumnView col) {
        GpuColumnVector.debugGPUAddrs(name, col);
        try (HostColumnVector hostCol = col.copyToHost();){
            GpuColumnVector.debug(name, (HostColumnVectorCore)hostCol);
        }
    }

    private static String hexString(byte[] bytes) {
        StringBuilder str = new StringBuilder();
        for (byte b : bytes) {
            str.append(String.format("%02x", b & 0xFF));
        }
        return str.toString();
    }

    public static synchronized void debug(String name, HostColumnVectorCore hostCol) {
        DType type = hostCol.getType();
        System.err.println("COLUMN " + name + " - " + type);
        if (type.isDecimalType()) {
            int i = 0;
            while ((long)i < hostCol.getRowCount()) {
                if (hostCol.isNull((long)i)) {
                    System.err.println(i + " NULL");
                } else {
                    System.err.println(i + " " + hostCol.getBigDecimal((long)i));
                }
                ++i;
            }
        } else if (DType.STRING.equals((Object)type)) {
            int i = 0;
            while ((long)i < hostCol.getRowCount()) {
                if (hostCol.isNull((long)i)) {
                    System.err.println(i + " NULL");
                } else {
                    System.err.println(i + " \"" + hostCol.getJavaString((long)i) + "\" " + GpuColumnVector.hexString(hostCol.getUTF8((long)i)));
                }
                ++i;
            }
        } else if (DType.INT32.equals((Object)type) || DType.INT8.equals((Object)type) || DType.INT16.equals((Object)type) || DType.INT64.equals((Object)type) || DType.TIMESTAMP_DAYS.equals((Object)type) || DType.TIMESTAMP_SECONDS.equals((Object)type) || DType.TIMESTAMP_MICROSECONDS.equals((Object)type) || DType.TIMESTAMP_MILLISECONDS.equals((Object)type) || DType.TIMESTAMP_NANOSECONDS.equals((Object)type) || DType.UINT8.equals((Object)type) || DType.UINT16.equals((Object)type) || DType.UINT32.equals((Object)type) || DType.UINT64.equals((Object)type)) {
            GpuColumnVector.debugInteger(hostCol, type);
        } else if (DType.BOOL8.equals((Object)type)) {
            int i = 0;
            while ((long)i < hostCol.getRowCount()) {
                if (hostCol.isNull((long)i)) {
                    System.err.println(i + " NULL");
                } else {
                    System.err.println(i + " " + hostCol.getBoolean((long)i));
                }
                ++i;
            }
        } else if (DType.FLOAT64.equals((Object)type)) {
            int i = 0;
            while ((long)i < hostCol.getRowCount()) {
                if (hostCol.isNull((long)i)) {
                    System.err.println(i + " NULL");
                } else {
                    System.err.println(i + " " + hostCol.getDouble((long)i));
                }
                ++i;
            }
        } else if (DType.FLOAT32.equals((Object)type)) {
            int i = 0;
            while ((long)i < hostCol.getRowCount()) {
                if (hostCol.isNull((long)i)) {
                    System.err.println(i + " NULL");
                } else {
                    System.err.println(i + " " + hostCol.getFloat((long)i));
                }
                ++i;
            }
        } else if (DType.STRUCT.equals((Object)type)) {
            int i = 0;
            while ((long)i < hostCol.getRowCount()) {
                if (hostCol.isNull((long)i)) {
                    System.err.println(i + " NULL");
                }
                ++i;
            }
            for (i = 0; i < hostCol.getNumChildren(); ++i) {
                GpuColumnVector.debug(name + ":CHILD_" + i, hostCol.getChildColumnView(i));
            }
        } else if (DType.LIST.equals((Object)type)) {
            System.err.println("OFFSETS");
            int i = 0;
            while ((long)i < hostCol.getRowCount()) {
                if (hostCol.isNull((long)i)) {
                    System.err.println(i + " NULL");
                } else {
                    System.err.println(i + " [" + hostCol.getStartListOffset((long)i) + " - " + hostCol.getEndListOffset((long)i) + ")");
                }
                ++i;
            }
            GpuColumnVector.debug(name + ":DATA", hostCol.getChildColumnView(0));
        } else {
            System.err.println("TYPE " + type + " NOT SUPPORTED FOR DEBUG PRINT");
        }
    }

    private static void debugInteger(HostColumnVectorCore hostCol, DType intType) {
        int i = 0;
        while ((long)i < hostCol.getRowCount()) {
            if (hostCol.isNull((long)i)) {
                System.err.println(i + " NULL");
            } else {
                Number value;
                int sizeInBytes = intType.getSizeInBytes();
                switch (sizeInBytes) {
                    case 1: {
                        value = hostCol.getByte((long)i);
                        break;
                    }
                    case 2: {
                        value = hostCol.getShort((long)i);
                        break;
                    }
                    case 4: {
                        value = hostCol.getInt((long)i);
                        break;
                    }
                    case 8: {
                        value = hostCol.getLong((long)i);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("INFEASIBLE: Unsupported integer-like type " + intType);
                    }
                }
                System.err.println(i + " " + value);
            }
            ++i;
        }
    }

    static HostColumnVector.DataType convertFrom(DataType spark, boolean nullable) {
        if (spark instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)spark;
            return new HostColumnVector.ListType(nullable, GpuColumnVector.convertFrom(arrayType.elementType(), arrayType.containsNull()));
        }
        if (spark instanceof MapType) {
            MapType mapType = (MapType)spark;
            return new HostColumnVector.ListType(nullable, (HostColumnVector.DataType)new HostColumnVector.StructType(false, Arrays.asList(GpuColumnVector.convertFrom(mapType.keyType(), false), GpuColumnVector.convertFrom(mapType.valueType(), mapType.valueContainsNull()))));
        }
        if (spark instanceof StructType) {
            StructType stType = (StructType)spark;
            HostColumnVector.DataType[] children = new HostColumnVector.DataType[stType.size()];
            StructField[] fields = stType.fields();
            for (int i = 0; i < children.length; ++i) {
                children[i] = GpuColumnVector.convertFrom(fields[i].dataType(), fields[i].nullable());
            }
            return new HostColumnVector.StructType(nullable, children);
        }
        if (spark instanceof BinaryType) {
            return new HostColumnVector.ListType(nullable, GpuColumnVector.convertFrom(DataTypes.ByteType, false));
        }
        return new HostColumnVector.BasicType(nullable, GpuColumnVector.getNonNestedRapidsType(spark));
    }

    private static DType toRapidsOrNull(DataType type) {
        DType ret = GpuColumnVector.toRapidsOrNullCommon(type);
        return ret != null ? ret : GpuTypeShims.toRapidsOrNull(type);
    }

    private static DType toRapidsOrNullCommon(DataType type) {
        if (type instanceof LongType) {
            return DType.INT64;
        }
        if (type instanceof DoubleType) {
            return DType.FLOAT64;
        }
        if (type instanceof ByteType) {
            return DType.INT8;
        }
        if (type instanceof BooleanType) {
            return DType.BOOL8;
        }
        if (type instanceof ShortType) {
            return DType.INT16;
        }
        if (type instanceof IntegerType) {
            return DType.INT32;
        }
        if (type instanceof FloatType) {
            return DType.FLOAT32;
        }
        if (type instanceof DateType) {
            return DType.TIMESTAMP_DAYS;
        }
        if (type instanceof TimestampType) {
            return DType.TIMESTAMP_MICROSECONDS;
        }
        if (type instanceof StringType) {
            return DType.STRING;
        }
        if (type instanceof BinaryType) {
            return DType.LIST;
        }
        if (type instanceof NullType) {
            return DType.INT8;
        }
        if (type instanceof DecimalType) {
            return DecimalUtil.createCudfDecimal((DecimalType)type);
        }
        if (type instanceof GpuUnsignedIntegerType) {
            return DType.UINT32;
        }
        if (type instanceof GpuUnsignedLongType) {
            return DType.UINT64;
        }
        return null;
    }

    public static DType getRapidsType(DataType type) {
        if (type instanceof ArrayType) {
            return DType.LIST;
        }
        if (type instanceof StructType) {
            return DType.STRUCT;
        }
        return GpuColumnVector.getNonNestedRapidsType(type);
    }

    public static boolean isNonNestedSupportedType(DataType type) {
        return GpuColumnVector.toRapidsOrNull(type) != null;
    }

    public static DType getNonNestedRapidsType(DataType type) {
        DType result = GpuColumnVector.toRapidsOrNull(type);
        if (result == null) {
            throw new IllegalArgumentException(type + " is not supported for GPU processing yet.");
        }
        return result;
    }

    public static ColumnarBatch emptyBatch(StructType schema) {
        try (GpuColumnarBatchBuilder builder = new GpuColumnarBatchBuilder(schema, 0);){
            ColumnarBatch columnarBatch = builder.build(0);
            return columnarBatch;
        }
    }

    public static ColumnarBatch emptyBatch(List<Attribute> format) {
        return GpuColumnVector.emptyBatch(GpuColumnVector.structFromAttributes(format));
    }

    public static ColumnarBatch emptyBatchFromTypes(DataType[] format) {
        return GpuColumnVector.emptyBatch(GpuColumnVector.structFromTypes(format));
    }

    public static HostColumnVector[] emptyHostColumns(StructType schema) {
        try (GpuColumnarBatchBuilder builder = new GpuColumnarBatchBuilder(schema, 0);){
            HostColumnVector[] hostColumnVectorArray = builder.buildHostColumns();
            return hostColumnVectorArray;
        }
    }

    public static HostColumnVector[] emptyHostColumns(List<Attribute> format) {
        return GpuColumnVector.emptyHostColumns(GpuColumnVector.structFromAttributes(format));
    }

    public static HostColumnVector[] emptyHostColumns(DataType[] format) {
        return GpuColumnVector.emptyHostColumns(GpuColumnVector.structFromTypes(format));
    }

    private static StructType structFromTypes(DataType[] format) {
        StructField[] fields = new StructField[format.length];
        int i = 0;
        for (DataType t : format) {
            fields[i++] = new StructField(String.valueOf(i), t, true, null);
        }
        return new StructType(fields);
    }

    private static StructType structFromAttributes(List<Attribute> format) {
        StructField[] fields = new StructField[format.size()];
        int i = 0;
        for (Attribute attribute : format) {
            fields[i++] = new StructField(attribute.name(), attribute.dataType(), attribute.nullable(), null);
        }
        return new StructType(fields);
    }

    public static Schema from(StructType input) {
        Schema.Builder builder = Schema.builder();
        input.foreach(f -> builder.column(GpuColumnVector.getNonNestedRapidsType(f.dataType()), f.name()));
        return builder.build();
    }

    public static Table from(ColumnarBatch batch) {
        return new Table(GpuColumnVector.extractBases(batch));
    }

    public static DataType[] extractTypes(ColumnarBatch batch) {
        DataType[] ret = new DataType[batch.numCols()];
        for (int i = 0; i < batch.numCols(); ++i) {
            ret[i] = batch.column(i).dataType();
        }
        return ret;
    }

    public static DataType[] extractTypes(StructType st) {
        DataType[] ret = new DataType[st.size()];
        for (int i = 0; i < st.size(); ++i) {
            ret[i] = st.apply(i).dataType();
        }
        return ret;
    }

    public static ColumnarBatch from(Table table, DataType[] colTypes) {
        return GpuColumnVector.from(table, colTypes, 0, table.getNumberOfColumns());
    }

    static boolean typeConversionAllowed(ColumnView cv, DataType colType) {
        DType dt = cv.getType();
        if (!dt.isNestedType()) {
            return GpuColumnVector.getNonNestedRapidsType(colType).equals((Object)dt);
        }
        if (colType instanceof MapType) {
            MapType mType = (MapType)colType;
            if (!dt.equals((Object)DType.LIST)) {
                return false;
            }
            try (ColumnView structCv = cv.getChildColumnView(0);){
                boolean bl;
                block54: {
                    if (!structCv.getType().equals((Object)DType.STRUCT)) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    if (structCv.getNumChildren() != 2) {
                        boolean bl3 = false;
                        return bl3;
                    }
                    try (ColumnView keyCv = structCv.getChildColumnView(0);){
                        if (!GpuColumnVector.typeConversionAllowed(keyCv, mType.keyType())) {
                            boolean bl4 = false;
                            return bl4;
                        }
                    }
                    ColumnView valCv = structCv.getChildColumnView(1);
                    try {
                        bl = GpuColumnVector.typeConversionAllowed(valCv, mType.valueType());
                        if (valCv == null) break block54;
                    }
                    catch (Throwable throwable) {
                        if (valCv != null) {
                            try {
                                valCv.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    valCv.close();
                }
                return bl;
            }
        }
        if (colType instanceof ArrayType) {
            if (!dt.equals((Object)DType.LIST)) {
                return false;
            }
            try (ColumnView tmp = cv.getChildColumnView(0);){
                boolean structCv = GpuColumnVector.typeConversionAllowed(tmp, ((ArrayType)colType).elementType());
                return structCv;
            }
        }
        if (colType instanceof StructType) {
            if (!dt.equals((Object)DType.STRUCT)) {
                return false;
            }
            StructType st = (StructType)colType;
            int numChildren = cv.getNumChildren();
            if (numChildren != st.size()) {
                return false;
            }
            for (int childIndex = 0; childIndex < numChildren; ++childIndex) {
                try (ColumnView tmp = cv.getChildColumnView(childIndex);){
                    StructField entry = ((StructType)colType).apply(childIndex);
                    if (GpuColumnVector.typeConversionAllowed(tmp, entry.dataType())) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            return true;
        }
        if (colType instanceof BinaryType) {
            if (!dt.equals((Object)DType.LIST)) {
                return false;
            }
            try (ColumnView tmp = cv.getChildColumnView(0);){
                DType tmpType = tmp.getType();
                boolean bl = tmpType.equals((Object)DType.INT8) || tmpType.equals((Object)DType.UINT8);
                return bl;
            }
        }
        return false;
    }

    static boolean typeConversionAllowed(Table table, DataType[] colTypes, int startCol, int endCol) {
        int numColumns = endCol - startCol;
        assert (numColumns == colTypes.length) : "The number of columns and the number of types don't match. Expected " + colTypes.length + " but found " + numColumns + ". (" + table + " columns " + startCol + " - " + endCol + " vs " + Arrays.toString(colTypes) + ")";
        boolean ret = true;
        for (int colIndex = startCol; colIndex < endCol; ++colIndex) {
            boolean t = GpuColumnVector.typeConversionAllowed((ColumnView)table.getColumn(colIndex), colTypes[colIndex - startCol]);
            ret = ret && t;
        }
        return ret;
    }

    static boolean typeConversionAllowed(Table table, DataType[] colTypes) {
        int numColumns = table.getNumberOfColumns();
        assert (numColumns == colTypes.length) : "The number of columns and the number of types don't match " + table + " " + Arrays.toString(colTypes);
        boolean ret = true;
        for (int colIndex = 0; colIndex < numColumns; ++colIndex) {
            ret = ret && GpuColumnVector.typeConversionAllowed((ColumnView)table.getColumn(colIndex), colTypes[colIndex]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColumnarBatch from(Table table, DataType[] colTypes, int startColIndex, int untilColIndex) {
        assert (table != null) : "Table cannot be null";
        assert (GpuColumnVector.typeConversionAllowed(table, colTypes, startColIndex, untilColIndex)) : "Type conversion is not allowed from " + table + " to " + Arrays.toString(colTypes) + " columns " + startColIndex + " to " + untilColIndex;
        int numColumns = untilColIndex - startColIndex;
        ColumnVector[] columns = new ColumnVector[numColumns];
        int finalLoc = 0;
        boolean success = false;
        try {
            for (int i = startColIndex; i < untilColIndex; ++i) {
                columns[finalLoc] = GpuColumnVector.from(table.getColumn(i).incRefCount(), colTypes[i - startColIndex]);
                ++finalLoc;
            }
            long rows = table.getRowCount();
            if (rows != (long)((int)rows)) {
                throw new IllegalStateException("Cannot support a batch larger that MAX INT rows");
            }
            ColumnarBatch ret = new ColumnarBatch(columns, (int)rows);
            success = true;
            ColumnarBatch columnarBatch = ret;
            return columnarBatch;
        }
        finally {
            if (!success) {
                for (ColumnVector cv : columns) {
                    if (cv == null) continue;
                    cv.close();
                }
            }
        }
    }

    public static GpuColumnVector from(ai.rapids.cudf.ColumnVector cudfCv, DataType type) {
        assert (GpuColumnVector.typeConversionAllowed((ColumnView)cudfCv, type)) : "Type conversion is not allowed from " + GpuColumnVector.buildColumnTypeString((ColumnView)cudfCv) + " to " + type + " expected " + GpuColumnVector.buildColumnTypeString(type);
        return new GpuColumnVector(type, cudfCv);
    }

    private static String buildColumnTypeString(ColumnView view) {
        DType type = view.getType();
        if (type.isNestedType()) {
            StringBuilder sb = new StringBuilder(type.toString());
            sb.append("(");
            for (int i = 0; i < view.getNumChildren(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                try (ColumnView childView = view.getChildColumnView(i);){
                    sb.append(GpuColumnVector.buildColumnTypeString(childView));
                    continue;
                }
            }
            sb.append(")");
            return sb.toString();
        }
        return type.toString();
    }

    private static String buildColumnTypeString(DataType sparkType) {
        DType dtype = GpuColumnVector.toRapidsOrNull(sparkType);
        if (dtype != null) {
            return dtype.toString();
        }
        StringBuilder sb = new StringBuilder();
        if (sparkType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)sparkType;
            sb.append("LIST(");
            sb.append(GpuColumnVector.buildColumnTypeString(arrayType.elementType()));
            sb.append(")");
        } else if (sparkType instanceof MapType) {
            MapType mapType = (MapType)sparkType;
            sb.append("LIST(STRUCT(");
            sb.append(GpuColumnVector.buildColumnTypeString(mapType.keyType()));
            sb.append(",");
            sb.append(GpuColumnVector.buildColumnTypeString(mapType.valueType()));
            sb.append("))");
        } else if (sparkType instanceof StructType) {
            StructType structType = (StructType)sparkType;
            sb.append(structType.iterator().map(f -> GpuColumnVector.buildColumnTypeString(f.dataType())).mkString("STRUCT(", ",", ")"));
        } else {
            throw new IllegalArgumentException("Unexpected data type: " + sparkType);
        }
        return sb.toString();
    }

    public static GpuColumnVector fromChecked(ai.rapids.cudf.ColumnVector cudfCv, DataType type) {
        if (!GpuColumnVector.typeConversionAllowed((ColumnView)cudfCv, type)) {
            throw new IllegalArgumentException("Type conversion error to " + type + ": expected cudf type " + GpuColumnVector.buildColumnTypeString(type) + " found cudf type " + GpuColumnVector.buildColumnTypeString((ColumnView)cudfCv));
        }
        return new GpuColumnVector(type, cudfCv);
    }

    public static GpuColumnVector from(Scalar scalar, int count, DataType sparkType) {
        return GpuColumnVector.from(ai.rapids.cudf.ColumnVector.fromScalar((Scalar)scalar, (int)count), sparkType);
    }

    public static GpuColumnVector from(GpuScalar scalar, int count, DataType sparkType) {
        return GpuColumnVector.from(ai.rapids.cudf.ColumnVector.fromScalar((Scalar)scalar.getBase(), (int)count), sparkType);
    }

    public static ai.rapids.cudf.ColumnVector columnVectorFromNull(int count, DataType sparkType) {
        try (Scalar s = GpuScalar.from(null, sparkType);){
            ai.rapids.cudf.ColumnVector columnVector = ai.rapids.cudf.ColumnVector.fromScalar((Scalar)s, (int)count);
            return columnVector;
        }
    }

    public static GpuColumnVector fromNull(int count, DataType sparkType) {
        return GpuColumnVector.from(GpuColumnVector.columnVectorFromNull(count, sparkType), sparkType);
    }

    public static ai.rapids.cudf.ColumnVector[] extractBases(ColumnarBatch batch) {
        int numColumns = batch.numCols();
        ai.rapids.cudf.ColumnVector[] vectors = new ai.rapids.cudf.ColumnVector[numColumns];
        for (int i = 0; i < vectors.length; ++i) {
            vectors[i] = ((GpuColumnVector)batch.column(i)).getBase();
        }
        return vectors;
    }

    public static ColumnarBatch tagAsFinalBatch(ColumnarBatch batch) {
        int numCols = batch.numCols();
        for (int col = 0; col < numCols; ++col) {
            ((GpuColumnVectorBase)batch.column(col)).setFinalBatch(true);
        }
        return batch;
    }

    public static boolean isTaggedAsFinalBatch(ColumnarBatch batch) {
        int numCols = batch.numCols();
        if (numCols <= 0) {
            return false;
        }
        for (int col = 0; col < numCols; ++col) {
            if (((GpuColumnVectorBase)batch.column(col)).isKnownFinalBatch()) continue;
            return false;
        }
        return true;
    }

    public static ColumnarBatch incRefCounts(ColumnarBatch batch) {
        for (ai.rapids.cudf.ColumnVector cv : GpuColumnVector.extractBases(batch)) {
            cv.incRefCount();
        }
        return batch;
    }

    public static ColumnarBatch combineColumns(ColumnarBatch ... batches) {
        boolean isFirst = true;
        int numRows = 0;
        ArrayList<ColumnVector> columns = new ArrayList<ColumnVector>();
        for (ColumnarBatch cb : batches) {
            if (isFirst) {
                numRows = cb.numRows();
                isFirst = false;
            } else assert (cb.numRows() == numRows) : "Rows do not match expected " + numRows + " found " + cb.numRows();
            int numColumns = cb.numCols();
            for (int i = 0; i < numColumns; ++i) {
                columns.add(cb.column(i));
            }
        }
        ColumnarBatch ret = new ColumnarBatch(columns.toArray(new ColumnVector[columns.size()]), numRows);
        return GpuColumnVector.incRefCounts(ret);
    }

    public static GpuColumnVector[] extractColumns(ColumnarBatch batch) {
        int numColumns = batch.numCols();
        GpuColumnVector[] vectors = new GpuColumnVector[numColumns];
        for (int i = 0; i < vectors.length; ++i) {
            vectors[i] = (GpuColumnVector)batch.column(i);
        }
        return vectors;
    }

    public static GpuColumnVector[] extractColumns(Table table, DataType[] colType) {
        try (ColumnarBatch batch = GpuColumnVector.from(table, colType);){
            GpuColumnVector[] gpuColumnVectorArray = GpuColumnVector.extractColumns(batch);
            return gpuColumnVectorArray;
        }
    }

    public static int[] toIntArray(ai.rapids.cudf.ColumnVector vec) {
        assert (vec.getType() == DType.INT32);
        int rowCount = (int)vec.getRowCount();
        int[] output2 = new int[rowCount];
        try (HostColumnVector h = vec.copyToHost();){
            for (int i = 0; i < rowCount; ++i) {
                output2[i] = h.getInt((long)i);
            }
        }
        return output2;
    }

    GpuColumnVector(DataType type, ai.rapids.cudf.ColumnVector cudfCv) {
        super(type);
        this.cudfCv = cudfCv;
    }

    public final GpuColumnVector incRefCount() {
        this.cudfCv.incRefCount();
        return this;
    }

    public final void close() {
        this.cudfCv.close();
    }

    public final boolean hasNull() {
        return this.cudfCv.hasNulls();
    }

    public final int numNulls() {
        return (int)this.cudfCv.getNullCount();
    }

    public static long getTotalDeviceMemoryUsed(ColumnarBatch batch) {
        long sum = 0L;
        if (batch.numCols() > 0) {
            if (batch.column(0) instanceof WithTableBuffer) {
                WithTableBuffer wtb = (WithTableBuffer)batch.column(0);
                sum += wtb.getTableBuffer().getLength();
            } else {
                HashSet<Long> found = new HashSet<Long>();
                for (int i = 0; i < batch.numCols(); ++i) {
                    ai.rapids.cudf.ColumnVector cv = ((GpuColumnVector)batch.column(i)).getBase();
                    long id = cv.getNativeView();
                    if (!found.add(id)) continue;
                    sum += cv.getDeviceMemorySize();
                }
            }
        }
        return sum;
    }

    public static long getTotalDeviceMemoryUsed(GpuColumnVector[] vectors) {
        long sum = 0L;
        HashSet<Long> found = new HashSet<Long>();
        for (GpuColumnVector vector : vectors) {
            ai.rapids.cudf.ColumnVector cv = vector.getBase();
            long id = cv.getNativeView();
            if (!found.add(id)) continue;
            sum += cv.getDeviceMemorySize();
        }
        return sum;
    }

    public static long getTotalDeviceMemoryUsed(Table table) {
        long sum = 0L;
        int len = table.getNumberOfColumns();
        HashSet<Long> found = new HashSet<Long>();
        for (int i = 0; i < len; ++i) {
            ai.rapids.cudf.ColumnVector cv = table.getColumn(i);
            long id = cv.getNativeView();
            if (!found.add(id)) continue;
            sum += cv.getDeviceMemorySize();
        }
        return sum;
    }

    public final ai.rapids.cudf.ColumnVector getBase() {
        return this.cudfCv;
    }

    public final long getRowCount() {
        return this.cudfCv.getRowCount();
    }

    public final RapidsHostColumnVector copyToHost() {
        return new RapidsHostColumnVector(this.type, this.cudfCv.copyToHost());
    }

    public final RapidsNullSafeHostColumnVector copyToNullSafeHost() {
        return new RapidsNullSafeHostColumnVector(this.copyToHost());
    }

    public final String toString() {
        return this.getBase().toString();
    }

    private static final class ArrowBufReferenceHolder {
        private final List<ReferenceManager> references = new ArrayList<ReferenceManager>();

        private ArrowBufReferenceHolder() {
        }

        public void addReferences(List<ReferenceManager> refs) {
            this.references.addAll(refs);
            refs.forEach(ReferenceManager::retain);
        }

        public void releaseReferences() {
            if (this.references.isEmpty()) {
                return;
            }
            for (ReferenceManager ref : this.references) {
                ref.release();
            }
            this.references.clear();
        }
    }

    public static final class GpuColumnarBatchBuilder
    extends GpuColumnarBatchBuilderBase {
        private final HostColumnVector.ColumnBuilder[] builders;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GpuColumnarBatchBuilder(StructType schema, int rows) {
            this.fields = schema.fields();
            int len = this.fields.length;
            this.builders = new HostColumnVector.ColumnBuilder[len];
            boolean success = false;
            try {
                for (int i = 0; i < len; ++i) {
                    StructField field = this.fields[i];
                    this.builders[i] = new HostColumnVector.ColumnBuilder(GpuColumnVector.convertFrom(field.dataType(), field.nullable()), (long)rows);
                }
                success = true;
            }
            finally {
                if (!success) {
                    for (HostColumnVector.ColumnBuilder b : this.builders) {
                        if (b == null) continue;
                        b.close();
                    }
                }
            }
        }

        @Override
        public void copyColumnar(ColumnVector cv, int colNum, boolean nullable, int rows) {
            HostColumnarToGpu.columnarCopy(cv, this.builder(colNum), rows);
        }

        public HostColumnVector.ColumnBuilder builder(int i) {
            return this.builders[i];
        }

        @Override
        protected int buildersLength() {
            return this.builders.length;
        }

        @Override
        protected ColumnVector buildAndPutOnDevice(int builderIndex) {
            ai.rapids.cudf.ColumnVector cv = this.builders[builderIndex].buildAndPutOnDevice();
            GpuColumnVector gcv = new GpuColumnVector(this.fields[builderIndex].dataType(), cv);
            this.builders[builderIndex] = null;
            return gcv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HostColumnVector[] buildHostColumns() {
            HostColumnVector[] vectors = new HostColumnVector[this.builders.length];
            try {
                for (int i = 0; i < this.builders.length; ++i) {
                    vectors[i] = this.builders[i].build();
                    this.builders[i] = null;
                }
                HostColumnVector[] result = vectors;
                vectors = null;
                HostColumnVector[] hostColumnVectorArray = result;
                return hostColumnVectorArray;
            }
            finally {
                if (vectors != null) {
                    for (HostColumnVector v : vectors) {
                        if (v == null) continue;
                        v.close();
                    }
                }
            }
        }

        @Override
        public void close() {
            for (HostColumnVector.ColumnBuilder b : this.builders) {
                if (b == null) continue;
                b.close();
            }
        }
    }

    public static final class GpuArrowColumnarBatchBuilder
    extends GpuColumnarBatchBuilderBase {
        private final ArrowColumnBuilder[] builders;
        private final ArrowBufReferenceHolder[] referenceHolders;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GpuArrowColumnarBatchBuilder(StructType schema) {
            this.fields = schema.fields();
            int len = this.fields.length;
            this.builders = new ArrowColumnBuilder[len];
            this.referenceHolders = new ArrowBufReferenceHolder[len];
            boolean success = false;
            try {
                for (int i = 0; i < len; ++i) {
                    StructField field = this.fields[i];
                    this.builders[i] = new ArrowColumnBuilder(GpuColumnVector.convertFrom(field.dataType(), field.nullable()));
                    this.referenceHolders[i] = new ArrowBufReferenceHolder();
                }
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        @Override
        protected int buildersLength() {
            return this.builders.length;
        }

        @Override
        protected ColumnVector buildAndPutOnDevice(int builderIndex) {
            ai.rapids.cudf.ColumnVector cv = this.builders[builderIndex].buildAndPutOnDevice();
            GpuColumnVector gcv = new GpuColumnVector(this.fields[builderIndex].dataType(), cv);
            this.referenceHolders[builderIndex].releaseReferences();
            this.builders[builderIndex] = null;
            return gcv;
        }

        @Override
        public void copyColumnar(ColumnVector cv, int colNum, boolean ignored, int rows) {
            this.referenceHolders[colNum].addReferences(HostColumnarToGpu.arrowColumnarCopy(cv, this.builder(colNum), rows));
        }

        public ArrowColumnBuilder builder(int i) {
            return this.builders[i];
        }

        @Override
        public void close() {
            for (ArrowColumnBuilder arrowColumnBuilder : this.builders) {
                if (arrowColumnBuilder == null) continue;
                arrowColumnBuilder.close();
            }
            for (ArrowBufReferenceHolder arrowBufReferenceHolder : this.referenceHolders) {
                arrowBufReferenceHolder.releaseReferences();
            }
        }
    }

    public static abstract class GpuColumnarBatchBuilderBase
    implements AutoCloseable {
        protected StructField[] fields;

        @Override
        public abstract void close();

        public abstract void copyColumnar(ColumnVector var1, int var2, boolean var3, int var4);

        protected abstract ColumnVector buildAndPutOnDevice(int var1);

        protected abstract int buildersLength();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ColumnarBatch build(int rows) {
            int buildersLen = this.buildersLength();
            ColumnVector[] vectors = new ColumnVector[buildersLen];
            boolean success = false;
            try {
                for (int i = 0; i < buildersLen; ++i) {
                    vectors[i] = this.buildAndPutOnDevice(i);
                }
                ColumnarBatch ret = new ColumnarBatch(vectors, rows);
                success = true;
                ColumnarBatch columnarBatch = ret;
                return columnarBatch;
            }
            finally {
                if (!success) {
                    for (ColumnVector vec : vectors) {
                        if (vec == null) continue;
                        vec.close();
                    }
                }
            }
        }
    }
}

