/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.GpuColumnVector;
import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecializedGettersReader;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public final class CudfUnsafeRow
extends InternalRow {
    private long address;
    private int[] startOffsets;
    private int fixedWidthSizeInBytes;
    private int sizeInBytes;
    private int[] remapping;

    public static int alignOffset(int offset, int alignment) {
        return offset + alignment - 1 & -alignment;
    }

    public static int calculateBitSetWidthInBytes(int numFields) {
        return (numFields + 7) / 8;
    }

    public static int getRowSizeEstimate(Attribute[] attributes) {
        int offset = 0;
        for (Attribute attr : attributes) {
            int length = GpuColumnVector.getNonNestedRapidsType(attr.dataType()).getSizeInBytes();
            offset = CudfUnsafeRow.alignOffset(offset, length);
            offset += length;
        }
        int bitSetWidthInBytes = CudfUnsafeRow.calculateBitSetWidthInBytes(attributes.length);
        return CudfUnsafeRow.alignOffset(offset + bitSetWidthInBytes, 8);
    }

    private long getFieldAddressFromOrdinal(int ordinal) {
        this.assertIndexIsValid(ordinal);
        int i = this.remapping[ordinal];
        return this.address + (long)this.startOffsets[i];
    }

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.startOffsets.length) : "index (" + index + ") should < " + this.startOffsets.length;
    }

    public CudfUnsafeRow(Attribute[] attributes, int[] remapping) {
        int offset = 0;
        this.startOffsets = new int[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attr = attributes[i];
            int length = GpuColumnVector.getNonNestedRapidsType(attr.dataType()).getSizeInBytes();
            assert (length > 0) : "Only fixed width types are currently supported.";
            this.startOffsets[i] = offset = CudfUnsafeRow.alignOffset(offset, length);
            offset += length;
        }
        this.fixedWidthSizeInBytes = offset;
        this.remapping = remapping;
        assert (this.startOffsets.length == remapping.length);
    }

    public CudfUnsafeRow() {
    }

    public int numFields() {
        return this.startOffsets.length;
    }

    public void pointTo(long address, int sizeInBytes) {
        assert (this.startOffsets != null && this.startOffsets.length > 0) : "startOffsets not properly initialized";
        assert (sizeInBytes % 8 == 0) : "sizeInBytes (" + sizeInBytes + ") should be a multiple of 8";
        this.address = address;
        this.sizeInBytes = sizeInBytes;
    }

    public void update(int ordinal, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object get(int ordinal, DataType dataType) {
        return SpecializedGettersReader.read((SpecializedGetters)this, (int)ordinal, (DataType)dataType, (boolean)true, (boolean)true);
    }

    public boolean isNullAt(int ordinal) {
        int i = this.remapping[ordinal];
        this.assertIndexIsValid(i);
        int validByteIndex = i / 8;
        int validBitIndex = i % 8;
        byte b = Platform.getByte(null, (long)(this.address + (long)this.fixedWidthSizeInBytes + (long)validByteIndex));
        return (1 << validBitIndex & b) == 0;
    }

    public void setNullAt(int ordinal) {
        int i = this.remapping[ordinal];
        this.assertIndexIsValid(i);
        int validByteIndex = i / 8;
        int validBitIndex = i % 8;
        byte b = Platform.getByte(null, (long)(this.address + (long)this.fixedWidthSizeInBytes + (long)validByteIndex));
        b = (byte)(b & ~(1 << validBitIndex) & 0xFF);
        Platform.putByte(null, (long)(this.address + (long)this.fixedWidthSizeInBytes + (long)validByteIndex), (byte)b);
    }

    public boolean getBoolean(int ordinal) {
        return Platform.getBoolean(null, (long)this.getFieldAddressFromOrdinal(ordinal));
    }

    public byte getByte(int ordinal) {
        return Platform.getByte(null, (long)this.getFieldAddressFromOrdinal(ordinal));
    }

    public short getShort(int ordinal) {
        return Platform.getShort(null, (long)this.getFieldAddressFromOrdinal(ordinal));
    }

    public int getInt(int ordinal) {
        return Platform.getInt(null, (long)this.getFieldAddressFromOrdinal(ordinal));
    }

    public long getLong(int ordinal) {
        return Platform.getLong(null, (long)this.getFieldAddressFromOrdinal(ordinal));
    }

    public float getFloat(int ordinal) {
        return Platform.getFloat(null, (long)this.getFieldAddressFromOrdinal(ordinal));
    }

    public double getDouble(int ordinal) {
        return Platform.getDouble(null, (long)this.getFieldAddressFromOrdinal(ordinal));
    }

    public Decimal getDecimal(int ordinal, int precision, int scale) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        if (precision <= Decimal.MAX_INT_DIGITS()) {
            return Decimal.createUnsafe((long)this.getInt(ordinal), (int)precision, (int)scale);
        }
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            return Decimal.createUnsafe((long)this.getLong(ordinal), (int)precision, (int)scale);
        }
        throw new IllegalArgumentException("NOT IMPLEMENTED YET");
    }

    public UTF8String getUTF8String(int ordinal) {
        throw new IllegalArgumentException("NOT IMPLEMENTED YET");
    }

    public byte[] getBinary(int ordinal) {
        throw new IllegalArgumentException("NOT IMPLEMENTED YET");
    }

    public CalendarInterval getInterval(int ordinal) {
        throw new IllegalArgumentException("NOT IMPLEMENTED YET");
    }

    public CudfUnsafeRow getStruct(int ordinal, int numFields) {
        throw new IllegalArgumentException("NOT IMPLEMENTED YET");
    }

    public ArrayData getArray(int ordinal) {
        throw new IllegalArgumentException("NOT IMPLEMENTED YET");
    }

    public MapData getMap(int ordinal) {
        throw new IllegalArgumentException("NOT IMPLEMENTED YET");
    }

    public CudfUnsafeRow copy() {
        throw new IllegalArgumentException("NOT IMPLEMENTED YET");
    }

    public int hashCode() {
        return Murmur3_x86_32.hashUnsafeWords(null, (long)this.address, (int)this.sizeInBytes, (int)42);
    }

    public boolean equals(Object other) {
        if (other instanceof CudfUnsafeRow) {
            CudfUnsafeRow o = (CudfUnsafeRow)((Object)other);
            return this.sizeInBytes == o.sizeInBytes && ByteArrayMethods.arrayEquals(null, (long)this.address, null, (long)o.address, (long)this.sizeInBytes) && Arrays.equals(this.remapping, o.remapping);
        }
        return false;
    }

    public String toString() {
        StringBuilder build = new StringBuilder("[");
        for (int i = 0; i < this.sizeInBytes; i += 8) {
            if (i != 0) {
                build.append(',');
            }
            build.append(Long.toHexString(Platform.getLong(null, (long)(this.address + (long)i))));
        }
        build.append(']');
        build.append(" remapped with ");
        build.append(Arrays.toString(this.remapping));
        return build.toString();
    }

    public boolean anyNull() {
        throw new IllegalArgumentException("NOT IMPLEMENTED YET");
    }
}

