/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.BaseExprMeta;
import com.nvidia.spark.rapids.CostModel;
import com.nvidia.spark.rapids.MemoryCostHelper$;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RowCountPlanVisitor$;
import com.nvidia.spark.rapids.SparkPlanMeta;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0002\u0004\u0001\u001f!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003\u001f\u0001\u0011\u0005q\u0004C\u0003#\u0001\u0011\u00051\u0005C\u00039\u0001\u0011%\u0011H\u0001\u0007DaV\u001cun\u001d;N_\u0012,GN\u0003\u0002\b\u0011\u00051!/\u00199jINT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011A\u00028wS\u0012L\u0017MC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]AR\"\u0001\u0004\n\u0005e1!!C\"pgRlu\u000eZ3m\u0003\u0011\u0019wN\u001c4\u0011\u0005]a\u0012BA\u000f\u0007\u0005)\u0011\u0016\r]5eg\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0001\n\u0003CA\f\u0001\u0011\u0015Q\"\u00011\u0001\u001c\u0003\u001d9W\r^\"pgR$\"\u0001J\u0014\u0011\u0005E)\u0013B\u0001\u0014\u0013\u0005\u0019!u.\u001e2mK\")\u0001f\u0001a\u0001S\u0005!\u0001\u000f\\1oa\tQs\u0006E\u0002\u0018W5J!\u0001\f\u0004\u0003\u001bM\u0003\u0018M]6QY\u0006tW*\u001a;b!\tqs\u0006\u0004\u0001\u0005\u0013A:\u0013\u0011!A\u0001\u0006\u0003\t$aA0%kE\u0011!'\u000e\t\u0003#MJ!\u0001\u000e\n\u0003\u000f9{G\u000f[5oOB\u0011\u0011CN\u0005\u0003oI\u00111!\u00118z\u0003!)\u0007\u0010\u001d:D_N$XC\u0001\u001eB)\r!3h\u0015\u0005\u0006y\u0011\u0001\r!P\u0001\u0005Kb\u0004(\u000fE\u0002\u0018}\u0001K!a\u0010\u0004\u0003\u0019\t\u000b7/Z#yaJlU\r^1\u0011\u00059\nE!\u0002\"\u0005\u0005\u0004\u0019%!B%O!V#\u0016C\u0001\u001aE!\t)\u0015+D\u0001G\u0015\t9\u0005*A\u0006fqB\u0014Xm]:j_:\u001c(BA%K\u0003!\u0019\u0017\r^1msN$(BA&M\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00135S!AT(\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0016aA8sO&\u0011!K\u0012\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\"\u0002+\u0005\u0001\u0004!\u0013\u0001\u0003:po\u000e{WO\u001c;")
public class CpuCostModel
implements CostModel {
    private final RapidsConf conf;

    @Override
    public double getCost(SparkPlanMeta<?> plan) {
        double rowCount = BoxesRunTime.unboxToDouble((Object)RowCountPlanVisitor$.MODULE$.visit(plan).map((Function1 & java.io.Serializable & Serializable)x$8 -> BoxesRunTime.boxToDouble((double)x$8.toDouble())).getOrElse((Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> $this.conf.defaultRowCount()));
        double operatorCost = BoxesRunTime.unboxToDouble((Object)plan.conf().getCpuOperatorCost(plan.wrapped().getClass().getSimpleName()).getOrElse((Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> $this.conf.defaultCpuOperatorCost())) * rowCount;
        double exprEvalCost = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)plan.childExprs().map((Function1 & java.io.Serializable & Serializable)expr -> BoxesRunTime.boxToDouble((double)this.exprCost(expr, rowCount)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return operatorCost + exprEvalCost;
    }

    private <INPUT extends Expression> double exprCost(BaseExprMeta<INPUT> expr, double rowCount) {
        double d;
        if (MemoryCostHelper$.MODULE$.isExcludedFromCost(expr)) {
            return 0.0;
        }
        Expression expression = (Expression)expr.wrapped();
        if (expression instanceof Alias) {
            d = this.exprCost((BaseExprMeta)expr.childExprs().head(), rowCount);
        } else {
            boolean bl = expression instanceof AttributeReference ? true : expression instanceof GetStructField;
            d = bl ? MemoryCostHelper$.MODULE$.calculateCost(MemoryCostHelper$.MODULE$.estimateGpuMemory(expr.typeMeta().dataType(), false, rowCount), this.conf.cpuReadMemorySpeed()) : BoxesRunTime.unboxToDouble((Object)((TraversableOnce)expr.childExprs().map((Function1 & java.io.Serializable & Serializable)e -> BoxesRunTime.boxToDouble((double)this.exprCost(e, rowCount)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        }
        double memoryReadCost = d;
        double memoryWriteCost = MemoryCostHelper$.MODULE$.calculateCost(MemoryCostHelper$.MODULE$.estimateGpuMemory(expr.typeMeta().dataType(), false, rowCount), this.conf.cpuWriteMemorySpeed());
        double exprEvalCost = rowCount * BoxesRunTime.unboxToDouble((Object)expr.conf().getCpuExpressionCost(expr.getClass().getSimpleName()).getOrElse((Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> $this.conf.defaultCpuExpressionCost()));
        return exprEvalCost + memoryReadCost + memoryWriteCost;
    }

    public CpuCostModel(RapidsConf conf) {
        this.conf = conf;
    }
}

