/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.DType;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.RapidsBuffer;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;

public final class BoolUtils$
implements Arm {
    public static BoolUtils$ MODULE$;

    static {
        new BoolUtils$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public boolean isAllValidTrue(ColumnVector col) {
        DType dType = DType.BOOL8;
        DType dType2 = col.getType();
        Predef$.MODULE$.assert(!(dType != null ? !dType.equals(dType2) : dType2 != null), (Function0 & java.io.Serializable & Serializable)() -> "input column type is not bool");
        if (col.getRowCount() == 0L) {
            return true;
        }
        if (col.getRowCount() == col.getNullCount()) {
            return true;
        }
        return BoxesRunTime.unboxToBoolean(this.withResource(col.all(), (Function1 & java.io.Serializable & Serializable)allTrue -> BoxesRunTime.boxToBoolean((boolean)allTrue.getBoolean())));
    }

    public boolean isAnyValidTrue(ColumnVector col) {
        DType dType = DType.BOOL8;
        DType dType2 = col.getType();
        Predef$.MODULE$.assert(!(dType != null ? !dType.equals(dType2) : dType2 != null), (Function0 & java.io.Serializable & Serializable)() -> "input column type is not bool");
        if (col.getRowCount() == col.getNullCount()) {
            return false;
        }
        return BoxesRunTime.unboxToBoolean(this.withResource(col.any(), (Function1 & java.io.Serializable & Serializable)anyTrue -> BoxesRunTime.boxToBoolean((boolean)anyTrue.getBoolean())));
    }

    private BoolUtils$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

