/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import ai.rapids.cudf.nvcomp.BatchedLZ4Decompressor;
import com.nvidia.spark.rapids.BatchedBufferDecompressor;
import com.nvidia.spark.rapids.RapidsPluginImplicits$;
import com.nvidia.spark.rapids.TableCompressionCodecConfig;
import com.nvidia.spark.rapids.format.BufferMeta;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0003\u0006\u0001'!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011!\u0019\u0003A!A!\u0002\u0013!\u0003\"B\u0019\u0001\t\u0003\u0011\u0004bB\u001c\u0001\u0005\u0004%\t\u0005\u000f\u0005\u0007y\u0001\u0001\u000b\u0011B\u001d\t\u000bu\u0002A\u0011\t \t\u000bU\u0003A\u0011\u0002,\u00039\t\u000bGo\u00195fI:38m\\7q\u0019j#D)Z2p[B\u0014Xm]:pe*\u00111\u0002D\u0001\u0007e\u0006\u0004\u0018\u000eZ:\u000b\u00055q\u0011!B:qCJ\\'BA\b\u0011\u0003\u0019qg/\u001b3jC*\t\u0011#A\u0002d_6\u001c\u0001a\u0005\u0002\u0001)A\u0011QCF\u0007\u0002\u0015%\u0011qC\u0003\u0002\u001a\u0005\u0006$8\r[3e\u0005V4g-\u001a:EK\u000e|W\u000e\u001d:fgN|'/\u0001\bnCb\u0014\u0015\r^2i\u001b\u0016lwN]=\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\t1{gnZ\u0001\rG>$WmY\"p]\u001aLwm\u001d\t\u0003+\u0005J!A\t\u0006\u00037Q\u000b'\r\\3D_6\u0004(/Z:tS>t7i\u001c3fG\u000e{gNZ5h\u0003\u0019\u0019HO]3b[B\u0011QE\f\b\u0003M1j\u0011a\n\u0006\u0003Q%\nAaY;eM*\u00111B\u000b\u0006\u0002W\u0005\u0011\u0011-[\u0005\u0003[\u001d\nAaQ;eC&\u0011q\u0006\r\u0002\u0007'R\u0014X-Y7\u000b\u00055:\u0013A\u0002\u001fj]&$h\b\u0006\u00034iU2\u0004CA\u000b\u0001\u0011\u0015AB\u00011\u0001\u001a\u0011\u0015yB\u00011\u0001!\u0011\u0015\u0019C\u00011\u0001%\u0003\u001d\u0019w\u000eZ3d\u0013\u0012,\u0012!\u000f\t\u00035iJ!aO\u000e\u0003\t\tKH/Z\u0001\tG>$WmY%eA\u0005yA-Z2p[B\u0014Xm]:Bgft7\r\u0006\u0003@\u000b.#\u0006c\u0001\u000eA\u0005&\u0011\u0011i\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003M\rK!\u0001R\u0014\u0003%\u0011+g/[2f\u001b\u0016lwN]=Ck\u001a4WM\u001d\u0005\u0006\r\u001e\u0001\raR\u0001\rS:\u0004X\u000f\u001e\"vM\u001a,'o\u001d\t\u00045\u0001C\u0005C\u0001\u0014J\u0013\tQuE\u0001\fCCN,G)\u001a<jG\u0016lU-\\8ss\n+hMZ3s\u0011\u0015au\u00011\u0001N\u0003-\u0011WO\u001a4fe6+G/Y:\u0011\u0007i\u0001e\n\u0005\u0002P%6\t\u0001K\u0003\u0002R\u0015\u00051am\u001c:nCRL!a\u0015)\u0003\u0015\t+hMZ3s\u001b\u0016$\u0018\rC\u0003$\u000f\u0001\u0007A%A\u000bbY2|7-\u0019;f\u001fV$\b/\u001e;Ck\u001a4WM]:\u0015\u0007}:\u0006\fC\u0003G\u0011\u0001\u0007q\tC\u0003M\u0011\u0001\u0007Q\n")
public class BatchedNvcompLZ4Decompressor
extends BatchedBufferDecompressor {
    private final TableCompressionCodecConfig codecConfigs;
    private final byte codecId;

    @Override
    public byte codecId() {
        return this.codecId;
    }

    @Override
    public DeviceMemoryBuffer[] decompressAsync(BaseDeviceMemoryBuffer[] inputBuffers, BufferMeta[] bufferMetas, Cuda.Stream stream) {
        Predef$.MODULE$.require(inputBuffers.length == bufferMetas.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("number of input buffers (").append(inputBuffers.length).append(") does not equal number of metadata ").append("buffers (").append(bufferMetas.length).toString());
        DeviceMemoryBuffer[] outputBuffers = this.allocateOutputBuffers(inputBuffers, bufferMetas);
        BatchedLZ4Decompressor.decompressAsync((long)this.codecConfigs.lz4ChunkSize(), (BaseDeviceMemoryBuffer[])inputBuffers, (BaseDeviceMemoryBuffer[])((BaseDeviceMemoryBuffer[])outputBuffers), (Cuda.Stream)stream);
        return outputBuffers;
    }

    private DeviceMemoryBuffer[] allocateOutputBuffers(BaseDeviceMemoryBuffer[] inputBuffers, BufferMeta[] bufferMetas) {
        return (DeviceMemoryBuffer[])this.withResource(new NvtxRange("alloc output bufs", NvtxColor.YELLOW), (Function1 & Serializable & scala.Serializable)x$2 -> (DeviceMemoryBuffer[])RapidsPluginImplicits$.MODULE$.AutoCloseableProducingArray(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bufferMetas)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])inputBuffers), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).safeMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BufferMeta meta = (BufferMeta)tuple2._1();
            BaseDeviceMemoryBuffer input = (BaseDeviceMemoryBuffer)tuple2._2();
            input.incRefCount();
            DeviceMemoryBuffer deviceMemoryBuffer = DeviceMemoryBuffer.allocate((long)meta.uncompressedSize());
            return deviceMemoryBuffer;
        }, ClassTag$.MODULE$.apply(DeviceMemoryBuffer.class)));
    }

    public BatchedNvcompLZ4Decompressor(long maxBatchMemory, TableCompressionCodecConfig codecConfigs, Cuda.Stream stream) {
        this.codecConfigs = codecConfigs;
        super(maxBatchMemory, stream);
        this.codecId = 1;
    }
}

