/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.util;

import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRFSUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MapRFSUtil.class);
    private static MapRFileSystem fs;

    public static MapRFileSystem getMapRFileSystem() {
        if (fs == null) {
            Configuration c = new Configuration();
            c.set("fs.default.name", "maprfs:///");
            try {
                fs = new MapRFileSystem();
                URI uri = new URI(c.get("fs.default.name"));
                fs.initialize(uri, c);
            }
            catch (Exception e) {
                LOG.error("Encountered error while trying to initialize MapRFS", (Throwable)e);
            }
        }
        return fs;
    }

    public static boolean isDir(String path) {
        try {
            return !MapRFSUtil.getMapRFileSystem().isFile(new Path(path));
        }
        catch (IOException e) {
            LOG.error("Exception while checking if the path specified is a dir. path: " + path, (Throwable)e);
            return false;
        }
    }

    public static boolean pathExists(String path) {
        try {
            return MapRFSUtil.getMapRFileSystem().exists(new Path(path));
        }
        catch (IOException e) {
            LOG.error("Exception while checking for existence of path: " + path, (Throwable)e);
            return false;
        }
    }

    public static boolean create(String path, boolean isDir) {
        if (isDir) {
            try {
                return MapRFSUtil.getMapRFileSystem().mkdirs(new Path(path));
            }
            catch (IOException e) {
                LOG.error("Exception while creating dir: " + path, (Throwable)e);
            }
        } else {
            try {
                return MapRFSUtil.getMapRFileSystem().createNewFile(new Path(path));
            }
            catch (IOException e) {
                LOG.error("Exception while creating file: " + path, (Throwable)e);
            }
        }
        return false;
    }

    public static boolean delete(String path) {
        try {
            return MapRFSUtil.getMapRFileSystem().delete(new Path(path));
        }
        catch (IOException e) {
            LOG.error("Exception while deleting path: " + path, (Throwable)e);
            return false;
        }
    }
}

