/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.util.zookeeper;

import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.baseutils.zookeeper.ZKClosedException;
import com.mapr.baseutils.zookeeper.ZKUtils;
import com.mapr.fs.proto.Common;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ZKDataRetrieval
implements Watcher {
    private static final Logger LOG = Logger.getLogger(ZKDataRetrieval.class);
    public static final String CLDB_SERVICE_MASTER_PATH = "/datacenter/controlnodes/cldb/active/CLDBMaster";
    public static final String SERVER_PATH = "/servers";
    public static final String SERVICES_PATH = "/services";
    public static final String CONF_SERVICES_PATH = "/services_config";
    public static final int TIMEOUT_SERVER = 30000;
    private static final String CLDB_SERVICE_NAME = "cldb";
    private boolean watchRMHAZNode = false;
    private String rmHAZNodeToWatch = null;
    private byte[] rmHAZNodeData = null;
    private List<String> serversInfo = new Vector<String>();
    private Map<String, List<String>> configServicesMap = new ConcurrentHashMap<String, List<String>>();
    private Map<String, List<String>> servicesMap = new ConcurrentHashMap<String, List<String>>();
    private Map<String, Common.ServiceData> serviceToMasterMap = new ConcurrentHashMap<String, Common.ServiceData>();
    private Map<String, Map<String, Properties>> serviceToProperties = new ConcurrentHashMap<String, Map<String, Properties>>();
    private Map<String, Map<String, Common.ServiceData>> serviceToData = new ConcurrentHashMap<String, Map<String, Common.ServiceData>>();
    private CountDownLatch lock = new CountDownLatch(1);
    private volatile boolean isSessionExpired = false;
    private String zkConnectString;
    private ZooKeeper s_zk;

    public ZKDataRetrieval(String zkConnectString) {
        this.zkConnectString = zkConnectString;
        this.initThread();
    }

    public ZKDataRetrieval(String zkConnectString, String rmHAZNode) {
        this(zkConnectString);
        this.watchRMHAZNode = true;
        this.rmHAZNodeToWatch = rmHAZNode;
    }

    public String getZKString() {
        return this.zkConnectString;
    }

    public synchronized ZooKeeper getZKObject() {
        return this.s_zk;
    }

    private void init() {
        this.serversInfo = new Vector<String>();
        this.configServicesMap = new ConcurrentHashMap<String, List<String>>();
        this.servicesMap = new ConcurrentHashMap<String, List<String>>();
        this.serviceToMasterMap = new ConcurrentHashMap<String, Common.ServiceData>();
        if (this.zkConnectString == null) {
            LOG.fatal((Object)"Could not create ZooKeeper instance. Zookeeper connection string is missing");
            return;
        }
        try {
            this.s_zk = new ZooKeeper(this.zkConnectString, 30000, (Watcher)this);
            while (!this.lock.await(30000L, TimeUnit.MILLISECONDS)) {
                LOG.error((Object)("Could not connect to ZK within: 30000 ms. Check if ZK connection defined correctly: " + this.zkConnectString + ". No data from ZK will be returned."));
            }
            LOG.info((Object)("Connected to ZK: " + this.zkConnectString));
        }
        catch (IOException e) {
            LOG.fatal((Object)("Could not create ZooKeeper instance. Due to IOException. No data from ZK with connect string: " + this.zkConnectString + " will be returned."), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"InterruptedException during wait for ZK to be connected");
        }
    }

    private void initThread() {
        this.init();
        Thread reinitThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    ZooKeeper zooKeeper = ZKDataRetrieval.this.s_zk;
                    synchronized (zooKeeper) {
                        while (!ZKDataRetrieval.this.isSessionExpired) {
                            try {
                                ZKDataRetrieval.this.s_zk.wait();
                            }
                            catch (InterruptedException e) {
                                LOG.error((Object)("InterruptedException during wait for ZK for: " + ZKDataRetrieval.this.zkConnectString));
                            }
                        }
                    }
                    ZKDataRetrieval.this.zooKeeperReset();
                    ZKDataRetrieval.this.isSessionExpired = false;
                }
            }
        });
        reinitThread.setDaemon(true);
        reinitThread.start();
    }

    public Map<String, Map<String, Common.ServiceData>> getServiceToNodeMap() {
        this.getServicesMap();
        return this.serviceToData;
    }

    public Map<String, Common.ServiceData> getServiceToMasterMap() {
        this.getServicesMap();
        return this.serviceToMasterMap;
    }

    public Map<String, Map<String, Properties>> getServiceToPropertiesMap() {
        this.getConfigServicesMap();
        return this.serviceToProperties;
    }

    public byte[] getActiveRMZNodeData() {
        if (!this.watchRMHAZNode) {
            LOG.error((Object)"Not watching any RM HA ZNode, unable to get Active RM Data");
            return null;
        }
        if (this.rmHAZNodeData == null) {
            try {
                try {
                    this.rmHAZNodeData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)this.rmHAZNodeToWatch, (Watcher)this, null, (int)3);
                }
                catch (Exception e) {
                    LOG.error((Object)("Unable to get Active RM Data at " + this.rmHAZNodeToWatch + " with error: " + e.getLocalizedMessage()));
                    ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)this.rmHAZNodeToWatch, (Watcher)this, (int)3);
                    return null;
                }
            }
            catch (KeeperException e) {
                LOG.error((Object)("Unable to get Active RM Data at " + this.rmHAZNodeToWatch + " with error: " + e.getLocalizedMessage()));
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Unable to get Active RM Data at " + this.rmHAZNodeToWatch + " with error: " + e.getLocalizedMessage()));
            }
            catch (ZKClosedException e) {
                LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting CACHED RMHAZNodeData");
        }
        return this.rmHAZNodeData;
    }

    public List<String> getServersInfo() {
        if (!this.serversInfo.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Getting CACHED list of servers");
            }
            return this.serversInfo;
        }
        int retries = 0;
        while (retries++ < 3) {
            LOG.info((Object)"Getting list of servers");
            ArrayList<String> nodes = new ArrayList<String>();
            try {
                List znodes = ZKUtils.getZkNodeChildren((ZooKeeper)this.s_zk, (String)SERVER_PATH, (Watcher)this, (int)3);
                for (String znode : znodes) {
                    byte[] znodeData = this.s_zk.getData("/servers/" + znode, false, null);
                    String znodeName = new String(znodeData);
                    nodes.add(znodeName);
                }
                this.serversInfo = nodes;
                break;
            }
            catch (KeeperException e) {
                LOG.error((Object)("Can not get children of /serverswith error: " + e.getLocalizedMessage()));
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Can not get children of /serverswith error: " + e.getLocalizedMessage()));
            }
            catch (ZKClosedException e) {
                LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
            }
        }
        return this.serversInfo;
    }

    public Map<String, List<String>> getConfigServicesMap() {
        if (!this.configServicesMap.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Getting CACHED configServicesMap");
            }
            return this.configServicesMap;
        }
        int retries = 0;
        while (retries++ < 3) {
            try {
                LOG.info((Object)"Getting configServicesMap");
                List services = ZKUtils.getZkNodeChildren((ZooKeeper)this.s_zk, (String)CONF_SERVICES_PATH, (Watcher)this, (int)3);
                for (String service : services) {
                    List nodes = ZKUtils.getZkNodeChildren((ZooKeeper)this.s_zk, (String)("/services_config/" + service), (Watcher)this, (int)3);
                    this.configServicesMap.put(service, nodes);
                    Map<String, Properties> nodeProperties = this.getPropertiesHelper(CONF_SERVICES_PATH, service, nodes);
                    this.serviceToProperties.put(service, nodeProperties);
                }
                break;
            }
            catch (KeeperException e) {
                LOG.error((Object)("Can not get children of /services_config or it's children with error: " + e.getLocalizedMessage()));
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Can not get children of /services_config or it's children with error: " + e.getLocalizedMessage()));
            }
            catch (ZKClosedException e) {
                LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
            }
        }
        return this.configServicesMap;
    }

    public Common.ServiceData getServiceMasterData(String serviceName) {
        if (!this.serviceToMasterMap.isEmpty()) {
            Common.ServiceData serviceMasterData;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting serviceData for master node of " + serviceName + " service from CACHED serviceToMasterMap"));
            }
            if ((serviceMasterData = this.serviceToMasterMap.get(serviceName)) != null) {
                return this.serviceToMasterMap.get(serviceName);
            }
        }
        int retries = 0;
        if (retries++ < 3) {
            try {
                LOG.info((Object)("Getting serviceData for master node of " + serviceName));
                if (!serviceName.equalsIgnoreCase(CLDB_SERVICE_NAME)) {
                    try {
                        byte[] byteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)("/services/" + serviceName + "/" + "master"), (Watcher)this, null, (int)3);
                        this.addServiceDataToMasterMap(serviceName, byteData);
                    }
                    catch (KeeperException.NoNodeException e) {
                        LOG.warn((Object)("Can not get children of /services/" + serviceName + "/" + "master" + " with error: " + e.getLocalizedMessage()));
                        ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)("/services/" + serviceName + "/" + "master"), (Watcher)this, (int)3);
                    }
                }
                if (serviceName.equalsIgnoreCase(CLDB_SERVICE_NAME)) {
                    try {
                        byte[] cldbByteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)CLDB_SERVICE_MASTER_PATH, (Watcher)this, null, (int)3);
                        this.serviceToMasterMap.put(serviceName, ZKDataRetrieval.parseCLDBMasterName(cldbByteData));
                    }
                    catch (KeeperException.NoNodeException e) {
                        LOG.warn((Object)("Can not get data for /datacenter/controlnodes/cldb/active/CLDBMaster" + e.getLocalizedMessage()));
                        ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)CLDB_SERVICE_MASTER_PATH, (Watcher)this, (int)3);
                    }
                }
            }
            catch (KeeperException e) {
                LOG.error((Object)("Can not get children of /services/" + serviceName + "/" + "master" + " with error: " + e.getLocalizedMessage()));
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Can not get children of /services/" + serviceName + "/" + "master" + " with error: " + e.getLocalizedMessage()));
            }
            catch (ZKClosedException e) {
                LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
            }
        }
        return this.serviceToMasterMap.get(serviceName);
    }

    public Map<String, List<String>> getServicesMap() {
        if (!this.servicesMap.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Getting CACHED servicesMap");
            }
            return this.servicesMap;
        }
        int retries = 0;
        while (retries++ < 3) {
            try {
                LOG.info((Object)"Getting servicesMap");
                List services = ZKUtils.getZkNodeChildren((ZooKeeper)this.s_zk, (String)SERVICES_PATH, (Watcher)this, (int)3);
                for (String service : services) {
                    List nodes = ZKUtils.getZkNodeChildren((ZooKeeper)this.s_zk, (String)("/services/" + service), (Watcher)this, (int)3);
                    this.serviceToData.put(service, this.getNodeDataHelper(SERVICES_PATH, service, nodes));
                    if (!service.equalsIgnoreCase(CLDB_SERVICE_NAME)) {
                        try {
                            byte[] byteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)("/services/" + service + "/" + "master"), (Watcher)this, null, (int)3);
                            this.addServiceDataToMasterMap(service, byteData);
                        }
                        catch (KeeperException.NoNodeException e) {
                            LOG.warn((Object)("Can not get children of /services or it's children with error: " + e.getLocalizedMessage()));
                            ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)("/services/" + service + "/" + "master"), (Watcher)this, (int)3);
                        }
                    }
                    nodes.remove("master");
                    this.servicesMap.put(service, nodes);
                    if (!service.equalsIgnoreCase(CLDB_SERVICE_NAME)) continue;
                    try {
                        byte[] cldbByteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)CLDB_SERVICE_MASTER_PATH, (Watcher)this, null, (int)3);
                        this.serviceToMasterMap.put(service, ZKDataRetrieval.parseCLDBMasterName(cldbByteData));
                    }
                    catch (KeeperException.NoNodeException e) {
                        LOG.warn((Object)("Can not get data for /datacenter/controlnodes/cldb/active/CLDBMaster" + e.getLocalizedMessage()));
                        ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)CLDB_SERVICE_MASTER_PATH, (Watcher)this, (int)3);
                    }
                }
                break;
            }
            catch (KeeperException e) {
                LOG.error((Object)("Can not get children of /services or it's children with error: " + e.getLocalizedMessage()));
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Can not get children of /services or it's children with error: " + e.getLocalizedMessage()));
            }
            catch (ZKClosedException e) {
                LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
            }
        }
        return this.servicesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void process(WatchedEvent event) {
        path = event.getPath();
        ZKDataRetrieval.LOG.info((Object)("Process path: " + path + ". Event state: " + event.getState() + ". Event type: " + event.getType()));
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            this.lock.countDown();
        }
        if (event.getState() == Watcher.Event.KeeperState.Expired) {
            ZKDataRetrieval.LOG.warn((Object)("ZK Reset due to SessionExpiration for ZK: " + this.zkConnectString));
            var3_3 = this.s_zk;
            synchronized (var3_3) {
                this.isSessionExpired = true;
                this.s_zk.notify();
            }
            return;
        }
        switch (2.$SwitchMap$org$apache$zookeeper$Watcher$Event$EventType[event.getType().ordinal()]) {
            case 1: {
                if (path.endsWith("master") && (servicesPath = path.split("/")).length > 1 && !(service = servicesPath[servicesPath.length - 2]).equalsIgnoreCase("cldb")) {
                    try {
                        stat = ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)path, (Watcher)this, (int)3);
                        if (stat != null) {
                            byteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)path, (Watcher)this, null, (int)3);
                            this.addServiceDataToMasterMap(service, byteData);
                        }
                    }
                    catch (KeeperException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (InterruptedException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (ZKClosedException e) {
                        ZKDataRetrieval.LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
                    }
                }
                if (path.equalsIgnoreCase("/datacenter/controlnodes/cldb/active/CLDBMaster")) {
                    try {
                        try {
                            cldbByteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)"/datacenter/controlnodes/cldb/active/CLDBMaster", (Watcher)this, null, (int)3);
                            this.serviceToMasterMap.put("cldb", ZKDataRetrieval.parseCLDBMasterName(cldbByteData));
                        }
                        catch (KeeperException.NoNodeException e) {
                            ZKDataRetrieval.LOG.warn((Object)("Can not get data for /datacenter/controlnodes/cldb/active/CLDBMaster" + e.getLocalizedMessage()));
                            ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)"/datacenter/controlnodes/cldb/active/CLDBMaster", (Watcher)this, (int)3);
                        }
                    }
                    catch (KeeperException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (InterruptedException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (ZKClosedException e) {
                        ZKDataRetrieval.LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
                    }
                }
                if (!path.equalsIgnoreCase(this.rmHAZNodeToWatch)) break;
                try {
                    this.rmHAZNodeData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)path, (Watcher)this, null, (int)3);
                }
                catch (KeeperException e) {
                    ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                }
                catch (InterruptedException e) {
                    ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                }
                catch (ZKClosedException e) {
                    ZKDataRetrieval.LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
                }
                break;
            }
            case 2: {
                if (path.endsWith("master") && (servicesPath = path.split("/")).length > 1 && !(service = servicesPath[servicesPath.length - 2]).equalsIgnoreCase("cldb")) {
                    this.serviceToMasterMap.remove(service);
                    try {
                        stat = ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)path, (Watcher)this, (int)3);
                        if (stat != null) {
                            byteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)path, (Watcher)this, null, (int)3);
                            this.addServiceDataToMasterMap(service, byteData);
                        }
                    }
                    catch (KeeperException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (InterruptedException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (ZKClosedException e) {
                        ZKDataRetrieval.LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
                    }
                }
                if (path.equalsIgnoreCase("/datacenter/controlnodes/cldb/active/CLDBMaster")) {
                    try {
                        this.serviceToMasterMap.remove("cldb");
                        stat = ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)path, (Watcher)this, (int)3);
                        if (stat != null) {
                            cldbByteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)path, (Watcher)this, null, (int)3);
                            this.serviceToMasterMap.put("cldb", ZKDataRetrieval.parseCLDBMasterName(cldbByteData));
                        }
                    }
                    catch (KeeperException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (InterruptedException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (ZKClosedException e) {
                        ZKDataRetrieval.LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
                    }
                }
                if (!path.equalsIgnoreCase(this.rmHAZNodeToWatch)) break;
                try {
                    this.rmHAZNodeData = null;
                    stat = ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)path, (Watcher)this, (int)3);
                    if (stat == null) break;
                    this.rmHAZNodeData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)path, (Watcher)this, null, (int)3);
                }
                catch (KeeperException e) {
                    ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                }
                catch (InterruptedException e) {
                    ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                }
                catch (ZKClosedException e) {
                    ZKDataRetrieval.LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
                }
                break;
            }
            case 3: {
                if (path.endsWith("master") && (servicesPath = path.split("/")).length > 1 && !(service = servicesPath[servicesPath.length - 2]).equalsIgnoreCase("cldb")) {
                    try {
                        try {
                            byteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)path, (Watcher)this, null, (int)3);
                            this.addServiceDataToMasterMap(service, byteData);
                        }
                        catch (KeeperException.NoNodeException e) {
                            ZKDataRetrieval.LOG.warn((Object)("Can not get data from " + path + " with error: " + e.getLocalizedMessage()));
                            ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)path, (Watcher)this, (int)3);
                        }
                    }
                    catch (KeeperException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (InterruptedException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (ZKClosedException e) {
                        ZKDataRetrieval.LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
                    }
                }
                if (path.equalsIgnoreCase("/datacenter/controlnodes/cldb/active/CLDBMaster")) {
                    try {
                        try {
                            cldbByteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)path, (Watcher)this, null, (int)3);
                            this.serviceToMasterMap.put("cldb", ZKDataRetrieval.parseCLDBMasterName(cldbByteData));
                        }
                        catch (KeeperException.NoNodeException e) {
                            ZKDataRetrieval.LOG.warn((Object)("Can not get data from " + path + " with error: " + e.getLocalizedMessage()));
                            ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)path, (Watcher)this, (int)3);
                        }
                    }
                    catch (KeeperException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (InterruptedException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (ZKClosedException e) {
                        ZKDataRetrieval.LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
                    }
                }
                if (!path.startsWith("/services_config")) ** GOTO lbl188
                try {
                    servicesPath = path.split("/");
                    if (servicesPath.length >= 3) {
                        service = servicesPath[servicesPath.length - 2];
                        node = servicesPath[servicesPath.length - 1];
                        nodeProperties = new HashMap<String, Properties>(this.serviceToProperties.get(service));
                        byteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)path, (Watcher)this, null, (int)3);
                        bais = new ByteArrayInputStream(byteData);
                        properties = new Properties();
                        try {
                            properties.load(bais);
                            nodeProperties.put(node, properties);
                        }
                        catch (IOException e) {
                            ZKDataRetrieval.LOG.error((Object)("Unable to load properties for path: " + path), (Throwable)e);
                        }
                        this.serviceToProperties.put(service, nodeProperties);
                    }
                    ** GOTO lbl214
                }
                catch (KeeperException e) {
                    ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                }
                catch (InterruptedException e) {
                    ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                }
                catch (ZKClosedException e) {
                    ZKDataRetrieval.LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
                }
                ** GOTO lbl214
lbl188:
                // 1 sources

                if (path.startsWith("/services")) {
                    try {
                        servicesPath = path.split("/");
                        if (servicesPath.length >= 3 && !servicesPath[servicesPath.length - 1].equals("master")) {
                            service = servicesPath[servicesPath.length - 2];
                            node = servicesPath[servicesPath.length - 1];
                            curNodeProps = this.serviceToData.get(service);
                            nodeProperties = curNodeProps == null ? new HashMap<K, V>() : new HashMap<String, Common.ServiceData>(curNodeProps);
                            byteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)("/services/" + service + "/" + node), (Watcher)this, null, (int)3);
                            hostInfo = Common.ServiceData.parseFrom((byte[])byteData);
                            nodeProperties.put(node, hostInfo);
                            this.serviceToData.put(service, nodeProperties);
                        }
                    }
                    catch (KeeperException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (InterruptedException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (ZKClosedException e) {
                        ZKDataRetrieval.LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
                    }
                    catch (InvalidProtocolBufferException e) {
                        ZKDataRetrieval.LOG.error((Object)"Did not receive valid Protobuf");
                    }
                }
lbl214:
                // 12 sources

                if (!path.equalsIgnoreCase(this.rmHAZNodeToWatch)) break;
                try {
                    try {
                        this.rmHAZNodeData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)path, (Watcher)this, null, (int)3);
                    }
                    catch (KeeperException.NoNodeException e) {
                        ZKDataRetrieval.LOG.warn((Object)("Can not get data from " + path + " with error: " + e.getLocalizedMessage()));
                        ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)path, (Watcher)this, (int)3);
                    }
                }
                catch (KeeperException e) {
                    ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                }
                catch (InterruptedException e) {
                    ZKDataRetrieval.LOG.error((Object)("Can not get data from " + path + "with error: " + e.getLocalizedMessage()));
                }
                catch (ZKClosedException e) {
                    ZKDataRetrieval.LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
                }
                break;
            }
            case 4: {
                if (path.startsWith("/services_config")) {
                    try {
                        servicePath = event.getPath();
                        if (servicePath.equalsIgnoreCase("/services_config")) {
                            services = ZKUtils.getZkNodeChildren((ZooKeeper)this.s_zk, (String)servicePath, (Watcher)this, (int)3);
                            for (String service : services) {
                                nodes = ZKUtils.getZkNodeChildren((ZooKeeper)this.s_zk, (String)(servicePath + "/" + service), (Watcher)this, (int)3);
                                this.configServicesMap.put(service, nodes);
                                nodeProperties = this.getPropertiesHelper("/services_config", service, nodes);
                                this.serviceToProperties.put(service, nodeProperties);
                                this.serviceToProperties.put(service, nodeProperties);
                            }
                            break;
                        }
                        nodes = ZKUtils.getZkNodeChildren((ZooKeeper)this.s_zk, (String)servicePath, (Watcher)this, (int)3);
                        servicesPath = servicePath.split("/");
                        service = servicesPath[servicesPath.length - 1];
                        this.configServicesMap.put(service, nodes);
                        nodeProperties = this.getPropertiesHelper("/services_config", service, nodes);
                        this.serviceToProperties.put(service, nodeProperties);
                    }
                    catch (KeeperException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get children of " + event.getPath() + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (InterruptedException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get children of " + event.getPath() + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (ZKClosedException e) {
                        ZKDataRetrieval.LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
                    }
                    break;
                }
                if (path.startsWith("/services")) {
                    try {
                        servicePath = event.getPath();
                        if (servicePath.equalsIgnoreCase("/services")) {
                            services = ZKUtils.getZkNodeChildren((ZooKeeper)this.s_zk, (String)servicePath, (Watcher)this, (int)3);
                            for (String service : services) {
                                nodes = ZKUtils.getZkNodeChildren((ZooKeeper)this.s_zk, (String)(servicePath + "/" + service), (Watcher)this, (int)3);
                                if (!service.equalsIgnoreCase("cldb")) {
                                    try {
                                        byteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)(servicePath + "/" + service + "/" + "master"), (Watcher)this, null, (int)3);
                                        this.addServiceDataToMasterMap(service, byteData);
                                    }
                                    catch (KeeperException.NoNodeException e) {
                                        ZKDataRetrieval.LOG.warn((Object)("Can not get children of /services or it's children with error: " + e.getLocalizedMessage()));
                                        ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)(servicePath + "/" + service + "/" + "master"), (Watcher)this, (int)3);
                                    }
                                } else {
                                    try {
                                        cldbByteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)"/datacenter/controlnodes/cldb/active/CLDBMaster", (Watcher)this, null, (int)3);
                                        this.serviceToMasterMap.put(service, ZKDataRetrieval.parseCLDBMasterName(cldbByteData));
                                    }
                                    catch (KeeperException.NoNodeException e) {
                                        ZKDataRetrieval.LOG.warn((Object)("Can not get data for /datacenter/controlnodes/cldb/active/CLDBMaster" + e.getLocalizedMessage()));
                                        ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)"/datacenter/controlnodes/cldb/active/CLDBMaster", (Watcher)this, (int)3);
                                    }
                                }
                                nodes.remove("master");
                                this.servicesMap.put(service, nodes);
                                this.serviceToData.put(service, this.getNodeDataHelper("/services", service, nodes));
                            }
                        }
                        nodes = ZKUtils.getZkNodeChildren((ZooKeeper)this.s_zk, (String)servicePath, (Watcher)this, (int)3);
                        servicesPath = servicePath.split("/");
                        service = servicesPath[servicesPath.length - 1];
                        nodes.remove("master");
                        this.servicesMap.put(service, nodes);
                        this.serviceToData.put(service, this.getNodeDataHelper("/services", service, nodes));
                    }
                    catch (KeeperException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get children of " + event.getPath() + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (InterruptedException e) {
                        ZKDataRetrieval.LOG.error((Object)("Can not get children of " + event.getPath() + "with error: " + e.getLocalizedMessage()));
                    }
                    catch (ZKClosedException e) {
                        ZKDataRetrieval.LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
                    }
                    break;
                }
                if (!path.equalsIgnoreCase("/servers")) break;
                nodes = new ArrayList<String>();
                try {
                    znodes = ZKUtils.getZkNodeChildren((ZooKeeper)this.s_zk, (String)"/servers", (Watcher)this, (int)3);
                    for (String znode : znodes) {
                        znodeData = this.s_zk.getData("/servers/" + znode, false, null);
                        znodeName = new String(znodeData);
                        nodes.add(znodeName);
                    }
                    this.serversInfo = nodes;
                }
                catch (KeeperException e) {
                    ZKDataRetrieval.LOG.error((Object)("Can not get children of /serverswith error: " + e.getLocalizedMessage()));
                }
                catch (InterruptedException e) {
                    ZKDataRetrieval.LOG.error((Object)("Can not get children of /serverswith error: " + e.getLocalizedMessage()));
                }
                catch (ZKClosedException e) {
                    ZKDataRetrieval.LOG.error((Object)"Most likely SessionExpirationException. Need to reset ZK and call myself again", (Throwable)e);
                }
                break;
            }
        }
    }

    private synchronized void zooKeeperReset() {
        LOG.info((Object)("Close zk for: " + this.zkConnectString));
        if (this.s_zk != null) {
            try {
                this.s_zk.close();
            }
            catch (InterruptedException e) {
                LOG.error((Object)"InterruptedException during ZK closure");
            }
        }
        this.lock = new CountDownLatch(1);
        this.init();
    }

    private void addServiceDataToMasterMap(String service, byte[] data) {
        try {
            Common.ServiceData hostInfo = Common.ServiceData.parseFrom((byte[])data);
            this.serviceToMasterMap.put(service, hostInfo);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Did not get valid ProtoBuf.", (Throwable)e);
        }
    }

    private static Common.ServiceData parseCLDBMasterName(byte[] data) {
        if (data == null) {
            return null;
        }
        String masterData = new String(data);
        int i = masterData.indexOf("HostName: ");
        if (i < 0 || i > masterData.length()) {
            return null;
        }
        String CLDBMasterName = masterData.substring(i + "HostName: ".length(), masterData.length());
        Common.ServiceData.Builder zkData = Common.ServiceData.newBuilder();
        zkData.setHost(CLDBMasterName);
        return zkData.build();
    }

    private Map<String, Common.ServiceData> getNodeDataHelper(String prefix, String service, List<String> nodes) throws KeeperException, InterruptedException, ZKClosedException {
        HashMap<String, Common.ServiceData> nodeProperties = new HashMap<String, Common.ServiceData>();
        for (String node : nodes) {
            try {
                byte[] byteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)(prefix + "/" + service + "/" + node), (Watcher)this, null, (int)3);
                Common.ServiceData dataInfo = Common.ServiceData.parseFrom((byte[])byteData);
                nodeProperties.put(node, dataInfo);
            }
            catch (KeeperException.NoNodeException e) {
                LOG.warn((Object)("Can not get children of " + service + " or it's children with error: " + e.getLocalizedMessage()));
                ZKUtils.checkZKNodeForExistence((ZooKeeper)this.s_zk, (String)(prefix + "/" + service + "/" + node), (Watcher)this, (int)3);
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error((Object)"Did not get valid ProtoBuf.", (Throwable)e);
            }
        }
        return nodeProperties;
    }

    private Map<String, Properties> getPropertiesHelper(String prefix, String service, List<String> nodes) throws KeeperException, InterruptedException, ZKClosedException {
        HashMap<String, Properties> nodeProperties = new HashMap<String, Properties>();
        for (String node : nodes) {
            byte[] byteData = ZKUtils.getData((ZooKeeper)this.s_zk, (String)(prefix + "/" + service + "/" + node), (Watcher)this, null, (int)3);
            ByteArrayInputStream bais = new ByteArrayInputStream(byteData);
            Properties properties = new Properties();
            try {
                properties.load(bais);
                nodeProperties.put(node, properties);
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to load properties for node: " + node + " and service: " + service), (Throwable)e);
            }
        }
        return nodeProperties;
    }
}

