package com.mapr.util;

import org.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

// import flexjson.JSONException;

import java.io.*;

public class JSONUtil {
  private static final Log LOG = LogFactory.getLog(JSONUtil.class);
  
  // Construct a JSON object from the contents of a file
  public static JSONObject GetJSONFromFile(String pathName) throws Exception
  {
    JSONObject jsonObject = null;
    
    try
    {
      // Build a single string from all of the lines in the file
      final String EoL = System.getProperty("line.separator");
      BufferedReader reader = new BufferedReader(new FileReader(pathName));
      String line;
      StringBuilder jsonStringBldr = new StringBuilder();
      while ((line = reader.readLine()) != null) {
        jsonStringBldr.append(line).append(EoL);
      }

      reader.close();

      // Get a JSON object from the string constructed from the file
      jsonObject = new JSONObject(jsonStringBldr.toString());
      
    } 
    catch (Exception e)
    {
      LOG.error("Unable to construct a JSON object from file " +
                pathName, e);
    }

    return jsonObject;
  }
}
