/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.util;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.SimpleEmail;
import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class EmailUtil {
    //SMTP Configuration parameter names
    private static final String SMTP_PARAM_PREFIX="mapr.smtp.";
    private static final String ParamSmtpPort = SMTP_PARAM_PREFIX + "port";
    private static final String ParamSmtpServer = SMTP_PARAM_PREFIX + "server";
    private static final String ParamSmtpSslRequired = SMTP_PARAM_PREFIX + "sslrequired";
    private static final String ParamSmtpSenderUserName = SMTP_PARAM_PREFIX + "sender.username";
    private static final String ParamSmtpSenderPassword = SMTP_PARAM_PREFIX + "sender.password";
    private static final String ParamSmtpSenderFullName = SMTP_PARAM_PREFIX + "sender.fullname";
    private static final String ParamSmtpSenderEmail = SMTP_PARAM_PREFIX + "sender.email";

    private static final Log LOG = LogFactory.getLog(EmailUtil.class);

    private static final String PassPhrase="MapR_Random_$$_Phrase";
    private static SecretKey PassKey;
    private static Base64 base64decoder;

    public EmailUtil() throws Exception {
     // Setup keys to store encrypted passwords
      DESKeySpec keySpec = new DESKeySpec(PassPhrase.getBytes("UTF8"));
      PassKey = SecretKeyFactory.getInstance("DES").generateSecret(keySpec);
      base64decoder = new Base64();
    }

    static String decryptPassword (String p) throws Exception {
      byte[] encryptedPwdBytes = base64decoder.decode(p);
      Cipher cipher = Cipher.getInstance("DES");// cipher is not thread safe
      cipher.init(Cipher.DECRYPT_MODE, PassKey);
      byte[] plainTextPwdBytes = cipher.doFinal(encryptedPwdBytes);
      return new String(plainTextPwdBytes);
    }


    // If toAddr is null, email is sent to the sender himself
    public void sendEmail (Properties prop, String toAddr,
                           String msg, String subject) throws Exception {
      // Validate Properties
      String server = prop.getProperty(ParamSmtpServer);
      if (server == null || server.isEmpty()) {
        LOG.error("EmailUtil: Failed to send email, Invalid SMTP Server");
        return;
      }
      String portStr = prop.getProperty(ParamSmtpPort);
      if (portStr == null || portStr.isEmpty()) {
        LOG.error("EmailUtil: Failed to send email, Invalid SMTP Port");
        return;
      }
      int port = Integer.parseInt(portStr);
      if (port == 0) {
        LOG.error("EmailUtil: Failed to send email, Invalid SMTP Port");
        return;
      }

      String senderEmail = prop.getProperty(ParamSmtpSenderEmail);
      String rcpt = ((toAddr != null) ? toAddr : senderEmail);
      if (rcpt == null || rcpt.isEmpty() || !validateEmail(rcpt)) {
        LOG.error("EmailUtil: Failed to send email, Invalid recipient");
        return;
      }
      String senderName = prop.getProperty(ParamSmtpSenderFullName);

      // Now do the sending
      Email email = new SimpleEmail();
      email.setHostName(server);
      email.setSmtpPort(port);
      boolean sslRequired = 
          Boolean.parseBoolean(prop.getProperty(ParamSmtpSslRequired, "false"));
      if (sslRequired) {
        email.setTLS(true);
        email.setSSL(true);
      }

      String userName = prop.getProperty(ParamSmtpSenderUserName);
      String passwd = prop.getProperty(ParamSmtpSenderPassword);
      if (userName != null && !userName.isEmpty() && 
         passwd != null && !passwd.isEmpty()) {
        email.setAuthenticator(new DefaultAuthenticator(
                               userName, decryptPassword(passwd)));
      }
      email.setDebug(LOG.isDebugEnabled());
      if (senderEmail != null && !senderEmail.isEmpty() &&
          validateEmail(senderEmail)) {
        email.setFrom(senderEmail, senderName);
      }
      email.addTo(rcpt);
      email.setSubject(subject);
      email.setMsg(msg);
      email.send();
      if (LOG.isDebugEnabled())
        LOG.debug("EmailUtil: Sent email to " + rcpt);
    }

    private boolean validateEmail(String email) {
      Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
      Matcher m = p.matcher(email);
      return m.matches();
    }
}
