/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.TimeZone;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingCalendar;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class MaprfsDailyRollingUTCAppender
extends FileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    private String datePattern = "'-'yyyy-MM-dd";
    private String scheduledFilename;
    private int maxBackupIndex = Integer.MAX_VALUE;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    RollingCalendar rc = new RollingCalendar(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
    int checkPeriod = -1;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    static final String jsonExtension = ".json";
    String fileNameNoJSONExt;
    public static String dirPath;
    private final Runnable LogRetaintionRunnable;
    private final Thread LogRetaintionThread;

    public MaprfsDailyRollingUTCAppender() {
        this.LogRetaintionRunnable = new LogRetaintionManager();
        this.LogRetaintionThread = new Thread(this.LogRetaintionRunnable, "Deletion Thread");
    }

    public MaprfsDailyRollingUTCAppender(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.LogRetaintionRunnable = new LogRetaintionManager();
        this.LogRetaintionThread = new Thread(this.LogRetaintionRunnable, "Deletion Thread");
        this.activateOptions();
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.maxBackupIndex = maxBackups;
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            this.sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rc.setType(type);
            this.LogRetaintionThread.setDaemon(true);
            this.LogRetaintionThread.start();
            this.fileNameNoJSONExt = this.fileName.endsWith(jsonExtension) ? this.fileName.substring(0, this.fileName.lastIndexOf(46)) : this.fileName;
            File file = new File(this.fileName);
            dirPath = file.getParent();
            this.scheduledFilename = this.fileNameNoJSONExt + this.sdf.format(new Date(file.lastModified())) + jsonExtension;
        } else {
            LogLog.error((String)("Either File or DatePattern options are not set for appender [" + this.name + "]."));
        }
    }

    void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled every minute."));
                break;
            }
            case 1: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled on top of every hour."));
                break;
            }
            case 2: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midday and midnight."));
                break;
            }
            case 3: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midnight."));
                break;
            }
            case 4: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of week."));
                break;
            }
            case 5: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of every month."));
                break;
            }
            default: {
                LogLog.warn((String)("Unknown periodicity for appender [" + this.name + "]."));
            }
        }
    }

    int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.ENGLISH);
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollOver() throws IOException {
        File file;
        boolean result;
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
            return;
        }
        String fileNameNoJSONExt = this.fileName.endsWith(jsonExtension) ? this.fileName.substring(0, this.fileName.lastIndexOf(46)) : this.fileName;
        String datedFilename = fileNameNoJSONExt + this.sdf.format(this.now) + jsonExtension;
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.closeFile();
        File target = new File(this.scheduledFilename);
        if (target.exists()) {
            target.delete();
        }
        if (result = (file = new File(this.fileName)).renameTo(target)) {
            LogLog.debug((String)(this.fileName + " -> " + this.scheduledFilename));
        } else {
            LogLog.error((String)("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "]."));
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            this.errorHandler.error("setFile(" + this.fileName + ", false) call failed.");
        }
        this.scheduledFilename = datedFilename;
        Runnable runnable = this.LogRetaintionRunnable;
        synchronized (runnable) {
            if (this.maxBackupIndex != Integer.MAX_VALUE) {
                this.LogRetaintionRunnable.notify();
            }
        }
    }

    protected void subAppend(LoggingEvent event) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.rollOver();
            }
            catch (IOException ioe) {
                LogLog.error((String)"rollOver() failed.", (Throwable)ioe);
            }
        }
        super.subAppend(event);
    }

    class LogRetaintionManager
    implements Runnable {
        LogRetaintionManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block5: while (true) {
                var1_1 = this;
                synchronized (var1_1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        LogLog.error((String)"Interrupted Exception during wait for extra files deletion", (Throwable)e);
                        e.printStackTrace();
                    }
                }
                dir = new File(MaprfsDailyRollingUTCAppender.dirPath);
                listOfFiles = dir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File path) {
                        return path.toString().contains(MaprfsDailyRollingUTCAppender.this.fileNameNoJSONExt);
                    }
                });
                LogLog.debug((String)("Scanning Directory " + dir + " filelist size " + listOfFiles.length));
                if (listOfFiles == null || listOfFiles.length < MaprfsDailyRollingUTCAppender.this.maxBackupIndex) continue;
                pq = new PriorityQueue<File>(listOfFiles.length, new Comparator<File>(){

                    @Override
                    public int compare(File file1, File file2) {
                        return Long.signum(file1.lastModified() - file2.lastModified());
                    }
                });
                pq.addAll(Arrays.asList(listOfFiles));
                i = 0;
                while (true) {
                    if (i < listOfFiles.length - MaprfsDailyRollingUTCAppender.this.maxBackupIndex) ** break;
                    continue block5;
                    file = pq.poll();
                    LogLog.debug((String)("Deleting old file " + file.getName() + ". Backup index " + MaprfsDailyRollingUTCAppender.this.maxBackupIndex));
                    file = new File(file.getAbsolutePath());
                    file.delete();
                    ++i;
                }
                break;
            }
        }
    }
}

