/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.log4j;

import com.mapr.log4j.CentralTaskLogAppender;
import java.io.File;
import java.util.Date;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;

public class MR1CentralTaskLogAppender
extends CentralTaskLogAppender
implements TaskLog.LogdirSwitchable {
    private static final String LOGSIZE_PROPERTY = "hadoop.tasklog.totalLogFileSize";
    private static final String CONF_PACKAGE = "org.apache.hadoop.conf";
    private static final String FS_PACKAGE = "org.apache.hadoop.fs";
    private static final String MAPR_PACKAGE = "com.mapr";

    @Override
    protected String getFrameworkType() {
        return "mapred";
    }

    public synchronized void switchLogdir(String dirname) {
        LogLog.debug((String)(new Date(System.currentTimeMillis()) + ": Setting Log Level to OFF for switchLogDir to: " + dirname));
        Level hcLevel = Logger.getLogger((String)CONF_PACKAGE).getLevel();
        Level hfLevel = Logger.getLogger((String)FS_PACKAGE).getLevel();
        Level maprLevel = Logger.getLogger((String)MAPR_PACKAGE).getLevel();
        Level rootLevel = Logger.getRootLogger().getLevel();
        LogLog.debug((String)("com.mapr level: " + maprLevel + ", root level: " + rootLevel));
        Logger.getLogger((String)CONF_PACKAGE).setLevel(Level.OFF);
        Logger.getLogger((String)FS_PACKAGE).setLevel(Level.OFF);
        Logger.getLogger((String)MAPR_PACKAGE).setLevel(Level.OFF);
        super.setFile(new File(dirname, TaskLog.LogName.SYSLOG.toString()).toString());
        super.activateOptions();
        LogLog.debug((String)(new Date(System.currentTimeMillis()) + ": resetting log level to original"));
        Logger.getLogger((String)CONF_PACKAGE).setLevel(hcLevel);
        Logger.getLogger((String)FS_PACKAGE).setLevel(hfLevel);
        Logger.getLogger((String)MAPR_PACKAGE).setLevel(maprLevel);
    }

    public TaskLog.LogName getLogname() {
        return TaskLog.LogName.SYSLOG;
    }

    @Override
    protected synchronized Long getFileSizeLimit() {
        try {
            String propValue = System.getProperty(LOGSIZE_PROPERTY, "100");
            return Long.parseLong(propValue);
        }
        catch (NumberFormatException e) {
            LogLog.error((String)"Log size property should be a number", (Throwable)e);
            return null;
        }
    }
}

