/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.log4j;

import com.mapr.baseutils.BaseUtilsHelper;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRFsDataOutputStream;
import com.mapr.log4j.MR1CentralTaskLogAppender;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MR1CentralTaskLogAppenderTest {
    private static String dirPath = "/var/mapr/local/testhost/logs/mapred/userlogs/job_201608241854_0001/attempt_201608241854_0001_m_000009_0";
    private MapRFileSystem fs;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.setProperty("log4j.appender.maprfsTLA", "com.mapr.log4j.MR1CentralTaskLogAppender");
        System.setProperty("log4j.rootLogger", "DEBUG,maprfsTLA");
        System.setProperty("hadoop.tasklog.taskid", "attempt_201608241854_0001_m_000009_0");
        System.setProperty("log4j.debug", "true");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.fs = (MapRFileSystem)Mockito.mock(MapRFileSystem.class);
        Mockito.when((Object)this.fs.exists(new Path("/var/mapr/local/testhost/logs/"))).thenReturn((Object)true);
        Mockito.when((Object)this.fs.exists(new Path(dirPath + "/syslog"))).thenReturn((Object)false);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test(timeout=30000L)
    public void DeadLockWhileSwitchLogTest() throws Exception {
        final MR1CentralTaskLogAppender mr1Appender = new MR1CentralTaskLogAppender();
        mr1Appender.setFS((FileSystem)this.fs);
        mr1Appender.setThreshold((Priority)Level.DEBUG);
        mr1Appender.setURI("maprfs:///");
        mr1Appender.setLayout((Layout)new PatternLayout());
        mr1Appender.activateOptions();
        Logger.getRootLogger().getLoggerRepository().resetConfiguration();
        Logger.getRootLogger().addAppender((Appender)mr1Appender);
        final Logger LOG = Logger.getLogger(MR1CentralTaskLogAppenderTest.class);
        LOG.info((Object)"abcdefg");
        final int[] switchFlag = new int[1];
        try {
            Mockito.when((Object)this.fs.create(new Path(dirPath + "/syslog"), true, 8192)).thenAnswer((Answer)new Answer<MapRFsDataOutputStream>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public MapRFsDataOutputStream answer(InvocationOnMock invocation) throws Throwable {
                    LogLog.debug((String)"before DEBUG");
                    int[] nArray = switchFlag;
                    synchronized (switchFlag) {
                        switchFlag[0] = 1;
                        switchFlag.notifyAll();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        Thread.sleep(3000L);
                        LOG.debug((Object)"debug in the middle of rollover");
                        LogLog.debug((String)"after DEBUG");
                        nArray = switchFlag;
                        synchronized (switchFlag) {
                            switchFlag[0] = 2;
                            switchFlag.notifyAll();
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return null;
                        }
                    }
                }
            });
        }
        catch (IOException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        Thread loggingThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int[] nArray = switchFlag;
                synchronized (switchFlag) {
                    while (switchFlag[0] == 0) {
                        try {
                            switchFlag.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                    Assert.assertFalse((0 == switchFlag[0] ? 1 : 0) != 0);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    LOG.debug((Object)"regular debug statement");
                    return;
                }
            }
        });
        Thread rolloverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                mr1Appender.switchLogdir(dirPath);
            }
        });
        loggingThread.setDaemon(true);
        rolloverThread.setDaemon(true);
        loggingThread.start();
        rolloverThread.start();
        loggingThread.join();
        rolloverThread.join();
        LOG.info((Object)"after log set back to normal");
    }

    static {
        BaseUtilsHelper.setMapRHostName((String)"testhost");
        LogLog.setInternalDebugging((boolean)true);
    }
}

