/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.iamserverutils;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.Util;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.login.client.MapRLoginHttpsClient;
import com.mapr.security.JNISecurity;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IamServerRpcCommonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IamServerRpcCommonUtils.class);
    private static IamServerRpcCommonUtils s_instance = null;
    List<Common.IPPort> reachableList = null;
    List<Common.IPPort> unreachableList = null;
    private final String metaDataFile = "/tmp/iamServerLocations";
    private int listenPort = 0;

    private IamServerRpcCommonUtils(int listenPort) {
        this.listenPort = listenPort;
        if (this.reachableList == null) {
            try {
                this.getIamServerLocations();
            }
            catch (Exception e) {
                LOG.error("Exception while initializing IamServerRpcCommonUtils: {}", (Object)e.getMessage());
            }
        }
    }

    public static IamServerRpcCommonUtils getInstance() {
        return IamServerRpcCommonUtils.getInstance(0);
    }

    public static synchronized IamServerRpcCommonUtils getInstance(int listenPort) {
        if (s_instance == null) {
            s_instance = new IamServerRpcCommonUtils(listenPort);
        }
        return s_instance;
    }

    public synchronized void getIamServerLocations() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getIamServerLocations");
        }
        this.reachableList = this.getSavedList();
        if (this.reachableList != null) {
            return;
        }
        CLDBProto.GetZkConnectStringRequest.Builder reqB = CLDBProto.GetZkConnectStringRequest.newBuilder();
        reqB.setIpType(Common.IPType.INTERNAL_ONLY);
        byte[] data = null;
        int numTry = 0;
        int maxTryBeforeGivingUp = 0;
        do {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(CLDBRpcCommonUtils.getInstance().getCurrentClusterName(), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetZkConnectStringProc.getNumber(), (MessageLite)reqB.build(), CLDBProto.GetZkConnectStringResponse.class, Security.ServerKeyType.ServerKey, this.listenPort);
            if (++numTry < 3) continue;
            try {
                ++maxTryBeforeGivingUp;
            }
            catch (Exception e) {
                LOG.error("Exception occured while holding IamServerRpcCommonUtils");
            }
            numTry = 0;
        } while (data == null && maxTryBeforeGivingUp <= 3);
        if (data == null) {
            return;
        }
        this.reachableList = new ArrayList<Common.IPPort>();
        this.unreachableList = new ArrayList<Common.IPPort>();
        try {
            CLDBProto.GetZkConnectStringResponse dataRcvd = CLDBProto.GetZkConnectStringResponse.parseFrom((byte[])data);
            int unReachableIdx = dataRcvd.getIamServerUnreachableIdx();
            CLDBProto.GetZkConnectStringResponse.Builder dataToSave = CLDBProto.GetZkConnectStringResponse.newBuilder();
            ArrayList iamList = new ArrayList();
            iamList.addAll(dataRcvd.getIamServersList());
            LOG.debug("Recieved list size {} and unReachableIdx as {}", (Object)iamList.size(), (Object)unReachableIdx);
            this.reachableList.clear();
            this.reachableList.addAll(new ArrayList(iamList.subList(0, unReachableIdx)));
            this.unreachableList.clear();
            this.unreachableList.addAll(new ArrayList(iamList.subList(unReachableIdx, iamList.size())));
            if (this.reachableList.size() > 0) {
                dataToSave.addAllIamServers(this.reachableList);
                BufferedOutputStream fw = new BufferedOutputStream(new FileOutputStream("/tmp/iamServerLocations"));
                fw.write(dataToSave.build().toByteArray());
                fw.flush();
                fw.close();
            }
        }
        catch (IOException e) {
            LOG.error("Exception while creating internal file.");
        }
    }

    private List<Common.IPPort> getSavedList() {
        if (!new File("/tmp/iamServerLocations").exists()) {
            return null;
        }
        Path fileLocation = Paths.get("/tmp/iamServerLocations", new String[0]);
        CLDBProto.GetZkConnectStringResponse resp = null;
        try {
            byte[] data = Files.readAllBytes(fileLocation);
            resp = CLDBProto.GetZkConnectStringResponse.parseFrom((byte[])data);
        }
        catch (Exception e) {
            LOG.error("Exception parsing saved file");
            this.removeMetaDataFile();
            return null;
        }
        return resp != null && resp.getIamServersCount() > 0 ? new ArrayList(resp.getIamServersList()) : null;
    }

    private long getBinding(Common.IPPort ipPort, String clusterName, Security.ServerKeyType keyType) throws Exception {
        MutableInt mutableerr;
        Security.TicketAndKey ticket;
        int port = ipPort.getPort();
        int ipCount = ipPort.getHostsList().size() + ipPort.getHostIpAddrsList().size();
        if (ipCount == 0) {
            return 0L;
        }
        try {
            int rpcPort = Rpc.initialize(0, 0, clusterName);
            if (rpcPort < 0) {
                throw new IOException("Error in RPC init");
            }
        }
        catch (Exception e) {
            throw new Exception("Exception in Rpc.initialize " + e);
        }
        if (JNISecurity.IsSecurityEnabled(clusterName) && (ticket = Security.GetTicketAndKeyForCluster(keyType, clusterName, mutableerr = new MutableInt())) == null) {
            int err = Security.SetTicketAndKeyFile(CLDBRpcCommonUtils.getInstance().getPathToServerTicketFile());
            if (err != 0) {
                LOG.error("Error " + err + " in loading " + CLDBRpcCommonUtils.getInstance().getPathToServerTicketFile());
            }
            ticket = Security.GetTicketAndKeyForCluster(keyType, clusterName, mutableerr);
        }
        byte[][] ipsArray = new byte[ipCount][];
        int idx = 0;
        for (Integer ip : ipPort.getHostsList()) {
            ipsArray[idx] = Util.intToByteArray(ip);
            ++idx;
        }
        for (Security.IpAddrMsg ipAddrMsg : ipPort.getHostIpAddrsList()) {
            ipsArray[idx] = Util.ipAddrMsgToByteArray(ipAddrMsg);
            ++idx;
        }
        int flags = CLDBRpcCommonUtils.getInstance().getFlagsForBinding(clusterName, false);
        long binding = Rpc.createBindingForIps2(ipsArray, port, clusterName, keyType.getNumber(), flags);
        return binding;
    }

    private byte[] sendRequestToParticularIamServer(String clusterName, Common.IPPort ips, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType) throws Exception {
        CLDBRpcCommonUtils cldbRpcUtils = CLDBRpcCommonUtils.getInstance();
        if (cldbRpcUtils.lookupInClusterMaps(clusterName) == null) {
            cldbRpcUtils.reloadClusterMap(clusterName);
            if (cldbRpcUtils.lookupInClusterMaps(clusterName) == null) {
                try {
                    Method newBuilder = responseClass.getMethod("newBuilder", new Class[0]);
                    Object returnObject = newBuilder.invoke(null, new Object[0]);
                    Method statusMethod = returnObject.getClass().getMethod("setStatus", Integer.TYPE);
                    returnObject = statusMethod.invoke(returnObject, 133);
                    Method errMsgMethod = returnObject.getClass().getMethod("setErrMsg", String.class);
                    returnObject = errMsgMethod.invoke(returnObject, "Cluster name is invalid.");
                    Method build = returnObject.getClass().getMethod("build", new Class[0]);
                    MessageLite buildObject = (MessageLite)build.invoke(returnObject, new Object[0]);
                    byte[] bytes = buildObject.toByteArray();
                    LOG.error("Unable to reach cluster with name: " + clusterName + ". No entry found  for cluster " + clusterName + ". Failing the CLDB RPC with status 133");
                    return bytes;
                }
                catch (Exception e) {
                    LOG.error("Error while trying to construct erroneous response", (Throwable)e);
                    LOG.error("Failed to find Cluster: " + clusterName + " in cluster map. Unable to perform RPC to policyserver");
                    return null;
                }
            }
        }
        try {
            MapRLoginHttpsClient loginClient = new MapRLoginHttpsClient();
            loginClient.quietAuthenticateIfNeeded(clusterName);
            long binding = this.getBinding(ips, clusterName, keyType);
            if (binding == 0L) {
                LOG.error("Unable to create binding for IamServer");
                return null;
            }
            Method parseFromMethod = responseClass.getMethod("parseFrom", ByteString.class);
            int MAX_ATTEMPTS = 6;
            int nAttempt = 0;
            Integer status = 0;
            do {
                byte[] retBytes;
                if ((retBytes = Rpc.sendRequest(binding, Common.MapRProgramId.IAMServerProgramId.getNumber(), procedureId, request)) != null) {
                    Object returnObject = parseFromMethod.invoke(null, ByteString.copyFrom((byte[])retBytes));
                    Method statusMethod = returnObject.getClass().getMethod("getStatus", new Class[0]);
                    status = (Integer)statusMethod.invoke(returnObject, new Object[0]);
                    if (status == null) {
                        LOG.error("Return Status is not Integer: " + status);
                        return null;
                    }
                    if (status == 30) {
                        LOG.debug("Current Server is READ_ONLY IamServer. Trying another one");
                        return null;
                    }
                    if (status == 3) {
                        if (++nAttempt == 1) {
                            LOG.error("Current Server is attempting to become a master. Retrying!");
                        }
                        if (nAttempt >= 6) continue;
                        Thread.sleep((2 * nAttempt + 1) * 1000);
                        continue;
                    }
                    return retBytes;
                }
                LOG.error("No data returned in RPC: Continue searching for correct IamServer");
                return null;
            } while (nAttempt < 6);
        }
        catch (MaprSecurityException se) {
            LOG.error(se.getMessage());
            throw se;
        }
        return null;
    }

    public byte[] sendRequestToIamServer(int procedureId, MessageLite request, Class<? extends MessageLite> responseClass) throws Exception {
        return this.sendRequestToIamServer(CLDBRpcCommonUtils.getInstance().getDefaultClusterName(), procedureId, request, responseClass);
    }

    public byte[] sendRequestToIamServer(String clusterName, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass) throws Exception {
        boolean fetchedIamServerLocation = false;
        do {
            int numTry = 0;
            do {
                if (this.reachableList == null) {
                    this.reachableList = this.getSavedList();
                }
                if (this.reachableList != null) continue;
                this.getIamServerLocations();
                if (this.reachableList == null) {
                    LOG.error("Couldn't fetch IAM server location, Check for CLDB process");
                    Method newBuilder = responseClass.getMethod("newBuilder", new Class[0]);
                    Object returnObject = newBuilder.invoke(null, new Object[0]);
                    Method statusMethod = returnObject.getClass().getMethod("setStatus", Integer.TYPE);
                    returnObject = statusMethod.invoke(returnObject, 10009);
                    Method errMsgMethod = returnObject.getClass().getMethod("setErrMsg", String.class);
                    returnObject = errMsgMethod.invoke(returnObject, "Couldn't connect to the CLDB service. Check for CLDB process");
                    Method build = returnObject.getClass().getMethod("build", new Class[0]);
                    MessageLite buildObject = (MessageLite)build.invoke(returnObject, new Object[0]);
                    return buildObject.toByteArray();
                }
                fetchedIamServerLocation = true;
            } while (this.reachableList == null && ++numTry <= 3);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reachable List of size{} and Unreachable List of size {} recieved", (Object)(this.reachableList != null ? this.reachableList.size() : 0), (Object)(this.unreachableList != null ? this.unreachableList.size() : 0));
            }
            try {
                for (int i = 0; i < 2; ++i) {
                    Common.IPPort ip;
                    List<Common.IPPort> listToProcess = null;
                    switch (i) {
                        case 0: {
                            listToProcess = this.reachableList;
                            break;
                        }
                        case 1: {
                            listToProcess = this.unreachableList;
                        }
                    }
                    if (listToProcess == null) continue;
                    Collections.shuffle(listToProcess);
                    byte[] data = null;
                    Iterator<Common.IPPort> iterator = listToProcess.iterator();
                    while (iterator.hasNext() && (data = this.sendRequestToParticularIamServer(clusterName, ip = iterator.next(), procedureId, request, responseClass, Security.ServerKeyType.ServerKey)) == null) {
                    }
                    if (data == null) continue;
                    return data;
                }
            }
            catch (MaprSecurityException se) {
                LOG.error(se.getMessage() + "Removing previously cached locations..");
            }
            this.removeMetaDataFile();
            this.reachableList = null;
        } while (!fetchedIamServerLocation);
        return null;
    }

    private void removeMetaDataFile() {
        File file = new File("/tmp/iamServerLocations");
        file.delete();
    }
}

