/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security.verifier;

import com.mapr.web.security.verifier.Log;
import com.mapr.web.security.verifier.Output;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class Tests {
    private static final Stack<Test> allTests = new Stack();
    private static int errorCount = 0;

    public static void assertEqualAndPrint(Object expected, Object actual, String test, Object ... args) {
        String message = String.format(test, args);
        boolean assertion = Tests.assertEquals(expected, actual);
        String output = String.format("%s? %s (found %s)", message, Output.color(assertion), actual);
        Tests.print(assertion, message, output);
    }

    public static void assertAndPrint(boolean assertion, String test, Object ... args) {
        String message = String.format(test, args);
        String output = String.format("%s? %s", message, Output.color(assertion));
        Tests.print(assertion, message, output);
    }

    private static void print(boolean assertion, String message, String output) {
        if (assertion) {
            Log.testSucceeded(message);
            Output.testSucceeded(output);
        } else {
            Tests.newError(output);
            Log.testFailed(message);
            Output.testFailed(output);
        }
    }

    private static boolean assertEquals(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        return Tests.isEquals(expected, actual);
    }

    static void newTest(String format, Object ... args) {
        String name = String.format(format, args);
        Output.printH2(name, new Object[0]);
        allTests.push(new Test(name));
    }

    static void newError(String message) {
        ++errorCount;
        Tests.allTests.peek().errors.add(message);
    }

    private static boolean isEquals(Object expected, Object actual) {
        return expected.equals(actual);
    }

    public static Stack<Test> getAllTests() {
        return allTests;
    }

    public static int getErrorCount() {
        return errorCount;
    }

    static class Test {
        final String name;
        final List<String> errors = new ArrayList<String>();

        public Test(String name) {
            this.name = name;
        }
    }
}

