/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import com.google.protobuf.ByteString;
import com.mapr.baseutils.acls.SecurityCommandHelper;
import com.mapr.baseutils.utils.ACL;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.baseutils.utils.Util;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Security;
import com.mapr.security.UnixUserGroupHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterAce {
    private static final Logger LOG = LogManager.getLogger(ClusterAce.class);
    private CLDBProto.ClusterAces clusterAces;
    private CLDBProto.ClusterAces clusterIamAces;
    private ACL clusterAcls;

    public ClusterAce(ACL acls, CLDBProto.ClusterAces clusterAces, CLDBProto.ClusterAces clusterIamAces) {
        this.clusterAces = clusterAces;
        this.clusterIamAces = clusterIamAces;
        this.clusterAcls = acls;
    }

    private boolean isPublicAccess(ByteString userExpression) {
        String aceExpression;
        try {
            aceExpression = AceHelper.toInfix(userExpression.toStringUtf8());
        }
        catch (IOException exp) {
            LOG.error("Failed to pasrse user expression");
            return false;
        }
        return aceExpression.equals("p");
    }

    private boolean isCredPresentInUserExpr(ByteString userExpression, Security.CredentialsMsg creds) {
        String aceExpression;
        try {
            aceExpression = AceHelper.toInfix(userExpression.toStringUtf8());
        }
        catch (IOException exp) {
            LOG.error("Failed to parse user expression");
            return false;
        }
        LOG.info("Ace Expression: {}", (Object)aceExpression);
        LOG.info("Creds: {}", (Object)creds.toString());
        if (aceExpression == null || aceExpression.isEmpty()) {
            LOG.debug("Ace Expression is Empty");
            return false;
        }
        if (creds == null) {
            LOG.debug("Creds are Empty");
            return false;
        }
        if (creds.hasUid() && this.isPartOfExpr(aceExpression, "user", creds.getUid())) {
            return true;
        }
        for (Integer gid : creds.getGidsList()) {
            if (!this.isPartOfExpr(aceExpression, "group", gid)) continue;
            return true;
        }
        if (creds.hasUserName() && aceExpression.contains("u:" + creds.getUserName())) {
            LOG.debug("Username present in ace expression");
            return true;
        }
        for (Integer rid : creds.getRidsList()) {
            if (!aceExpression.contains(rid.toString())) continue;
            LOG.debug("RID: {} present in ace expression", (Object)rid.toString());
            return true;
        }
        return false;
    }

    boolean isPartOfExpr(String aceExpression, String identityType, Integer id) {
        UnixUserGroupHelper uugh = new UnixUserGroupHelper();
        Object name = id.toString();
        switch (identityType) {
            case "user": {
                name = "u:" + (String)name;
                try {
                    name = "u:" + uugh.getUsername(id);
                }
                catch (SecurityException se) {
                    LOG.error("Failed to fetch user name from uugh {}", (Object)id);
                }
                break;
            }
            case "group": {
                name = "g:" + (String)name;
                try {
                    name = "g:" + uugh.getGroupname(id);
                }
                catch (SecurityException se) {
                    LOG.error("Failed to fetch user name from uugh {}", (Object)id);
                }
                break;
            }
            default: {
                LOG.error("Unsupported user type: " + identityType);
                return false;
            }
        }
        return aceExpression.contains((CharSequence)name);
    }

    private boolean isDeniedAccess(List<CLDBProto.ClusterAceEntry> denyAceEntryList, CLDBProto.ClusterActions clusterAction, Security.CredentialsMsg creds) {
        if (denyAceEntryList == null || denyAceEntryList.isEmpty()) {
            LOG.debug("DenyAceEntryList is empty so access allowed.");
            return false;
        }
        if (creds == null) {
            LOG.debug("Creds are empty so access denied.");
            return true;
        }
        for (CLDBProto.ClusterAceEntry denyAceEntry : denyAceEntryList) {
            if (!denyAceEntry.getClusterAction().equals((Object)clusterAction)) continue;
            if (this.isPublicAccess(denyAceEntry.getExpr())) {
                LOG.debug("Public access in deny Entry. so access allowed");
                return false;
            }
            if (!this.isCredPresentInUserExpr(denyAceEntry.getExpr(), creds)) continue;
            LOG.debug("Creds: {} are present in deny list.", (Object)creds.toString());
            return true;
        }
        return false;
    }

    private boolean isAllowedAccess(List<CLDBProto.ClusterAceEntry> allowAceEntryList, CLDBProto.ClusterActions clusterAction, Security.CredentialsMsg creds) {
        if (allowAceEntryList == null || allowAceEntryList.isEmpty()) {
            LOG.debug("AllowAceEntryList is empty so access denied.");
            return false;
        }
        if (creds == null) {
            LOG.debug("Creds are null");
            return false;
        }
        for (CLDBProto.ClusterAceEntry allowAceEntry : allowAceEntryList) {
            if (!allowAceEntry.getClusterAction().equals((Object)clusterAction)) continue;
            if (this.isPublicAccess(allowAceEntry.getExpr())) {
                LOG.debug("Public access in allowed Entry. so access allowed");
                return true;
            }
            if (!this.isCredPresentInUserExpr(allowAceEntry.getExpr(), creds)) continue;
            LOG.debug("Creds: {} are present in allow list.", (Object)creds.toString());
            return true;
        }
        return false;
    }

    public boolean checkAccessWithAces(CLDBProto.ClusterActions clusterAction, Security.CredentialsMsg creds, boolean isCapable) {
        if (this.clusterAces != null && this.isDeniedAccess(this.clusterAces.getDenyAcesList(), clusterAction, creds) || this.clusterIamAces != null && this.isDeniedAccess(this.clusterIamAces.getDenyAcesList(), clusterAction, creds)) {
            return false;
        }
        if (isCapable) {
            return true;
        }
        return this.clusterAces != null && this.isAllowedAccess(this.clusterAces.getAcesList(), clusterAction, creds) || this.clusterIamAces != null && this.isAllowedAccess(this.clusterIamAces.getAcesList(), clusterAction, creds);
    }

    public boolean checkAccessWithCapabilities(int actionMask, Security.CredentialsMsg creds) {
        if (creds.hasCapabilities()) {
            CLDBProto.SecureObjectType objType = CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER;
            List<String> acl = SecurityCommandHelper.formatActionMask((int)creds.getCapabilities().getClusterOpsMask(), objType, true);
            LOG.debug("acl list: {}", (Object)acl.toString());
            int formattedMask = 0;
            try {
                formattedMask = SecurityCommandHelper.convertActionsToMask(String.join((CharSequence)",", acl), ",", objType);
                LOG.debug("acl list: {} , formatted mask: {}", (Object)acl.toString(), (Object)formattedMask);
                return (formattedMask & actionMask) == actionMask;
            }
            catch (Exception e) {
                LOG.error("failed to convert acl to mask. acl list: {} ,formatted mask: {}, Exception: {}", (Object)acl.toString(), (Object)formattedMask, (Object)e.getMessage());
            }
        }
        return false;
    }

    private boolean isBitSet(int number, int bitPosition) {
        return (number & 1 << bitPosition) != 0;
    }

    private List<CLDBProto.ClusterActions> actionMaskToClusterActions(int actionMask) {
        ArrayList<CLDBProto.ClusterActions> clusterActionList = new ArrayList<CLDBProto.ClusterActions>();
        EnumSet.allOf(CLDBProto.ClusterActions.class).forEach(clusterAction -> {
            if (this.isBitSet(actionMask, clusterAction.getNumber())) {
                clusterActionList.add((CLDBProto.ClusterActions)clusterAction);
            }
        });
        LOG.debug("action mask to cluster actions list: {}", (Object)((Object)clusterActionList).toString());
        return clusterActionList;
    }

    public boolean checkAccess(int actionMask, Security.CredentialsMsg creds) {
        boolean isCapable;
        StringBuilder strError = new StringBuilder();
        if (this.clusterAcls != null) {
            if (this.clusterAcls.verifyPermissions(creds, actionMask, strError)) {
                LOG.debug("ACL check access success");
                return true;
            }
            LOG.warn("ACL check access failed with error " + strError);
        }
        LOG.debug((isCapable = this.checkAccessWithCapabilities(actionMask, creds)) ? "true" : "false");
        for (CLDBProto.ClusterActions clusAction : this.actionMaskToClusterActions(actionMask)) {
            if (!this.checkAccessWithAces(clusAction, creds, isCapable)) {
                LOG.debug("User: {} does not have access for action {}", (Object)Util.printCredentials(creds), (Object)clusAction.toString());
                return false;
            }
            LOG.debug("User: {} have access for action {}", (Object)Util.printCredentials(creds), (Object)clusAction.toString());
        }
        LOG.debug("user granted permission for action mask: {}, creds: {}", (Object)actionMask, (Object)Util.printCredentials(creds));
        return true;
    }
}

