/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Msicommon;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3BucketUtils {
    private static final Logger LOG = LoggerFactory.getLogger(S3BucketUtils.class);
    public static final String reserveredBucketNamePrefix = "mapr.internal";
    public static final String reservedDeletedBucketNamePrefix = Msicommon.MSIDefaults.getDefaultInstance().getBucketDeleteRenamePrefix();
    static Pattern validName = Pattern.compile("[a-z0-9\\.\\-]+");
    static String validCharacters = "a-z0-9.-";
    public static final int BUCKET_NAME_MAX_LEN = Common.MapRSharedConfigInfo.getDefaultInstance().getS3BucketNameMaxLen();

    public static boolean isReservedBucketName(String bucketName) {
        return bucketName.startsWith(reserveredBucketNamePrefix) || bucketName.startsWith(reservedDeletedBucketNamePrefix);
    }

    public static boolean isValidBucketName(String name) {
        Matcher m = validName.matcher(name);
        if (!m.matches()) {
            return false;
        }
        if (name.length() == 0 || name.length() > BUCKET_NAME_MAX_LEN) {
            return false;
        }
        char firstChar = name.charAt(0);
        char lastChar = name.charAt(name.length() - 1);
        if (!Character.isLetter(firstChar) && !Character.isDigit(firstChar) || !Character.isLetter(lastChar) && !Character.isDigit(lastChar)) {
            return false;
        }
        return !S3BucketUtils.isValidIPAddress(name);
    }

    private static boolean isValidIPAddress(String str) {
        if (str == null || str.isEmpty() || str.endsWith(".")) {
            return false;
        }
        String[] parts = str.split("\\.");
        if (parts.length != 4) {
            return false;
        }
        for (String s : parts) {
            int i = 0;
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (i >= 0 && i <= 255) continue;
            return false;
        }
        return true;
    }

    public static String getValidName() {
        return validCharacters;
    }
}

