/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LRUCache<K, V> {
    private static final float hashTableLoadFactor = 0.75f;
    private final Map<K, V> syncMap;
    private final long cacheSize;

    public LRUCache(long maxSize) {
        this.cacheSize = maxSize;
        int hashTableCapacity = (int)Math.ceil((float)this.cacheSize / 0.75f) + 1;
        LinkedHashMap map = new LinkedHashMap<K, V>(hashTableCapacity, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return (long)this.size() > LRUCache.this.cacheSize;
            }
        };
        this.syncMap = Collections.synchronizedMap(map);
    }

    public V get(K key) {
        return this.syncMap.get(key);
    }

    public void put(K key, V value) {
        this.syncMap.put(key, value);
    }

    public V remove(K key) {
        return this.syncMap.remove(key);
    }

    public void clear() {
        this.syncMap.clear();
    }

    public int usedEntries() {
        return this.syncMap.size();
    }

    public int size() {
        return this.syncMap.size();
    }

    public Collection<V> getAllValues() {
        return this.syncMap.values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.syncMap.entrySet();
    }
}

