/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.zookeeper;

import com.mapr.baseutils.zookeeper.ZKClosedException;
import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKUtils {
    public static final int ZK_RETRIALS = 3;
    public static final int TIMEOUT = 30000;
    public static final int TIMEOUT_SERVER = 30000;
    public static final String SERVICE_MASTER_NODE = "master";
    private static final Logger LOG = LoggerFactory.getLogger(ZKUtils.class);

    public static byte[] getData(ZooKeeper s_zk, String nodeName, Watcher watcher, Stat stat, int retrials) throws KeeperException, InterruptedException, ZKClosedException {
        try {
            return s_zk.getData(nodeName, watcher, stat);
        }
        catch (KeeperException.ConnectionLossException e) {
            LOG.error("Lost connection to ZK while trying to get data. Reconnecting...");
            if (retrials > 0 && s_zk.getState().isAlive()) {
                return ZKUtils.getData(s_zk, nodeName, watcher, stat, retrials - 1);
            }
            if (!s_zk.getState().isAlive()) {
                LOG.error("ZK is not alive. Throwing KeeperException after retrials: " + retrials);
            }
            throw new ZKClosedException(e);
        }
        catch (KeeperException.SessionExpiredException see) {
            LOG.error("ZK Session expired. Need to reset ZK completely for node: " + nodeName);
            throw new ZKClosedException(see);
        }
    }

    public static Stat checkZKNodeForExistence(ZooKeeper s_zk, String nodeName, Watcher watcher, int retrials) throws KeeperException, InterruptedException, ZKClosedException {
        try {
            return s_zk.exists(nodeName, watcher);
        }
        catch (KeeperException.ConnectionLossException e) {
            LOG.error(Thread.currentThread().getId() + " Lost connection to ZK while trying to get data. Reconnecting...");
            if (retrials > 0 && s_zk.getState().isAlive()) {
                return ZKUtils.checkZKNodeForExistence(s_zk, nodeName, watcher, retrials - 1);
            }
            if (!s_zk.getState().isAlive()) {
                LOG.error("ZK is not alive. Throwing KeeperException after retrials: " + retrials);
            }
            throw new ZKClosedException(e);
        }
        catch (KeeperException.SessionExpiredException see) {
            LOG.error("ZK Session expired. Need to reset ZK completely for node: " + nodeName);
            throw new ZKClosedException(see);
        }
    }

    public static List<String> getZkNodeChildren(ZooKeeper s_zk, String nodeName, Watcher watcher, int retrials) throws KeeperException, InterruptedException, ZKClosedException {
        try {
            return s_zk.getChildren(nodeName, watcher);
        }
        catch (KeeperException.ConnectionLossException e) {
            LOG.error(Thread.currentThread().getId() + " Lost connection to ZK while trying to get data. Reconnecting...");
            if (retrials > 0 && s_zk.getState().isAlive()) {
                return ZKUtils.getZkNodeChildren(s_zk, nodeName, watcher, retrials - 1);
            }
            if (!s_zk.getState().isAlive()) {
                LOG.error("ZK is not alive. Throwing KeeperException after retrials: " + retrials);
            }
            throw new ZKClosedException(e);
        }
        catch (KeeperException.SessionExpiredException see) {
            LOG.error("ZK Session expired. Need to reset ZK completely for node: " + nodeName);
            throw new ZKClosedException(see);
        }
    }

    public static void resetZookeeper(String zkAddresses, ZooKeeper s_zk, Watcher watcher) throws IOException {
        block3: {
            if (s_zk != null) {
                try {
                    s_zk.close();
                }
                catch (InterruptedException e) {
                    if (!LOG.isInfoEnabled()) break block3;
                    LOG.info("Interrupted Exception during ZK closure", (Throwable)e);
                }
            }
        }
        s_zk = null;
        s_zk = new ZooKeeper(zkAddresses, 30000, watcher);
    }
}

