/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTLCache<K, V> {
    public static final Logger LOG = LoggerFactory.getLogger(TTLCache.class);
    private long timeToLive;
    private final ConcurrentHashMap<K, CacheEntry<V>> cache = new ConcurrentHashMap();

    public TTLCache(long ttl) {
        this.timeToLive = ttl;
    }

    public void put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        CacheEntry<V> entry = new CacheEntry<V>(value);
        this.cache.put(key, entry);
    }

    public V get(K key) {
        CacheEntry<V> entry = this.cache.get(key);
        if (entry != null && (Instant.now().toEpochMilli() - entry.inTime) / 60000L - this.timeToLive > 0L) {
            this.cache.remove(key);
            LOG.debug("Cache Miss: Entry for {} evicted from cache due to TTL hit,, will update from SSO", key);
            entry = null;
        }
        return entry == null ? null : (V)entry.value;
    }

    public V remove(K key) {
        CacheEntry<V> removed = this.cache.remove(key);
        if (removed == null) {
            return null;
        }
        return removed.value;
    }

    public void clear() {
        this.cache.clear();
    }

    public V getOrDefault(K key, V defVal) {
        CacheEntry<V> val = this.cache.get(key);
        if (this.cache.get(key) == null) {
            return defVal;
        }
        return val.value;
    }

    private class CacheEntry<V> {
        V value;
        long inTime;

        CacheEntry(V value) {
            this.value = value;
            this.inTime = Instant.now().toEpochMilli();
        }
    }
}

