/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.mapr.security.FipsLoader;
import com.mapr.web.security.KeystoreFileType;
import com.mapr.web.security.SslConfig;
import com.mapr.web.security.WebSecurityConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collections;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslFactory {
    private static final Logger log = LoggerFactory.getLogger(SslFactory.class);

    private SslFactory() {
    }

    public static SSLContext getSslContext() throws Exception {
        return SslFactory.getSslContext(SslConfig.SslConfigScope.SCOPE_ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLContext getSslContext(SslConfig.SslConfigScope scope) throws Exception {
        SslConfig sslConfig = WebSecurityConfig.CONFIG.getSslConfig(scope);
        try {
            TrustManagerFactory tmf = SslFactory.getTrustManagerFactoryImpl(sslConfig);
            Provider provider = tmf.getProvider();
            TrustManager[] tms = tmf.getTrustManagers();
            SecureRandom random = SecureRandom.getInstance("DEFAULT", provider);
            KeyManager[] kms = scope == SslConfig.SslConfigScope.SCOPE_ALL ? SslFactory.getKeyManagerFactoryImpl(sslConfig).getKeyManagers() : null;
            SSLContext sslContext = SSLContext.getInstance("TLS", provider);
            sslContext.init(kms, tms, random);
            SSLContext sSLContext = sslContext;
            return sSLContext;
        }
        finally {
            if (Collections.singletonList(sslConfig).get(0) != null) {
                sslConfig.close();
            }
        }
    }

    public static KeyManagerFactory getKeyManagerFactory() throws Exception {
        SslConfig sslConfig = WebSecurityConfig.CONFIG.getSslConfig(SslConfig.SslConfigScope.SCOPE_ALL);
        try {
            KeyManagerFactory keyManagerFactory = SslFactory.getKeyManagerFactoryImpl(sslConfig);
            return keyManagerFactory;
        }
        finally {
            if (Collections.singletonList(sslConfig).get(0) != null) {
                sslConfig.close();
            }
        }
    }

    public static TrustManagerFactory getTrustManagerFactory() throws Exception {
        SslConfig sslConfig = WebSecurityConfig.CONFIG.getSslConfig(SslConfig.SslConfigScope.SCOPE_CLIENT_ONLY);
        try {
            TrustManagerFactory trustManagerFactory = SslFactory.getTrustManagerFactoryImpl(sslConfig);
            return trustManagerFactory;
        }
        finally {
            if (Collections.singletonList(sslConfig).get(0) != null) {
                sslConfig.close();
            }
        }
    }

    private static KeyManagerFactory getKeyManagerFactoryImpl(SslConfig sslConfig) throws Exception {
        String keystoreType = sslConfig.getServerKeystoreType();
        String keystoreFilePath = sslConfig.getServerKeystoreLocation();
        File keystoreFile = new File(keystoreFilePath);
        if (!keystoreFile.exists()) {
            throw new FileNotFoundException("Unable to find or load the server keystore file" + keystoreFile);
        }
        log.debug("Initializing Java KeyManagerFactory with keystore '{}', type '{}', algorithm '{}'.", new Object[]{keystoreFile, keystoreType, "PKIX"});
        String provider = SslFactory.getProvider(sslConfig.getServerKeystoreFileType());
        KeyStore ksKeys = KeyStore.getInstance(keystoreType);
        char[] keyStorePassphrase = sslConfig.getServerKeystorePassword();
        ksKeys.load(new FileInputStream(keystoreFile), keyStorePassphrase);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("PKIX", provider);
        char[] keyPassphrase = sslConfig.getServerKeyPassword();
        kmf.init(ksKeys, keyPassphrase);
        return kmf;
    }

    private static TrustManagerFactory getTrustManagerFactoryImpl(SslConfig sslConfig) throws Exception {
        String trustStoreType = sslConfig.getClientTruststoreType();
        String trustStoreFilePath = sslConfig.getClientTruststoreLocation();
        File trustStoreFile = new File(trustStoreFilePath);
        if (!trustStoreFile.exists()) {
            throw new FileNotFoundException("Unable to find or load the client trust store file" + trustStoreFile);
        }
        log.debug("Initializing Java TrustManagerFactory with trust store '{}', type '{}', algorithm '{}'.", new Object[]{trustStoreFile, trustStoreType, "PKIX"});
        String provider = SslFactory.getProvider(sslConfig.getClientTruststoreFileType());
        KeyStore trustStore = KeyStore.getInstance(trustStoreType);
        char[] trustStorePassphrase = sslConfig.getClientTruststorePassword();
        trustStore.load(new FileInputStream(trustStoreFile), trustStorePassphrase);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX", provider);
        tmf.init(trustStore);
        return tmf;
    }

    private static String getProvider(KeystoreFileType storeFileType) {
        switch (storeFileType) {
            case JKS: {
                return "SunJSSE";
            }
            case BCFKS: {
                FipsLoader.loadFipsProviders();
                return "BCJSSE";
            }
        }
        throw new IllegalArgumentException("Unsupported Java Keystore type: " + storeFileType);
    }
}

